/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.unitTests;

import cytoscape.data.Interaction;
import cytoscape.unitTests.AllTests;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class InteractionTest
extends TestCase {
    public InteractionTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void test3ArgCtor() throws Exception {
        AllTests.standardOut("test3ArgCtor");
        String string = "YNL312W";
        String string2 = "pd";
        String string3 = "YPL111W";
        Interaction interaction = new Interaction(string, string3, string2);
        InteractionTest.assertTrue((boolean)interaction.getSource().equals(string));
        InteractionTest.assertTrue((boolean)interaction.getType().equals(string2));
        InteractionTest.assertTrue((interaction.numberOfTargets() == 1 ? 1 : 0) != 0);
        InteractionTest.assertTrue((boolean)interaction.getTargets()[0].equals(string3));
    }

    public void test1ArgCtor() throws Exception {
        AllTests.standardOut("test1ArgCtor");
        String string = "YNL312W pp YPL111W";
        Interaction interaction = new Interaction(string);
        InteractionTest.assertTrue((boolean)interaction.getSource().equals("YNL312W"));
        InteractionTest.assertTrue((boolean)interaction.getType().equals("pp"));
        InteractionTest.assertTrue((interaction.numberOfTargets() == 1 ? 1 : 0) != 0);
        InteractionTest.assertTrue((boolean)interaction.getTargets()[0].equals("YPL111W"));
        String string2 = "YPL075W pd YDR050C YGR254W YHR174W";
        Interaction interaction2 = new Interaction(string2);
        InteractionTest.assertTrue((boolean)interaction2.getSource().equals("YPL075W"));
        InteractionTest.assertTrue((boolean)interaction2.getType().equals("pd"));
        InteractionTest.assertTrue((interaction2.numberOfTargets() == 3 ? 1 : 0) != 0);
        InteractionTest.assertTrue((boolean)interaction2.getTargets()[0].equals("YDR050C"));
        InteractionTest.assertTrue((boolean)interaction2.getTargets()[1].equals("YGR254W"));
        InteractionTest.assertTrue((boolean)interaction2.getTargets()[2].equals("YHR174W"));
    }

    public void test1ArgCtorOnDegenerateFrom() throws Exception {
        AllTests.standardOut("test1ArgCtorOnDegenerateForm");
        String string = "YNL312W";
        Interaction interaction = new Interaction(string);
        InteractionTest.assertTrue((boolean)interaction.getSource().equals("YNL312W"));
        InteractionTest.assertTrue((interaction.getType() == null ? 1 : 0) != 0);
        InteractionTest.assertTrue((interaction.numberOfTargets() == 0 ? 1 : 0) != 0);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(InteractionTest.class));
    }
}

