/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.unitTests;

import cytoscape.data.ExpressionData;
import cytoscape.data.mRNAMeasurement;
import cytoscape.unitTests.AllTests;
import java.io.File;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ExpressionDataTest
extends TestCase {
    private static String testDataDir = "testData";
    private static String testDataFilename = "/gal1.22x5.mRNA";

    public ExpressionDataTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCtor() throws Exception {
        AllTests.standardOut("testCtor");
        ExpressionData expressionData = new ExpressionData(testDataDir + testDataFilename);
        Vector vector = expressionData.getAllMeasurements();
        ExpressionDataTest.assertTrue((expressionData.getNumberOfGenes() == vector.size() ? 1 : 0) != 0);
        if (expressionData.getNumberOfGenes() > 0) {
            String string = expressionData.getGeneNames()[0];
            Vector vector2 = (Vector)vector.get(0);
            if (expressionData.getNumberOfConditions() > 0) {
                String string2 = expressionData.getConditionNames()[0];
                mRNAMeasurement mRNAMeasurement2 = (mRNAMeasurement)vector2.get(0);
                ExpressionDataTest.assertTrue((mRNAMeasurement2.getRatio() >= -200.0 ? 1 : 0) != 0);
                ExpressionDataTest.assertTrue((mRNAMeasurement2.getSignificance() >= 0.0 ? 1 : 0) != 0);
            }
        }
    }

    public void testGetConditionNames() throws Exception {
        AllTests.standardOut("testGetConditionNames");
        ExpressionData expressionData = new ExpressionData(testDataDir + testDataFilename);
        String[] stringArray = expressionData.getConditionNames();
        ExpressionDataTest.assertTrue((stringArray.length == expressionData.getNumberOfConditions() ? 1 : 0) != 0);
    }

    public void testGetGeneNames() throws Exception {
        AllTests.standardOut("testGetGeneNames");
        ExpressionData expressionData = new ExpressionData(testDataDir + testDataFilename);
        String[] stringArray = expressionData.getGeneNames();
        ExpressionDataTest.assertTrue((stringArray.length == expressionData.getNumberOfGenes() ? 1 : 0) != 0);
    }

    public void testGetGeneDescriptors() throws Exception {
        AllTests.standardOut("testGetGeneDescriptors");
        ExpressionData expressionData = new ExpressionData(testDataDir + testDataFilename);
        String[] stringArray = expressionData.getGeneDescriptors();
        ExpressionDataTest.assertTrue((stringArray.length == expressionData.getNumberOfGenes() ? 1 : 0) != 0);
    }

    public void testGetMeasurement() throws Exception {
        AllTests.standardOut("testGetMeasurement");
        ExpressionData expressionData = new ExpressionData(testDataDir + testDataFilename);
        if (expressionData.getNumberOfGenes() > 0 && expressionData.getNumberOfConditions() > 0) {
            String string = expressionData.getGeneNames()[0];
            String string2 = expressionData.getConditionNames()[0];
            mRNAMeasurement mRNAMeasurement2 = expressionData.getMeasurement(string, string2);
            double d = mRNAMeasurement2.getRatio();
            double d2 = mRNAMeasurement2.getSignificance();
            ExpressionDataTest.assertTrue((d > -100.0 ? 1 : 0) != 0);
            ExpressionDataTest.assertTrue((d < 1000.0 ? 1 : 0) != 0);
            ExpressionDataTest.assertTrue((d2 >= 0.0 ? 1 : 0) != 0);
            ExpressionDataTest.assertTrue((d2 < 10000.0 ? 1 : 0) != 0);
        }
    }

    public static void main(String[] stringArray) {
        File file;
        if (stringArray.length == 1) {
            testDataDir = stringArray[0];
        }
        if (!(file = new File(testDataDir)).canRead() || !file.isDirectory()) {
            System.err.println("error! ExpressionDataTest cannot read relative directory '" + testDataDir + "'");
            System.exit(1);
        }
        TestRunner.run((Test)new TestSuite(ExpressionDataTest.class));
    }
}

