/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.synonyms.unitTests;

import cytoscape.data.synonyms.Thesaurus;
import cytoscape.unitTests.AllTests;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ThesaurusTest
extends TestCase {
    public ThesaurusTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCtor() throws Exception {
        AllTests.standardOut("testCtor");
        String string = "fugu";
        Thesaurus thesaurus = new Thesaurus(string);
        ThesaurusTest.assertTrue((thesaurus.canonicalNameCount() == 0 ? 1 : 0) != 0);
        ThesaurusTest.assertTrue((boolean)thesaurus.getSpecies().equals(string));
    }

    public void testAddSimplePairs() throws Exception {
        int n;
        AllTests.standardOut("testAddSimplePairs");
        String[] stringArray = new String[]{"YCR097W", "YCR096C", "YMR056C", "YBR085W"};
        String[] stringArray2 = new String[]{"MAT1A", "MATA2", "AAC1", "AAC3"};
        ThesaurusTest.assertTrue((stringArray.length == stringArray2.length ? 1 : 0) != 0);
        String string = "Saccharomyces cerevisiae";
        Thesaurus thesaurus = new Thesaurus(string);
        ThesaurusTest.assertTrue((boolean)thesaurus.getSpecies().equals(string));
        for (n = 0; n < stringArray.length; ++n) {
            thesaurus.add(stringArray[n], stringArray2[n]);
        }
        ThesaurusTest.assertTrue((thesaurus.canonicalNameCount() == 4 ? 1 : 0) != 0);
        for (n = 0; n < stringArray.length; ++n) {
            ThesaurusTest.assertTrue((boolean)thesaurus.getCommonName(stringArray[n]).equals(stringArray2[n]));
            ThesaurusTest.assertTrue((boolean)thesaurus.getCanonicalName(stringArray2[n]).equals(stringArray[n]));
            String[] stringArray3 = thesaurus.getAllCommonNames(stringArray[n]);
            ThesaurusTest.assertTrue((stringArray3.length == 1 ? 1 : 0) != 0);
            ThesaurusTest.assertTrue((boolean)stringArray3[0].equals(stringArray2[n]));
        }
    }

    public void testAddDuplicatePairs() throws Exception {
        AllTests.standardOut("testAddDuplicatePairs");
        String[] stringArray = new String[]{"YCR097W", "YCR096C", "YMR056C", "YBR085W"};
        String[] stringArray2 = new String[]{"MAT1A", "MATA2", "AAC1", "AAC3"};
        ThesaurusTest.assertTrue((stringArray.length == stringArray2.length ? 1 : 0) != 0);
        String string = "Saccharomyces cerevisiae";
        Thesaurus thesaurus = new Thesaurus(string);
        for (int i = 0; i < stringArray.length; ++i) {
            thesaurus.add(stringArray[i], stringArray2[i]);
        }
        ThesaurusTest.assertTrue((thesaurus.canonicalNameCount() == 4 ? 1 : 0) != 0);
        try {
            thesaurus.add(stringArray[stringArray.length - 1], stringArray2[stringArray.length - 1]);
            ThesaurusTest.assertTrue((boolean)true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            thesaurus.add(stringArray[stringArray.length - 1], "yojo");
            ThesaurusTest.assertTrue((boolean)true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            thesaurus.add("yojoYama", stringArray2[stringArray.length - 1]);
            ThesaurusTest.assertTrue((boolean)true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddRemoveAddAgain() throws Exception {
        int n;
        AllTests.standardOut("testAddRemoveAddAgain");
        String[] stringArray = new String[]{"YCR097W", "YCR096C", "YMR056C", "YBR085W"};
        String[] stringArray2 = new String[]{"MAT1A", "MATA2", "AAC1", "AAC3"};
        ThesaurusTest.assertTrue((stringArray.length == stringArray2.length ? 1 : 0) != 0);
        String string = "Saccharomyces cerevisiae";
        Thesaurus thesaurus = new Thesaurus(string);
        for (n = 0; n < stringArray.length; ++n) {
            thesaurus.add(stringArray[n], stringArray2[n]);
        }
        ThesaurusTest.assertTrue((thesaurus.canonicalNameCount() == 4 ? 1 : 0) != 0);
        for (n = 0; n < stringArray.length; ++n) {
            thesaurus.remove(stringArray[n], stringArray2[n]);
        }
        ThesaurusTest.assertTrue((thesaurus.canonicalNameCount() == 0 ? 1 : 0) != 0);
        for (n = 0; n < stringArray.length; ++n) {
            thesaurus.add(stringArray[n], stringArray2[n]);
        }
        ThesaurusTest.assertTrue((thesaurus.canonicalNameCount() == 4 ? 1 : 0) != 0);
        for (n = 0; n < stringArray.length; ++n) {
            ThesaurusTest.assertTrue((boolean)thesaurus.getCommonName(stringArray[n]).equals(stringArray2[n]));
            ThesaurusTest.assertTrue((boolean)thesaurus.getCanonicalName(stringArray2[n]).equals(stringArray[n]));
            String[] stringArray3 = thesaurus.getAllCommonNames(stringArray[n]);
            ThesaurusTest.assertTrue((stringArray3.length == 1 ? 1 : 0) != 0);
            ThesaurusTest.assertTrue((boolean)stringArray3[0].equals(stringArray2[n]));
        }
    }

    public void testAddAlternateCommonNames() throws Exception {
        int n;
        AllTests.standardOut("testAddAlternateCommonNames");
        String[] stringArray = new String[]{"YCR097W", "YCR096C", "YMR056C", "YBR085W"};
        String[] stringArray2 = new String[]{"MAT1A", "MATA2", "AAC1", "AAC3"};
        String[][] stringArrayArray = new String[][]{{"alt00", "alt01", "alt02"}, {"alt10", "alt11", "alt12"}, {"alt20", "alt21", "alt22"}, {"alt30", "alt31", "alt32"}};
        ThesaurusTest.assertTrue((stringArray.length == stringArray2.length ? 1 : 0) != 0);
        String string = "Saccharomyces cerevisiae";
        Thesaurus thesaurus = new Thesaurus(string);
        for (n = 0; n < stringArray.length; ++n) {
            thesaurus.add(stringArray[n], stringArray2[n]);
        }
        ThesaurusTest.assertTrue((thesaurus.canonicalNameCount() == 4 ? 1 : 0) != 0);
        for (n = 0; n < stringArray.length; ++n) {
            for (int i = 0; i < stringArrayArray[n].length; ++i) {
                thesaurus.addAlternateCommonName(stringArray[n], stringArrayArray[n][i]);
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            String[] stringArray3 = thesaurus.getAllCommonNames(stringArray[n]);
            ThesaurusTest.assertTrue((stringArray3.length == 4 ? 1 : 0) != 0);
            ThesaurusTest.assertTrue((boolean)stringArray3[0].equals(stringArray2[n]));
            for (int i = 0; i < stringArrayArray[n].length; ++i) {
                String string2 = stringArrayArray[n][i];
                ThesaurusTest.assertTrue((boolean)stringArray3[i + 1].equals(stringArrayArray[n][i]));
            }
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(ThesaurusTest.class));
    }
}

