/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.synonyms.readers.unitTests;

import cytoscape.data.synonyms.Thesaurus;
import cytoscape.data.synonyms.readers.ThesaurusFlatFileReader;
import cytoscape.unitTests.AllTests;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ThesaurusFlatFileReaderTest
extends TestCase {
    public ThesaurusFlatFileReaderTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testReadSmallYeastThesaurus() throws Exception {
        AllTests.standardOut("testReadSmallYeastThesaurus");
        String string = "sampleData/yeastSmall.txt";
        if (AllTests.runAllTests()) {
            string = "src/cytoscape/data/synonyms/readers/unitTests/sampleData/yeastSmall.txt";
        }
        ThesaurusFlatFileReader thesaurusFlatFileReader = new ThesaurusFlatFileReader(string);
        Thesaurus thesaurus = thesaurusFlatFileReader.getThesaurus();
        ThesaurusFlatFileReaderTest.assertTrue((boolean)thesaurus.getSpecies().equals("Saccharomyces cerevisiae"));
        ThesaurusFlatFileReaderTest.assertTrue((thesaurus.canonicalNameCount() == 8 ? 1 : 0) != 0);
        String[] stringArray = new String[]{"YHR047C", "YBL074C", "YKL106W", "YLR027C", "YGL119W", "YBR236C", "YKL112W", "YMR072W"};
        String[] stringArray2 = new String[]{"AAP1'", "AAR2", "AAT1", "AAT2", "ABC1", "ABD1", "ABF1", "ABF2"};
        int[] nArray = new int[]{1, 0, 0, 1, 0, 0, 3, 0};
        for (int i = 0; i < stringArray.length; ++i) {
            ThesaurusFlatFileReaderTest.assertTrue((boolean)thesaurus.getCommonName(stringArray[i]).equals(stringArray2[i]));
            ThesaurusFlatFileReaderTest.assertTrue((boolean)thesaurus.getCanonicalName(stringArray2[i]).equals(stringArray[i]));
            String[] stringArray3 = thesaurus.getAlternateCommonNames(stringArray[i]);
            if (i == 6) {
                String string2 = stringArray[i];
                ThesaurusFlatFileReaderTest.assertTrue((boolean)string2.equals("YKL112W"));
                ThesaurusFlatFileReaderTest.assertTrue((boolean)stringArray3[0].equals("BAF1"));
                ThesaurusFlatFileReaderTest.assertTrue((boolean)stringArray3[1].equals("OBF1"));
                ThesaurusFlatFileReaderTest.assertTrue((boolean)stringArray3[2].equals("REB2"));
            }
            for (int j = 0; j < stringArray3.length; ++j) {
                AllTests.standardOut(stringArray[i] + " -> " + stringArray3[j]);
            }
            ThesaurusFlatFileReaderTest.assertTrue((stringArray3.length == nArray[i] ? 1 : 0) != 0);
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(ThesaurusFlatFileReaderTest.class));
    }
}

