/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.synonyms.readers;

import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextHttpReader;
import cytoscape.data.readers.TextJarReader;
import cytoscape.data.synonyms.Thesaurus;

public class ThesaurusFlatFileReader {
    Thesaurus thesaurus;
    String fullText;

    public ThesaurusFlatFileReader(String string) throws Exception {
        try {
            if (string.trim().startsWith("jar://")) {
                TextJarReader textJarReader = new TextJarReader(string);
                textJarReader.read();
                this.fullText = textJarReader.getText();
            } else if (string.trim().startsWith("http://")) {
                TextHttpReader textHttpReader = new TextHttpReader(string);
                textHttpReader.read();
                this.fullText = textHttpReader.getText();
            } else {
                TextFileReader textFileReader = new TextFileReader(string);
                textFileReader.read();
                this.fullText = textFileReader.getText();
            }
        }
        catch (Exception exception) {
            System.err.println("-- Exception while reading ontology flat file " + string);
            System.err.println(exception.getMessage());
            return;
        }
        this.read();
    }

    private void read() throws Exception {
        String[] stringArray = this.fullText.split("\n");
        String string = stringArray[0].trim();
        this.thesaurus = new Thesaurus(string);
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray2;
            String string2 = stringArray[i].trim();
            if (string2.startsWith("#") || string2.length() < 3 || (stringArray2 = stringArray[i].split("\\s+", 0)).length < 2) continue;
            String string3 = stringArray2[0].trim();
            String string4 = stringArray2[1].trim();
            if (string3.length() == 0 || string4.length() == 0) continue;
            this.thesaurus.add(string3, string4);
            for (int j = 2; j < stringArray2.length; ++j) {
                this.thesaurus.addAlternateCommonName(string3, stringArray2[j].trim());
            }
        }
    }

    public Thesaurus getThesaurus() {
        return this.thesaurus;
    }
}

