/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.synonyms;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

public class Thesaurus
implements Serializable {
    String species;
    HashMap canonicalToCommon;
    HashMap commonToCanonical;
    HashMap alternatesToCanonical;
    HashMap canonicalToAll;

    public Thesaurus(String string) {
        this.species = string;
        this.canonicalToCommon = new HashMap();
        this.commonToCanonical = new HashMap();
        this.alternatesToCanonical = new HashMap();
        this.canonicalToAll = new HashMap();
    }

    public String getSpecies() {
        return this.species;
    }

    public int canonicalNameCount() {
        return this.canonicalToAll.size();
    }

    public void add(String string, String string2) {
        if (this.canonicalToCommon.containsKey(string)) {
            throw new IllegalArgumentException("duplicate canonicalName: " + string);
        }
        if (this.commonToCanonical.containsKey(string2)) {
            System.out.println("commonName " + string2 + " already has canonicalName " + this.commonToCanonical.get(string2) + " skipping new map: " + string2 + " -> " + string);
        } else {
            this.canonicalToCommon.put(string, string2);
        }
        this.commonToCanonical.put(string2, string);
        this.storeAmongAllCommonNames(string2, string);
    }

    public void remove(String string, String string2) {
        this.canonicalToCommon.remove(string);
        this.commonToCanonical.remove(string2);
        this.canonicalToAll.remove(string);
    }

    public void addAlternateCommonName(String string, String string2) {
        this.alternatesToCanonical.put(string2, string);
        this.storeAmongAllCommonNames(string2, string);
    }

    protected void storeAmongAllCommonNames(String string, String string2) {
        Vector vector = this.canonicalToAll.containsKey(string2) ? (Vector)this.canonicalToAll.get(string2) : new Vector();
        vector.add(string);
        this.canonicalToAll.put(string2, vector);
    }

    public String getCommonName(String string) {
        return (String)this.canonicalToCommon.get(string);
    }

    public String getCanonicalName(String string) {
        if (this.commonToCanonical.containsKey(string)) {
            return (String)this.commonToCanonical.get(string);
        }
        if (this.alternatesToCanonical.containsKey(string)) {
            return (String)this.alternatesToCanonical.get(string);
        }
        return null;
    }

    public String[] getAllCommonNames(String string) {
        if (this.canonicalToAll.containsKey(string)) {
            Vector vector = (Vector)this.canonicalToAll.get(string);
            return vector.toArray(new String[0]);
        }
        return new String[0];
    }

    public String[] getAlternateCommonNames(String string) {
        if (this.canonicalToAll.containsKey(string)) {
            Vector vector = (Vector)this.canonicalToAll.get(string);
            vector.remove(this.getCommonName(string));
            return vector.toArray(new String[0]);
        }
        return new String[0];
    }

    public String toString() {
        int n = 0;
        if (this.canonicalToCommon != null) {
            n = this.canonicalToCommon.size();
        }
        return this.species + ": " + n;
    }
}

