/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.servers;

import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.AnnotationDescription;
import cytoscape.data.servers.BioDataServerInterface;
import cytoscape.data.synonyms.Thesaurus;
import java.io.Serializable;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.HashMap;

public class BioDataServerRmi
extends UnicastRemoteObject
implements BioDataServerInterface,
Serializable {
    protected HashMap annotations = new HashMap();
    protected HashMap thesauri = new HashMap();
    protected Date startTime = new Date();
    protected Date lastAccessTime = new Date();

    public void addAnnotation(Annotation annotation) {
        this.lastAccessTime = new Date();
        AnnotationDescription annotationDescription = new AnnotationDescription(annotation.getSpecies(), annotation.getCurator(), annotation.getType());
        if (this.annotations.containsKey(annotationDescription)) {
            Annotation annotation2 = (Annotation)this.annotations.get(annotationDescription);
            String[] stringArray = annotation.getNames();
            for (int i = 0; i < stringArray.length; ++i) {
                int[] nArray = annotation.getClassifications(stringArray[i]);
                for (int j = 0; j < nArray.length; ++j) {
                    annotation2.add(stringArray[i], nArray[j]);
                }
            }
        } else {
            this.annotations.put(annotationDescription, annotation);
        }
    }

    public void clear() {
        this.annotations = new HashMap();
        this.lastAccessTime = new Date();
    }

    public int getAnnotationCount() {
        this.lastAccessTime = new Date();
        return this.annotations.size();
    }

    public AnnotationDescription[] getAnnotationDescriptions() {
        this.lastAccessTime = new Date();
        AnnotationDescription[] annotationDescriptionArray = this.annotations.keySet().toArray(new AnnotationDescription[0]);
        return annotationDescriptionArray;
    }

    public Annotation getAnnotation(String string, String string2, String string3) {
        this.lastAccessTime = new Date();
        AnnotationDescription annotationDescription = new AnnotationDescription(string, string2, string3);
        return this.getAnnotation(annotationDescription);
    }

    public Annotation getAnnotation(AnnotationDescription annotationDescription) {
        this.lastAccessTime = new Date();
        return (Annotation)this.annotations.get(annotationDescription);
    }

    public int[] getClassifications(String string, String string2, String string3, String string4) {
        this.lastAccessTime = new Date();
        AnnotationDescription annotationDescription = new AnnotationDescription(string, string2, string3);
        return this.getClassifications(annotationDescription, string4);
    }

    public int[] getClassifications(AnnotationDescription annotationDescription, String string) {
        this.lastAccessTime = new Date();
        Annotation annotation = (Annotation)this.annotations.get(annotationDescription);
        return annotation.getClassifications(string);
    }

    public String[][] getAllAnnotations(AnnotationDescription annotationDescription, String string) {
        this.lastAccessTime = new Date();
        Annotation annotation = (Annotation)this.annotations.get(annotationDescription);
        return annotation.getAllHierarchyPathsAsNames(string);
    }

    public String describe() {
        StringBuffer stringBuffer = new StringBuffer();
        Annotation[] annotationArray = this.annotations.values().toArray(new Annotation[0]);
        for (int i = 0; i < annotationArray.length; ++i) {
            stringBuffer.append(annotationArray[i]);
            stringBuffer.append("\n");
        }
        Thesaurus[] thesaurusArray = this.thesauri.values().toArray(new Thesaurus[0]);
        for (int i = 0; i < thesaurusArray.length; ++i) {
            stringBuffer.append(thesaurusArray[i]);
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("    started: " + this.startTime);
        stringBuffer.append("\n");
        stringBuffer.append("last access: " + this.lastAccessTime);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void addThesaurus(String string, Thesaurus thesaurus) {
        this.thesauri.put(string, thesaurus);
    }

    public String getCanonicalName(String string, String string2) {
        String string3;
        Thesaurus thesaurus;
        if (this.thesauri.containsKey(string) && (thesaurus = (Thesaurus)this.thesauri.get(string)) != null && (string3 = thesaurus.getCanonicalName(string2)) != null) {
            return string3;
        }
        return string2;
    }

    public String[] getAllCommonNames(String string, String string2) {
        String[] stringArray;
        String[] stringArray2;
        if (this.thesauri.containsKey(string) && (stringArray2 = (Thesaurus)this.thesauri.get(string)) != null && (stringArray = stringArray2.getAllCommonNames(string2)) != null) {
            return stringArray;
        }
        stringArray2 = new String[]{string2};
        return stringArray2;
    }

    public String getCommonName(String string, String string2) {
        String string3;
        Thesaurus thesaurus;
        if (this.thesauri.containsKey(string) && (thesaurus = (Thesaurus)this.thesauri.get(string)) != null && (string3 = thesaurus.getCommonName(string2)) != null) {
            return string3;
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("usage:  BioDataServerRmi <server name>");
            System.exit(1);
        }
        String string = stringArray[0];
        try {
            BioDataServerRmi bioDataServerRmi = new BioDataServerRmi();
            Naming.rebind(string, bioDataServerRmi);
            System.out.println("BioDataServer bound as '" + string + "'");
        }
        catch (Exception exception) {
            System.err.println("BioDataServer exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

