/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers.unitTests;

import cytoscape.GraphObjAttributes;
import cytoscape.data.Interaction;
import cytoscape.data.readers.InteractionsReader;
import cytoscape.data.servers.BioDataServer;
import cytoscape.unitTests.AllTests;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import y.base.EdgeCursor;
import y.base.NodeCursor;
import y.view.Graph2D;

public class InteractionsReaderTest
extends TestCase {
    private boolean runAllTests = AllTests.runAllTests();
    private BioDataServer nullServer = null;
    private String species = "unknown";

    public InteractionsReaderTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testReadFromTypicalFile() throws Exception {
        AllTests.standardOut("testFromTypicalFile");
        InteractionsReader interactionsReader = this.getReader("sample.sif");
        interactionsReader.read();
        InteractionsReaderTest.assertTrue((interactionsReader.getCount() == 25 ? 1 : 0) != 0);
        Interaction[] interactionArray = interactionsReader.getAllInteractions();
        InteractionsReaderTest.assertTrue((boolean)interactionArray[0].getSource().equals("YNL312W"));
        InteractionsReaderTest.assertTrue((boolean)interactionArray[0].getType().equals("pd"));
        InteractionsReaderTest.assertTrue((interactionArray[0].numberOfTargets() == 1 ? 1 : 0) != 0);
        InteractionsReaderTest.assertTrue((boolean)interactionArray[0].getTargets()[0].equals("YPL111W"));
        InteractionsReaderTest.assertTrue((interactionArray[11].numberOfTargets() == 3 ? 1 : 0) != 0);
    }

    public void testReadFileWithNoInteractions() throws Exception {
        AllTests.standardOut("testReadFileWithNoInteractions");
        InteractionsReader interactionsReader = this.getReader("degenerate.sif");
        interactionsReader.read();
        InteractionsReaderTest.assertTrue((interactionsReader.getCount() == 9 ? 1 : 0) != 0);
        Interaction[] interactionArray = interactionsReader.getAllInteractions();
        for (int i = 0; i < interactionArray.length; ++i) {
            InteractionsReaderTest.assertTrue((boolean)interactionArray[i].getSource().startsWith("Y"));
            InteractionsReaderTest.assertTrue((interactionArray[i].getType() == null ? 1 : 0) != 0);
            InteractionsReaderTest.assertTrue((interactionArray[i].numberOfTargets() == 0 ? 1 : 0) != 0);
        }
    }

    public void testGetGraph() throws Exception {
        AllTests.standardOut("testGetGraph");
        InteractionsReader interactionsReader = this.getReader("sample.sif");
        interactionsReader.read();
        InteractionsReaderTest.assertTrue((interactionsReader.getCount() == 25 ? 1 : 0) != 0);
        Graph2D graph2D = interactionsReader.getGraph();
        NodeCursor nodeCursor = graph2D.nodes();
        InteractionsReaderTest.assertTrue((String)"node count", (nodeCursor.size() == 31 ? 1 : 0) != 0);
        EdgeCursor edgeCursor = graph2D.edges();
        InteractionsReaderTest.assertTrue((String)"edge count", (edgeCursor.size() == 27 ? 1 : 0) != 0);
    }

    public void testGetGraphAndEdgeAttributes() throws Exception {
        AllTests.standardOut("testGetGraphAndEdgeAttributes");
        InteractionsReader interactionsReader = this.getReader("sample.sif");
        interactionsReader.read();
        InteractionsReaderTest.assertTrue((interactionsReader.getCount() == 25 ? 1 : 0) != 0);
        Graph2D graph2D = interactionsReader.getGraph();
        NodeCursor nodeCursor = graph2D.nodes();
        InteractionsReaderTest.assertTrue((String)"node count", (nodeCursor.size() == 31 ? 1 : 0) != 0);
        EdgeCursor edgeCursor = graph2D.edges();
        InteractionsReaderTest.assertTrue((String)"edge count", (edgeCursor.size() == 27 ? 1 : 0) != 0);
        GraphObjAttributes graphObjAttributes = interactionsReader.getEdgeAttributes();
        InteractionsReaderTest.assertTrue((String)"attribute count", (graphObjAttributes.size() == 2 ? 1 : 0) != 0);
        HashMap hashMap = graphObjAttributes.getAttribute("interaction");
        InteractionsReaderTest.assertTrue((String)"non-null interactions", (hashMap != null ? 1 : 0) != 0);
        String[] stringArray = graphObjAttributes.getObjectNames("interaction");
        InteractionsReaderTest.assertTrue((String)"edgeNames count", (stringArray.length == 27 ? 1 : 0) != 0);
        for (int i = 0; i < stringArray.length; ++i) {
            InteractionsReaderTest.assertTrue((String)"looking for ' (pd) '", (stringArray[i].indexOf(" (pd) ") > 0 ? 1 : 0) != 0);
            String string = (String)graphObjAttributes.getValue("interaction", stringArray[i]);
            InteractionsReaderTest.assertTrue((boolean)string.equals("pd"));
        }
    }

    public void testReadMultiWordProteinsFile() throws Exception {
        AllTests.standardOut("testReadMultiWordProteinsFile");
        String string = "multiWordProteins.sif";
        InteractionsReader interactionsReader = this.getReader(string);
        interactionsReader.read();
        InteractionsReaderTest.assertTrue((interactionsReader.getCount() == 29 ? 1 : 0) != 0);
        Interaction[] interactionArray = interactionsReader.getAllInteractions();
        InteractionsReaderTest.assertTrue((boolean)interactionArray[16].getSource().equals("26S ubiquitin dependent proteasome"));
        InteractionsReaderTest.assertTrue((boolean)interactionArray[16].getType().equals("interactsWith"));
        InteractionsReaderTest.assertTrue((interactionArray[16].numberOfTargets() == 1 ? 1 : 0) != 0);
        InteractionsReaderTest.assertTrue((boolean)interactionArray[16].getTargets()[0].equals("I-kappa-B-alpha"));
        InteractionsReaderTest.assertTrue((boolean)interactionArray[28].getSource().equals("TRAF6"));
        InteractionsReaderTest.assertTrue((boolean)interactionArray[28].getType().equals("interactsWith"));
        InteractionsReaderTest.assertTrue((interactionArray[28].numberOfTargets() == 3 ? 1 : 0) != 0);
        InteractionsReaderTest.assertTrue((boolean)interactionArray[28].getTargets()[0].equals("RIP2"));
        InteractionsReaderTest.assertTrue((boolean)interactionArray[28].getTargets()[1].equals("ABCDE oopah"));
        InteractionsReaderTest.assertTrue((boolean)interactionArray[28].getTargets()[2].equals("HJKOL coltrane"));
    }

    public void testReadMultiWordProteinsFileWithErrantSpaces() throws Exception {
        AllTests.standardOut("testReadMultiWordProteinsFileWithErrantSpaces");
        String string = "multiWordProteinsFileTrailingSpaces.sif";
        InteractionsReader interactionsReader = this.getReader(string);
        interactionsReader.read();
        InteractionsReaderTest.assertTrue((interactionsReader.getCount() == 29 ? 1 : 0) != 0);
        Interaction[] interactionArray = interactionsReader.getAllInteractions();
        InteractionsReaderTest.assertTrue((boolean)interactionArray[16].getSource().equals("26S ubiquitin dependent proteasome"));
        InteractionsReaderTest.assertTrue((boolean)interactionArray[16].getType().equals("interactsWith"));
        InteractionsReaderTest.assertTrue((interactionArray[16].numberOfTargets() == 1 ? 1 : 0) != 0);
        InteractionsReaderTest.assertTrue((boolean)interactionArray[16].getTargets()[0].equals("I-kappa-B-alpha"));
        InteractionsReaderTest.assertTrue((boolean)interactionArray[28].getSource().equals("TRAF6"));
        InteractionsReaderTest.assertTrue((boolean)interactionArray[28].getType().equals("interactsWith"));
        InteractionsReaderTest.assertTrue((interactionArray[28].numberOfTargets() == 3 ? 1 : 0) != 0);
        InteractionsReaderTest.assertTrue((boolean)interactionArray[28].getTargets()[0].equals("RIP2"));
        InteractionsReaderTest.assertTrue((boolean)interactionArray[28].getTargets()[1].equals("ABCDE oopah"));
        InteractionsReaderTest.assertTrue((boolean)interactionArray[28].getTargets()[2].equals("HJKOL coltrane"));
    }

    private InteractionsReader getReader(String string) {
        if (this.runAllTests) {
            string = new String("src/cytoscape/data/readers/unitTests/" + string);
        }
        InteractionsReader interactionsReader = new InteractionsReader(this.nullServer, this.species, string);
        return interactionsReader;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(InteractionsReaderTest.class));
    }
}

