/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers.unitTests;

import cytoscape.data.readers.GMLReader;
import cytoscape.unitTests.AllTests;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import y.view.Graph2D;

public class GMLReaderTest
extends TestCase {
    private static String testDataDir;

    public GMLReaderTest(String string) {
        super(string);
        if (AllTests.runAllTests()) {
            testDataDir = "testData";
        }
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testSmallGraphRead() throws Exception {
        AllTests.standardOut("testSmallGraphRead");
        GMLReader gMLReader = new GMLReader(testDataDir + "/gal.gml");
        gMLReader.read();
        Graph2D graph2D = gMLReader.getGraph();
        GMLReaderTest.assertTrue((String)"node count", (graph2D.nodeCount() == 11 ? 1 : 0) != 0);
        GMLReaderTest.assertTrue((String)"edge count", (graph2D.edgeCount() == 10 ? 1 : 0) != 0);
    }

    public void testMediumGraphRead() throws Exception {
        AllTests.standardOut("testMediumGraphRead");
        GMLReader gMLReader = new GMLReader(testDataDir + "/noLabels.gml");
        gMLReader.read();
        Graph2D graph2D = gMLReader.getGraph();
        GMLReaderTest.assertTrue((String)"node count", (graph2D.nodeCount() == 332 ? 1 : 0) != 0);
        GMLReaderTest.assertTrue((String)"edge count", (graph2D.edgeCount() == 362 ? 1 : 0) != 0);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Error!  must supply path to test data directory on command line");
            System.exit(0);
        }
        testDataDir = stringArray[0];
        TestRunner.run((Test)new TestSuite(GMLReaderTest.class));
    }
}

