/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.GraphObjAttributes;
import cytoscape.data.GraphProps;
import java.io.FileWriter;
import java.io.IOException;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Node;

public class SIFWriter {
    private GraphProps props;
    private GraphObjAttributes nodeAttributes;
    private GraphObjAttributes edgeAttributes;

    public SIFWriter(GraphProps graphProps) {
        this.props = graphProps;
        this.nodeAttributes = graphProps.getNodeAttributes();
        this.edgeAttributes = graphProps.getEdgeAttributes();
    }

    public void write(String string) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
        }
        catch (IOException iOException) {
            System.err.println("Couldn't open " + string);
            iOException.printStackTrace();
        }
        Node[] nodeArray = this.props.getGraph().getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            Node node = nodeArray[i];
            String string2 = this.getCanonicalNodeName(node);
            if (node.edges().size() == 0) {
                stringBuffer.append(string2 + "\n");
            } else {
                EdgeCursor edgeCursor = node.outEdges();
                edgeCursor.toFirst();
                while (edgeCursor.ok()) {
                    Edge edge = edgeCursor.edge();
                    Node node2 = edge.target();
                    String string3 = this.getCanonicalNodeName(node2);
                    String string4 = this.edgeAttributes.getCanonicalName(edge);
                    String string5 = (String)this.edgeAttributes.getValue("interaction", string4);
                    if (string5 == null) {
                        string5 = "xx";
                    }
                    stringBuffer.append(string2);
                    stringBuffer.append("\t");
                    stringBuffer.append(string5);
                    stringBuffer.append("\t");
                    stringBuffer.append(string3);
                    stringBuffer.append("\n");
                    edgeCursor.next();
                }
            }
            try {
                fileWriter.write(stringBuffer.toString());
                continue;
            }
            catch (IOException iOException) {
                System.err.println("Error while writing " + string);
                iOException.printStackTrace();
            }
        }
        try {
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("Error while closing " + string);
            iOException.printStackTrace();
        }
    }

    public String getCanonicalNodeName(Node node) {
        return this.nodeAttributes.getCanonicalName(node);
    }
}

