/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.GraphObjAttributes;
import cytoscape.data.Interaction;
import cytoscape.data.readers.GraphReader;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextJarReader;
import cytoscape.data.servers.BioDataServer;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import y.base.Edge;
import y.base.Node;
import y.view.Graph2D;

public class InteractionsReader
implements GraphReader {
    String filename;
    Vector allInteractions = new Vector();
    GraphObjAttributes edgeAttributes = new GraphObjAttributes();
    Graph2D graph;
    BioDataServer dataServer;
    String species;

    public InteractionsReader(BioDataServer bioDataServer, String string, String string2) {
        this.filename = string2;
        this.dataServer = bioDataServer;
        this.species = string;
    }

    public void read(boolean bl) {
        String string;
        Object object;
        try {
            if (this.filename.trim().startsWith("jar://")) {
                object = new TextJarReader(this.filename);
                ((TextJarReader)object).read();
                string = ((TextJarReader)object).getText();
            } else {
                object = new TextFileReader(this.filename);
                ((TextFileReader)object).read();
                string = ((TextFileReader)object).getText();
            }
        }
        catch (Exception exception) {
            System.err.println("-- Exception while reading interaction file " + this.filename);
            System.err.println(exception.getMessage());
            return;
        }
        object = " ";
        if (string.indexOf("\t") >= 0) {
            object = "\t";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            this.allInteractions.addElement(new Interaction(string2, (String)object));
        }
        this.createGraphFromInteractionData(bl);
    }

    public void read() {
        this.read(true);
    }

    public int getCount() {
        return this.allInteractions.size();
    }

    public Interaction[] getAllInteractions() {
        Interaction[] interactionArray = new Interaction[this.allInteractions.size()];
        for (int i = 0; i < this.allInteractions.size(); ++i) {
            Interaction interaction;
            interactionArray[i] = interaction = (Interaction)this.allInteractions.elementAt(i);
        }
        return interactionArray;
    }

    protected String canonicalizeName(String string) {
        String string2 = string;
        if (this.dataServer != null && (string2 = this.dataServer.getCanonicalName(this.species, string)) == null) {
            string2 = string;
        }
        return string2;
    }

    protected void createGraphFromInteractionData(boolean bl) {
        Node node;
        Object object;
        Node node2;
        String string;
        Interaction interaction;
        int n;
        this.graph = new Graph2D();
        Interaction[] interactionArray = this.getAllInteractions();
        Hashtable<String, Node> hashtable = new Hashtable<String, Node>();
        for (n = 0; n < interactionArray.length; ++n) {
            interaction = interactionArray[n];
            string = bl ? this.canonicalizeName(interaction.getSource()) : interaction.getSource();
            if (!hashtable.containsKey(string)) {
                node2 = this.graph.createNode(0.0, 0.0, 70.0, 30.0, string);
                hashtable.put(string, node2);
            }
            node2 = interaction.getTargets();
            for (int i = 0; i < ((String[])node2).length; ++i) {
                object = bl ? this.canonicalizeName((String)node2[i]) : node2[i];
                if (hashtable.containsKey(object)) continue;
                node = this.graph.createNode(0.0, 0.0, 70.0, 30.0, (String)object);
                hashtable.put((String)object, node);
            }
        }
        for (n = 0; n < interactionArray.length; ++n) {
            interaction = interactionArray[n];
            string = bl ? this.canonicalizeName(interaction.getSource()) : interaction.getSource();
            node2 = interaction.getType();
            Node node3 = (Node)hashtable.get(string);
            node = interaction.getTargets();
            for (int i = 0; i < ((String[])node).length; ++i) {
                object = bl ? this.canonicalizeName(node[i]) : node[i];
                Node node4 = (Node)hashtable.get(object);
                Edge edge = this.graph.createEdge(node3, node4);
                String string2 = string + " (" + (String)node2 + ") " + (String)object;
                int n2 = this.edgeAttributes.countIdentical(string2);
                if (n2 > 0) {
                    string2 = string2 + "_" + n2;
                }
                this.edgeAttributes.add("interaction", string2, node2);
                this.edgeAttributes.addNameMapping(string2, edge);
            }
        }
    }

    public Graph2D getGraph() {
        return this.graph;
    }

    public GraphObjAttributes getEdgeAttributes() {
        return this.edgeAttributes;
    }
}

