/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.data.GraphProps;
import java.io.IOException;
import y.base.Edge;
import y.base.Node;
import y.base.NodeCursor;
import y.io.GMLIOHandler;
import y.view.Graph2D;

public class GMLWriter {
    GraphProps props;

    public GMLWriter(GraphProps graphProps) {
        this.props = graphProps;
    }

    public void write(String string) {
        String string2;
        Node node;
        GMLIOHandler gMLIOHandler = new GMLIOHandler();
        Graph2D graph2D = this.props.getGraph();
        NodeCursor nodeCursor = graph2D.nodes();
        while (nodeCursor.ok()) {
            node = nodeCursor.node();
            string2 = this.props.getName(node);
            graph2D.setLabelText(node, string2);
            nodeCursor.next();
        }
        nodeCursor = graph2D.edges();
        while (nodeCursor.ok()) {
            node = nodeCursor.edge();
            string2 = this.props.getType((Edge)node);
            if (string2.startsWith("(")) {
                string2 = string2.substring(1, string2.length());
            }
            if (string2.endsWith(")")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            graph2D.setLabelText((Edge)node, string2);
            nodeCursor.next();
        }
        try {
            gMLIOHandler.write(graph2D, string);
        }
        catch (IOException iOException) {
            System.err.println("error reading '" + string + "' -- " + iOException.getMessage());
            iOException.printStackTrace();
            return;
        }
        nodeCursor = graph2D.edges();
        while (nodeCursor.ok()) {
            node = nodeCursor.edge();
            graph2D.setLabelText((Edge)node, null);
            nodeCursor.next();
        }
    }
}

