/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.GraphObjAttributes;
import cytoscape.data.readers.GraphReader;
import java.io.IOException;
import y.base.Edge;
import y.base.EdgeCursor;
import y.io.GMLIOHandler;
import y.view.Graph2D;
import y.view.Graph2DView;

public class GMLReader
implements GraphReader {
    private String filename;
    GraphObjAttributes edgeAttributes = new GraphObjAttributes();
    Graph2D graph;

    public GMLReader(String string) {
        this.filename = string;
    }

    public void read(boolean bl) {
        this.read();
    }

    public void read() {
        GMLIOHandler gMLIOHandler = new GMLIOHandler();
        this.graph = new Graph2D();
        try {
            gMLIOHandler.read(this.graph, this.filename);
        }
        catch (IOException iOException) {
            System.err.println("error reading '" + this.filename + "' -- " + iOException.getMessage());
            iOException.printStackTrace();
            this.graph = null;
            return;
        }
        Graph2DView graph2DView = new Graph2DView(this.graph);
        EdgeCursor edgeCursor = this.graph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            String string = this.graph.getLabelText(edge);
            this.graph.setLabelText(edge, null);
            String string2 = graph2DView.getGraph2D().getLabelText(edge.source());
            String string3 = graph2DView.getGraph2D().getLabelText(edge.target());
            String string4 = string2 + " (" + string + ") " + string3;
            int n = this.edgeAttributes.countIdentical(string4);
            if (n > 0) {
                string4 = string4 + "_" + n;
            }
            this.edgeAttributes.add("interaction", string4, string);
            this.edgeAttributes.addNameMapping(string4, edge);
            this.edgeAttributes.add("interaction", string4, string);
            edgeCursor.next();
        }
    }

    public Graph2D getGraph() {
        return this.graph;
    }

    public GraphObjAttributes getEdgeAttributes() {
        return this.edgeAttributes;
    }
}

