/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CytoscapeConfig;
import cytoscape.GraphObjAttributes;
import cytoscape.data.readers.GMLReader;
import cytoscape.data.readers.GraphReader;
import cytoscape.data.readers.InteractionsReader;
import cytoscape.data.servers.BioDataServer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarFile;
import y.view.Graph2D;

public class FileReadingAbstractions {
    public static InputStream getInputStream(String string) {
        if (string == null) {
            return null;
        }
        try {
            if (string.trim().startsWith("jar://")) {
                String string2 = string.substring(6);
                ClassLoader classLoader = FileReadingAbstractions.class.getClassLoader();
                URL uRL = classLoader.getResource(string2);
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                JarFile jarFile = jarURLConnection.getJarFile();
                InputStream inputStream = jarFile.getInputStream(jarFile.getJarEntry(string2));
                return inputStream;
            }
            FileInputStream fileInputStream = new FileInputStream(string);
            return fileInputStream;
        }
        catch (Exception exception) {
            System.err.println("In FileReadingAbstractions.getInputStream:");
            String string3 = "Exception while constructing InputStream from file " + string;
            System.err.println(string3);
            exception.printStackTrace();
            System.err.println("returning null and continuing execution");
            return null;
        }
    }

    public static Graph2D loadGMLBasic(String string, GraphObjAttributes graphObjAttributes, boolean bl) {
        GMLReader gMLReader = new GMLReader(string);
        return FileReadingAbstractions.loadBasic(gMLReader, graphObjAttributes, bl);
    }

    public static Graph2D loadIntrBasic(BioDataServer bioDataServer, String string, String string2, GraphObjAttributes graphObjAttributes, boolean bl) {
        InteractionsReader interactionsReader = new InteractionsReader(bioDataServer, string, string2);
        return FileReadingAbstractions.loadBasic(interactionsReader, graphObjAttributes, bl);
    }

    public static Graph2D loadBasic(GraphReader graphReader, GraphObjAttributes graphObjAttributes, boolean bl) {
        graphReader.read(bl);
        Graph2D graph2D = graphReader.getGraph();
        if (graph2D == null) {
            return null;
        }
        GraphObjAttributes graphObjAttributes2 = graphReader.getEdgeAttributes();
        graphObjAttributes.add(graphObjAttributes2);
        graphObjAttributes.addNameMap(graphObjAttributes2.getNameMap());
        graphObjAttributes.addClassMap(graphObjAttributes2.getClassMap());
        return graph2D;
    }

    public static void initAttribs(BioDataServer bioDataServer, String string, CytoscapeConfig cytoscapeConfig, Graph2D graph2D, GraphObjAttributes graphObjAttributes, GraphObjAttributes graphObjAttributes2) {
        String[] stringArray = cytoscapeConfig.getEdgeAttributeFilenames();
        String[] stringArray2 = cytoscapeConfig.getNodeAttributeFilenames();
        boolean bl = cytoscapeConfig.getCanonicalize();
        FileReadingAbstractions.initAttribs(bioDataServer, string, graph2D, graphObjAttributes, graphObjAttributes2, stringArray2, stringArray, bl);
    }

    public static void initAttribs(BioDataServer bioDataServer, String string, Graph2D graph2D, GraphObjAttributes graphObjAttributes, GraphObjAttributes graphObjAttributes2, String[] stringArray, String[] stringArray2, boolean bl) {
        FileReadingAbstractions.readAttribs(bioDataServer, string, graph2D, graphObjAttributes, graphObjAttributes2, stringArray, stringArray2, bl);
        if (graphObjAttributes != null) {
            FileReadingAbstractions.addNameMappingToAttributes(graph2D.getNodeArray(), graphObjAttributes);
        }
    }

    public static void readAttribs(BioDataServer bioDataServer, String string, Graph2D graph2D, GraphObjAttributes graphObjAttributes, GraphObjAttributes graphObjAttributes2, String[] stringArray, String[] stringArray2, boolean bl) {
        int n;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                try {
                    graphObjAttributes.readAttributesFromFile(bioDataServer, string, stringArray[n], bl);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(numberFormatException.getMessage());
                    numberFormatException.printStackTrace();
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(illegalArgumentException.getMessage());
                    illegalArgumentException.printStackTrace();
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getMessage());
                    fileNotFoundException.printStackTrace();
                }
            }
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                try {
                    graphObjAttributes2.readAttributesFromFile(stringArray2[n]);
                    continue;
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
    }

    protected static void addNameMappingToAttributes(Object[] objectArray, GraphObjAttributes graphObjAttributes) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            String string = object.toString();
            graphObjAttributes.addNameMapping(string, object);
        }
    }
}

