/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation.unitTests;

import cytoscape.data.annotation.Ontology;
import cytoscape.data.annotation.OntologyDescription;
import cytoscape.data.annotation.OntologyTerm;
import cytoscape.data.annotation.unitTests.Utils;
import cytoscape.unitTests.AllTests;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class OntologyTest
extends TestCase {
    public OntologyTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCtor() throws Exception {
        AllTests.standardOut("testCtor");
        String string = "KEGG";
        String string2 = "Metabolic Pathways";
        Ontology ontology = Utils.createMinimalKeggMetabolicPathwayOntology();
        OntologyTest.assertTrue((boolean)ontology.getCurator().equals(string));
        OntologyTest.assertTrue((boolean)ontology.getType().equals(string2));
        OntologyDescription ontologyDescription = ontology.getDescription();
        OntologyTest.assertTrue((boolean)ontologyDescription.getCurator().equals(string));
        OntologyTest.assertTrue((boolean)ontologyDescription.getType().equals(string2));
    }

    public void testAdd() throws Exception {
        AllTests.standardOut("testAdd");
        String string = "KEGG";
        String string2 = "Metabolic Pathways";
        Ontology ontology = new Ontology(string, string2);
        OntologyTerm ontologyTerm = new OntologyTerm("Metabolism", 90001);
        OntologyTerm ontologyTerm2 = new OntologyTerm("Carbohydrate Metabolism", 80001);
        ontologyTerm2.addParent(ontologyTerm.getId());
        ontology.add(ontologyTerm);
        ontology.add(ontologyTerm2);
        OntologyTest.assertTrue((ontology.size() == 2 ? 1 : 0) != 0);
        OntologyTest.assertTrue((boolean)ontology.containsTerm(ontologyTerm.getId()));
        OntologyTest.assertTrue((boolean)ontology.containsTerm(ontologyTerm2.getId()));
        OntologyTerm ontologyTerm3 = ontology.getTerm(ontologyTerm.getId());
        OntologyTerm ontologyTerm4 = ontology.getTerm(ontologyTerm2.getId());
        OntologyTest.assertTrue((boolean)ontologyTerm3.getName().equals("Metabolism"));
        OntologyTest.assertTrue((boolean)ontologyTerm4.getName().equals("Carbohydrate Metabolism"));
        OntologyTest.assertTrue((ontology.getTerms().size() == 2 ? 1 : 0) != 0);
    }

    public void testGetHierarchyInts() throws Exception {
        AllTests.standardOut("testGetHierarchyInts");
        Ontology ontology = Utils.createMinimalKeggMetabolicPathwayOntology();
        int[][] nArray = ontology.getAllHierarchyPaths(80001);
        OntologyTest.assertTrue((nArray.length == 1 ? 1 : 0) != 0);
        OntologyTest.assertTrue((nArray[0].length == 2 ? 1 : 0) != 0);
        OntologyTest.assertTrue((nArray[0][0] == 90001 ? 1 : 0) != 0);
        OntologyTest.assertTrue((nArray[0][1] == 80001 ? 1 : 0) != 0);
        nArray = ontology.getAllHierarchyPaths(40);
        OntologyTest.assertTrue((nArray.length == 1 ? 1 : 0) != 0);
        OntologyTest.assertTrue((nArray[0].length == 3 ? 1 : 0) != 0);
        OntologyTest.assertTrue((nArray[0][0] == 90001 ? 1 : 0) != 0);
        OntologyTest.assertTrue((nArray[0][1] == 80001 ? 1 : 0) != 0);
        OntologyTest.assertTrue((nArray[0][2] == 40 ? 1 : 0) != 0);
        nArray = ontology.getAllHierarchyPaths(666);
        OntologyTest.assertTrue((nArray.length == 2 ? 1 : 0) != 0);
        OntologyTest.assertTrue((nArray[0].length == 4 ? 1 : 0) != 0);
        OntologyTest.assertTrue((nArray[0][0] == 90001 ? 1 : 0) != 0);
        OntologyTest.assertTrue((nArray[0][1] == 80007 ? 1 : 0) != 0);
        OntologyTest.assertTrue((nArray[0][2] == 500 ? 1 : 0) != 0);
        OntologyTest.assertTrue((nArray[0][3] == 666 ? 1 : 0) != 0);
        OntologyTest.assertTrue((nArray[1].length == 4 ? 1 : 0) != 0);
        OntologyTest.assertTrue((nArray[1][0] == 90001 ? 1 : 0) != 0);
        OntologyTest.assertTrue((nArray[1][1] == 80007 ? 1 : 0) != 0);
        OntologyTest.assertTrue((nArray[1][2] == 530 ? 1 : 0) != 0);
        OntologyTest.assertTrue((nArray[1][3] == 666 ? 1 : 0) != 0);
    }

    public void testGetHierarchyNames() throws Exception {
        AllTests.standardOut("testGetHierarchyNames");
        Ontology ontology = Utils.createMinimalKeggMetabolicPathwayOntology();
        String[][] stringArray = ontology.getAllHierarchyPathsAsNames(80001);
        this.printHierarchy(stringArray);
        OntologyTest.assertTrue((stringArray.length == 1 ? 1 : 0) != 0);
        OntologyTest.assertTrue((stringArray[0].length == 2 ? 1 : 0) != 0);
        OntologyTest.assertTrue((boolean)stringArray[0][0].equals("Metabolism"));
        OntologyTest.assertTrue((boolean)stringArray[0][1].equals("Carbohydrate Metabolism"));
        stringArray = ontology.getAllHierarchyPathsAsNames(40);
        OntologyTest.assertTrue((stringArray.length == 1 ? 1 : 0) != 0);
        OntologyTest.assertTrue((stringArray[0].length == 3 ? 1 : 0) != 0);
        OntologyTest.assertTrue((boolean)stringArray[0][0].equals("Metabolism"));
        OntologyTest.assertTrue((boolean)stringArray[0][1].equals("Carbohydrate Metabolism"));
        OntologyTest.assertTrue((boolean)stringArray[0][2].equals("Nucleotide Metabolism"));
        stringArray = ontology.getAllHierarchyPathsAsNames(666);
        this.printHierarchy(stringArray);
        OntologyTest.assertTrue((stringArray.length == 2 ? 1 : 0) != 0);
        OntologyTest.assertTrue((stringArray[0].length == 4 ? 1 : 0) != 0);
        OntologyTest.assertTrue((boolean)stringArray[0][0].equals("Metabolism"));
        OntologyTest.assertTrue((boolean)stringArray[0][1].equals("Glutamate metabolism"));
        OntologyTest.assertTrue((boolean)stringArray[0][2].equals("Biosynthesis of Secondary Metabolites"));
        OntologyTest.assertTrue((boolean)stringArray[0][3].equals("Two Parents"));
        OntologyTest.assertTrue((stringArray[1].length == 4 ? 1 : 0) != 0);
        OntologyTest.assertTrue((boolean)stringArray[1][0].equals("Metabolism"));
        OntologyTest.assertTrue((boolean)stringArray[1][1].equals("Glutamate metabolism"));
        OntologyTest.assertTrue((boolean)stringArray[1][2].equals("Starch and sucrose metabolism"));
        OntologyTest.assertTrue((boolean)stringArray[1][3].equals("Two Parents"));
    }

    private void printHierarchy(int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = nArray[i];
            for (int j = 0; j < nArray2.length; ++j) {
                AllTests.standardOut(nArray2[j] + " ");
            }
            AllTests.standardOut("\n");
        }
    }

    private void printHierarchy(String[][] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            for (int j = 0; j < stringArray2.length; ++j) {
                AllTests.standardOut(stringArray2[j]);
                if (j >= stringArray2.length - 1) continue;
                AllTests.standardOut(", ");
            }
            AllTests.standardOut("\n");
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(OntologyTest.class));
    }
}

