/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation.unitTests;

import cytoscape.data.annotation.OntologyTerm;
import cytoscape.unitTests.AllTests;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class OntologyTermTest
extends TestCase {
    public OntologyTermTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCtor() throws Exception {
        AllTests.standardOut("testCtor");
        String string = "Carbohydrate Metabolism";
        int n = 80001;
        OntologyTerm ontologyTerm = new OntologyTerm(string, n);
        OntologyTermTest.assertTrue((boolean)ontologyTerm.getName().equals(string));
        OntologyTermTest.assertTrue((ontologyTerm.getId() == n ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((ontologyTerm.numberOfParents() == 0 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((ontologyTerm.numberOfContainers() == 0 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((ontologyTerm.numberOfParentsAndContainers() == 0 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((ontologyTerm.getParents().length == 0 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((ontologyTerm.getContainers().length == 0 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((ontologyTerm.getParentsAndContainers().length == 0 ? 1 : 0) != 0);
    }

    public void testAddParentsAndContainers() throws Exception {
        AllTests.standardOut("testAddParentsAndContainers");
        String string = "Carbohydrate Metabolism";
        int n = 80001;
        OntologyTerm ontologyTerm = new OntologyTerm(string, n);
        int[] nArray = new int[]{123, 456};
        for (int i = 0; i < nArray.length; ++i) {
            ontologyTerm.addParent(nArray[i]);
        }
        int[] nArray2 = new int[]{1, 2, 3, 4};
        for (int i = 0; i < nArray2.length; ++i) {
            ontologyTerm.addContainer(nArray2[i]);
        }
        OntologyTermTest.assertTrue((boolean)ontologyTerm.getName().equals(string));
        OntologyTermTest.assertTrue((ontologyTerm.getId() == n ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((ontologyTerm.numberOfParents() == 2 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((ontologyTerm.numberOfContainers() == 4 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((ontologyTerm.numberOfParentsAndContainers() == 6 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((ontologyTerm.getParents().length == 2 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((ontologyTerm.getContainers().length == 4 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((ontologyTerm.getParentsAndContainers().length == 6 ? 1 : 0) != 0);
        int[] nArray3 = ontologyTerm.getParents();
        OntologyTermTest.assertTrue((nArray3[0] == nArray[0] ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((nArray3[1] == nArray[1] ? 1 : 0) != 0);
        int[] nArray4 = ontologyTerm.getContainers();
        OntologyTermTest.assertTrue((nArray4[0] == nArray2[0] ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((nArray4[1] == nArray2[1] ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((nArray4[2] == nArray2[2] ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((nArray4[3] == nArray2[3] ? 1 : 0) != 0);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(OntologyTermTest.class));
    }
}

