/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation.unitTests;

import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.Ontology;
import cytoscape.data.annotation.unitTests.Utils;
import cytoscape.unitTests.AllTests;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AnnotationTest
extends TestCase {
    public AnnotationTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCtor() throws Exception {
        AllTests.standardOut("testCtor");
        Ontology ontology = Utils.createMinimalKeggMetabolicPathwayOntology();
        String string = "Saccharomyces cerevisiae";
        String string2 = "pathways";
        Annotation annotation = new Annotation(string, string2, ontology);
        AnnotationTest.assertTrue((annotation.size() == 0 ? 1 : 0) != 0);
        AnnotationTest.assertTrue((annotation.count() == 0 ? 1 : 0) != 0);
        AnnotationTest.assertTrue((boolean)annotation.getCurator().equals(ontology.getCurator()));
        AnnotationTest.assertTrue((boolean)annotation.getType().equals(string2));
        AnnotationTest.assertTrue((boolean)annotation.getOntologyType().equals(ontology.getType()));
        AnnotationTest.assertTrue((boolean)annotation.getSpecies().equals(string));
    }

    public void testAdd() throws Exception {
        AllTests.standardOut("testAdd");
        Ontology ontology = Utils.createMinimalKeggMetabolicPathwayOntology();
        Annotation annotation = new Annotation("Halobacterium Sp.", "pathways", ontology);
        AnnotationTest.assertTrue((annotation.size() == 0 ? 1 : 0) != 0);
        annotation.add("VNG0006G", 251);
        annotation.add("VNG0006G", 530);
        annotation.add("VNG0008G", 520);
        annotation.add("VNG0008G", 522);
        annotation.add("VNG0009G", 520);
        annotation.add("VNG0009G", 522);
        annotation.add("VNG0046G", 40);
        annotation.add("VNG0046G", 500);
        annotation.add("VNG0046G", 520);
        AnnotationTest.assertTrue((annotation.size() == 9 ? 1 : 0) != 0);
        AnnotationTest.assertTrue((annotation.count() == 4 ? 1 : 0) != 0);
    }

    public void testGet() throws Exception {
        AllTests.standardOut("testGet");
        Ontology ontology = Utils.createMinimalKeggMetabolicPathwayOntology();
        Annotation annotation = new Annotation("Halobacterium Sp.", "pathways", ontology);
        annotation.add("VNG0006G", 251);
        annotation.add("VNG0006G", 530);
        annotation.add("VNG0008G", 520);
        annotation.add("VNG0008G", 522);
        annotation.add("VNG0009G", 520);
        annotation.add("VNG0046G", 40);
        annotation.add("VNG0046G", 500);
        annotation.add("VNG0046G", 520);
        String[] stringArray = annotation.getNames();
        AnnotationTest.assertTrue((stringArray.length == 4 ? 1 : 0) != 0);
        int[] nArray = annotation.getClassifications("VNG0006G");
        AnnotationTest.assertTrue((nArray.length == 2 ? 1 : 0) != 0);
        AnnotationTest.assertTrue((nArray[0] == 251 ? 1 : 0) != 0);
        AnnotationTest.assertTrue((nArray[1] == 530 ? 1 : 0) != 0);
        nArray = annotation.getClassifications("VNG0008G");
        AnnotationTest.assertTrue((nArray.length == 2 ? 1 : 0) != 0);
        AnnotationTest.assertTrue((nArray[0] == 520 ? 1 : 0) != 0);
        AnnotationTest.assertTrue((nArray[1] == 522 ? 1 : 0) != 0);
        nArray = annotation.getClassifications("VNG0009G");
        AnnotationTest.assertTrue((nArray.length == 1 ? 1 : 0) != 0);
        AnnotationTest.assertTrue((nArray[0] == 520 ? 1 : 0) != 0);
        nArray = annotation.getClassifications("VNG0046G");
        AnnotationTest.assertTrue((nArray.length == 3 ? 1 : 0) != 0);
        AnnotationTest.assertTrue((nArray[0] == 40 ? 1 : 0) != 0);
        AnnotationTest.assertTrue((nArray[1] == 500 ? 1 : 0) != 0);
        AnnotationTest.assertTrue((nArray[2] == 520 ? 1 : 0) != 0);
    }

    public void testMaxDepth() throws Exception {
        AllTests.standardOut("testMaxDepth");
        Ontology ontology = Utils.createMinimalKeggMetabolicPathwayOntology();
        Annotation annotation = new Annotation("Halobacterium Sp.", "pathways", ontology);
        annotation.add("VNG0009G", 520);
        AnnotationTest.assertTrue((annotation.maxDepth() == 3 ? 1 : 0) != 0);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(AnnotationTest.class));
    }
}

