/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation.readers;

import cytoscape.data.annotation.Ontology;
import cytoscape.data.annotation.OntologyTerm;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextHttpReader;
import cytoscape.data.readers.TextJarReader;
import java.io.File;

public class OntologyFlatFileReader {
    Ontology ontology;
    String curator = "unknown";
    String ontologyType = "unknown";
    String filename;
    String fullText;
    String[] lines;

    public OntologyFlatFileReader(File file) throws Exception {
        this(file.getPath());
    }

    public OntologyFlatFileReader(String string) throws Exception {
        this.filename = string;
        try {
            if (string.trim().startsWith("jar://")) {
                TextJarReader textJarReader = new TextJarReader(string);
                textJarReader.read();
                this.fullText = textJarReader.getText();
            } else if (string.trim().startsWith("http://")) {
                TextHttpReader textHttpReader = new TextHttpReader(string);
                textHttpReader.read();
                this.fullText = textHttpReader.getText();
            } else {
                TextFileReader textFileReader = new TextFileReader(string);
                textFileReader.read();
                this.fullText = textFileReader.getText();
            }
        }
        catch (Exception exception) {
            System.err.println("-- Exception while reading ontology flat file " + string);
            System.err.println(exception.getMessage());
            return;
        }
        this.lines = this.fullText.split("\n");
        this.parseHeader();
        this.parse();
    }

    private int stringToInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private void parseHeader() throws Exception {
        String string = this.lines[0].trim();
        String[] stringArray = string.split("\\)");
        String string2 = "error in OntologyFlatFileReader.parseHeader ().\n";
        string2 = string2 + "First line of " + this.filename + " must have form:\n";
        string2 = string2 + "   (curator=GO) (type=all) \n";
        string2 = string2 + "instead found:\n";
        string2 = string2 + "   " + string + "\n";
        if (stringArray.length != 2) {
            throw new IllegalArgumentException(string2);
        }
        String[] stringArray2 = stringArray[0].split("=");
        if (stringArray2.length != 2) {
            throw new IllegalArgumentException(string2);
        }
        this.curator = stringArray2[1].trim();
        String[] stringArray3 = stringArray[1].split("=");
        if (stringArray3.length != 2) {
            throw new IllegalArgumentException(string2);
        }
        this.ontologyType = stringArray3[1].trim();
    }

    private void parse() throws Exception {
        this.ontology = new Ontology(this.curator, this.ontologyType);
        for (int i = 1; i < this.lines.length; ++i) {
            Object object;
            int n;
            String string = this.lines[i];
            int n2 = string.indexOf("=");
            String string2 = string.substring(0, n2).trim();
            int n3 = this.stringToInt(string2);
            String string3 = string.substring(n2 + 1);
            int n4 = string3.indexOf("[");
            if (n4 < 0) continue;
            String string4 = string3.substring(0, n4).trim();
            OntologyTerm ontologyTerm = new OntologyTerm(string4, n3);
            int n5 = string3.indexOf("[isa: ");
            if (n5 >= 0) {
                n = string3.indexOf("]", n5);
                String string5 = string3.substring(n5 + 6, n).trim();
                object = string5.split(" ");
                for (int j = 0; j < ((String[])object).length; ++j) {
                    ontologyTerm.addParent(this.stringToInt((String)object[j]));
                }
            }
            if ((n = string3.indexOf("[partof: ")) >= 0) {
                int n6 = string3.indexOf("]", n);
                object = string3.substring(n + 9, n6).trim();
                String[] stringArray = ((String)object).split(" ");
                for (int j = 0; j < stringArray.length; ++j) {
                    ontologyTerm.addContainer(this.stringToInt(stringArray[j]));
                }
            }
            this.ontology.add(ontologyTerm);
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }
}

