/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation.readers;

import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.Ontology;
import cytoscape.data.annotation.readers.OntologyXmlReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class AnnotationXmlReader {
    File xmlFile;
    Annotation annotation;
    File directoryAbsolute;

    public AnnotationXmlReader(File file) throws Exception {
        if (!file.canRead()) {
            System.out.println("---- data.annotation.readers.AnnotationXmlReader error, cannot read");
            System.out.println("        " + file);
            throw new Exception("cannot read input: " + file);
        }
        this.xmlFile = file;
        this.directoryAbsolute = file.getAbsoluteFile().getParentFile();
        this.read();
    }

    private void read() throws Exception {
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(this.xmlFile);
        Element element = document.getRootElement();
        String string = element.getAttributeValue("species");
        String string2 = element.getAttributeValue("ontology");
        String string3 = element.getAttributeValue("type");
        File file = new File(this.directoryAbsolute, string2);
        if (!file.canRead()) {
            System.err.println("annotation xml file must name its associated ontology xml file");
            System.err.println("by giving its path relative to the actual location of the");
            System.err.println("annotation xml file.\n");
            System.err.println("could not find:");
            System.err.println("  " + file);
            throw new FileNotFoundException(file.getPath());
        }
        OntologyXmlReader ontologyXmlReader = new OntologyXmlReader(file);
        Ontology ontology = ontologyXmlReader.getOntology();
        this.annotation = new Annotation(string, string3, ontology);
        List list = element.getChildren();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Element element2 = (Element)listIterator.next();
            String string4 = element2.getChild("entity").getText().trim();
            String string5 = element2.getChild("id").getText().trim();
            int n = Integer.parseInt(string5);
            this.annotation.add(string4, n);
        }
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }
}

