/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation.readers;

import cytoscape.data.annotation.Annotation;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextHttpReader;
import cytoscape.data.readers.TextJarReader;
import java.io.File;

public class AnnotationFlatFileReader {
    Annotation annotation;
    String annotationType;
    String species;
    String curator;
    String filename;
    File directoryAbsolute;
    String fullText;
    String[] lines;

    public AnnotationFlatFileReader(File file) throws Exception {
        this(file.getPath());
    }

    public AnnotationFlatFileReader(String string) throws Exception {
        this.filename = string;
        try {
            if (string.trim().startsWith("jar://")) {
                TextJarReader textJarReader = new TextJarReader(string);
                textJarReader.read();
                this.fullText = textJarReader.getText();
            } else if (string.trim().startsWith("http://")) {
                TextHttpReader textHttpReader = new TextHttpReader(string);
                textHttpReader.read();
                this.fullText = textHttpReader.getText();
            } else {
                TextFileReader textFileReader = new TextFileReader(string);
                textFileReader.read();
                this.fullText = textFileReader.getText();
            }
        }
        catch (Exception exception) {
            System.err.println("-- Exception while reading ontology flat file " + string);
            System.err.println(exception.getMessage());
            return;
        }
        this.lines = this.fullText.split("\n");
        this.parseHeader(this.lines[0]);
        this.parse();
    }

    private int stringToInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public void parseHeader(String string) throws Exception {
        String[] stringArray = string.trim().split("\\)");
        String string2 = "error in AnnotationFlatFileReader.parseHeader ().\n";
        string2 = string2 + "First line of " + this.filename + " must have form:\n";
        string2 = string2 + "   (species=Homo sapiens) (type=Biological Process) (curator=GO)\n";
        string2 = string2 + "instead found:\n";
        string2 = string2 + "   " + string + "\n";
        if (stringArray.length != 3) {
            throw new IllegalArgumentException(string2);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            if (stringArray2.length != 2) {
                throw new IllegalArgumentException(string2);
            }
            String string3 = stringArray2[0].trim();
            String string4 = stringArray2[1].trim();
            if (string3.equalsIgnoreCase("(species")) {
                this.species = string4;
                continue;
            }
            if (string3.equalsIgnoreCase("(type")) {
                this.annotationType = string4;
                continue;
            }
            if (!string3.equalsIgnoreCase("(curator")) continue;
            this.curator = string4;
        }
    }

    private void parse() throws Exception {
        this.annotation = new Annotation(this.species, this.annotationType, this.curator);
        for (int i = 1; i < this.lines.length; ++i) {
            String string = this.lines[i];
            if (string.length() < 2) continue;
            String[] stringArray = string.split("=");
            String string2 = stringArray[0].trim();
            int n = this.stringToInt(stringArray[1].trim());
            this.annotation.add(string2, n);
        }
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }
}

