/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation;

import cytoscape.data.annotation.Ontology;
import java.io.Serializable;
import java.util.Vector;

public class OntologyTerm
implements Serializable {
    String name;
    int id;
    Vector parents;
    Vector containers;

    public OntologyTerm(String string, int n) {
        this.name = string;
        this.id = n;
        this.parents = new Vector();
        this.containers = new Vector();
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public void addParent(int n) {
        this.parents.addElement(new Integer(n));
    }

    public void addContainer(int n) {
        this.containers.addElement(new Integer(n));
    }

    public int numberOfParentsAndContainers() {
        return this.numberOfParents() + this.numberOfContainers();
    }

    public int numberOfParents() {
        return this.parents.size();
    }

    public int numberOfContainers() {
        return this.containers.size();
    }

    public int[] getParents() {
        int n = this.numberOfParents();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            Integer n2 = (Integer)this.parents.elementAt(i);
            nArray[i] = n2;
        }
        return nArray;
    }

    public int[] getContainers() {
        int n = this.numberOfContainers();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            Integer n2 = (Integer)this.containers.elementAt(i);
            nArray[i] = n2;
        }
        return nArray;
    }

    public int[] getParentsAndContainers() {
        int n;
        int n2 = this.numberOfParents() + this.numberOfContainers();
        int[] nArray = new int[n2];
        int[] nArray2 = this.getParents();
        int[] nArray3 = this.getContainers();
        for (n = 0; n < nArray2.length; ++n) {
            nArray[n] = nArray2[n];
        }
        for (n = 0; n < nArray3.length; ++n) {
            nArray[n + nArray2.length] = nArray3[n];
        }
        return nArray;
    }

    public boolean isParentOf(OntologyTerm ontologyTerm) {
        int[] nArray = ontologyTerm.getParents();
        for (int i = 0; i < nArray.length; ++i) {
            if (this.id != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isAncestorOf(Ontology ontology, OntologyTerm ontologyTerm) {
        if (this.isParentOrContainerOf(ontologyTerm)) {
            return true;
        }
        int[] nArray = this.getParentsAndContainers();
        for (int i = 0; i < nArray.length; ++i) {
            OntologyTerm ontologyTerm2 = ontology.getTerm(nArray[i]);
            if (ontologyTerm2 == null || !ontologyTerm2.isAncestorOf(ontology, ontologyTerm)) continue;
            return true;
        }
        return false;
    }

    public boolean isChildOf(OntologyTerm ontologyTerm) {
        int n = ontologyTerm.getId();
        int[] nArray = this.getParents();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    public boolean isContainerOf(OntologyTerm ontologyTerm) {
        int[] nArray = ontologyTerm.getContainers();
        for (int i = 0; i < nArray.length; ++i) {
            if (this.id != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isContainedIn(OntologyTerm ontologyTerm) {
        int[] nArray = this.getContainers();
        int n = ontologyTerm.getId();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    public boolean isChildOfOrContainedIn(OntologyTerm ontologyTerm) {
        int n = ontologyTerm.getId();
        int[] nArray = this.getParentsAndContainers();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isParentOrContainerOf(OntologyTerm ontologyTerm) {
        int[] nArray = ontologyTerm.getParentsAndContainers();
        for (int i = 0; i < nArray.length; ++i) {
            if (this.id != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("name: ");
        stringBuffer.append(this.name);
        stringBuffer.append("\n");
        stringBuffer.append("id: ");
        stringBuffer.append(this.id);
        stringBuffer.append("\n");
        int[] nArray = this.getParents();
        stringBuffer.append("parents: ");
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            stringBuffer.append(" ");
        }
        stringBuffer.append("\n");
        int[] nArray2 = this.getContainers();
        stringBuffer.append("containers: ");
        for (int i = 0; i < nArray2.length; ++i) {
            stringBuffer.append(nArray2[i]);
            stringBuffer.append(" ");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

