/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation;

import cytoscape.data.annotation.FlattenIntVectors;
import cytoscape.data.annotation.OntologyDescription;
import cytoscape.data.annotation.OntologyTerm;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

public class Ontology
implements Serializable {
    protected String curator;
    protected String ontologyType;
    protected HashMap termHash;

    public Ontology(String string, String string2) {
        this.curator = string;
        this.ontologyType = string2;
        this.termHash = new HashMap();
    }

    public String getCurator() {
        return this.curator;
    }

    public String getType() {
        return this.ontologyType;
    }

    public void add(OntologyTerm ontologyTerm) {
        this.termHash.put(new Integer(ontologyTerm.getId()), ontologyTerm);
    }

    public int size() {
        return this.termHash.size();
    }

    public HashMap getTerms() {
        return this.termHash;
    }

    public boolean containsTerm(int n) {
        return this.termHash.containsKey(new Integer(n));
    }

    public OntologyTerm getTerm(int n) {
        return (OntologyTerm)this.termHash.get(new Integer(n));
    }

    public int[][] getAllHierarchyPaths(int n) {
        Vector vector = this.getAllHierarchyPathsAsVector(n);
        int n2 = vector.size();
        int[][] nArrayArray = new int[n2][];
        for (int i = 0; i < n2; ++i) {
            Vector vector2 = (Vector)vector.get(i);
            int n3 = vector2.size();
            nArrayArray[i] = new int[n3];
            for (int j = 0; j < n3; ++j) {
                int n4 = n3 - j - 1;
                nArrayArray[i][j] = (Integer)vector2.get(n4);
            }
        }
        return nArrayArray;
    }

    public String[][] getAllHierarchyPathsAsNames(int n) {
        int[][] nArray = this.getAllHierarchyPaths(n);
        String[][] stringArray = new String[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = nArray[i];
            int n2 = nArray2.length;
            stringArray[i] = new String[n2];
            for (int j = 0; j < nArray2.length; ++j) {
                stringArray[i][j] = this.getTerm(nArray2[j]).getName();
            }
        }
        return stringArray;
    }

    protected Vector getAllHierarchyPathsAsVector(int n) {
        Vector vector = this.recursiveGetPath(n, new Vector());
        if (vector.size() == 0) {
            return vector;
        }
        FlattenIntVectors flattenIntVectors = new FlattenIntVectors(vector);
        Vector vector2 = flattenIntVectors.getResult();
        return vector2;
    }

    protected Vector recursiveGetPath(int n, Vector vector) {
        Integer n2 = new Integer(n);
        if (this.termHash != null && this.termHash.containsKey(n2)) {
            OntologyTerm ontologyTerm = (OntologyTerm)this.termHash.get(n2);
            int n3 = ontologyTerm.numberOfParentsAndContainers();
            vector.addElement(n2);
            if (n3 == 0) {
                return vector;
            }
            if (n3 == 1) {
                int n4 = ontologyTerm.getParentsAndContainers()[0];
                return this.recursiveGetPath(n4, vector);
            }
            Vector<Vector> vector2 = new Vector<Vector>();
            for (int i = 0; i < n3; ++i) {
                Vector vector3 = (Vector)vector.clone();
                int n5 = ontologyTerm.getParentsAndContainers()[i];
                vector2.addElement(this.recursiveGetPath(n5, vector3));
            }
            return vector2;
        }
        return vector;
    }

    protected Vector oldRecursiveGetPath(int n, Vector vector) {
        Integer n2 = new Integer(n);
        if (this.termHash != null && this.termHash.containsKey(n2)) {
            OntologyTerm ontologyTerm = (OntologyTerm)this.termHash.get(n2);
            int n3 = ontologyTerm.numberOfParentsAndContainers();
            if (n3 == 0) {
                vector.addElement(n2);
                return vector;
            }
            if (n3 == 1) {
                vector.addElement(n2);
                int n4 = ontologyTerm.getParentsAndContainers()[0];
                return this.recursiveGetPath(n4, vector);
            }
            vector.addElement(n2);
            Vector<Vector> vector2 = new Vector<Vector>();
            Vector vector3 = (Vector)vector.clone();
            Vector vector4 = (Vector)vector.clone();
            int n5 = ontologyTerm.getParentsAndContainers()[0];
            int n6 = ontologyTerm.getParentsAndContainers()[1];
            vector2.addElement(this.recursiveGetPath(n5, vector3));
            vector2.addElement(this.recursiveGetPath(n6, vector4));
            return vector2;
        }
        return vector;
    }

    public OntologyDescription getDescription() {
        return new OntologyDescription(this.curator, this.ontologyType);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ontology: " + this.ontologyType + "\n");
        stringBuffer.append("curator:  " + this.curator + "\n");
        return stringBuffer.toString();
    }
}

