/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation;

import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.AnnotationDescription;
import cytoscape.data.servers.BioDataServer;
import cytoscape.layout.AttributeLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import y.base.Node;
import y.view.Graph2D;

public class AnnotationGui
extends AbstractAction {
    protected CytoscapeWindow cytoscapeWindow;
    protected GraphObjAttributes nodeAttributes;
    protected GraphObjAttributes edgeAttributes;
    protected BioDataServer dataServer;
    protected String defaultSpecies;
    protected Properties props;
    AnnotationDescription[] annotationDescriptions;
    JTree availableAnnotationsTree;
    JTree currentAnnotationsTree;
    JList actionListBox;
    DefaultListModel actionListModel;
    int actionListBoxCurrentSelection;
    TreePath annotationPath;
    String currentAnnotationCategory;
    AttributeLayout attributeLayouter;
    Graph2D graph;
    JButton annotateNodesButton;
    JButton layoutByAnnotationButton;
    JButton addSharedAnnotationEdgesButton;

    public AnnotationGui(CytoscapeWindow cytoscapeWindow) {
        this.dataServer = cytoscapeWindow.getBioDataServer();
        if (this.dataServer != null) {
            this.annotationDescriptions = this.dataServer.getAnnotationDescriptions();
        }
        this.cytoscapeWindow = cytoscapeWindow;
        this.defaultSpecies = cytoscapeWindow.getDefaultSpecies();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.dataServer == null) {
            JOptionPane.showMessageDialog(null, "No annotations are available.", "Error!", 0);
            return;
        }
        this.cytoscapeWindow.setInteractivity(false);
        this.graph = this.cytoscapeWindow.getGraph();
        this.nodeAttributes = this.cytoscapeWindow.getNodeAttributes();
        this.edgeAttributes = this.cytoscapeWindow.getEdgeAttributes();
        this.attributeLayouter = new AttributeLayout(this.cytoscapeWindow);
        Gui gui = new Gui("Annotation");
        gui.pack();
        gui.setLocationRelativeTo(this.cytoscapeWindow.getMainFrame());
        gui.setVisible(true);
        this.cytoscapeWindow.setInteractivity(true);
    }

    public String addAnnotationToNodes(AnnotationDescription annotationDescription, int n) {
        String string = annotationDescription.getCurator() + " " + annotationDescription.getType();
        String string2 = string + " (level " + n + ")";
        String string3 = string + " leaf IDs";
        this.nodeAttributes.deleteAttribute(string2);
        this.nodeAttributes.deleteAttribute(string3);
        this.cytoscapeWindow.setInteractivity(false);
        HashMap hashMap = this.nodeAttributes.getNameMap();
        String[] stringArray = hashMap.values().toArray(new String[0]);
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String[][] stringArray2 = this.dataServer.getAllAnnotations(annotationDescription, stringArray[i]);
            if (stringArray2.length == 0) {
                ++n2;
                continue;
            }
            String[] stringArray3 = this.collapseToUniqueAnnotationsAtLevel(stringArray2, n);
            for (int j = 0; j < stringArray3.length; ++j) {
                this.nodeAttributes.append(string2, stringArray[i], stringArray3[j]);
            }
            int[] nArray = this.dataServer.getClassifications(annotationDescription, stringArray[i]);
            Integer[] integerArray = new Integer[nArray.length];
            for (int j = 0; j < nArray.length; ++j) {
                integerArray[j] = new Integer(nArray[j]);
            }
        }
        this.nodeAttributes.setCategory(string2, "annotation");
        this.cytoscapeWindow.setInteractivity(true);
        return string2;
    }

    private String[] collapseToUniqueAnnotationsAtLevel(String[][] stringArray, int n) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n2 = n - 1;
            if (n2 > stringArray[i].length - 1) {
                n2 = stringArray[i].length - 1;
            }
            if (vector.contains(string = stringArray[i][n2])) continue;
            vector.add(string);
        }
        return vector.toArray(new String[0]);
    }

    class ActionListBoxSelectionListener
    implements ListSelectionListener {
        ActionListBoxSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            Vector vector = new Vector();
            if (!listSelectionModel.isSelectionEmpty()) {
                int n = listSelectionModel.getMinSelectionIndex();
                int n2 = listSelectionModel.getMaxSelectionIndex();
                for (int i = n; i <= n2; ++i) {
                    if (!listSelectionModel.isSelectedIndex(i)) continue;
                    Object e = AnnotationGui.this.actionListModel.elementAt(i);
                    AnnotationGui.this.currentAnnotationCategory = (String)e;
                }
            }
        }
    }

    class ApplyAnnotationAction
    extends AbstractAction {
        ApplyAnnotationAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Serializable serializable;
            int n = AnnotationGui.this.annotationPath.getPathCount();
            for (int i = 0; i < n; ++i) {
                serializable = (DefaultMutableTreeNode)AnnotationGui.this.annotationPath.getPathComponent(i);
                object = serializable.getUserObject();
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)AnnotationGui.this.annotationPath.getPathComponent(1);
            serializable = (AnnotationDescription)defaultMutableTreeNode.getUserObject();
            object = (DefaultMutableTreeNode)AnnotationGui.this.annotationPath.getPathComponent(2);
            int n2 = (Integer)((DefaultMutableTreeNode)object).getUserObject();
            if (serializable == null) {
                return;
            }
            AnnotationGui.this.cytoscapeWindow.setInteractivity(false);
            AnnotationGui.this.currentAnnotationCategory = AnnotationGui.this.addAnnotationToNodes((AnnotationDescription)serializable, n2);
            Object[] objectArray = AnnotationGui.this.nodeAttributes.getUniqueValues(AnnotationGui.this.currentAnnotationCategory);
            if (objectArray != null && objectArray.length > 0 && objectArray[0].getClass() == "string".getClass()) {
                Arrays.sort(objectArray, String.CASE_INSENSITIVE_ORDER);
                this.appendToSelectionTree(AnnotationGui.this.currentAnnotationCategory, objectArray);
            }
            AnnotationGui.this.cytoscapeWindow.setInteractivity(true);
        }

        protected void appendToSelectionTree(String string, Object[] objectArray) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
            for (int i = 0; i < objectArray.length; ++i) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(objectArray[i]));
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)AnnotationGui.this.currentAnnotationsTree.getModel().getRoot();
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)AnnotationGui.this.currentAnnotationsTree.getModel();
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
            AnnotationGui.this.currentAnnotationsTree.scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
            defaultTreeModel.reload();
        }
    }

    protected class Gui
    extends JDialog {
        Gui(String string) {
            super((Frame)AnnotationGui.this.cytoscapeWindow.getMainFrame(), false);
            this.setTitle(string);
            this.setContentPane(this.createWidgets());
        }

        private JPanel createWidgets() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(0, 2));
            AnnotationGui.this.availableAnnotationsTree = this.createAvailableAnnotationsTree();
            AnnotationGui.this.currentAnnotationsTree = this.createNodeSelectionTree();
            AnnotationGui.this.availableAnnotationsTree.addTreeSelectionListener(new AddAnnotationTreeSelectionListener());
            AnnotationGui.this.currentAnnotationsTree.addTreeSelectionListener(new SelectNodesTreeSelectionListener());
            JScrollPane jScrollPane = new JScrollPane(AnnotationGui.this.availableAnnotationsTree);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)jScrollPane, "Center");
            AnnotationGui.this.annotateNodesButton = new JButton("Apply Annotation to All Nodes");
            AnnotationGui.this.annotateNodesButton.setEnabled(false);
            jPanel3.add((Component)AnnotationGui.this.annotateNodesButton, "South");
            jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Avaliable"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            AnnotationGui.this.annotateNodesButton.addActionListener(new ApplyAnnotationAction());
            jPanel2.add(jPanel3);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridLayout(0, 2));
            AnnotationGui.this.layoutByAnnotationButton = new JButton("Layout");
            AnnotationGui.this.layoutByAnnotationButton.setEnabled(false);
            jPanel4.add(AnnotationGui.this.layoutByAnnotationButton);
            AnnotationGui.this.layoutByAnnotationButton.addActionListener(new LayoutByAnnotationAction());
            AnnotationGui.this.addSharedAnnotationEdgesButton = new JButton("Add Edges");
            jPanel4.add(AnnotationGui.this.addSharedAnnotationEdgesButton);
            AnnotationGui.this.addSharedAnnotationEdgesButton.setEnabled(false);
            AnnotationGui.this.addSharedAnnotationEdgesButton.addActionListener(new DrawSharedEdgesAnnotationAction());
            JScrollPane jScrollPane2 = new JScrollPane(AnnotationGui.this.currentAnnotationsTree);
            jScrollPane2.setPreferredSize(jScrollPane.getPreferredSize());
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BorderLayout());
            jPanel5.add((Component)jScrollPane2, "Center");
            jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Current Annotations"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            jPanel5.add((Component)jPanel4, "South");
            jPanel2.add(jPanel5);
            jPanel.add((Component)jPanel2, "Center");
            JPanel jPanel6 = new JPanel();
            JButton jButton = new JButton("Dismiss");
            jButton.addActionListener(new DismissAction());
            jPanel6.add(jButton);
            jPanel.add((Component)jPanel6, "South");
            return jPanel;
        }

        private void expandAll(JTree jTree, TreePath treePath, boolean bl) {
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            if (treeNode.getChildCount() >= 0) {
                Enumeration<? extends TreeNode> enumeration = treeNode.children();
                while (enumeration.hasMoreElements()) {
                    TreeNode treeNode2 = enumeration.nextElement();
                    TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                    this.expandAll(jTree, treePath2, bl);
                }
            }
            if (bl) {
                jTree.expandPath(treePath);
            } else {
                jTree.collapsePath(treePath);
            }
        }

        protected JTree createAvailableAnnotationsTree() {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Available Annotations");
            this.createTreeNodes(defaultMutableTreeNode, AnnotationGui.this.annotationDescriptions);
            JTree jTree = new JTree(defaultMutableTreeNode);
            jTree.getSelectionModel().setSelectionMode(1);
            jTree.setRootVisible(false);
            jTree.setShowsRootHandles(true);
            return jTree;
        }

        protected JTree createNodeSelectionTree() {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Annotations Categories");
            JTree jTree = new JTree(defaultMutableTreeNode);
            jTree.setRootVisible(false);
            jTree.setShowsRootHandles(true);
            this.expandAll(jTree, new TreePath(defaultMutableTreeNode), true);
            return jTree;
        }

        protected void createTreeNodes(DefaultMutableTreeNode defaultMutableTreeNode, AnnotationDescription[] annotationDescriptionArray) {
            if (annotationDescriptionArray == null || annotationDescriptionArray.length == 0) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(AnnotationGui.this.cytoscapeWindow.getAllSpecies()));
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            Object var5_5 = null;
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < annotationDescriptionArray.length; ++i) {
                String string = annotationDescriptionArray[i].getSpecies();
                if (!arrayList.contains(string)) continue;
                vector.add(annotationDescriptionArray[i].getCurator() + ", " + annotationDescriptionArray[i].getType() + ", " + annotationDescriptionArray[i].getSpecies());
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(annotationDescriptionArray[i]);
                Annotation annotation = AnnotationGui.this.dataServer.getAnnotation(annotationDescriptionArray[i]);
                if (annotation == null) continue;
                int n = annotation.maxDepth();
                for (int j = 0; j < n; ++j) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new Integer(j + 1)));
                }
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }

        public class DrawSharedEdgesAnnotationAction
        extends AbstractAction {
            DrawSharedEdgesAnnotationAction() {
                super("");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ((Gui)Gui.this).AnnotationGui.this.attributeLayouter.doCallback(((Gui)Gui.this).AnnotationGui.this.currentAnnotationCategory, 1);
            }
        }

        public class LayoutByAnnotationAction
        extends AbstractAction {
            LayoutByAnnotationAction() {
                super("");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ((Gui)Gui.this).AnnotationGui.this.attributeLayouter.doCallback(((Gui)Gui.this).AnnotationGui.this.currentAnnotationCategory, 0);
            }
        }

        public class DismissAction
        extends AbstractAction {
            DismissAction() {
                super("");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.dispose();
            }
        }

        class SelectNodesTreeSelectionListener
        implements TreeSelectionListener {
            SelectNodesTreeSelectionListener() {
            }

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((Gui)Gui.this).AnnotationGui.this.currentAnnotationsTree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                ((Gui)Gui.this).AnnotationGui.this.layoutByAnnotationButton.setEnabled(!defaultMutableTreeNode.isLeaf());
                ((Gui)Gui.this).AnnotationGui.this.addSharedAnnotationEdgesButton.setEnabled(!defaultMutableTreeNode.isLeaf());
                if (!defaultMutableTreeNode.isLeaf()) {
                    return;
                }
                TreePath[] treePathArray = ((Gui)Gui.this).AnnotationGui.this.currentAnnotationsTree.getSelectionPaths();
                HashMap hashMap = this.extractAnnotationsFromSelection(treePathArray);
                String[] stringArray = hashMap.keySet().toArray(new String[0]);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    Vector vector = (Vector)hashMap.get(string);
                    String[] stringArray2 = vector.toArray(new String[0]);
                    Node[] nodeArray = this.getNodesByAttributeValues(string, stringArray2);
                    boolean bl = false;
                    if (i == 0) {
                        bl = true;
                    }
                    ((Gui)Gui.this).AnnotationGui.this.cytoscapeWindow.selectNodes(nodeArray, bl);
                    ((Gui)Gui.this).AnnotationGui.this.cytoscapeWindow.redrawGraph();
                }
            }

            protected HashMap extractAnnotationsFromSelection(TreePath[] treePathArray) {
                HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
                for (int i = 0; i < treePathArray.length; ++i) {
                    Vector vector;
                    String string = treePathArray[i].getPathComponent(1).toString();
                    String string2 = treePathArray[i].getPathComponent(2).toString();
                    if (!hashMap.containsKey(string)) {
                        vector = new Vector();
                        hashMap.put(string, vector);
                    }
                    vector = (Vector)hashMap.get(string);
                    vector.add(string2);
                }
                String[] stringArray = hashMap.keySet().toArray(new String[0]);
                return hashMap;
            }

            protected Node[] getNodesByAttributeValues(String string, String[] stringArray) {
                Vector<Node> vector = new Vector<Node>();
                Node[] nodeArray = ((Gui)Gui.this).AnnotationGui.this.graph.getNodeArray();
                for (int i = 0; i < nodeArray.length; ++i) {
                    Object object;
                    String string2 = ((Gui)Gui.this).AnnotationGui.this.cytoscapeWindow.getCanonicalNodeName(nodeArray[i]);
                    if (string2 == null || (object = ((Gui)Gui.this).AnnotationGui.this.nodeAttributes.getValue(string, string2)) == null) continue;
                    String[] stringArray2 = GraphObjAttributes.unpackPossiblyCompoundStringAttributeValue(object);
                    for (int j = 0; j < stringArray2.length; ++j) {
                        for (int k = 0; k < stringArray.length; ++k) {
                            if (!stringArray[k].equals(stringArray2[j])) continue;
                            vector.add(nodeArray[i]);
                        }
                    }
                }
                return vector.toArray(new Node[0]);
            }
        }

        class AddAnnotationTreeSelectionListener
        implements TreeSelectionListener {
            AddAnnotationTreeSelectionListener() {
            }

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((Gui)Gui.this).AnnotationGui.this.availableAnnotationsTree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                if (!defaultMutableTreeNode.isLeaf()) {
                    return;
                }
                ((Gui)Gui.this).AnnotationGui.this.annotationPath = ((Gui)Gui.this).AnnotationGui.this.availableAnnotationsTree.getSelectionPaths()[0];
                Object object = defaultMutableTreeNode.getUserObject();
                ((Gui)Gui.this).AnnotationGui.this.annotateNodesButton.setEnabled(true);
            }
        }
    }
}

