/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation;

import cytoscape.data.annotation.Ontology;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

public class Annotation
implements Serializable {
    protected Ontology ontology;
    protected String curator;
    protected String species;
    protected String type;
    protected HashMap hash;

    public Annotation(String string, String string2, Ontology ontology) {
        this.ontology = ontology;
        this.species = string;
        this.type = string2;
        this.curator = ontology.getCurator();
        this.hash = new HashMap();
    }

    public Annotation(String string, String string2, String string3) {
        this.curator = string3;
        this.species = string;
        this.type = string2;
        this.hash = new HashMap();
    }

    public HashMap getMap() {
        return this.hash;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public String getCurator() {
        return this.curator;
    }

    public String getType() {
        return this.type;
    }

    public String getOntologyType() {
        if (this.ontology != null) {
            return this.ontology.getType();
        }
        return "unknown";
    }

    public String getSpecies() {
        return this.species;
    }

    public void add(String string, int n) {
        Vector vector;
        if (this.hash.containsKey(string)) {
            vector = (Vector)this.hash.get(string);
        } else {
            vector = new Vector();
            this.hash.put(string, vector);
        }
        Integer n2 = new Integer(n);
        if (!vector.contains(n2)) {
            vector.add(new Integer(n));
        }
    }

    public String[] getNames() {
        return this.hash.keySet().toArray(new String[0]);
    }

    public int[] getClassifications() {
        Vector[] vectorArray = this.hash.values().toArray(new Vector[0]);
        Vector vector = new Vector();
        for (int i = 0; i < vectorArray.length; ++i) {
            Vector vector2 = vectorArray[i];
            for (int j = 0; j < vector2.size(); ++j) {
                vector.add(vector2.get(j));
            }
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    public int[] getClassifications(String string) {
        if (!this.hash.containsKey(string)) {
            return new int[0];
        }
        Vector vector = (Vector)this.hash.get(string);
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    public Vector getClassificationsVector(String string) {
        if (!this.hash.containsKey(string)) {
            return new Vector();
        }
        return (Vector)this.hash.get(string);
    }

    public String[][] getAllHierarchyPathsAsNames(String string) {
        String[][] stringArray;
        int n;
        String[][] stringArray2;
        if (this.ontology == null) {
            return new String[0][0];
        }
        int[] nArray = this.getClassifications(string);
        if (nArray.length == 0) {
            stringArray2 = new String[0][0];
        }
        Vector<String[]> vector = new Vector<String[]>();
        for (n = 0; n < nArray.length; ++n) {
            stringArray = this.ontology.getAllHierarchyPathsAsNames(nArray[n]);
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
        }
        stringArray2 = new String[vector.size()][];
        for (n = 0; n < vector.size(); ++n) {
            stringArray = (String[])vector.get(n);
            stringArray2[n] = stringArray;
        }
        return stringArray2;
    }

    public int count() {
        return this.hash.size();
    }

    public int size() {
        String[] stringArray = this.getNames();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            n += ((Vector)this.hash.get(stringArray[i])).size();
        }
        return n;
    }

    public int maxDepth() {
        if (this.ontology == null) {
            return 0;
        }
        int[] nArray = this.getClassifications();
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int[][] nArray2 = this.ontology.getAllHierarchyPaths(nArray[i]);
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray2[j].length <= n) continue;
                n = nArray2[j].length;
            }
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("annotation: ");
        stringBuffer.append(this.getCurator());
        stringBuffer.append(", ");
        stringBuffer.append(this.type);
        stringBuffer.append(", ");
        stringBuffer.append(this.species);
        stringBuffer.append(" (" + this.count() + " entities)  ");
        stringBuffer.append(" (" + this.size() + " classifications)  ");
        return stringBuffer.toString();
    }
}

