/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.GraphObjAttributes;
import y.base.Edge;
import y.base.Node;
import y.view.Graph2D;
import y.view.Graph2DView;

public class GraphProps {
    private Graph2D graph;
    private GraphObjAttributes nodeAttributes;
    private GraphObjAttributes edgeAttributes;

    public GraphProps(Graph2D graph2D, GraphObjAttributes graphObjAttributes, GraphObjAttributes graphObjAttributes2) {
        this.graph = graph2D;
        this.nodeAttributes = graphObjAttributes;
        this.edgeAttributes = graphObjAttributes2;
    }

    public GraphProps(Graph2D graph2D) {
        this.graph = graph2D;
        this.nodeAttributes = new GraphObjAttributes();
        this.edgeAttributes = new GraphObjAttributes();
    }

    public Graph2D getGraph() {
        return this.graph;
    }

    public GraphObjAttributes getNodeAttributes() {
        return this.nodeAttributes;
    }

    public GraphObjAttributes getEdgeAttributes() {
        return this.edgeAttributes;
    }

    public String getName(Node node) {
        String string = this.nodeAttributes.getCanonicalName(node);
        if (string == null) {
            Graph2DView graph2DView = new Graph2DView(this.graph);
            string = this.graph.getLabelText(node);
        }
        return string;
    }

    public String getName(Edge edge) {
        String string = this.edgeAttributes.getCanonicalName(edge);
        return string;
    }

    public void setType(Edge edge, String string) {
        this.edgeAttributes.add("interaction", this.getName(edge), string);
    }

    public String getType(Edge edge) {
        String string = (String)this.edgeAttributes.getValue("interaction", this.getName(edge));
        return string;
    }

    public String getType(Node node) {
        String string = this.getName(node);
        if (string != null) {
            char c = string.charAt(0);
            if (c == 'C') {
                return "compound";
            }
            if (c == 'R') {
                return "reaction";
            }
        }
        return "gene";
    }
}

