/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.GraphObjAttributes;
import cytoscape.data.mRNAMeasurement;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextJarReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExpressionData
implements Serializable {
    public static final int MAX_LINE_SIZE = 8192;
    public static final int PVAL = 0;
    public static final int LAMBDA = 1;
    public static final int NONE = 2;
    public static final int UNKNOWN = 3;
    protected int significanceType = 3;
    String filename = null;
    int numGenes = 0;
    int numConds = 0;
    int extraTokens = 0;
    boolean haveSigValues = false;
    Vector geneNames;
    Vector geneDescripts;
    Vector condNames;
    Hashtable geneNameToIndex;
    Hashtable condNameToIndex;
    double minExp;
    double maxExp;
    double minSig;
    double maxSig;
    Vector allMeasurements;
    static /* synthetic */ Class class$java$lang$Double;

    public ExpressionData() {
        this.initDataStructures();
    }

    public ExpressionData(String string) {
        this.initDataStructures();
        this.loadData(string);
    }

    public String getFileName() {
        return this.filename;
    }

    public File getFullPath() {
        File file = new File(this.filename);
        return file.getAbsoluteFile();
    }

    private void initDataStructures() {
        int n = 1000;
        if (this.geneNames != null) {
            this.geneNames.clear();
        }
        this.geneNames = new Vector(0, n);
        if (this.geneDescripts != null) {
            this.geneDescripts.clear();
        }
        this.geneDescripts = new Vector(0, n);
        if (this.condNames != null) {
            this.condNames.clear();
        }
        this.condNames = new Vector();
        if (this.geneNameToIndex != null) {
            this.geneNameToIndex.clear();
        }
        this.geneNameToIndex = new Hashtable();
        if (this.condNameToIndex != null) {
            this.condNameToIndex.clear();
        }
        this.condNameToIndex = new Hashtable();
        this.minExp = Double.MAX_VALUE;
        this.maxExp = Double.MIN_VALUE;
        this.minSig = Double.MAX_VALUE;
        this.maxSig = Double.MIN_VALUE;
        if (this.allMeasurements != null) {
            this.allMeasurements.clear();
        }
        this.allMeasurements = new Vector(0, n);
    }

    public boolean oldLoadData(String string) {
        int n;
        int n2;
        BufferedReader bufferedReader;
        if (string == null) {
            return false;
        }
        try {
            bufferedReader = new BufferedReader(new FileReader(string), 8192);
        }
        catch (IOException iOException) {
            System.err.println("Error trying to open data file " + string);
            return false;
        }
        String string2 = this.readOneLine(bufferedReader);
        if (this.isHeaderLineNull(string2, bufferedReader, string)) {
            return false;
        }
        if (this.isHeaderLineMTXHeader(string2)) {
            string2 = this.readOneLine(bufferedReader);
        }
        boolean bl = this.doesHeaderLineHaveDuplicates(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n3 = stringTokenizer.countTokens();
        if (n3 < 3 || n3 < 4 && bl) {
            System.err.println("Bad header format in data file " + string);
            System.err.println("Number of tokens parsed: " + n3);
            for (int i = 0; i < n3; ++i) {
                System.err.println("Token " + i + ": " + stringTokenizer.nextToken());
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        double d = (double)n3 / 2.0;
        int n4 = (int)Math.rint(d);
        int n5 = 0;
        if (bl) {
            if ((double)n4 == d) {
                n2 = (n3 - 2) / 2;
                n5 = 0;
            } else {
                n2 = (n3 - 3) / 2;
                n5 = 1;
            }
        } else {
            n2 = n3 - 2;
        }
        System.out.println("parsed " + n3 + " tokens from header line," + " representing " + n2 + " conditions.");
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        Vector<String> vector = new Vector<String>(n2);
        for (n = 0; n < n2; ++n) {
            vector.add(stringTokenizer.nextToken());
        }
        if (bl) {
            for (n = 0; n < n2; ++n) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals(vector.get(n))) continue;
                System.err.println("Expecting both ratios and p-values.\n");
                System.err.println("Condition name mismatch in header line of data file " + string + ": " + vector.get(n) + " vs. " + string3);
                return false;
            }
        }
        this.filename = string;
        this.numConds = n2;
        this.extraTokens = n5;
        this.initDataStructures();
        this.condNames = vector;
        for (n = 0; n < this.numConds; ++n) {
            this.condNameToIndex.put(this.condNames.get(n), new Integer(n));
        }
        String string4 = this.readOneLine(bufferedReader);
        int n6 = 1;
        while (string4 != null) {
            this.parseOneLine(string4, ++n6, bl);
            string4 = this.readOneLine(bufferedReader);
        }
        this.numGenes = this.geneNames.size();
        for (int i = 0; i < this.geneNames.size(); ++i) {
            this.geneNameToIndex.put(this.geneNames.get(i), new Integer(i));
        }
        this.geneNames.trimToSize();
        this.geneDescripts.trimToSize();
        this.allMeasurements.trimToSize();
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public boolean loadData(String string) {
        int n;
        int n2;
        StringTokenizer stringTokenizer;
        int n3;
        String string2;
        String[] stringArray;
        if (string == null) {
            return false;
        }
        try {
            if (string.trim().startsWith("jar://")) {
                stringArray = new TextJarReader(string);
                stringArray.read();
                string2 = stringArray.getText();
            } else {
                stringArray = new TextFileReader(string);
                stringArray.read();
                string2 = stringArray.getText();
            }
        }
        catch (Exception exception) {
            System.err.println("-- Exception while reading expression file " + string);
            System.err.println(exception.getMessage());
            return false;
        }
        stringArray = string2.split("\n");
        int n4 = 0;
        String string3 = stringArray[n4++];
        if (string3 == null || string3.length() == 0) {
            return false;
        }
        if (this.isHeaderLineMTXHeader(string3)) {
            this.significanceType = 1;
            string3 = stringArray[n4++];
        }
        boolean bl = this.doesHeaderLineHaveDuplicates(string3);
        if (this.significanceType != 1 && !bl) {
            this.significanceType = 2;
        }
        if ((n3 = (stringTokenizer = new StringTokenizer(string3)).countTokens()) < 3 || n3 < 4 && bl) {
            System.err.println("Bad header format in data file " + string);
            System.err.println("Number of tokens parsed: " + n3);
            for (int i = 0; i < n3; ++i) {
                System.err.println("Token " + i + ": " + stringTokenizer.nextToken());
            }
            return false;
        }
        double d = (double)n3 / 2.0;
        int n5 = (int)Math.rint(d);
        int n6 = 0;
        if (bl) {
            if ((double)n5 == d) {
                n2 = (n3 - 2) / 2;
                n6 = 0;
            } else {
                n2 = (n3 - 3) / 2;
                n6 = 1;
            }
        } else {
            n2 = n3 - 2;
        }
        System.out.println("parsed " + n3 + " tokens from header line," + " representing " + n2 + " conditions.");
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        Vector<String> vector = new Vector<String>(n2);
        for (n = 0; n < n2; ++n) {
            vector.add(stringTokenizer.nextToken());
        }
        if (bl) {
            for (n = 0; n < n2; ++n) {
                String string4 = stringTokenizer.nextToken();
                if (string4.equals(vector.get(n))) continue;
                System.err.println("Expecting both ratios and p-values.\n");
                System.err.println("Condition name mismatch in header line of data file " + string + ": " + vector.get(n) + " vs. " + string4);
                return false;
            }
        }
        this.filename = string;
        this.numConds = n2;
        this.extraTokens = n6;
        this.haveSigValues = bl;
        this.initDataStructures();
        this.condNames = vector;
        for (n = 0; n < this.numConds; ++n) {
            this.condNameToIndex.put(this.condNames.get(n), new Integer(n));
        }
        for (n = n4; n < stringArray.length; ++n) {
            this.parseOneLine(stringArray[n], n4, bl);
        }
        this.numGenes = this.geneNames.size();
        for (n = 0; n < this.geneNames.size(); ++n) {
            this.geneNameToIndex.put(this.geneNames.get(n), new Integer(n));
        }
        this.geneNames.trimToSize();
        this.geneDescripts.trimToSize();
        this.allMeasurements.trimToSize();
        return true;
    }

    private boolean doesHeaderLineHaveDuplicates(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n < 3) {
            bl = false;
        } else {
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            while (!bl && stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = string2;
                if (hashMap.get(string3) == null) {
                    hashMap.put(string3, string3);
                    continue;
                }
                bl = true;
            }
        }
        return bl;
    }

    private boolean isHeaderLineNull(String string, BufferedReader bufferedReader, String string2) {
        if (string == null) {
            System.err.println("Could not read header line from data file " + string2);
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private boolean isHeaderLineMTXHeader(String string) {
        boolean bl = false;
        String string2 = "\t+RATIOS\t+LAMBDAS";
        try {
            bl = string.matches(string2);
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION in isHeaderLineMTXHeader: " + exception);
            System.out.flush();
        }
        return bl;
    }

    private String readOneLine(BufferedReader bufferedReader) {
        String string = null;
        try {
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    private void parseOneLine(String string, int n) {
        this.parseOneLine(string, n, true);
    }

    private void parseOneLine(String string, int n, boolean bl) {
        int n2;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n3 = stringTokenizer.countTokens();
        if (n3 == 0) {
            return;
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.startsWith("NumSigGenes")) {
            return;
        }
        if (bl && n3 < 2 * this.numConds + 2 || !bl && n3 < this.numConds + 2) {
            System.out.println("Warning: parse error on line " + n + "  tokens read: " + n3);
            return;
        }
        this.geneNames.add(string2);
        this.geneDescripts.add(stringTokenizer.nextToken());
        String[] stringArray = new String[this.numConds];
        for (int i = 0; i < this.numConds; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        String[] stringArray2 = new String[this.numConds];
        if (bl) {
            for (n2 = 0; n2 < this.numConds; ++n2) {
                stringArray2[n2] = stringTokenizer.nextToken();
            }
        } else {
            for (n2 = 0; n2 < this.numConds; ++n2) {
                stringArray2[n2] = stringArray[n2];
            }
        }
        Vector<mRNAMeasurement> vector = new Vector<mRNAMeasurement>(this.numConds);
        for (int i = 0; i < this.numConds; ++i) {
            mRNAMeasurement mRNAMeasurement2 = new mRNAMeasurement(stringArray[i], stringArray2[i]);
            vector.add(mRNAMeasurement2);
            double d = mRNAMeasurement2.getRatio();
            double d2 = mRNAMeasurement2.getSignificance();
            if (d < this.minExp) {
                this.minExp = d;
            }
            if (d > this.maxExp) {
                this.maxExp = d;
            }
            if (d2 < this.minSig) {
                this.minSig = d2;
            }
            if (!(d2 > this.maxSig)) continue;
            this.maxSig = d2;
            if (this.significanceType == 1 || !bl || !(this.maxSig > 1.0)) continue;
            this.significanceType = 1;
        }
        if (this.significanceType != 1 && bl && this.minSig > 0.0) {
            this.significanceType = 0;
        }
        this.allMeasurements.add(vector);
    }

    public void convertLambdasToPvals() {
        Iterator iterator = this.allMeasurements.iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            Iterator iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                mRNAMeasurement mRNAMeasurement2 = (mRNAMeasurement)iterator2.next();
                double d = ExpressionData.getPvalueFromLambda(mRNAMeasurement2.getSignificance());
                mRNAMeasurement2.setSignificance(d);
            }
        }
    }

    public static double getPvalueFromLambda(double d) {
        double d2 = StrictMath.sqrt(d) / 2.0;
        double d3 = 1.0 / (1.0 + 0.3275911 * d2);
        double d4 = StrictMath.exp(-(d2 * d2)) * (0.254829592 * d3 + -0.284496736 * StrictMath.pow(d3, 2.0) + 1.421413741 * StrictMath.pow(d3, 3.0) + -1.453152027 * StrictMath.pow(d3, 4.0) + 1.061405429 * StrictMath.pow(d3, 5.0));
        if ((d4 /= 2.0) < 0.0 || d4 > 1.0) {
            throw new IllegalStateException("The calculated pvalue for lambda = " + d + " is " + d4);
        }
        return d4;
    }

    public int getSignificanceType() {
        return this.significanceType;
    }

    public String getDescription() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Data read from: " + this.filename + string);
        stringBuffer.append(string);
        stringBuffer.append("Number of genes = " + this.getNumberOfGenes() + string);
        stringBuffer.append("Number of conditions = " + this.getNumberOfConditions() + string);
        stringBuffer.append("Significance values: ");
        if (this.haveSigValues) {
            stringBuffer.append("yes");
        } else {
            stringBuffer.append("no");
        }
        stringBuffer.append(string).append(string);
        stringBuffer.append("MinExp: " + this.minExp + "    MaxExp: " + this.maxExp + string);
        if (this.haveSigValues) {
            stringBuffer.append("MinSig: " + this.minSig + "    MaxSig: " + this.maxSig + string);
            String string2 = null;
            if (this.significanceType == 3) {
                string2 = "unknown";
            } else if (this.significanceType == 1) {
                string2 = "lambda values";
            } else if (this.significanceType == 0) {
                string2 = "p-values";
            } else if (this.significanceType == 2) {
                string2 = "none";
            }
            stringBuffer.append("Type of significance: " + string2 + string);
        }
        return stringBuffer.toString();
    }

    public int getNumberOfGenes() {
        return this.numGenes;
    }

    public int getNumberOfConditions() {
        return this.numConds;
    }

    public String[] getGeneNames() {
        return this.geneNames.toArray(new String[0]);
    }

    public Vector getGeneNamesVector() {
        return this.geneNames;
    }

    public void setGeneNames(Vector vector) {
        this.geneNames = vector;
        this.geneNameToIndex.clear();
        for (int i = 0; i < this.geneNames.size(); ++i) {
            this.geneNameToIndex.put(this.geneNames.get(i), new Integer(i));
        }
    }

    public String[] getGeneDescriptors() {
        return this.geneDescripts.toArray(new String[0]);
    }

    public Vector getGeneDescriptorsVector() {
        return this.geneDescripts;
    }

    public void setGeneDescriptors(Vector vector) {
        this.geneDescripts = vector;
    }

    public String[] getConditionNames() {
        return this.condNames.toArray(new String[0]);
    }

    public int getConditionIndex(String string) {
        return (Integer)this.condNameToIndex.get(string);
    }

    public double[][] getExtremeValues() {
        double[][] dArray = new double[2][2];
        dArray[0][0] = this.minExp;
        dArray[0][1] = this.maxExp;
        dArray[1][0] = this.minSig;
        dArray[0][1] = this.maxSig;
        return dArray;
    }

    public String getGeneDescriptor(String string) {
        Integer n = (Integer)this.geneNameToIndex.get(string);
        if (n == null) {
            return null;
        }
        return (String)this.geneDescripts.get(n);
    }

    public boolean hasSignificanceValues() {
        return this.haveSigValues;
    }

    public Vector getAllMeasurements() {
        return this.allMeasurements;
    }

    public Vector getMeasurements(String string) {
        Integer n = (Integer)this.geneNameToIndex.get(string);
        if (n == null) {
            return null;
        }
        Vector vector = (Vector)this.getAllMeasurements().get(n);
        return vector;
    }

    public mRNAMeasurement getMeasurement(String string, String string2) {
        Integer n = (Integer)this.condNameToIndex.get(string2);
        if (n == null) {
            return null;
        }
        Vector vector = this.getMeasurements(string);
        if (vector == null) {
            return null;
        }
        mRNAMeasurement mRNAMeasurement2 = (mRNAMeasurement)vector.get(n);
        return mRNAMeasurement2;
    }

    public void copyToAttribs(GraphObjAttributes graphObjAttributes) {
        String[] stringArray = this.getConditionNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = string + "exp";
            String string3 = string + "sig";
            for (int j = 0; j < this.geneNames.size(); ++j) {
                String string4 = (String)this.geneNames.get(j);
                mRNAMeasurement mRNAMeasurement2 = this.getMeasurement(string4, string);
                if (mRNAMeasurement2 == null) continue;
                graphObjAttributes.add(string2, string4, mRNAMeasurement2.getRatio());
                graphObjAttributes.add(string3, string4, mRNAMeasurement2.getSignificance());
            }
            graphObjAttributes.setClass(string2, class$java$lang$Double == null ? ExpressionData.class$("java.lang.Double") : class$java$lang$Double);
            graphObjAttributes.setClass(string3, class$java$lang$Double == null ? ExpressionData.class$("java.lang.Double") : class$java$lang$Double);
        }
    }
}

