/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.CytoscapeConfig;
import cytoscape.CytoscapeVersion;
import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import cytoscape.SplashScreen;
import cytoscape.data.ExpressionData;
import cytoscape.data.readers.FileReadingAbstractions;
import cytoscape.data.servers.BioDataServer;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import y.view.Graph2D;

public class cytoscape
implements WindowListener {
    protected Vector windows = new Vector();
    protected String logicFilename;
    protected String geometryFilename;
    protected GraphObjAttributes edgeAttributes = new GraphObjAttributes();
    protected GraphObjAttributes nodeAttributes = new GraphObjAttributes();
    protected ExpressionData expressionData = null;
    protected String bioDataServerName;
    protected static BioDataServer bioDataServer;
    protected CytoscapeVersion version = new CytoscapeVersion();
    protected Logger logger;
    protected String defaultSpecies;
    protected SplashScreen splashScreen = new SplashScreen();
    int progress;

    public cytoscape(String[] stringArray) throws Exception {
        CytoscapeConfig cytoscapeConfig = new CytoscapeConfig(stringArray);
        this.setupLogger(cytoscapeConfig);
        this.splashScreen.advance(10);
        if (cytoscapeConfig.helpRequested()) {
            System.out.println(this.version);
            System.out.println(cytoscapeConfig.getUsage());
            this.exit(0);
        } else if (cytoscapeConfig.inputsError()) {
            System.out.println(this.version);
            System.out.println("------------- Inputs Error");
            System.out.println(cytoscapeConfig.getUsage());
            System.out.println(cytoscapeConfig);
            this.exit(1);
        } else if (cytoscapeConfig.displayVersion()) {
            System.out.println(this.version);
            this.exit(0);
        }
        this.splashScreen.advance(20);
        this.logger.info(cytoscapeConfig.toString());
        String string = cytoscapeConfig.getGeometryFilename();
        String string2 = cytoscapeConfig.getBioDataDirectory();
        String string3 = cytoscapeConfig.getInteractionsFilename();
        String string4 = cytoscapeConfig.getExpressionFilename();
        this.defaultSpecies = cytoscapeConfig.getDefaultSpeciesName();
        Graph2D graph2D = null;
        CytoscapeWindow cytoscapeWindow = null;
        String string5 = null;
        boolean bl = true;
        boolean bl2 = cytoscapeConfig.getWhetherToCopyExpToAttribs();
        if (string2 != null) {
            bioDataServer = new BioDataServer(string2);
        }
        this.splashScreen.advance(25);
        if (string != null) {
            this.logger.info("reading " + string + "...");
            graph2D = FileReadingAbstractions.loadGMLBasic(string, this.edgeAttributes, cytoscapeConfig.getCanonicalize());
            this.logger.info("  done");
            string5 = string;
            bl = false;
            this.splashScreen.advance(90);
        } else if (string3 != null) {
            this.logger.info("reading " + string3 + "...");
            graph2D = FileReadingAbstractions.loadIntrBasic(bioDataServer, this.defaultSpecies, string3, this.edgeAttributes, cytoscapeConfig.getCanonicalize());
            this.logger.info("  done");
            string5 = string3;
            this.splashScreen.advance(90);
        }
        if (string4 != null) {
            this.logger.info("reading " + string4 + "...");
            this.expressionData = new ExpressionData(string4);
            this.logger.info("  done");
            this.splashScreen.advance(90);
        }
        if (graph2D == null) {
            this.splashScreen.advance(90);
            this.splashScreen.noGraph = true;
            graph2D = new Graph2D();
        }
        FileReadingAbstractions.initAttribs(bioDataServer, this.defaultSpecies, cytoscapeConfig, graph2D, this.nodeAttributes, this.edgeAttributes);
        if (this.expressionData != null && bl2) {
            this.expressionData.copyToAttribs(this.nodeAttributes);
        }
        cytoscapeWindow = new CytoscapeWindow(this, cytoscapeConfig, this.logger, graph2D, this.expressionData, bioDataServer, this.nodeAttributes, this.edgeAttributes, string, string4, string5, bl);
        if (this.splashScreen != null) {
            this.splashScreen.advance(100);
        }
    }

    protected void setupLogger(CytoscapeConfig cytoscapeConfig) {
        this.logger = Logger.getLogger("global");
        Properties properties = cytoscapeConfig.getProperties();
        String string = properties.getProperty("logging", "SEVERE");
        if (string.equalsIgnoreCase("severe")) {
            this.logger.setLevel(Level.SEVERE);
        } else if (string.equalsIgnoreCase("warning")) {
            this.logger.setLevel(Level.WARNING);
        } else if (string.equalsIgnoreCase("info")) {
            this.logger.setLevel(Level.INFO);
        } else if (string.equalsIgnoreCase("config")) {
            this.logger.setLevel(Level.CONFIG);
        } else if (string.equalsIgnoreCase("all")) {
            this.logger.setLevel(Level.ALL);
        } else if (string.equalsIgnoreCase("none")) {
            this.logger.setLevel(Level.OFF);
        } else if (string.equalsIgnoreCase("off")) {
            this.logger.setLevel(Level.OFF);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (this.splashScreen != null) {
            this.splashScreen.advance(200);
            this.splashScreen.dispose();
            this.splashScreen = null;
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.windowClosed(windowEvent);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
        if (this.splashScreen != null) {
            this.splashScreen.advance(200);
            this.splashScreen.dispose();
            this.splashScreen = null;
        }
        this.windows.add(windowEvent.getWindow());
    }

    public void windowClosed(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (this.windows.contains(window)) {
            this.windows.remove(window);
        }
        if (this.windows.size() == 0) {
            this.logger.info("all windows closed, exiting...");
            this.exit(0);
        }
    }

    public void exit(int n) {
        for (int i = 0; i < this.windows.size(); ++i) {
            Window window = (Window)this.windows.elementAt(i);
            window.dispose();
        }
        System.exit(n);
    }

    public static void main(String[] stringArray) throws Exception {
        cytoscape cytoscape2 = new cytoscape(stringArray);
    }
}

