/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.browsers;

import cytoscape.GraphObjAttributes;
import cytoscape.browsers.BrowserTableModel;
import cytoscape.browsers.OpenBrowser;
import cytoscape.util.Exec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import y.base.Edge;
import y.base.Node;

public class TabbedBrowser
extends JFrame
implements ClipboardOwner {
    protected Object[] graphObjects;
    protected GraphObjAttributes attributes;
    protected Vector attributeCategoriesToIgnore;
    protected int preferredTableWidth = 600;
    protected int preferredTableHeight = 100;
    protected String webBrowserScript;
    protected JTabbedPane tabbedPane;
    protected Vector customAttributesList;
    protected JTextField customTabNameTextField;
    protected File currentDirectory;
    static HashMap customNodeAttributes = new HashMap();
    static HashMap customEdgeAttributes = new HashMap();
    HashMap customAttributes;
    int browseObjectClass;
    static final int BROWSING_UNRECOGNIZED_OBJECTS = 0;
    static final int BROWSING_NODES = 1;
    static final int BROWSING_EDGES = 2;

    public TabbedBrowser(Object[] objectArray, GraphObjAttributes graphObjAttributes, Vector vector, String string) {
        this.graphObjects = objectArray;
        this.attributes = graphObjAttributes;
        this.attributeCategoriesToIgnore = vector;
        this.webBrowserScript = string;
        this.browseObjectClass = this.detectClassOfBrowsedObjects(objectArray);
        if (this.browseObjectClass == 1) {
            this.customAttributes = customNodeAttributes;
            this.setTitle("Node Browser");
        } else if (this.browseObjectClass == 2) {
            this.setTitle("Edge Browser");
            this.customAttributes = customEdgeAttributes;
        } else {
            this.setTitle("Browser of unrecognized objects");
            this.customAttributes = new HashMap();
        }
        String[] stringArray = graphObjAttributes.getAttributeNames();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createGui(graphObjAttributes), "Center");
        this.getContentPane().add((Component)this.createButtons(), "South");
        this.pack();
        this.placeInCenter();
        this.setVisible(true);
    }

    JTabbedPane createGui(GraphObjAttributes graphObjAttributes) {
        String[] stringArray;
        String string;
        this.tabbedPane = new JTabbedPane();
        String[] stringArray2 = graphObjAttributes.getAttributeNames();
        this.tabbedPane.add("Customize", this.createCustomizerTab(stringArray2));
        for (int i = 0; i < stringArray2.length; ++i) {
            String string2 = stringArray2[i];
            if (string2.equalsIgnoreCase("commonName") || this.attributeCategoriesToIgnore.contains(string = graphObjAttributes.getCategory(string2))) continue;
            stringArray = new String[]{string2};
            BrowserTableModel browserTableModel = new BrowserTableModel(this.graphObjects, graphObjAttributes, stringArray);
            JTable jTable = new JTable(browserTableModel);
            this.setPreferredColumnWidths(jTable);
            jTable.setCellSelectionEnabled(true);
            jTable.addMouseListener(new MyMouseListener(jTable));
            jTable.setPreferredScrollableViewportSize(new Dimension(this.preferredTableWidth, this.preferredTableHeight));
            JScrollPane jScrollPane = new JScrollPane(jTable);
            this.tabbedPane.add(stringArray2[i], jScrollPane);
        }
        String[] stringArray3 = this.customAttributes.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray3.length; ++i) {
            string = stringArray3[i];
            stringArray = (Vector)this.customAttributes.get(string);
            this.createNewPanel((Vector)stringArray, string);
        }
        return this.tabbedPane;
    }

    protected int detectClassOfBrowsedObjects(Object[] objectArray) {
        if (objectArray[0] instanceof Node) {
            return 1;
        }
        if (objectArray[0] instanceof Edge) {
            return 2;
        }
        return 0;
    }

    protected JPanel createCustomizerTab(String[] stringArray) {
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Select attributes for custom view"), BorderFactory.createEmptyBorder(20, 20, 20, 20)));
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        JButton jButton = new JButton("Create");
        jPanel4.add(jButton);
        jButton.addActionListener(new CreateNewPanelAction());
        int n = stringArray.length;
        int n2 = 1;
        if (n > 8) {
            n2 = 2;
        }
        jPanel3.setLayout(new GridLayout(0, n2));
        this.customAttributesList = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (stringArray[i].equals("commonName") || this.attributeCategoriesToIgnore.contains(string = this.attributes.getCategory((String)(object = stringArray[i])))) continue;
            JCheckBox jCheckBox = new JCheckBox(stringArray[i]);
            jPanel3.add(jCheckBox);
            jCheckBox.addItemListener(new CheckBoxListener(stringArray[i]));
        }
        JCheckBox jCheckBox = new JCheckBox("canonicalName");
        jPanel3.add(jCheckBox);
        jCheckBox.addItemListener(new CheckBoxListener("canonicalName"));
        object = new JPanel();
        ((Container)object).add(new JLabel("Name for new tab: "));
        this.customTabNameTextField = new JTextField(10);
        ((Container)object).add((Component)this.customTabNameTextField, "South");
        jPanel2.add((Component)object, "South");
        jPanel2.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    JPanel createButtons() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Save Table");
        JButton jButton2 = new JButton("Dismiss");
        jButton.addActionListener(new SaveTableAction(this));
        jButton2.addActionListener(new DismissAction(this));
        jPanel.add((Component)jButton, "Center");
        jPanel.add((Component)jButton2, "Center");
        return jPanel;
    }

    private void createNewPanel(Vector vector, String string) {
        String[] stringArray = vector.toArray(new String[0]);
        BrowserTableModel browserTableModel = new BrowserTableModel(this.graphObjects, this.attributes, stringArray);
        JTable jTable = new JTable(browserTableModel);
        this.setPreferredColumnWidths(jTable);
        jTable.setCellSelectionEnabled(true);
        jTable.addMouseListener(new MyMouseListener(jTable));
        jTable.setPreferredScrollableViewportSize(new Dimension(this.preferredTableWidth, this.preferredTableHeight));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.tabbedPane.add(string, jScrollPane);
        this.tabbedPane.setSelectedComponent(jScrollPane);
    }

    private void setPreferredColumnWidths(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = jTable.getModel().getColumnCount();
        tableColumnModel.getColumn(0).setPreferredWidth(80);
    }

    private void placeInCenter() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = (int)graphicsConfiguration.getBounds().getHeight();
        int n2 = (int)graphicsConfiguration.getBounds().getWidth();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        this.setLocation((n2 - n3) / 2, (n - n4) / 2);
    }

    protected void addCellSelection(JTable jTable) {
        jTable.setSelectionMode(0);
        jTable.setCellSelectionEnabled(true);
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        RowListener rowListener = new RowListener(jTable);
        listSelectionModel.addListSelectionListener(rowListener);
        ListSelectionModel listSelectionModel2 = jTable.getColumnModel().getSelectionModel();
        listSelectionModel2.addListSelectionListener(rowListener);
    }

    protected void displayWebPage(URL uRL) {
        try {
            BasicService basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            basicService.showDocument(uRL);
        }
        catch (Exception exception) {
            OpenBrowser.openURL(uRL.toString());
        }
    }

    protected void oldDisplayWebPage(URL uRL) {
        String[] stringArray = new String[]{this.webBrowserScript, uRL.toString()};
        Exec exec = new Exec(stringArray);
        exec.run();
        Vector vector = exec.getStdout();
        Vector vector2 = exec.getStderr();
        for (int i = 0; i < vector2.size(); ++i) {
            System.out.println(vector2.elementAt(i));
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    class MyMouseListener
    implements MouseListener {
        private JTable table;

        public MyMouseListener(JTable jTable) {
            this.table = jTable;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = mouseEvent.getY() / this.table.getRowHeight();
            if (n2 >= this.table.getRowCount() || n2 < 0 || n >= this.table.getColumnCount() || n < 0) {
                return;
            }
            Object object = this.table.getValueAt(n2, n);
            try {
                if (object != null && object.getClass() == Class.forName("java.net.URL")) {
                    URL uRL = (URL)object;
                    TabbedBrowser.this.displayWebPage(uRL);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (TabbedBrowser.this.tabbedPane.getSelectedIndex() == 0) {
                return;
            }
            JScrollPane jScrollPane = (JScrollPane)TabbedBrowser.this.tabbedPane.getSelectedComponent();
            JTable jTable = (JTable)jScrollPane.getViewport().getView();
            String string = new String();
            StringWriter stringWriter = new StringWriter();
            int[] nArray = jTable.getSelectedRows();
            int[] nArray2 = jTable.getSelectedColumns();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                for (int j = 0; j < nArray2.length; ++j) {
                    int n2 = nArray2[j];
                    Class<?> clazz = jTable.getColumnClass(n2);
                    Object object = jTable.getValueAt(n, n2);
                    stringWriter.write(object + "\t");
                }
                stringWriter.write("\n");
            }
            Clipboard clipboard = TabbedBrowser.this.getToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(stringWriter.toString());
            clipboard.setContents(stringSelection, TabbedBrowser.this);
        }
    }

    class RowListener
    implements ListSelectionListener {
        JTable table;
        int selectedRow;
        int selectedColumn;

        RowListener(JTable jTable) {
            this.table = jTable;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (!listSelectionModel.isSelectionEmpty()) {
                this.selectedRow = listSelectionModel.getMinSelectionIndex();
                Object object = this.table.getModel().getValueAt(this.selectedRow, 0);
            }
        }
    }

    public class DismissAction
    extends AbstractAction {
        private JFrame frame;

        DismissAction(JFrame jFrame) {
            super("");
            this.frame = jFrame;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.frame.dispose();
        }
    }

    public class SaveTableAction
    extends AbstractAction {
        private JFrame frame;

        SaveTableAction(JFrame jFrame) {
            super("");
            this.frame = jFrame;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (TabbedBrowser.this.tabbedPane.getSelectedIndex() == 0) {
                return;
            }
            JScrollPane jScrollPane = (JScrollPane)TabbedBrowser.this.tabbedPane.getSelectedComponent();
            JTable jTable = (JTable)jScrollPane.getViewport().getView();
            int n = jTable.getRowCount();
            int n2 = jTable.getColumnCount();
            JFileChooser jFileChooser = new JFileChooser(TabbedBrowser.this.currentDirectory);
            if (jFileChooser.showSaveDialog(TabbedBrowser.this) == 0) {
                String string = jFileChooser.getSelectedFile().toString();
                TabbedBrowser.this.currentDirectory = jFileChooser.getCurrentDirectory();
                File file = new File(string);
                try {
                    FileWriter fileWriter = new FileWriter(file);
                    for (int i = 0; i < n; ++i) {
                        for (int j = 0; j < n2; ++j) {
                            Class<?> clazz = jTable.getColumnClass(j);
                            Object object = jTable.getValueAt(i, j);
                            fileWriter.write(object + "\t");
                        }
                        fileWriter.write("\n");
                    }
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, iOException.toString(), "Error Writing to \"" + file.getName() + "\"", 0);
                }
            }
        }
    }

    public class CreateNewPanelAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (TabbedBrowser.this.customAttributesList == null || TabbedBrowser.this.customAttributesList.size() == 0) {
                return;
            }
            String string = TabbedBrowser.this.customTabNameTextField.getText();
            if (string == null) {
                string = "";
            }
            TabbedBrowser.this.customAttributes.put(string, new Vector(TabbedBrowser.this.customAttributesList));
            TabbedBrowser.this.createNewPanel(TabbedBrowser.this.customAttributesList, string);
        }
    }

    class CheckBoxListener
    implements ItemListener {
        String attributeName;

        CheckBoxListener(String string) {
            this.attributeName = string;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            int n = itemEvent.getStateChange();
            if (n == 1) {
                if (!TabbedBrowser.this.customAttributesList.contains(this.attributeName)) {
                    TabbedBrowser.this.customAttributesList.add(this.attributeName);
                }
            } else if (n == 2 && TabbedBrowser.this.customAttributesList.contains(this.attributeName)) {
                TabbedBrowser.this.customAttributesList.remove(this.attributeName);
            }
        }
    }
}

