/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.browsers;

import cytoscape.CytoscapeWindow;
import cytoscape.browsers.TabbedBrowser;
import cytoscape.util.Misc;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Node;
import y.base.NodeCursor;
import y.view.Graph2D;
import y.view.PopupMode;

public class NodeBrowsingMode
extends PopupMode {
    protected CytoscapeWindow cytoscapeWindow;
    protected Graph2D graph;
    Vector attributeCategoriesToIgnore;
    static final String invisibilityPropertyName = "nodeAttributeCategories.invisibleToBrowser";
    String webBrowserScript;

    public void set(CytoscapeWindow cytoscapeWindow) {
        this.cytoscapeWindow = cytoscapeWindow;
        Properties properties = cytoscapeWindow.getConfiguration().getProperties();
        this.webBrowserScript = cytoscapeWindow.getConfiguration().getProperties().getProperty("webBrowserScript", "noScriptDefined");
        cytoscapeWindow.getNodeAttributes().setCategory("tissueCount", "hideFromBrowser");
        this.attributeCategoriesToIgnore = Misc.getPropertyValues(properties, invisibilityPropertyName);
        for (int i = 0; i < this.attributeCategoriesToIgnore.size(); ++i) {
            System.out.println("  ignore type " + this.attributeCategoriesToIgnore.get(i));
        }
    }

    public JPopupMenu getNodePopup(Node node) {
        this.graph = this.cytoscapeWindow.getGraph();
        boolean bl = this.graph.isSelected(node);
        this.graph.setSelected(node, true);
        this.getSelectionPopup(this.graph.getCenterX(node), this.graph.getCenterY(node));
        this.graph.setSelected(node, bl);
        return null;
    }

    public JPopupMenu getPaperPopup(double d, double d2) {
        return null;
    }

    public JPopupMenu getSelectionPopup(double d, double d2) {
        this.graph = this.cytoscapeWindow.getGraph();
        NodeCursor nodeCursor = this.graph.selectedNodes();
        Vector<Node> vector = new Vector<Node>();
        while (nodeCursor.ok()) {
            vector.add(nodeCursor.node());
            nodeCursor.next();
        }
        Object[] objectArray = vector.toArray(new Node[0]);
        EdgeCursor edgeCursor = this.graph.selectedEdges();
        Vector<Edge> vector2 = new Vector<Edge>();
        while (edgeCursor.ok()) {
            vector2.add(edgeCursor.edge());
            edgeCursor.next();
        }
        Object[] objectArray2 = vector2.toArray(new Edge[0]);
        TabbedBrowser tabbedBrowser = null;
        TabbedBrowser tabbedBrowser2 = null;
        if (objectArray.length == 0 && objectArray2.length == 0) {
            JOptionPane.showMessageDialog(null, "No selected nodes or edges", "Error", 0);
            return null;
        }
        if (objectArray.length > 0) {
            tabbedBrowser = new TabbedBrowser(objectArray, this.cytoscapeWindow.getNodeAttributes(), this.attributeCategoriesToIgnore, this.webBrowserScript);
        }
        if (objectArray2.length > 0) {
            tabbedBrowser2 = new TabbedBrowser(objectArray2, this.cytoscapeWindow.getEdgeAttributes(), this.attributeCategoriesToIgnore, this.webBrowserScript);
        }
        return null;
    }
}

