/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import javax.swing.JProgressBar;

public class SplashScreen
extends Canvas
implements Runnable {
    Thread t = new Thread(this);
    Frame win;
    Image image;
    Image offscreenImg;
    Graphics offscreenGfx;
    int progress;
    public boolean noGraph = false;
    JProgressBar progressBar;

    public void run() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.image = this.getToolkit().getImage(this.getClass().getResource("/cytoscape/images/cytoSplash.jpg"));
        MediaTracker mediaTracker = new MediaTracker(this);
        if (this.image != null) {
            mediaTracker.addImage(this.image, 0);
        }
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            System.out.println("Can not load the image" + exception.getMessage());
        }
        this.win = new Frame("Cytoscape is loading...");
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = new Dimension(400, 330);
        this.win.setSize(dimension2);
        this.win.setLayout(new BorderLayout());
        this.win.add("Center", this);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.win.add("South", this.progressBar);
        this.win.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.win.validate();
        this.win.show();
        while (this.progress < 100) {
            try {
                Thread.sleep(100L);
                this.progressBar.setValue(this.progress);
                ++this.progress;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.noGraph) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setString("Loading and laying out the graph...");
        }
    }

    public SplashScreen() {
        this.t.start();
    }

    public void advance(int n) {
        this.progress = n;
    }

    public void dispose() {
        this.t.stop();
        if (this.win != null) {
            this.win.dispose();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offscreenImg == null) {
            this.offscreenImg = this.createImage(dimension.width, dimension.height);
            this.offscreenGfx = this.offscreenImg.getGraphics();
        }
        this.offscreenGfx.setColor(Color.black);
        this.offscreenGfx.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        this.offscreenGfx.drawImage(this.image, 1, 1, this);
        this.offscreenGfx.setColor(Color.white);
        this.offscreenGfx.setFont(new Font("Arial", 1, 22));
        this.offscreenGfx.drawString("Welcome to Cytoscape!", 3, 40);
        this.offscreenGfx.setFont(new Font("Arial", 1, 14));
        this.offscreenGfx.drawString("A general-purpose modeling environment", 3, 210);
        this.offscreenGfx.drawString("for integrating biomolecular interaction", 3, 230);
        this.offscreenGfx.drawString("networks, network states, and functional", 3, 250);
        this.offscreenGfx.drawString("ontologies.", 3, 270);
        graphics.drawImage(this.offscreenImg, 0, 0, this);
        this.notify();
    }
}

