/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.GraphObjAttributes;
import java.util.HashMap;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.view.Graph2D;

public class SelectedSubGraphFactory {
    Graph2D parentGraph;
    Graph2D subgraph;
    GraphObjAttributes parentNodeAttributes;
    GraphObjAttributes parentEdgeAttributes;
    GraphObjAttributes newNodeAttributes;
    GraphObjAttributes newEdgeAttributes;
    HashMap subgraphNodeMap = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public SelectedSubGraphFactory(Graph2D graph2D, GraphObjAttributes graphObjAttributes, GraphObjAttributes graphObjAttributes2) {
        this.parentGraph = graph2D;
        this.parentNodeAttributes = graphObjAttributes;
        this.parentEdgeAttributes = graphObjAttributes2;
        this.createSubgraph();
    }

    protected void createSubgraph() {
        NodeCursor nodeCursor = this.parentGraph.selectedNodes();
        if (!$assertionsDisabled && this.parentNodeAttributes.getNameMap().size() != this.parentGraph.nodeCount()) {
            throw new AssertionError();
        }
        this.subgraph = new Graph2D();
        this.newNodeAttributes = (GraphObjAttributes)this.parentNodeAttributes.clone();
        this.newNodeAttributes.clearNameMap();
        nodeCursor.toFirst();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            Node node2 = node.createCopy((Graph)this.subgraph);
            String string = this.parentNodeAttributes.getCanonicalName(node);
            this.newNodeAttributes.addNameMapping(string, node2);
            this.subgraphNodeMap.put(string, node2);
            nodeCursor.next();
        }
        this.createEdgesWithAttributes();
    }

    protected void createEdgesWithAttributes() {
        if (!$assertionsDisabled && this.parentEdgeAttributes.getNameMap().size() != this.parentGraph.edgeCount()) {
            throw new AssertionError();
        }
        this.newEdgeAttributes = new GraphObjAttributes();
        Edge[] edgeArray = this.subgraph.getEdgeArray();
        for (int i = 0; i < edgeArray.length; ++i) {
            this.subgraph.removeEdge(edgeArray[i]);
        }
        EdgeCursor edgeCursor = this.parentGraph.edges();
        edgeCursor.toFirst();
        while (edgeCursor.ok()) {
            boolean bl;
            Edge edge = edgeCursor.edge();
            String string = this.parentEdgeAttributes.getCanonicalName(edge);
            Node node = edge.source();
            Node node2 = edge.target();
            String string2 = this.parentNodeAttributes.getCanonicalName(node);
            String string3 = this.parentNodeAttributes.getCanonicalName(node2);
            boolean bl2 = bl = this.subgraphNodeMap.containsKey(string2) && this.subgraphNodeMap.containsKey(string3);
            if (bl) {
                Node node3 = (Node)this.subgraphNodeMap.get(string2);
                Node node4 = (Node)this.subgraphNodeMap.get(string3);
                Edge edge2 = this.subgraph.createEdge(node3, node4);
                String string4 = this.parentEdgeAttributes.getCanonicalName(edge);
                HashMap hashMap = this.parentEdgeAttributes.getAttributes(string4);
                this.newEdgeAttributes.set(string4, hashMap);
                this.newEdgeAttributes.addNameMapping(string4, edge2);
            }
            edgeCursor.next();
        }
    }

    public Graph2D getSubGraph() {
        return this.subgraph;
    }

    public GraphObjAttributes getNodeAttributes() {
        return this.newNodeAttributes;
    }

    public GraphObjAttributes getEdgeAttributes() {
        return this.newEdgeAttributes;
    }

    static {
        $assertionsDisabled = !SelectedSubGraphFactory.class.desiredAssertionStatus();
    }
}

