/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.CytoscapeConfig;
import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import cytoscape.PluginInfo;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class PluginLoader {
    protected CytoscapeWindow cytoscapeWindow;
    protected CytoscapeConfig config;
    protected Vector classesToLoad = new Vector();
    protected Properties props;
    protected GraphObjAttributes nodeAttributes;
    protected GraphObjAttributes edgeAttributes;
    StringBuffer messageBuffer = new StringBuffer();

    public PluginLoader(CytoscapeWindow cytoscapeWindow, CytoscapeConfig cytoscapeConfig, GraphObjAttributes graphObjAttributes, GraphObjAttributes graphObjAttributes2) {
        this.cytoscapeWindow = cytoscapeWindow;
        this.config = cytoscapeConfig;
        this.props = cytoscapeConfig.getProperties();
        this.nodeAttributes = graphObjAttributes;
        this.edgeAttributes = graphObjAttributes2;
        String[] stringArray = this.extractPluginProperties(this.props);
        for (int i = 0; i < stringArray.length; ++i) {
            this.messageBuffer.append("  " + stringArray[i] + "\n");
        }
        this.findUnconditionallyLoadedClasses(stringArray);
        this.findConditionallyLoadedClasses(stringArray);
        this.messageBuffer.append(this.toString() + "\n");
    }

    String[] extractPluginProperties(Properties properties) {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            if (!stringArray.startsWith("plugin")) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    protected void findUnconditionallyLoadedClasses(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.endsWith(".load")) continue;
            String string2 = this.props.getProperty(string);
            this.messageBuffer.append(" PluginLoader, unconditional: " + string2 + "\n");
            this.addClassForLoading(string2);
        }
    }

    protected void findConditionallyLoadedClasses(String[] stringArray) {
        int n;
        Object object;
        Object object2;
        Object object3;
        int n2;
        String[] stringArray2;
        HashMap<String[], PluginInfo> hashMap = new HashMap<String[], PluginInfo>();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2 = stringArray[i];
            if (stringArray2.endsWith(".load")) continue;
            try {
                int n3 = "plugin.".length();
                n2 = stringArray2.indexOf(".", n3 + 1);
                object3 = stringArray2.substring(n3, n2);
                object2 = stringArray2.substring(n2 + 1);
                this.messageBuffer.append(" PluginLoader, conditional: " + (String)object3 + " category: " + (String)object2 + "\n");
                PluginInfo pluginInfo = (PluginInfo)hashMap.get(object3);
                if (pluginInfo == null) {
                    pluginInfo = new PluginInfo();
                    hashMap.put((String[])object3, pluginInfo);
                }
                object = this.props.getProperty((String)stringArray2);
                if (((String)object2).equals("fileExtension")) {
                    pluginInfo.setFileExtension((String)object);
                    continue;
                }
                if (((String)object2).equals("attributeName")) {
                    pluginInfo.setAttributeName((String)object);
                    continue;
                }
                if (!((String)object2).equals("className")) continue;
                pluginInfo.setClassName((String)object);
                continue;
            }
            catch (Exception exception) {
                System.err.println("-- PluginLoader error parsing: " + (String)stringArray2);
            }
        }
        String[] stringArray3 = hashMap.keySet().toArray(new String[0]);
        stringArray2 = this.config.getAllDataFileExtensions();
        Vector<String> vector = new Vector<String>();
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            vector.add(stringArray2[n2]);
        }
        for (n2 = 0; n2 < stringArray3.length; ++n2) {
            object3 = (PluginInfo)hashMap.get(stringArray3[n2]);
            if (!vector.contains(object3.getFileExtension())) continue;
            this.addClassForLoading(object3.getClassName());
        }
        String[] stringArray4 = this.nodeAttributes.getAttributeNames();
        object3 = this.edgeAttributes.getAttributeNames();
        object2 = new Vector();
        for (n = 0; n < stringArray4.length; ++n) {
            ((Vector)object2).add(stringArray4[n]);
        }
        for (n = 0; n < ((String[])object3).length; ++n) {
            ((Vector)object2).add(object3[n]);
        }
        for (n = 0; n < stringArray3.length; ++n) {
            object = (PluginInfo)hashMap.get(stringArray3[n]);
            if (!((Vector)object2).contains(((PluginInfo)object).getFileExtension())) continue;
            this.addClassForLoading(((PluginInfo)object).getClassName());
        }
    }

    protected void addClassForLoading(String string) {
        if (string != null && string.length() > 0 && !this.classesToLoad.contains(string)) {
            this.classesToLoad.add(string);
            this.messageBuffer.append(" PluginLoader, by file extension: " + string + "\n");
        }
    }

    public String[] getClassesToLoad() {
        return this.classesToLoad.toArray(new String[0]);
    }

    public void load() {
        String[] stringArray = this.getClassesToLoad();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.loadPlugin(string, this.cytoscapeWindow);
        }
    }

    protected void loadPlugin(String string, CytoscapeWindow cytoscapeWindow) {
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{cytoscapeWindow.getClass()};
            Object[] objectArray = new Object[]{cytoscapeWindow};
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Constructor<?> constructor = clazz.getConstructor(classArray);
            this.messageBuffer.append("  now loading plugin:  " + constructor + "\n");
            Object obj = constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-- PluginLoader, classes to load:\n   ");
        stringBuffer.append(this.classesToLoad);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public String getMessages() {
        return this.messageBuffer.toString();
    }
}

