/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextJarReader;
import cytoscape.data.servers.BioDataServer;
import cytoscape.util.Misc;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class GraphObjAttributes
implements Cloneable,
Serializable {
    HashMap map = new HashMap();
    transient HashMap nameFinder = new HashMap();
    transient HashMap canonicalToGraphObject = new HashMap();
    transient HashMap countIdMap = new HashMap();
    HashMap categoryMap = new HashMap();
    HashMap classMap = new HashMap();
    public static final String DEFAULT_CATEGORY = "unknown";

    public Object clone() {
        GraphObjAttributes graphObjAttributes = null;
        try {
            graphObjAttributes = (GraphObjAttributes)super.clone();
            graphObjAttributes.map = (HashMap)this.map.clone();
            String[] stringArray = this.map.keySet().toArray(new String[0]);
            for (int i = 0; i < stringArray.length; ++i) {
                HashMap hashMap = (HashMap)this.map.get(stringArray[i]);
                HashMap hashMap2 = (HashMap)hashMap.clone();
                graphObjAttributes.map.put(stringArray[i], hashMap2);
                String[] stringArray2 = hashMap.keySet().toArray(new String[0]);
                for (int j = 0; j < stringArray2.length; ++j) {
                    Object v = hashMap.get(stringArray2[j]);
                    if (v.getClass() != Class.forName("java.util.Vector")) continue;
                    Vector vector = (Vector)v;
                    Vector vector2 = (Vector)vector.clone();
                    hashMap2.put(stringArray2[j], vector2);
                }
            }
            graphObjAttributes.nameFinder = (HashMap)this.nameFinder.clone();
            graphObjAttributes.canonicalToGraphObject = (HashMap)this.canonicalToGraphObject.clone();
            graphObjAttributes.countIdMap = (HashMap)this.countIdMap.clone();
            graphObjAttributes.categoryMap = (HashMap)this.categoryMap.clone();
            graphObjAttributes.classMap = (HashMap)this.classMap.clone();
        }
        catch (Exception exception) {
            System.err.println(" --- error in GraphObjAttributes.clone");
            exception.printStackTrace();
        }
        return graphObjAttributes;
    }

    public void addNameMapping(String string, Object object) {
        this.nameFinder.put(object, string);
        this.canonicalToGraphObject.put(string, object);
        this.set("canonicalName", string, string);
    }

    public void removeNameMapping(String string) {
        Integer n;
        Object v = this.canonicalToGraphObject.remove(string);
        this.nameFinder.remove(v);
        if (this.countIdMap != null && (n = (Integer)this.countIdMap.get(string)) != null && n > 0) {
            this.countIdMap.put(string, new Integer(n - 1));
        }
    }

    public void removeObjectMapping(Object object) {
        String string = (String)this.nameFinder.remove(object);
        this.canonicalToGraphObject.remove(string);
    }

    public void clearNameMap() {
        this.nameFinder = new HashMap();
        this.clearObjectMap();
    }

    public void clearObjectMap() {
        this.canonicalToGraphObject = new HashMap();
    }

    public HashMap getNameMap() {
        return this.nameFinder;
    }

    public HashMap getClassMap() {
        return this.classMap;
    }

    public void addClassMap(HashMap hashMap) {
        this.classMap.putAll(hashMap);
    }

    public HashMap getObjectMap() {
        return this.canonicalToGraphObject;
    }

    public void addNameMap(HashMap hashMap) {
        this.nameFinder.putAll(hashMap);
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        HashMap hashMap2 = new HashMap();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            String string = (String)this.nameFinder.get(k);
            hashMap2.put(string, k);
        }
        this.addObjectMap(hashMap2);
    }

    public void addObjectMap(HashMap hashMap) {
        this.canonicalToGraphObject.putAll(hashMap);
    }

    public String getCanonicalName(Object object) {
        if (this.nameFinder == null) {
            System.out.println("oh oh, nameFinder is NULL !!!!!!!!!!!!!!");
        }
        return (String)this.nameFinder.get(object);
    }

    public Object getGraphObject(String string) {
        return this.canonicalToGraphObject.get(string);
    }

    public void set(GraphObjAttributes graphObjAttributes) {
        String[] stringArray = graphObjAttributes.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            HashMap hashMap = graphObjAttributes.getAttribute(stringArray[i]);
            this.map.put(string, hashMap);
        }
    }

    protected void initializeAttributeAsRequired(String string, String string2, Object object) {
        Class<?> clazz;
        if (!this.map.containsKey(string)) {
            this.map.put(string, new HashMap());
            if (this.getClass(string) == null) {
                clazz = object.getClass();
                if (object.getClass().isArray()) {
                    clazz = ((Object[])object)[0].getClass();
                }
                this.setClass(string, clazz);
            }
        }
        clazz = this.getClass(string);
        Class<?> clazz2 = object.getClass();
        if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            Object object2 = objectArray[0];
            clazz2 = object2.getClass();
        }
        if (clazz2 != clazz) {
            throw new IllegalArgumentException("class mismatch during set for attribute " + string + ",\n object: " + string2 + "\n expected " + clazz + "\n got " + clazz2);
        }
    }

    public boolean set(String string, String string2, Object object) {
        if (object == null) {
            return false;
        }
        if (!this.implementsSerializable(object.getClass())) {
            throw new IllegalArgumentException("The class " + object.getClass().getName() + " of the object that represents the value for the attribute \"" + string + "\" must implement java.io.Serializable.");
        }
        this.initializeAttributeAsRequired(string, string2, object);
        HashMap hashMap = (HashMap)this.map.get(string);
        hashMap.put(string2, object);
        return true;
    }

    public boolean append(String string, String string2, Object object) {
        if (object == null) {
            return false;
        }
        if (!this.implementsSerializable(object.getClass())) {
            throw new IllegalArgumentException("The class " + object.getClass().getName() + " of the object that represents the value for the attribute \"" + string + "\" must implement java.io.Serializable.");
        }
        this.initializeAttributeAsRequired(string, string2, object);
        HashMap hashMap = (HashMap)this.map.get(string);
        Vector vector = null;
        vector = hashMap.containsKey(string2) ? (Vector)hashMap.get(string2) : new Vector();
        if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                vector.add(objectArray[i]);
            }
        } else {
            vector.add(object);
        }
        hashMap.put(string2, vector);
        return true;
    }

    public boolean set(String string, String string2, double d) {
        return this.set(string, string2, new Double(d));
    }

    public boolean set(String string, HashMap hashMap) {
        String[] stringArray = hashMap.keySet().toArray(new String[0]);
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Object v = hashMap.get(string2);
            if (this.set(string2, string, v)) continue;
            bl = false;
        }
        return bl;
    }

    public void add(GraphObjAttributes graphObjAttributes) {
        this.set(graphObjAttributes);
    }

    public boolean add(String string, String string2, Object object) {
        return this.set(string, string2, object);
    }

    public boolean add(String string, String string2, double d) {
        return this.set(string, string2, d);
    }

    public boolean add(String string, HashMap hashMap) {
        return this.set(string, hashMap);
    }

    public int size() {
        return this.numberOfAttributes();
    }

    public int numberOfAttributes() {
        return this.map.size();
    }

    public String[] getAttributeNames() {
        return this.map.keySet().toArray(new String[0]);
    }

    public String[] getObjectNames(String string) {
        HashMap hashMap = this.getAttribute(string);
        if (hashMap == null) {
            return new String[0];
        }
        return hashMap.keySet().toArray(new String[0]);
    }

    public Object[] getUniqueValues(String string) {
        HashMap hashMap = this.getAttribute(string);
        if (hashMap == null) {
            return null;
        }
        Object[] objectArray = hashMap.values().toArray(new Object[0]);
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            int n;
            Object[] objectArray2;
            if (objectArray[i].getClass() == vector.getClass()) {
                objectArray2 = ((Vector)objectArray[i]).toArray(new Object[0]);
                for (n = 0; n < objectArray2.length; ++n) {
                    if (vector.contains(objectArray2[n])) continue;
                    vector.add(objectArray2[n]);
                }
                continue;
            }
            if (objectArray[i].getClass().isArray()) {
                objectArray2 = (Object[])objectArray[i];
                for (n = 0; n < objectArray2.length; ++n) {
                    if (vector.contains(objectArray2[n])) continue;
                    vector.add(objectArray2[n]);
                }
                continue;
            }
            if (vector.contains(objectArray[i])) continue;
            vector.add(objectArray[i]);
        }
        return vector.toArray(new Object[0]);
    }

    public String[] getUniqueStringValues(String string) {
        Object[] objectArray = this.getUniqueValues(string);
        if (objectArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    public int getObjectCount(String string) {
        HashMap hashMap = this.getAttribute(string);
        if (hashMap == null) {
            return 0;
        }
        return hashMap.size();
    }

    public void setCategory(String string, String string2) {
        this.categoryMap.put(string, string2);
    }

    public String getCategory(String string) {
        return (String)this.categoryMap.get(string);
    }

    public boolean hasAttribute(String string) {
        return this.map.containsKey(string);
    }

    public boolean hasAttribute(String string, String string2) {
        HashMap hashMap = (HashMap)this.map.get(string);
        if (hashMap == null) {
            return false;
        }
        return hashMap.containsKey(string2);
    }

    public HashMap getAttribute(String string) {
        return (HashMap)this.map.get(string);
    }

    public void deleteAttribute(String string) {
        if (this.hasAttribute(string)) {
            this.map.remove(string);
        }
    }

    public void deleteAttribute(String string, String string2) {
        if (!this.hasAttribute(string)) {
            return;
        }
        HashMap hashMap = this.getAttribute(string);
        hashMap.remove(string2);
    }

    public void deleteAttributeValue(String string, String string2, Object object) {
        if (!this.hasAttribute(string)) {
            return;
        }
        Vector vector = this.getList(string, string2);
        if (vector.contains(object)) {
            vector.remove(object);
        }
    }

    public boolean setClass(String string, Class clazz) {
        if (this.implementsSerializable(clazz) || clazz == null) {
            this.classMap.put(string, clazz);
            return true;
        }
        throw new IllegalArgumentException("Attribute class " + clazz.toString() + " must implement java.io.Serializable");
    }

    public Class getClass(String string) {
        return (Class)this.classMap.get(string);
    }

    public Vector getList(String string, String string2) {
        HashMap hashMap = (HashMap)this.map.get(string);
        if (hashMap == null) {
            return new Vector();
        }
        if (!hashMap.containsKey(string2)) {
            return new Vector();
        }
        Object v = hashMap.get(string2);
        Vector vector = new Vector();
        if (v.getClass() != vector.getClass()) {
            vector.add(v);
            return vector;
        }
        return (Vector)hashMap.get(string2);
    }

    public Object getValue(String string, String string2) {
        return this.get(string, string2);
    }

    public Object get(String string, String string2) {
        HashMap hashMap = (HashMap)this.map.get(string);
        if (hashMap == null) {
            return null;
        }
        if (!hashMap.containsKey(string2)) {
            return null;
        }
        return hashMap.get(string2);
    }

    public Object[] getArrayValues(String string, String string2) {
        Vector vector = this.getList(string, string2);
        if (vector == null) {
            return new Object[0];
        }
        Object[] objectArray = vector.toArray(new Object[0]);
        return objectArray;
    }

    public String[] getStringArrayValues(String string, String string2) {
        Vector vector = this.getList(string, string2);
        if (vector == null) {
            return new String[0];
        }
        String[] stringArray = vector.toArray(new String[0]);
        return stringArray;
    }

    public Double getDoubleValue(String string, String string2) {
        Object object = this.getValue(string, string2);
        if (object == null) {
            return null;
        }
        try {
            if (object.getClass() == Class.forName("java.util.Vector")) {
                Vector vector = (Vector)object;
                object = vector.size() < 1 ? null : vector.get(0);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return (Double)object;
    }

    public Integer getIntegerValue(String string, String string2) {
        Object object = this.getValue(string, string2);
        if (object == null) {
            return null;
        }
        try {
            if (object.getClass() == Class.forName("java.util.Vector")) {
                Vector vector = (Vector)object;
                object = vector.size() < 1 ? null : vector.get(0);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return (Integer)object;
    }

    public String getStringValue(String string, String string2) {
        Object object = this.getValue(string, string2);
        if (object == null) {
            return null;
        }
        try {
            if (object.getClass() == Class.forName("java.util.Vector")) {
                Vector vector = (Vector)object;
                object = vector.size() < 1 ? null : vector.get(0);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return object.toString();
    }

    public String processFileHeader(String string) {
        String string2 = "";
        String string3 = DEFAULT_CATEGORY;
        Class<?> clazz = null;
        if (string.indexOf("(") < 0) {
            string2 = string.trim();
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "(");
            string2 = stringTokenizer.nextToken().trim();
            while (stringTokenizer.hasMoreElements()) {
                String string4;
                int n;
                String string5 = stringTokenizer.nextToken().trim();
                if (!string5.endsWith(")") || (n = (string4 = string5.substring(0, string5.length() - 1)).indexOf("=")) < 0 || string4.endsWith("=")) continue;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "=");
                String string6 = stringTokenizer2.nextToken();
                String string7 = stringTokenizer2.nextToken();
                if (string6.equals("category")) {
                    string3 = string7;
                }
                if (!string6.equals("class")) continue;
                try {
                    clazz = Class.forName(string7);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        this.setCategory(string2, string3);
        this.setClass(string2, clazz);
        return string2;
    }

    public void readAttributesFromFile(String string) throws FileNotFoundException, IllegalArgumentException, NumberFormatException {
        this.readAttributesFromFile(null, DEFAULT_CATEGORY, string, true);
    }

    public void readAttributesFromFile(File file) throws FileNotFoundException, IllegalArgumentException, NumberFormatException {
        this.readAttributesFromFile(null, DEFAULT_CATEGORY, file.getPath(), true);
    }

    public static Class deduceClass(String string) {
        String[] stringArray = new String[]{"java.net.URL", "java.lang.Integer", "java.lang.Double", "java.lang.String"};
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object object = GraphObjAttributes.createInstanceFromString(Class.forName(stringArray[i]), string);
                return object.getClass();
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static Object createInstanceFromString(Class clazz, String string) throws Exception {
        Class[] classArray = new Class[]{Class.forName("java.lang.String")};
        Object[] objectArray = new Object[]{new String(string)};
        Constructor constructor = clazz.getConstructor(classArray);
        return constructor.newInstance(objectArray);
    }

    public void readAttributesFromFile(BioDataServer bioDataServer, String string, String string2, boolean bl) throws FileNotFoundException, IllegalArgumentException, NumberFormatException {
        String string3;
        Object object;
        try {
            if (string2.trim().startsWith("jar://")) {
                object = new TextJarReader(string2);
                ((TextJarReader)object).read();
                string3 = ((TextJarReader)object).getText();
            } else {
                object = new TextFileReader(string2);
                ((TextFileReader)object).read();
                string3 = ((TextFileReader)object).getText();
            }
        }
        catch (Exception exception) {
            System.err.println("-- Exception while reading attributes file " + string2);
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            return;
        }
        object = new StringTokenizer(string3, "\n");
        int n = 0;
        if (((StringTokenizer)object).countTokens() < 2) {
            throw new IllegalArgumentException(string2 + " must have at least 2 lines");
        }
        String string4 = this.processFileHeader(((StringTokenizer)object).nextToken().trim());
        boolean bl2 = true;
        boolean bl3 = true;
        while (((StringTokenizer)object).hasMoreElements()) {
            Object object2;
            String[] stringArray;
            String string5 = (String)((StringTokenizer)object).nextElement();
            if (string5.trim().startsWith("#")) continue;
            ++n;
            StringTokenizer stringTokenizer = new StringTokenizer(string5, "=");
            if (stringTokenizer.countTokens() < 2) {
                throw new IllegalArgumentException("cannot parse line number " + n + ":\n\t" + string5);
            }
            String string6 = stringTokenizer.nextToken().trim();
            if (bl && bioDataServer != null) {
                string6 = bioDataServer.getCanonicalName(string, string6);
            }
            String string7 = string5.substring(string5.indexOf("=") + 1).trim();
            boolean bl4 = false;
            if (Misc.isList(string7, "(", ")", "::")) {
                stringArray = Misc.parseList(string7, "(", ")", "::");
                bl4 = true;
            } else {
                stringArray = new String[]{string7};
            }
            if (bl2 && this.getClass(string4) == null) {
                bl2 = false;
                object2 = GraphObjAttributes.deduceClass(stringArray[0]);
                this.setClass(string4, (Class)object2);
            }
            object2 = new Object[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    object2[i] = GraphObjAttributes.createInstanceFromString(this.getClass(string4), stringArray[i]);
                    if (bl4) {
                        this.append(string4, string6, object2[i]);
                        continue;
                    }
                    this.set(string4, string6, object2[i]);
                    continue;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("\tcould not create an instance of\n" + this.getClass(string4) + " from\n" + stringArray[i] + ", attribute name = " + string4);
                }
            }
        }
    }

    public HashMap getSummary() {
        HashMap hashMap = new HashMap();
        String[] stringArray = this.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = this.getObjectNames(string)[0];
            Object object = this.getValue(string, string2);
            hashMap.put(string, object.getClass());
        }
        return hashMap;
    }

    public HashMap getAttributes(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String[] stringArray = this.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Object object = this.getValue(string2, string);
            if (object == null) continue;
            hashMap.put(string2, object);
        }
        return hashMap;
    }

    public int countIdentical(String string) {
        Integer n;
        if (this.countIdMap == null) {
            this.countIdMap = new HashMap();
        }
        if ((n = (Integer)this.countIdMap.get(string)) == null) {
            n = new Integer(0);
        }
        this.countIdMap.put(string, new Integer(n + 1));
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n-- canonicalNames: " + this.nameFinder.size());
        String string = this.nameFinder.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            stringBuffer.append("\n");
            stringBuffer.append(stringTokenizer.nextToken());
        }
        String[] stringArray = this.getAttributeNames();
        stringBuffer.append("\n-- attributes: " + stringArray.length + "\n");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("attribute " + i + ": " + stringArray[i] + "  ");
            Class clazz = this.getClass(stringArray[i]);
            String string2 = this.getCategory(stringArray[i]);
            stringBuffer.append("(class:" + clazz + ") ");
            stringBuffer.append("(category: " + string2 + ")");
            stringBuffer.append("\n");
            String[] stringArray2 = this.getObjectNames(stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                Object[] objectArray = this.getArrayValues(stringArray[i], stringArray2[j]);
                stringBuffer.append("   " + stringArray2[j] + " -> (");
                for (int k = 0; k < objectArray.length; ++k) {
                    stringBuffer.append(objectArray[k]);
                    if (k >= objectArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(")\n");
            }
        }
        return stringBuffer.toString();
    }

    protected boolean implementsSerializable(Class clazz) {
        if (clazz == null) {
            return false;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName("java.io.Serializable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (!clazz2.isAssignableFrom(classArray[i])) continue;
            return true;
        }
        return this.implementsSerializable(clazz.getSuperclass());
    }

    public static String[] unpackPossiblyCompoundStringAttributeValue(Object object) {
        String[] stringArray = new String[]{};
        try {
            if (object.getClass() == Class.forName("java.lang.String")) {
                stringArray = new String[]{(String)object};
            } else if (object.getClass() == Class.forName("[Ljava.lang.String;")) {
                stringArray = (String[])object;
            } else if (object.getClass() == Class.forName("java.util.Vector")) {
                Vector vector = (Vector)object;
                stringArray = vector.toArray(new String[0]);
            } else {
                String string = "AnnotationGui.unpackPossiblyCompoundAttributeValue, unrecognized class: " + object.getClass();
                System.err.println(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return stringArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws Exception {
        System.out.println("Writing GraphObjAttributes...");
        System.out.flush();
        objectOutputStream.defaultWriteObject();
        System.out.println("Wrote GraphObjAttributes");
        System.out.flush();
    }
}

