/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.CytoscapeConfig;
import cytoscape.CytoscapeVersion;
import cytoscape.FilterDialogClient;
import cytoscape.GraphObjAttributes;
import cytoscape.PluginLoader;
import cytoscape.SelectedSubGraphFactory;
import cytoscape.browsers.NodeBrowsingMode;
import cytoscape.cytoscape;
import cytoscape.data.ExpressionData;
import cytoscape.data.GraphProps;
import cytoscape.data.annotation.AnnotationGui;
import cytoscape.data.readers.FileReadingAbstractions;
import cytoscape.data.readers.GMLWriter;
import cytoscape.data.readers.SIFWriter;
import cytoscape.data.servers.BioDataServer;
import cytoscape.dialogs.EdgeControlDialog;
import cytoscape.dialogs.PopupTextArea;
import cytoscape.dialogs.RotateSelectionDialog;
import cytoscape.dialogs.ShrinkExpandGraphUI;
import cytoscape.filters.dialogs.EdgeTypeDialogIndep;
import cytoscape.filters.dialogs.MainFilterDialog;
import cytoscape.jarLoader.JarLoaderUI;
import cytoscape.layout.EmbeddedLayouter;
import cytoscape.layout.HierarchicalLayoutDialog;
import cytoscape.layout.ReduceEquivalentNodes;
import cytoscape.layout.Subgraph;
import cytoscape.undo.CytoscapeUndoManager;
import cytoscape.undo.EmptyUndoManager;
import cytoscape.undo.UndoableGraphHider;
import cytoscape.util.CyFileFilter;
import cytoscape.view.StraightLineMoveMode;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorIO;
import cytoscape.visual.Network;
import cytoscape.visual.OldStyleCalculatorIO;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.GenericNodeLabelCalculator;
import cytoscape.visual.calculators.NodeLabelCalculator;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import cytoscape.visual.ui.VizMapUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.filechooser.FileSystemView;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Graph;
import y.base.GraphListener;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeMap;
import y.base.YCursor;
import y.layout.LayoutGraph;
import y.layout.Layouter;
import y.layout.circular.CircularLayouter;
import y.layout.hierarchic.HierarchicLayouter;
import y.layout.organic.OrganicLayouter;
import y.layout.random.RandomLayouter;
import y.option.OptionHandler;
import y.util.GraphHider;
import y.view.BackgroundRenderer;
import y.view.DefaultBackgroundRenderer;
import y.view.EdgeRealizer;
import y.view.EditMode;
import y.view.Graph2D;
import y.view.Graph2DListener;
import y.view.Graph2DPrinter;
import y.view.Graph2DSelectionEvent;
import y.view.Graph2DSelectionListener;
import y.view.Graph2DView;
import y.view.NodeRealizer;
import y.view.PopupMode;
import y.view.View;
import y.view.ViewMode;

public class CytoscapeWindow
extends JPanel
implements FilterDialogClient,
Graph2DSelectionListener {
    public static final String NO_PLUGINS = "No plugins loaded";
    protected static final int DEFAULT_WIDTH = 700;
    protected static final int DEFAULT_HEIGHT = 700;
    protected cytoscape parentApp;
    protected Graph2D graph;
    protected String geometryFilename;
    protected String expressionDataFilename;
    protected Logger logger;
    protected JFrame mainFrame;
    protected JMenuBar menuBar;
    protected JMenu opsMenu;
    protected JMenu vizMenu;
    protected JMenu selectMenu;
    protected JMenu layoutMenu;
    protected JMenu fileMenu;
    protected JMenu editMenu;
    protected JMenu loadSubMenu;
    protected JMenu saveSubMenu;
    protected JToolBar toolbar;
    protected JLabel infoLabel;
    protected Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    protected Cursor busyCursor = Cursor.getPredefinedCursor(3);
    protected Layouter layouter;
    protected Graph2DView graphView;
    protected ViewMode editGraphMode = new EditGraphMode();
    protected ViewMode readOnlyGraphMode;
    protected ViewMode currentGraphMode = this.readOnlyGraphMode = new ReadOnlyGraphMode();
    protected ViewMode nodeAttributesPopupMode;
    protected ViewMode currentPopupMode = this.nodeAttributesPopupMode = new NodeBrowsingMode();
    protected boolean viewModesInstalled = false;
    protected String defaultSpecies;
    protected BioDataServer bioDataServer;
    protected String bioDataServerName;
    protected GraphObjAttributes nodeAttributes = new GraphObjAttributes();
    protected GraphObjAttributes edgeAttributes = new GraphObjAttributes();
    protected static CalculatorCatalog calculatorCatalog;
    protected VizMapUI vizMapUI;
    protected VisualMappingManager vizMapper;
    protected Network network;
    protected ExpressionData expressionData = null;
    protected final String goModeMenuLabel = "Show GeneOntology Info";
    protected final String expressionModeMenuLabel = "Show mRNA Expression";
    protected CytoscapeUndoManager undoManager;
    protected JMenuItem undoMenuItem;
    protected JMenuItem redoMenuItem;
    protected UndoableGraphHider graphHider;
    protected Vector subwindows = new Vector();
    protected String defaultWindowTitle = "Cytoscape " + CytoscapeVersion.version + "     ";
    protected String windowTitle;
    protected File currentDirectory;
    protected String titleForCurrentSelection = null;
    protected CytoscapeConfig config;
    protected JMenuItem deleteSelectionMenuItem;
    public static StringBuffer debugLog;

    public CytoscapeWindow(cytoscape cytoscape2, CytoscapeConfig cytoscapeConfig, Logger logger, Graph2D graph2D, ExpressionData expressionData, BioDataServer bioDataServer, GraphObjAttributes graphObjAttributes, GraphObjAttributes graphObjAttributes2, String string, String string2, String string3, boolean bl) throws Exception {
        this.parentApp = cytoscape2;
        this.logger = logger;
        this.geometryFilename = string;
        this.expressionDataFilename = string2;
        this.bioDataServer = bioDataServer;
        this.expressionData = expressionData;
        this.config = cytoscapeConfig;
        if (graphObjAttributes != null) {
            this.nodeAttributes = graphObjAttributes;
        }
        if (graphObjAttributes2 != null) {
            this.edgeAttributes = graphObjAttributes2;
        }
        this.currentDirectory = new File(System.getProperty("user.dir"));
        this.windowTitle = string3 == null ? this.defaultWindowTitle : this.defaultWindowTitle + string3;
        this.initializeWidgets();
        this.setGraph(graph2D);
        JButton jButton = this.toolbar.add(new AnnotationGui(this));
        this.loadVizMapper();
        jButton.setIcon(new ImageIcon(this.getClass().getResource("images/AnnotationGui.gif")));
        jButton.setToolTipText("add annotation to nodes");
        jButton.setBorderPainted(false);
        this.assignSpeciesAttributeToAllNodes();
        this.displayCommonNodeNames();
        this.displayNewGraph(bl);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CytoscapeWindow.this.saveCalculatorCatalog();
            }
        });
        this.mainFrame.addWindowListener(cytoscape2);
        this.mainFrame.setVisible(true);
        this.setPopupMode(new NodeBrowsingMode());
        this.loadPlugins();
        JarLoaderUI jarLoaderUI = new JarLoaderUI(this, this.loadSubMenu);
    }

    private void loadVizMapper() {
        if (calculatorCatalog == null) {
            this.loadCalculatorCatalog();
        }
        Properties properties = this.config.getProperties();
        VisualStyle visualStyle = null;
        String string = properties.getProperty("visualStyle");
        if (string != null) {
            visualStyle = calculatorCatalog.getVisualStyle(string);
        }
        if (visualStyle == null) {
            visualStyle = calculatorCatalog.getVisualStyle("default");
        }
        this.vizMapper = new VisualMappingManager(this, calculatorCatalog, visualStyle);
        this.network = new Network(this);
        this.vizMapUI = new VizMapUI(this.vizMapper);
        this.toolbar.addSeparator();
        JButton jButton = this.toolbar.add(new SetVisualPropertiesAction(false));
        jButton.setIcon(new ImageIcon(this.getClass().getResource("images/ColorVisual.gif")));
        jButton.setToolTipText("Set Visual Properties");
        jButton.setBorderPainted(false);
        this.toolbar.add(this.vizMapUI.getStyleSelector().getToolbarComboBox());
        this.toolbar.addSeparator();
    }

    public void setVizMapper(VisualMappingManager visualMappingManager) {
        this.vizMapper = visualMappingManager;
    }

    public void setNetwork(Network network) {
        this.network = network;
    }

    public void setVizMapUI(VizMapUI vizMapUI) {
        this.vizMapUI = vizMapUI;
    }

    private void loadCalculatorCatalog() {
        Object object;
        Object object2;
        Object object3;
        calculatorCatalog = new CalculatorCatalog();
        calculatorCatalog.addMapping("Discrete Mapper", DiscreteMapping.class);
        calculatorCatalog.addMapping("Continuous Mapper", ContinuousMapping.class);
        calculatorCatalog.addMapping("Passthrough Mapper", PassThroughMapping.class);
        Properties properties = new Properties();
        String string = "vizmap.props";
        try {
            object3 = new File(System.getProperty("CYTOSCAPE_HOME"), string);
            if (object3 != null && ((File)object3).canRead()) {
                object2 = new Properties();
                object = new FileInputStream((File)object3);
                ((Properties)object2).load((InputStream)object);
                ((InputStream)object).close();
                properties.putAll((Map<?, ?>)object2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            object3 = new File(System.getProperty("user.dir"), string);
            if (object3 != null && ((File)object3).canRead()) {
                object2 = new Properties();
                object = new FileInputStream((File)object3);
                ((Properties)object2).load((InputStream)object);
                ((InputStream)object).close();
                properties.putAll((Map<?, ?>)object2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            object3 = new File(System.getProperty("user.home"), string);
            if (object3 != null && ((File)object3).canRead()) {
                object2 = new Properties();
                object = new FileInputStream((File)object3);
                ((Properties)object2).load((InputStream)object);
                ((InputStream)object).close();
                properties.putAll((Map<?, ?>)object2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.config.getProjectVizmapPropsFileName() != null) {
            object3 = this.config.getProjectVizmapPropsFileName();
            properties.putAll((Map<?, ?>)this.config.readPropertyFileAsText((String)object3));
        }
        CalculatorIO.loadCalculators(properties, calculatorCatalog);
        object3 = calculatorCatalog.getVisualStyle("default");
        if (object3 == null) {
            object3 = new VisualStyle("default");
            object2 = "canonical names as node labels";
            object = calculatorCatalog.getNodeLabelCalculator((String)object2);
            if (object == null) {
                PassThroughMapping passThroughMapping = new PassThroughMapping((Object)new String(), "canonicalName");
                object = new GenericNodeLabelCalculator((String)object2, passThroughMapping);
            }
            ((VisualStyle)object3).getNodeAppearanceCalculator().setNodeLabelCalculator((NodeLabelCalculator)object);
            calculatorCatalog.addVisualStyle((VisualStyle)object3);
        }
        object2 = this.config.getProperties();
        OldStyleCalculatorIO.checkForCalculators((Properties)object2, calculatorCatalog);
    }

    public void saveCalculatorCatalog() {
        File file = new File(System.getProperty("user.home"), "vizmap.props");
        CalculatorIO.storeCatalog(calculatorCatalog, file);
    }

    private void addRandomColor(DiscreteMapping discreteMapping, String string) {
        discreteMapping.put(string, new Color((int)Math.floor(Math.random() * 255.0), (int)Math.floor(Math.random() * 255.0), (int)Math.floor(Math.random() * 255.0)));
    }

    private void addRandomDouble(DiscreteMapping discreteMapping, String string) {
        discreteMapping.put(string, new Double(20.0 + Math.random() * 40.0));
    }

    protected void setupLogging() {
        this.logger = Logger.getLogger("global");
        Properties properties = this.getConfiguration().getProperties();
        String string = properties.getProperty("logging", "SEVERE");
        if (string.equalsIgnoreCase("severe")) {
            this.logger.setLevel(Level.SEVERE);
        } else if (string.equalsIgnoreCase("warning")) {
            this.logger.setLevel(Level.WARNING);
        } else if (string.equalsIgnoreCase("info")) {
            this.logger.setLevel(Level.INFO);
        } else if (string.equalsIgnoreCase("config")) {
            this.logger.setLevel(Level.CONFIG);
        }
    }

    public BioDataServer getBioDataServer() {
        return this.bioDataServer;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void loadPlugins() {
        PluginLoader pluginLoader = new PluginLoader(this, this.config, this.nodeAttributes, this.edgeAttributes);
        pluginLoader.load();
        this.logger.info(pluginLoader.getMessages());
        if (this.opsMenu.getItemCount() == 0) {
            JMenuItem jMenuItem = new JMenuItem(NO_PLUGINS);
            jMenuItem.setEnabled(false);
            this.opsMenu.add(jMenuItem);
        }
    }

    public void windowStateChanged(WindowEvent windowEvent) {
        this.logger.info("--- windowStateChanged: " + windowEvent);
    }

    public CytoscapeConfig getConfiguration() {
        return this.config;
    }

    public CytoscapeUndoManager getUndoManager() {
        return this.undoManager;
    }

    public Graph2D getGraph() {
        return this.graph;
    }

    public GraphProps getProps() {
        return new GraphProps(this.graph, this.nodeAttributes, this.edgeAttributes);
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File file) {
        this.currentDirectory = file;
    }

    public void setGraph(Graph2D graph2D) {
        if (this.graph != null) {
            Graph2DListener graph2DListener;
            Iterator iterator = this.graph.getGraph2DListeners();
            ArrayList<Graph2DListener> arrayList = new ArrayList<Graph2DListener>();
            while (iterator.hasNext()) {
                graph2DListener = (Graph2DListener)iterator.next();
                arrayList.add(graph2DListener);
                graph2D.addGraph2DListener(graph2DListener);
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.graph.removeGraph2DListener((Graph2DListener)iterator.next());
            }
            arrayList.clear();
            iterator = this.graph.getGraph2DSelectionListeners();
            while (iterator.hasNext()) {
                graph2DListener = (Graph2DSelectionListener)iterator.next();
                arrayList.add(graph2DListener);
                graph2D.addGraph2DSelectionListener((Graph2DSelectionListener)graph2DListener);
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.graph.removeGraph2DSelectionListener((Graph2DSelectionListener)iterator.next());
            }
            arrayList.clear();
            iterator = this.graph.getGraphListeners();
            while (iterator.hasNext()) {
                graph2DListener = (GraphListener)iterator.next();
                arrayList.add(graph2DListener);
                if (graph2DListener == this.undoManager) continue;
                graph2D.addGraphListener((GraphListener)graph2DListener);
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.graph.removeGraphListener((GraphListener)iterator.next());
            }
        }
        this.graph = graph2D;
        this.graph.addGraph2DSelectionListener((Graph2DSelectionListener)this);
        if (this.getConfiguration().enableUndo()) {
            this.undoManager = new CytoscapeUndoManager(this, this.graph);
            graph2D.addGraphListener((GraphListener)this.undoManager);
            this.updateUndoRedoMenuItemStatus();
        } else {
            this.undoManager = new EmptyUndoManager(this, this.graph);
        }
        this.graphHider = new UndoableGraphHider((Graph)this.graph, this.undoManager);
        this.setLayouterAndGraphView();
    }

    public Graph2DView getGraphView() {
        return this.graphView;
    }

    public UndoableGraphHider getGraphHider() {
        return this.graphHider;
    }

    public void redrawGraph() {
        this.redrawGraph(false, true);
    }

    public void redrawGraph(boolean bl, boolean bl2) {
        int n;
        Iterator iterator = this.graph.getGraphListeners();
        ArrayList<GraphListener> arrayList = new ArrayList<GraphListener>();
        while (iterator.hasNext()) {
            GraphListener graphListener = (GraphListener)iterator.next();
            arrayList.add(graphListener);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.graph.removeGraphListener((GraphListener)arrayList.get(n));
        }
        if (bl2) {
            this.applyVizmapSettings();
        }
        if (bl) {
            this.applyLayout(false);
        }
        this.graphView.updateView();
        this.graphView.paintImmediately(0, 0, this.graphView.getWidth(), this.graphView.getHeight());
        this.updateStatusText();
        for (n = 0; n < arrayList.size(); ++n) {
            this.graph.addGraphListener((GraphListener)arrayList.get(n));
        }
    }

    public void redrawGraph(boolean bl) {
        this.redrawGraph(bl, true);
    }

    public void updateStatusText() {
        this.updateStatusText(0, 0);
    }

    public void updateStatusText(int n, int n2) {
        int n3 = this.graph.nodeCount();
        int n4 = this.graph.selectedNodes().size() + n;
        int n5 = this.graph.edgeCount();
        int n6 = this.graph.selectedEdges().size() + n2;
        this.infoLabel.setText("  Nodes: " + n3 + " (" + n4 + " selected)" + " Edges: " + n5 + " (" + n6 + " selected)");
    }

    public void selectionStateChanged(Graph2DSelectionEvent graph2DSelectionEvent) {
        if (graph2DSelectionEvent.isEdgeSelection()) {
            this.updateStatusText(0, this.graph.isSelected((Edge)graph2DSelectionEvent.getSubject()) ? -1 : 1);
        } else if (graph2DSelectionEvent.isNodeSelection()) {
            this.updateStatusText(this.graph.isSelected((Node)graph2DSelectionEvent.getSubject()) ? -1 : 1, 0);
        }
    }

    public void onGraph2DSelectionEvent(Graph2DSelectionEvent graph2DSelectionEvent) {
        this.updateStatusText();
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public void setWindowTitle(String string) {
        this.windowTitle = this.defaultWindowTitle + string;
        this.mainFrame.setTitle(this.windowTitle);
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setMenuBar(JMenuBar jMenuBar) {
        this.mainFrame.setJMenuBar(jMenuBar);
    }

    public JToolBar getToolBar() {
        return this.toolbar;
    }

    public ExpressionData getExpressionData() {
        return this.expressionData;
    }

    public void setExpressionData(ExpressionData expressionData) {
        this.expressionData = expressionData;
        if (this.expressionData != null) {
            this.expressionDataFilename = this.expressionData.getFileName();
        }
    }

    public String getExpressionDataFileName() {
        return this.expressionDataFilename;
    }

    public void setExpressionData(ExpressionData expressionData, String string) {
        this.expressionData = expressionData;
        this.expressionDataFilename = string;
    }

    public VisualMappingManager getVizMapManager() {
        return this.vizMapper;
    }

    public VizMapUI getVizMapUI() {
        return this.vizMapUI;
    }

    protected void initializeWidgets() {
        this.setLayout(new BorderLayout());
        this.graphView = new Graph2DView();
        DefaultBackgroundRenderer defaultBackgroundRenderer = new DefaultBackgroundRenderer(this.graphView);
        this.graphView.setBackgroundRenderer((BackgroundRenderer)defaultBackgroundRenderer);
        this.add((Component)this.graphView, "Center");
        this.graphView.setPreferredSize(new Dimension(700, 700));
        this.toolbar = this.createToolBar();
        this.add((Component)this.toolbar, "North");
        this.infoLabel = new JLabel();
        this.add((Component)this.infoLabel, "South");
        this.mainFrame = new JFrame(this.windowTitle);
        this.mainFrame.setJMenuBar(this.createMenuBar());
        this.mainFrame.setContentPane(this);
        this.mainFrame.pack();
        this.setInteractivity(true);
    }

    public String getCanonicalNodeName(Node node) {
        return this.nodeAttributes.getCanonicalName(node);
    }

    protected void assignSpeciesAttributeToAllNodes() {
        Node[] nodeArray = this.graphView.getGraph2D().getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            this.nodeAttributes.set("species", this.nodeAttributes.getCanonicalName(nodeArray[i]), this.getSpecies(nodeArray[i]));
        }
    }

    public void setDefaultSpecies(String string) {
        this.defaultSpecies = string;
    }

    public String getDefaultSpecies() {
        String string = this.config.getDefaultSpeciesName();
        if (string != null) {
            return string;
        }
        string = this.getConfiguration().getProperties().getProperty("species", "unknown");
        return string;
    }

    public String getSpecies(Node node) {
        String string = this.nodeAttributes.getStringValue("species", this.nodeAttributes.getCanonicalName(node));
        if (string != null) {
            return string;
        }
        return this.getDefaultSpecies();
    }

    public String[] getAllSpecies() {
        Vector<String> vector = new Vector<String>();
        Node[] nodeArray = this.graphView.getGraph2D().getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            String string = this.getSpecies(nodeArray[i]);
            if (vector.contains(string) || string == null) continue;
            vector.add(string);
        }
        return vector.toArray(new String[0]);
    }

    protected void displayNewGraph(boolean bl) {
        String string;
        if (this.graph == null) {
            this.setGraph(new Graph2D());
        }
        if ((string = this.config.getDefaultLayoutStrategy()).equals("hierarchical")) {
            this.layouter = new HierarchicLayouter();
        } else if (string.equals("circular")) {
            this.layouter = new CircularLayouter();
        } else if (string.equals("embedded")) {
            this.layouter = new EmbeddedLayouter();
        } else if (string.equals("organic")) {
            OrganicLayouter organicLayouter = new OrganicLayouter();
            organicLayouter.setActivateDeterministicMode(true);
            organicLayouter.setPreferredEdgeLength(80);
            this.layouter = organicLayouter;
        }
        this.graphView.setGraph2D(this.graph);
        this.redrawGraph(bl, true);
        this.graphView.fitContent();
        this.graphView.setZoom(this.graphView.getZoom() * 0.9);
    }

    protected void setLayouterAndGraphView() {
        String string;
        if (this.graph == null) {
            this.setGraph(new Graph2D());
        }
        if ((string = this.config.getDefaultLayoutStrategy()).equals("hierarchical")) {
            this.layouter = new HierarchicLayouter();
        } else if (string.equals("circular")) {
            this.layouter = new CircularLayouter();
        } else if (string.equals("embedded")) {
            this.layouter = new EmbeddedLayouter();
        } else if (string.equals("organic")) {
            OrganicLayouter organicLayouter = new OrganicLayouter();
            organicLayouter.setActivateDeterministicMode(true);
            organicLayouter.setPreferredEdgeLength(80);
            this.layouter = organicLayouter;
        }
        this.graphView.setGraph2D(this.graph);
        this.graph.setCurrentView((View)this.graphView);
        this.graphView.fitContent();
        this.graphView.setZoom(this.graphView.getZoom() * 0.9);
    }

    protected void applyVizmapSettings() {
        this.getVizMapManager().applyAppearances();
    }

    public Node getNode(String string) {
        Node[] nodeArray = this.graphView.getGraph2D().getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            String string2 = this.nodeAttributes.getCanonicalName(node);
            this.logger.warning(" -- checking " + string + " against " + string2 + " " + node);
            if (!string.equals(string2)) continue;
            return node;
        }
        return null;
    }

    public GraphObjAttributes getNodeAttributes() {
        return this.nodeAttributes;
    }

    public void setNodeAttributes(GraphObjAttributes graphObjAttributes) {
        this.nodeAttributes = graphObjAttributes;
        this.nodeAttributes.clearNameMap();
        Node[] nodeArray = this.graphView.getGraph2D().getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            String string = nodeArray[i].toString();
            this.nodeAttributes.addNameMapping(string, nodeArray[i]);
        }
        this.displayCommonNodeNames();
    }

    public void setNodeAttributes(GraphObjAttributes graphObjAttributes, boolean bl) {
        this.nodeAttributes = graphObjAttributes;
        if (!bl) {
            this.nodeAttributes.clearNameMap();
            Node[] nodeArray = this.graphView.getGraph2D().getNodeArray();
            for (int i = 0; i < nodeArray.length; ++i) {
                String string = nodeArray[i].toString();
                this.nodeAttributes.addNameMapping(string, nodeArray[i]);
            }
        }
        this.displayCommonNodeNames();
    }

    public GraphObjAttributes getEdgeAttributes() {
        return this.edgeAttributes;
    }

    public void setEdgeAttributes(GraphObjAttributes graphObjAttributes) {
        this.edgeAttributes = graphObjAttributes;
    }

    public void displayCommonNodeNames() {
        Node[] nodeArray = this.graph.getNodeArray();
        String string = "";
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            NodeRealizer nodeRealizer = this.graphView.getGraph2D().getRealizer(node);
            String string2 = nodeRealizer.getLabelText();
            String string3 = this.getCanonicalNodeName(node);
            String[] stringArray = this.nodeAttributes.getStringArrayValues("commonName", string3);
            if (stringArray != null && stringArray.length > 0) {
                string2 = stringArray[0];
                string = "from pre-existing node attribute";
            } else {
                try {
                    String[] stringArray2 = this.bioDataServer.getAllCommonNames(this.getSpecies(node), string3);
                    if (stringArray2 != null && stringArray2.length > 0) {
                        string2 = stringArray2[0];
                    }
                    if (string2 == null || string2.length() == 0) {
                        string2 = string3;
                    }
                    string = " from annotation server";
                }
                catch (Exception exception) {
                    string2 = string3;
                    string = "from canonicalName";
                }
            }
            this.nodeAttributes.set("commonName", string3, string2);
            nodeRealizer.setLabelText(string2);
        }
    }

    public void displayNodeLabels(String string) {
        Node[] nodeArray = this.graph.getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            Object object;
            Node node = nodeArray[i];
            String string2 = this.getCanonicalNodeName(node);
            String string3 = "";
            if (!string.equals("canonicalName")) {
                if (this.nodeAttributes.getClass(string) == "string".getClass()) {
                    string3 = this.nodeAttributes.getStringValue(string, string2);
                } else {
                    object = this.nodeAttributes.getAttributes(string2);
                    Object v = ((HashMap)object).get(string);
                    if (v != null) {
                        string3 = v.toString();
                    }
                }
            } else {
                string3 = string2;
            }
            object = this.graphView.getGraph2D().getRealizer(node);
            object.setLabelText(string3);
        }
    }

    public JMenu getOperationsMenu() {
        return this.opsMenu;
    }

    public JMenu getVizMenu() {
        return this.vizMenu;
    }

    public JMenu getSelectMenu() {
        return this.selectMenu;
    }

    public JMenu getLayoutMenu() {
        return this.layoutMenu;
    }

    public Layouter getLayouter() {
        return this.layouter;
    }

    public void setPopupMode(PopupMode popupMode) {
        if (this.currentPopupMode != null) {
            this.graphView.removeViewMode(this.currentPopupMode);
            if (popupMode instanceof NodeBrowsingMode) {
                NodeBrowsingMode nodeBrowsingMode = (NodeBrowsingMode)popupMode;
                nodeBrowsingMode.set(this);
            }
        }
        this.graphView.addViewMode((ViewMode)popupMode);
        this.currentPopupMode = popupMode;
    }

    public void setInteractivity(boolean bl) {
        if (bl) {
            if (!this.viewModesInstalled) {
                this.graphView.addViewMode(this.currentGraphMode);
                if (this.currentPopupMode != null) {
                    this.graphView.addViewMode(this.currentPopupMode);
                }
                this.viewModesInstalled = true;
            }
            this.graphView.setViewCursor(this.defaultCursor);
            this.setCursor(this.defaultCursor);
            if (this.undoManager != null) {
                this.undoManager.resume();
            }
        } else {
            if (this.viewModesInstalled) {
                this.graphView.removeViewMode(this.currentGraphMode);
                this.graphView.removeViewMode(this.currentPopupMode);
                this.viewModesInstalled = false;
            }
            this.graphView.setViewCursor(this.busyCursor);
            this.setCursor(this.busyCursor);
            if (this.undoManager != null) {
                this.undoManager.pause();
            }
        }
        MenuElement[] menuElementArray = this.menuBar.getSubElements();
        for (int i = 0; i < menuElementArray.length; ++i) {
            Component component = menuElementArray[i].getComponent();
            component.setEnabled(bl);
        }
        this.toolbar.setEnabled(bl);
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.loadSubMenu = new JMenu("Load");
        this.fileMenu.add(this.loadSubMenu);
        JMenuItem jMenuItem = this.loadSubMenu.add(new LoadGMLFileAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        jMenuItem = this.loadSubMenu.add(new LoadInteractionFileAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        jMenuItem = this.loadSubMenu.add(new LoadExpressionMatrixAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem = this.loadSubMenu.add(new LoadBioDataServerAction());
        jMenuItem = this.loadSubMenu.add(new LoadNodeAttributesAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 3));
        jMenuItem = this.loadSubMenu.add(new LoadEdgeAttributesAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(74, 3));
        this.saveSubMenu = new JMenu("Save");
        this.fileMenu.add(this.saveSubMenu);
        this.saveSubMenu.add(new SaveAsGMLAction());
        this.saveSubMenu.add(new SaveAsInteractionsAction());
        this.saveSubMenu.add(new SaveVisibleNodesAction());
        this.saveSubMenu.add(new SaveSelectedNodesAction());
        this.fileMenu.add(new PrintAction());
        jMenuItem = this.fileMenu.add(new CloseWindowAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        if (this.parentApp != null) {
            jMenuItem = this.fileMenu.add(new ExitAction());
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        }
        this.menuBar.add(this.fileMenu);
        this.editMenu = new JMenu("Edit");
        this.menuBar.add(this.editMenu);
        if (this.getConfiguration().enableUndo()) {
            this.undoMenuItem = this.editMenu.add(new UndoAction());
            this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
            this.redoMenuItem = this.editMenu.add(new RedoAction());
            this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
            this.editMenu.addSeparator();
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Read-only mode");
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Edit mode for nodes and edges");
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        this.editMenu.add(jRadioButtonMenuItem);
        this.editMenu.add(jRadioButtonMenuItem2);
        jRadioButtonMenuItem.setSelected(true);
        jRadioButtonMenuItem.addActionListener(new ReadOnlyModeAction());
        jRadioButtonMenuItem2.addActionListener(new EditModeAction());
        this.editMenu.addSeparator();
        this.deleteSelectionMenuItem = this.editMenu.add(new DeleteSelectedAction());
        this.deleteSelectionMenuItem.setEnabled(false);
        this.selectMenu = new JMenu("Select");
        this.menuBar.add(this.selectMenu);
        JMenu jMenu = new JMenu("Nodes");
        this.selectMenu.add(jMenu);
        JMenu jMenu2 = new JMenu("Edges");
        this.selectMenu.add(jMenu2);
        JMenu jMenu3 = new JMenu("To New Window");
        this.selectMenu.add(jMenu3);
        jMenuItem = jMenu.add(new InvertSelectedNodesAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        jMenuItem = jMenu.add(new HideSelectedNodesAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        jMenuItem = jMenu2.add(new InvertSelectedEdgesAction());
        jMenuItem = jMenu2.add(new HideSelectedEdgesAction());
        jMenuItem = jMenu2.add(new EdgeManipulationAction());
        jMenuItem = jMenu.add(new SelectFirstNeighborsAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        jMenu.add(new AlphabeticalSelectionAction());
        jMenu.add(new ListFromFileSelectionAction());
        jMenu.add(new MenuFilterAction());
        jMenuItem = jMenu3.add(new NewWindowSelectedNodesOnlyAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItem = jMenu3.add(new NewWindowSelectedNodesEdgesAction());
        jMenuItem = jMenu3.add(new CloneGraphInNewWindowAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.layoutMenu = new JMenu("Layout");
        this.layoutMenu.setToolTipText("Apply new layout algorithm to graph");
        this.menuBar.add(this.layoutMenu);
        String string = this.config.getDefaultLayoutStrategy();
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem("Circular");
        buttonGroup2.add(jRadioButtonMenuItem3);
        this.layoutMenu.add(jRadioButtonMenuItem3);
        jRadioButtonMenuItem3.addActionListener(new CircularLayoutAction());
        if (string.equals("circular")) {
            jRadioButtonMenuItem3.setSelected(true);
        }
        jRadioButtonMenuItem3 = new JRadioButtonMenuItem("Hierarchicial");
        buttonGroup2.add(jRadioButtonMenuItem3);
        this.layoutMenu.add(jRadioButtonMenuItem3);
        jRadioButtonMenuItem3.addActionListener(new HierarchicalLayoutAction());
        if (string.equals("hierarchical")) {
            jRadioButtonMenuItem3.setSelected(true);
        }
        jRadioButtonMenuItem3 = new JRadioButtonMenuItem("Organic");
        buttonGroup2.add(jRadioButtonMenuItem3);
        this.layoutMenu.add(jRadioButtonMenuItem3);
        if (string.equals("organic")) {
            jRadioButtonMenuItem3.setSelected(true);
        }
        jRadioButtonMenuItem3.addActionListener(new OrganicLayoutAction());
        jRadioButtonMenuItem3 = new JRadioButtonMenuItem("Embedded");
        buttonGroup2.add(jRadioButtonMenuItem3);
        this.layoutMenu.add(jRadioButtonMenuItem3);
        if (string.equals("embedded")) {
            jRadioButtonMenuItem3.setSelected(true);
        }
        jRadioButtonMenuItem3.addActionListener(new EmbeddedLayoutAction());
        jRadioButtonMenuItem3 = new JRadioButtonMenuItem("Random");
        buttonGroup2.add(jRadioButtonMenuItem3);
        this.layoutMenu.add(jRadioButtonMenuItem3);
        if (string.equals("random")) {
            jRadioButtonMenuItem3.setSelected(true);
        }
        jRadioButtonMenuItem3.addActionListener(new RandomLayoutAction());
        this.layoutMenu.addSeparator();
        jMenuItem = this.layoutMenu.add(new LayoutAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.layoutMenu.add(new LayoutSelectionAction());
        this.layoutMenu.addSeparator();
        JMenu jMenu4 = new JMenu("Align Selected Nodes");
        this.layoutMenu.add(jMenu4);
        jMenu4.add(new AlignHorizontalAction());
        jMenu4.add(new AlignVerticalAction());
        this.layoutMenu.add(new RotateSelectedNodesAction());
        this.layoutMenu.add(new ReduceEquivalentNodesAction());
        ShrinkExpandGraphUI shrinkExpandGraphUI = new ShrinkExpandGraphUI(this);
        this.vizMenu = new JMenu("Visualization");
        this.menuBar.add(this.vizMenu);
        this.vizMenu.add(new SetVisualPropertiesAction());
        this.opsMenu = new JMenu("PlugIns");
        this.menuBar.add(this.opsMenu);
        return this.menuBar;
    }

    protected JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        JButton jButton = jToolBar.add(new ZoomAction(0.9));
        jButton.setIcon(new ImageIcon(this.getClass().getResource("images/ZoomOut24.gif")));
        jButton.setToolTipText("Zoom Out");
        jButton.setBorderPainted(false);
        jButton.setRolloverEnabled(true);
        jButton = jToolBar.add(new ZoomAction(1.1));
        jButton.setIcon(new ImageIcon(this.getClass().getResource("images/ZoomIn24.gif")));
        jButton.setToolTipText("Zoom In");
        jButton.setBorderPainted(false);
        jButton = jToolBar.add(new ZoomSelectedAction());
        jButton.setIcon(new ImageIcon(this.getClass().getResource("images/ZoomArea24.gif")));
        jButton.setToolTipText("Zoom Selected Region");
        jButton.setBorderPainted(false);
        jButton = jToolBar.add(new FitContentAction());
        jButton.setIcon(new ImageIcon(this.getClass().getResource("images/overview.gif")));
        jButton.setToolTipText("Zoom out to display all of current graph");
        jButton.setBorderPainted(false);
        jButton = jToolBar.add(new ShowAllAction());
        jButton.setIcon(new ImageIcon(this.getClass().getResource("images/overall.gif")));
        jButton.setToolTipText("Show all nodes and edges (unhiding as necessary)");
        jButton.setBorderPainted(false);
        jButton = jToolBar.add(new HideSelectedAction());
        jButton.setIcon(new ImageIcon(this.getClass().getResource("images/Zoom24.gif")));
        jButton.setToolTipText("Hide Selected Region");
        jButton.setBorderPainted(false);
        jToolBar.addSeparator();
        jButton = jToolBar.add(new MainFilterDialogAction());
        jButton.setIcon(new ImageIcon(this.getClass().getResource("images/Grid24.gif")));
        jButton.setToolTipText("Apply Filters to Graph");
        jButton.setBorderPainted(false);
        return jToolBar;
    }

    public String[] selectNodesByName(String[] stringArray) {
        boolean bl = true;
        return this.selectNodesByName(stringArray, bl);
    }

    protected void showNodesByName(String[] stringArray) {
        int n;
        Graph2D graph2D = this.graphView.getGraph2D();
        this.graphHider.unhideAll();
        Node[] nodeArray = this.graphView.getGraph2D().getNodeArray();
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n].toLowerCase();
            hashtable.put(stringArray[n], Boolean.TRUE);
        }
        for (n = 0; n < nodeArray.length; ++n) {
            String string = this.getCanonicalNodeName(nodeArray[n]);
            string.toLowerCase();
            Boolean bl = (Boolean)hashtable.get(string);
            if (bl != null) continue;
            this.graphHider.hide(nodeArray[n]);
        }
        this.redrawGraph(false, false);
    }

    public void showNodesByName(Vector vector) {
        this.showNodesByName(vector.toArray(new String[0]));
    }

    public String[] selectNodesByName(String[] stringArray, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        int n;
        Graph2D graph2D = this.graphView.getGraph2D();
        Node[] nodeArray = this.graphView.getGraph2D().getNodeArray();
        int n2 = 0;
        Hashtable<Object, Boolean> hashtable = new Hashtable<Object, Boolean>();
        Hashtable<String, Boolean> hashtable2 = new Hashtable<String, Boolean>();
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n].toLowerCase();
            hashtable2.put(stringArray[n], Boolean.TRUE);
            hashtable.put(stringArray[n], Boolean.FALSE);
        }
        for (n = 0; n < nodeArray.length; ++n) {
            object3 = this.getCanonicalNodeName(nodeArray[n]);
            object2 = this.graphView.getGraph2D().getRealizer(nodeArray[n]);
            ((String)object3).toLowerCase();
            object = (Boolean)hashtable2.get(object3);
            if (object != null) {
                ++n2;
                object2.setSelected(true);
                hashtable.put(object3, Boolean.TRUE);
                continue;
            }
            if (!bl) continue;
            object2.setSelected(false);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (n2 < stringArray.length) {
            object3 = hashtable.keySet();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if ((Boolean)hashtable.get(object) != Boolean.FALSE) continue;
                arrayList.add(object);
            }
        }
        this.redrawGraph(false, false);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void selectEdges(Edge[] edgeArray, boolean bl) {
        if (bl) {
            this.graph.unselectEdges();
        }
        for (int i = 0; i < edgeArray.length; ++i) {
            EdgeRealizer edgeRealizer = this.graph.getRealizer(edgeArray[i]);
            edgeRealizer.setSelected(true);
        }
        this.redrawGraph(false, false);
    }

    public void selectNodes(Node[] nodeArray, boolean bl) {
        if (bl) {
            this.graph.unselectNodes();
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            NodeRealizer nodeRealizer = this.graph.getRealizer(nodeArray[i]);
            nodeRealizer.setSelected(true);
        }
        this.redrawGraph(false, false);
    }

    public void deselectAllNodes(boolean bl) {
        if (bl) {
            this.deselectAllNodes();
        } else {
            this.graph.unselectNodes();
        }
    }

    public void deselectAllNodes() {
        this.graph.unselectNodes();
        this.redrawGraph(false, false);
    }

    protected void selectNodesStartingWith(String string) {
        this.setInteractivity(false);
        string = string.toLowerCase();
        Graph2D graph2D = this.graphView.getGraph2D();
        this.redrawGraph(false, false);
        Node[] nodeArray = this.graphView.getGraph2D().getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            String string2 = this.graphView.getGraph2D().getLabelText(nodeArray[i]);
            String string3 = this.nodeAttributes.getCanonicalName(nodeArray[i]);
            boolean bl = false;
            if (string2.toLowerCase().startsWith(string) || string3.toLowerCase().startsWith(string)) {
                bl = true;
            } else if (this.bioDataServer != null) {
                try {
                    String[] stringArray = this.bioDataServer.getAllCommonNames(this.getSpecies(nodeArray[i]), string2);
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (!stringArray[j].toLowerCase().startsWith(string)) continue;
                        bl = true;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setNodeSelected(nodeArray[i], bl);
        }
        this.setInteractivity(true);
        this.redrawGraph(false, false);
    }

    protected void additionallySelectNodesMatching(String string) {
        this.setInteractivity(false);
        string = string.toLowerCase();
        Graph2D graph2D = this.graphView.getGraph2D();
        this.redrawGraph(false, false);
        Node[] nodeArray = this.graphView.getGraph2D().getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            String string2 = this.graphView.getGraph2D().getLabelText(nodeArray[i]);
            boolean bl = false;
            if (string2.toLowerCase().equalsIgnoreCase(string)) {
                bl = true;
            } else if (this.bioDataServer != null) {
                try {
                    String[] stringArray = this.bioDataServer.getAllCommonNames(this.getSpecies(nodeArray[i]), string2);
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (!stringArray[j].equalsIgnoreCase(string)) continue;
                        bl = true;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!bl) continue;
            this.setNodeSelected(nodeArray[i], true);
        }
        this.setInteractivity(true);
        this.redrawGraph(false, false);
    }

    protected String findCanonicalName(String string) {
        String string2 = string;
        if (this.bioDataServer != null) {
            try {
                String[] stringArray = this.bioDataServer.getAllCommonNames(this.getDefaultSpecies(), string);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    if (!string3.equalsIgnoreCase(string)) continue;
                    string2 = string3;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }

    protected void setNodeSelected(Node node, boolean bl) {
        NodeRealizer nodeRealizer = this.graphView.getGraph2D().getRealizer(node);
        nodeRealizer.setSelected(bl);
    }

    protected void updateEdgeVisibilityFromNodeVisibility() {
        EdgeCursor edgeCursor = this.graphView.getGraph2D().edges();
        while (edgeCursor.ok()) {
            Node node;
            Edge edge = edgeCursor.edge();
            Node node2 = edge.source();
            boolean bl = false;
            if (this.graphView.getGraph2D().getRealizer(node2).isVisible()) {
                node = edge.target();
                if (this.graphView.getGraph2D().getRealizer(node).isVisible()) {
                    bl = true;
                }
            }
            node = this.graphView.getGraph2D().getRealizer(edge);
            node.setVisible(bl);
            edgeCursor.next();
        }
    }

    public void applyLayout(boolean bl) {
        int n;
        if (this.graph.getNodeArray().length == 0) {
            return;
        }
        Iterator iterator = this.graph.getGraphListeners();
        ArrayList<GraphListener> arrayList = new ArrayList<GraphListener>();
        while (iterator.hasNext()) {
            GraphListener graphListener = (GraphListener)iterator.next();
            arrayList.add(graphListener);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.graph.removeGraphListener((GraphListener)arrayList.get(n));
        }
        this.logger.warning("starting layout...");
        this.setInteractivity(false);
        this.layouter.doLayout((LayoutGraph)this.graphView.getGraph2D());
        this.graphView.fitContent();
        this.graphView.setZoom(this.graphView.getZoom() * 0.9);
        this.setInteractivity(true);
        this.logger.info(" done");
        for (n = 0; n < arrayList.size(); ++n) {
            this.graph.addGraphListener((GraphListener)arrayList.get(n));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void applyLayoutSelection() {
        Graph2D graph2D = this.graphView.getGraph2D();
        if (this.layouter.getClass().getName().endsWith("EmbeddedLayouter")) {
            void by2;
            NodeMap nodeMap = graph2D.createNodeMap();
            graph2D.addDataProvider((Object)"Cytoscape:slug", (DataProvider)nodeMap);
            Node[] nodeArray = graph2D.selectedNodes();
            while (nodeArray.ok()) {
                nodeMap.setDouble((Object)nodeArray.node(), 0.5);
                nodeArray.next();
            }
            nodeArray = graph2D.getNodeArray();
            int n = graph2D.nodeCount();
            boolean i = false;
            while (by2 < n) {
                if (nodeMap.getDouble((Object)nodeArray[by2]) != 0.5) {
                    nodeMap.setDouble((Object)nodeArray[by2], 0.0);
                }
                ++by2;
            }
            this.applyLayout(false);
            graph2D.removeDataProvider((Object)"Cytoscape:slug");
            graph2D.disposeNodeMap(nodeMap);
        } else if (this.layouter.getClass().getName().endsWith("OrganicLayouter")) {
            byte edgeRealizer;
            OrganicLayouter organicLayouter = (OrganicLayouter)this.layouter;
            NodeMap nodeMap = graph2D.createNodeMap();
            graph2D.addDataProvider(Layouter.SELECTED_NODES, (DataProvider)nodeMap);
            Node[] nodeArray = graph2D.selectedNodes();
            while (nodeArray.ok()) {
                nodeMap.setBool((Object)nodeArray.node(), true);
                nodeArray.next();
            }
            nodeArray = graph2D.getNodeArray();
            byte edge = graph2D.nodeCount();
            for (edgeRealizer = 0; edgeRealizer < edge; ++edgeRealizer) {
                if (nodeMap.getBool((Object)nodeArray[edgeRealizer])) continue;
                nodeMap.setBool((Object)nodeArray[edgeRealizer], false);
            }
            edgeRealizer = organicLayouter.getSphereOfAction();
            organicLayouter.setSphereOfAction((byte)2);
            this.applyLayout(false);
            organicLayouter.setSphereOfAction(edgeRealizer);
            graph2D.removeDataProvider(Layouter.SELECTED_NODES);
            graph2D.disposeNodeMap(nodeMap);
        } else {
            this.logger.warning("starting layout...");
            this.setInteractivity(false);
            Subgraph subgraph = new Subgraph((LayoutGraph)graph2D, (YCursor)graph2D.selectedNodes());
            this.layouter.doLayout((LayoutGraph)subgraph);
            subgraph.reInsert();
            EdgeCursor edgeCursor = this.graphView.getGraph2D().edges();
            edgeCursor.toFirst();
            for (int i = 0; i < edgeCursor.size(); ++i) {
                Edge edge = edgeCursor.edge();
                EdgeRealizer edgeRealizer = this.graphView.getGraph2D().getRealizer(edge);
                edgeRealizer.clearBends();
                edgeCursor.cyclicNext();
            }
            this.setInteractivity(true);
            this.logger.info("  done");
        }
    }

    protected void hideSelectedNodes() {
        this.graphView.getGraph2D().firePreEvent();
        Graph2D graph2D = this.graphView.getGraph2D();
        NodeCursor nodeCursor = graph2D.selectedNodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            this.graphHider.hide(node);
            nodeCursor.next();
        }
        this.redrawGraph(false, false);
        this.graphView.getGraph2D().firePostEvent();
    }

    protected void hideSelectedEdges() {
        this.graphView.getGraph2D().firePreEvent();
        Graph2D graph2D = this.graphView.getGraph2D();
        EdgeCursor edgeCursor = graph2D.selectedEdges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            this.graphHider.hide(edge);
            edgeCursor.next();
        }
        this.redrawGraph(false, false);
        this.graphView.getGraph2D().firePostEvent();
    }

    public boolean saveVisibleNodeNames() {
        return this.saveVisibleNodeNames("visibleNodes.txt");
    }

    public boolean saveVisibleNodeNames(String string) {
        Graph2D graph2D = this.graphView.getGraph2D();
        Node[] nodeArray = this.graphView.getGraph2D().getNodeArray();
        File file = new File(string);
        try {
            FileWriter fileWriter = new FileWriter(file);
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[i];
                NodeRealizer nodeRealizer = this.graphView.getGraph2D().getRealizer(node);
                String string2 = nodeRealizer.getLabelText();
                String string3 = this.nodeAttributes.getCanonicalName(node);
                fileWriter.write(string3 + "\n");
            }
            fileWriter.close();
            return true;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, iOException.toString(), "Error Writing to \"" + file.getName() + "\"", 0);
            return false;
        }
    }

    public boolean saveSelectedNodeNames(String string) {
        Graph2D graph2D = this.graphView.getGraph2D();
        Node[] nodeArray = this.graphView.getGraph2D().getNodeArray();
        File file = new File(string);
        try {
            FileWriter fileWriter = new FileWriter(file);
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[i];
                NodeRealizer nodeRealizer = this.graphView.getGraph2D().getRealizer(node);
                if (!this.graph.isSelected(node)) continue;
                String string2 = nodeRealizer.getLabelText();
                String string3 = this.nodeAttributes.getCanonicalName(node);
                fileWriter.write(string3 + "\n");
            }
            fileWriter.close();
            return true;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, iOException.toString(), "Error Writing to \"" + file.getName() + "\"", 0);
            return false;
        }
    }

    public void updateUndoRedoMenuItemStatus() {
        if (this.undoMenuItem != null) {
            this.undoMenuItem.setEnabled(this.undoManager.undoLength() > 0);
        }
        if (this.redoMenuItem != null) {
            this.redoMenuItem.setEnabled(this.undoManager.redoLength() > 0);
        }
    }

    public CytoscapeWindow newWindowEmpty() {
        this.saveCalculatorCatalog();
        SelectedSubGraphFactory selectedSubGraphFactory = new SelectedSubGraphFactory(this.graph, this.nodeAttributes, this.edgeAttributes);
        GraphObjAttributes graphObjAttributes = selectedSubGraphFactory.getNodeAttributes();
        GraphObjAttributes graphObjAttributes2 = selectedSubGraphFactory.getEdgeAttributes();
        try {
            boolean bl = false;
            CytoscapeWindow cytoscapeWindow = new CytoscapeWindow(this.parentApp, this.config, this.logger, new Graph2D(), this.expressionData, this.bioDataServer, graphObjAttributes, graphObjAttributes2, "dataSourceName", this.expressionDataFilename, "New Window", bl);
            this.subwindows.add(cytoscapeWindow);
            return cytoscapeWindow;
        }
        catch (Exception exception) {
            System.err.println("exception when creating new window");
            exception.printStackTrace();
            return null;
        }
    }

    public CytoscapeWindow newWindowSelectedNodesOnly() {
        this.saveCalculatorCatalog();
        SelectedSubGraphFactory selectedSubGraphFactory = new SelectedSubGraphFactory(this.graph, this.nodeAttributes, this.edgeAttributes);
        Graph2D graph2D = selectedSubGraphFactory.getSubGraph();
        GraphObjAttributes graphObjAttributes = selectedSubGraphFactory.getNodeAttributes();
        GraphObjAttributes graphObjAttributes2 = selectedSubGraphFactory.getEdgeAttributes();
        String string = "selection";
        if (this.titleForCurrentSelection != null) {
            string = this.titleForCurrentSelection;
        }
        try {
            boolean bl = true;
            CytoscapeWindow cytoscapeWindow = new CytoscapeWindow(this.parentApp, this.config, this.logger, graph2D, this.expressionData, this.bioDataServer, graphObjAttributes, graphObjAttributes2, "dataSourceName", this.expressionDataFilename, string, bl);
            this.subwindows.add(cytoscapeWindow);
            return cytoscapeWindow;
        }
        catch (Exception exception) {
            System.err.println("exception when creating new window");
            exception.printStackTrace();
            return null;
        }
    }

    public CytoscapeWindow newWindowSelectedNodesEdges() {
        this.saveCalculatorCatalog();
        GraphHider graphHider = new GraphHider((Graph)this.graph);
        Object object = this.graph.nodes();
        while (object.ok()) {
            if (!this.graph.isSelected(object.node())) {
                graphHider.hide(object.node());
            }
            object.next();
        }
        object = this.graph.edges();
        while (object.ok()) {
            if (!this.graph.isSelected(object.edge())) {
                graphHider.hide(object.edge());
            }
            object.next();
        }
        object = new SelectedSubGraphFactory(this.graph, this.nodeAttributes, this.edgeAttributes);
        Graph2D graph2D = ((SelectedSubGraphFactory)object).getSubGraph();
        GraphObjAttributes graphObjAttributes = ((SelectedSubGraphFactory)object).getNodeAttributes();
        GraphObjAttributes graphObjAttributes2 = ((SelectedSubGraphFactory)object).getEdgeAttributes();
        graphHider.unhideAll();
        String string = "selection";
        if (this.titleForCurrentSelection != null) {
            string = this.titleForCurrentSelection;
        }
        try {
            boolean bl = true;
            CytoscapeWindow cytoscapeWindow = new CytoscapeWindow(this.parentApp, this.config, this.logger, graph2D, this.expressionData, this.bioDataServer, graphObjAttributes, graphObjAttributes2, "dataSourceName", this.expressionDataFilename, string, bl);
            this.subwindows.add(cytoscapeWindow);
            return cytoscapeWindow;
        }
        catch (Exception exception) {
            System.err.println("exception when creating new window");
            exception.printStackTrace();
            return null;
        }
    }

    public CytoscapeWindow cloneGraphInNewWindow() {
        this.setInteractivity(false);
        CytoscapeWindow cytoscapeWindow = this.cloneWindow();
        this.setInteractivity(true);
        return cytoscapeWindow;
    }

    public CytoscapeWindow cloneWindow() {
        this.saveCalculatorCatalog();
        Node[] nodeArray = this.graph.getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            this.graph.setSelected(nodeArray[i], true);
        }
        SelectedSubGraphFactory selectedSubGraphFactory = new SelectedSubGraphFactory(this.graph, this.nodeAttributes, this.edgeAttributes);
        Graph2D graph2D = selectedSubGraphFactory.getSubGraph();
        GraphObjAttributes graphObjAttributes = selectedSubGraphFactory.getNodeAttributes();
        GraphObjAttributes graphObjAttributes2 = selectedSubGraphFactory.getEdgeAttributes();
        String string = "selection";
        if (this.titleForCurrentSelection != null) {
            string = this.titleForCurrentSelection;
        }
        try {
            boolean bl = true;
            CytoscapeWindow cytoscapeWindow = new CytoscapeWindow(this.parentApp, this.config, this.logger, graph2D, this.expressionData, this.bioDataServer, graphObjAttributes, graphObjAttributes2, "dataSourceName", this.expressionDataFilename, string, bl);
            this.subwindows.add(cytoscapeWindow);
            this.graph.unselectAll();
            return cytoscapeWindow;
        }
        catch (Exception exception) {
            System.err.println("exception when creating new window");
            exception.printStackTrace();
            return null;
        }
    }

    protected boolean loadGML(String string) {
        Graph2D graph2D = FileReadingAbstractions.loadGMLBasic(string, this.edgeAttributes, this.config.getCanonicalize());
        if (graph2D == null) {
            return false;
        }
        this.setGraph(graph2D);
        FileReadingAbstractions.initAttribs(this.bioDataServer, this.getDefaultSpecies(), this.config, this.graph, this.nodeAttributes, this.edgeAttributes);
        this.displayCommonNodeNames();
        this.geometryFilename = string;
        this.setWindowTitle(string);
        this.displayNewGraph(false);
        return true;
    }

    protected void loadInteraction(String string) {
        long l = System.currentTimeMillis();
        System.out.println("Calling FileReadingAbstractions.loadIntrBasic...");
        this.setGraph(FileReadingAbstractions.loadIntrBasic(this.bioDataServer, this.getDefaultSpecies(), string, this.edgeAttributes, this.config.getCanonicalize()));
        System.out.println("done calling FileReadingAbstractions.loadIntrBasic " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        System.out.println("Calling FileReadingAbstractions.initAttribs...");
        FileReadingAbstractions.initAttribs(this.bioDataServer, this.getDefaultSpecies(), this.config, this.graph, this.nodeAttributes, this.edgeAttributes);
        System.out.println("done calling FileReadingAbstractions.initAttribs..." + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        System.out.println("Calling displayCommonNodeNames...");
        this.displayCommonNodeNames();
        System.out.println("done calling displayCommonNames" + (System.currentTimeMillis() - l));
        this.geometryFilename = null;
        this.setWindowTitle(string);
        this.displayNewGraph(true);
    }

    public AbstractAction getZoomSelectedAction() {
        return new ZoomSelectedAction();
    }

    public AbstractAction getDeleteSelectedAction() {
        return new DeleteSelectedAction();
    }

    public boolean loadExpressionData(String string) {
        ExpressionData expressionData = new ExpressionData();
        boolean bl = expressionData.loadData(string);
        if (bl) {
            this.expressionData = expressionData;
        }
        return bl;
    }

    public void close() {
        this.saveCalculatorCatalog();
        this.mainFrame.dispose();
    }

    protected HashMap configureNewNode(Node node) {
        Object object;
        OptionHandler optionHandler = new OptionHandler("New Node");
        String[] stringArray = this.nodeAttributes.getAttributeNames();
        if (stringArray.length == 0) {
            optionHandler.addComment("commonName is required; canonicalName is optional and defaults to commonName");
            optionHandler.addString("commonName", "");
            optionHandler.addString("canonicalName", "");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                object = this.nodeAttributes.getClass(string);
                if (object.equals("string".getClass())) {
                    optionHandler.addString(string, "");
                    continue;
                }
                if (object.equals(new Double(0.0).getClass())) {
                    optionHandler.addDouble(string, 0.0);
                    continue;
                }
                if (!object.equals(new Integer(0).getClass())) continue;
                optionHandler.addInt(string, 0);
            }
        }
        optionHandler.showEditor();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (stringArray.length == 0) {
            hashMap.put("commonName", (String)optionHandler.get("commonName"));
            hashMap.put("canonicalName", (String)optionHandler.get("canonicalName"));
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i];
                Class clazz = this.nodeAttributes.getClass((String)object);
                if (clazz.equals("string".getClass())) {
                    hashMap.put(object, (String)optionHandler.get((String)object));
                    continue;
                }
                if (clazz.equals(new Double(0.0).getClass())) {
                    hashMap.put(object, (Double)optionHandler.get((String)object));
                    continue;
                }
                if (!clazz.equals(new Integer(0).getClass())) continue;
                hashMap.put(object, (Integer)optionHandler.get((String)object));
            }
        }
        return hashMap;
    }

    protected String[] getInteractionTypes() {
        if (this.edgeAttributes == null) {
            return new String[0];
        }
        String[] stringArray = this.edgeAttributes.getUniqueStringValues("interaction");
        return stringArray;
    }

    static {
        debugLog = new StringBuffer();
    }

    protected class EdgeTypeDialogAction
    extends AbstractAction {
        EdgeTypeDialogAction() {
            super("Edges by Interaction Type");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = CytoscapeWindow.this.getInteractionTypes();
            new EdgeTypeDialogIndep(CytoscapeWindow.this, CytoscapeWindow.this.mainFrame, CytoscapeWindow.this.graph, CytoscapeWindow.this.edgeAttributes, CytoscapeWindow.this.graphHider, CytoscapeWindow.this.getInteractionTypes());
        }
    }

    protected class DisplayDebugLog
    extends AbstractAction {
        DisplayDebugLog() {
            super("DisplayDebugLog");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFrame jFrame = CytoscapeWindow.this.getMainFrame();
            PopupTextArea popupTextArea = new PopupTextArea((Frame)jFrame, "debug", debugLog.toString());
            popupTextArea.pack();
            popupTextArea.setLocationRelativeTo(jFrame);
            popupTextArea.setVisible(true);
        }
    }

    protected class EdgeManipulationAction
    extends AbstractAction {
        EdgeManipulationAction() {
            super("Select or hide by attributes...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = CytoscapeWindow.this.edgeAttributes.getAttributeNames();
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (CytoscapeWindow.this.edgeAttributes.getClass(string) != "string".getClass()) continue;
                String[] stringArray2 = CytoscapeWindow.this.edgeAttributes.getUniqueStringValues(string);
                hashMap.put(string, stringArray2);
            }
            if (hashMap.size() > 0) {
                EdgeControlDialog edgeControlDialog = new EdgeControlDialog(CytoscapeWindow.this, hashMap, "Control Edges");
                edgeControlDialog.pack();
                edgeControlDialog.setLocationRelativeTo(CytoscapeWindow.this.getMainFrame());
                edgeControlDialog.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(null, "There are no String edge attributes suitable for controlling edge display");
            }
        }
    }

    protected class MenuFilterAction
    extends MainFilterDialogAction {
        MenuFilterAction() {
            super("Using filters...");
        }
    }

    protected class MainFilterDialogAction
    extends AbstractAction {
        MainFilterDialogAction() {
        }

        MainFilterDialogAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = CytoscapeWindow.this.getInteractionTypes();
            new MainFilterDialog(CytoscapeWindow.this, CytoscapeWindow.this.mainFrame, CytoscapeWindow.this.graph, CytoscapeWindow.this.nodeAttributes, CytoscapeWindow.this.edgeAttributes, CytoscapeWindow.this.expressionData, CytoscapeWindow.this.graphHider, stringArray);
        }
    }

    class ReadOnlyGraphMode
    extends EditMode {
        ReadOnlyGraphMode() {
            this.allowNodeCreation(false);
            this.allowEdgeCreation(false);
            this.allowBendCreation(false);
            this.showNodeTips(true);
            this.showEdgeTips(true);
            this.setMoveSelectionMode((ViewMode)new StraightLineMoveMode());
        }

        protected String getNodeTip(Node node) {
            String string = CytoscapeWindow.this.graphView.getGraph2D().getRealizer(node).getLabelText();
            String string2 = CytoscapeWindow.this.getCanonicalNodeName(node);
            if (string2 != null && string2.length() > 0 && !string2.equals(string)) {
                return string + " " + string2;
            }
            return string;
        }

        protected String getEdgeTip(Edge edge) {
            String string = CytoscapeWindow.this.edgeAttributes.getCanonicalName(edge);
            String string2 = CytoscapeWindow.this.edgeAttributes.getStringValue("commonName", string);
            if (string2 != null && string2.length() > 0) {
                return string2;
            }
            return string;
        }
    }

    class CreateEdgeMode
    extends ViewMode {
        CreateEdgeMode() {
        }

        protected void edgeCreated(Edge edge) {
            CytoscapeWindow.this.logger.info("edge created: " + edge);
        }
    }

    class EditGraphMode
    extends EditMode {
        EditGraphMode() {
            this.allowNodeCreation(true);
            this.allowEdgeCreation(true);
            this.allowBendCreation(true);
            this.showNodeTips(true);
            this.showEdgeTips(true);
            this.setMoveSelectionMode((ViewMode)new StraightLineMoveMode());
        }

        protected String getNodeTip(Node node) {
            String string = CytoscapeWindow.this.graphView.getGraph2D().getRealizer(node).getLabelText();
            String string2 = CytoscapeWindow.this.getCanonicalNodeName(node);
            if (string2 != null && string2.length() > 0 && !string2.equals(string)) {
                return string + " " + string2;
            }
            return string;
        }

        protected void nodeCreated(Node node) {
            String string;
            String string2 = CytoscapeWindow.this.graphView.getGraph2D().getLabelText(node);
            HashMap hashMap = CytoscapeWindow.this.configureNewNode(node);
            String string3 = "commonName";
            String string4 = string2;
            if (hashMap.containsKey(string3)) {
                string4 = (String)hashMap.get(string3);
                string = CytoscapeWindow.this.graphView.getGraph2D().getRealizer(node);
                string.setLabelText(string4);
            }
            if ((string = (String)hashMap.get("canonicalName")) == null || string.length() < 1) {
                string = string4;
            }
            if (string == null || string.length() < 1) {
                string = string2;
            }
            CytoscapeWindow.this.nodeAttributes.set(string, hashMap);
            CytoscapeWindow.this.nodeAttributes.addNameMapping(string, node);
        }

        protected void edgeCreated(Edge edge) {
            CytoscapeWindow.this.logger.info("edge created: " + edge);
        }

        protected String getEdgeTip(Edge edge) {
            String string = CytoscapeWindow.this.edgeAttributes.getCanonicalName(edge);
            String string2 = CytoscapeWindow.this.edgeAttributes.getStringValue("commonName", string);
            if (string2 != null && string2.length() > 0) {
                return string2;
            }
            return string;
        }
    }

    protected class CursorTesterAction
    extends AbstractAction {
        boolean busy;

        CursorTesterAction() {
            super("Cursor test");
            this.busy = false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.busy) {
                CytoscapeWindow.this.setInteractivity(true);
            } else {
                CytoscapeWindow.this.setInteractivity(false);
            }
            this.busy = !this.busy;
        }
    }

    protected class ZoomSelectedAction
    extends AbstractAction {
        ZoomSelectedAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Graph2D graph2D = CytoscapeWindow.this.graphView.getGraph2D();
            NodeCursor nodeCursor = graph2D.selectedNodes();
            if (nodeCursor.ok()) {
                Rectangle2D.Double double_ = graph2D.getRealizer(nodeCursor.node()).getBoundingBox();
                nodeCursor.next();
                while (nodeCursor.ok()) {
                    graph2D.getRealizer(nodeCursor.node()).calcUnionRect((Rectangle2D)double_);
                    nodeCursor.next();
                }
                CytoscapeWindow.this.graphView.zoomToArea(((RectangularShape)double_).getX(), ((RectangularShape)double_).getY(), ((RectangularShape)double_).getWidth(), ((RectangularShape)double_).getHeight());
                if (CytoscapeWindow.this.graphView.getZoom() > 2.0) {
                    CytoscapeWindow.this.graphView.setZoom(2.0);
                }
                CytoscapeWindow.this.redrawGraph(false, false);
            }
        }
    }

    protected class HideSelectedAction
    extends AbstractAction {
        HideSelectedAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.graph.firePreEvent();
            CytoscapeWindow.this.hideSelectedNodes();
            CytoscapeWindow.this.hideSelectedEdges();
            CytoscapeWindow.this.graph.firePostEvent();
        }
    }

    protected class ShowAllAction
    extends AbstractAction {
        ShowAllAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.graph.firePreEvent();
            CytoscapeWindow.this.graphHider.unhideAll();
            CytoscapeWindow.this.graph.firePostEvent();
            CytoscapeWindow.this.graphView.fitContent();
            CytoscapeWindow.this.graphView.setZoom(CytoscapeWindow.this.graphView.getZoom() * 0.9);
            CytoscapeWindow.this.redrawGraph(false, true);
        }
    }

    protected class FitContentAction
    extends AbstractAction {
        FitContentAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.graphView.fitContent();
            CytoscapeWindow.this.redrawGraph(false, false);
        }
    }

    protected class ZoomAction
    extends AbstractAction {
        double factor;

        ZoomAction(double d) {
            this.factor = d;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.graphView.setZoom(CytoscapeWindow.this.graphView.getZoom() * this.factor);
            CytoscapeWindow.this.redrawGraph(false, false);
        }
    }

    protected class DeleteSelectionAction
    extends AbstractAction {
        DeleteSelectionAction() {
            super("Delete Selection");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.graphView.getGraph2D().removeSelection();
            CytoscapeWindow.this.redrawGraph(false, false);
        }
    }

    protected class LoadBioDataServerAction
    extends AbstractAction {
        LoadBioDataServerAction() {
            super("Bio Data Server...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(CytoscapeWindow.this.currentDirectory);
            jFileChooser.setFileSelectionMode(1);
            if (jFileChooser.showOpenDialog(CytoscapeWindow.this) == 0) {
                CytoscapeWindow.this.currentDirectory = jFileChooser.getCurrentDirectory();
                String string = jFileChooser.getSelectedFile().toString();
                try {
                    CytoscapeWindow.this.bioDataServer = new BioDataServer(string);
                }
                catch (Exception exception) {
                    CytoscapeWindow.this.logger.warning("cannot create new biodata server at " + string);
                }
                CytoscapeWindow.this.displayCommonNodeNames();
                CytoscapeWindow.this.redrawGraph(false, true);
            }
        }
    }

    protected class ExpFileChooser
    extends JFileChooser {
        JCheckBox jcb;
        boolean copyToAttribs;

        public ExpFileChooser(File file) {
            super(file, (FileSystemView)null);
            this.copyToAttribs = true;
        }

        protected JDialog createDialog(Component component) throws HeadlessException {
            JDialog jDialog = super.createDialog(component);
            this.jcb = new JCheckBox("Copy Expression Data to Graph Attributes?");
            this.jcb.setSelected(this.copyToAttribs);
            this.jcb.addItemListener(new CopyExpListener());
            Container container = jDialog.getContentPane();
            container.add((Component)this.jcb, "South");
            jDialog.pack();
            return jDialog;
        }

        public boolean getWhetherToCopyExpToAttribs() {
            return this.copyToAttribs;
        }

        private class CopyExpListener
        implements ItemListener {
            private CopyExpListener() {
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ExpFileChooser.this.copyToAttribs = true;
                } else if (itemEvent.getStateChange() == 2) {
                    ExpFileChooser.this.copyToAttribs = false;
                }
            }
        }
    }

    protected class LoadExpressionMatrixAction
    extends AbstractAction {
        LoadExpressionMatrixAction() {
            super("Expression Matrix File...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExpFileChooser expFileChooser = new ExpFileChooser(CytoscapeWindow.this.currentDirectory);
            CyFileFilter cyFileFilter = new CyFileFilter();
            cyFileFilter.addExtension("mrna");
            cyFileFilter.addExtension("mRNA");
            cyFileFilter.addExtension("pvals");
            cyFileFilter.setDescription("Expression Matrix files");
            expFileChooser.setFileFilter(cyFileFilter);
            expFileChooser.addChoosableFileFilter(cyFileFilter);
            if (expFileChooser.showOpenDialog(CytoscapeWindow.this) == 0) {
                CytoscapeWindow.this.currentDirectory = expFileChooser.getCurrentDirectory();
                CytoscapeWindow.this.expressionDataFilename = expFileChooser.getSelectedFile().toString();
                boolean bl = CytoscapeWindow.this.loadExpressionData(CytoscapeWindow.this.expressionDataFilename);
                if (bl) {
                    if (expFileChooser.getWhetherToCopyExpToAttribs()) {
                        CytoscapeWindow.this.expressionData.copyToAttribs(CytoscapeWindow.this.nodeAttributes);
                    }
                    String string = CytoscapeWindow.this.expressionData.getDescription();
                    String string2 = "Load Expression Data";
                    JOptionPane.showMessageDialog(CytoscapeWindow.this.mainFrame, string, string2, -1);
                } else {
                    String string = "Unable to load expression data from " + CytoscapeWindow.this.expressionDataFilename;
                    String string3 = "Load Expression Data";
                    JOptionPane.showMessageDialog(CytoscapeWindow.this.mainFrame, string, string3, 0);
                }
            }
        }
    }

    protected class LoadEdgeAttributesAction
    extends AbstractAction {
        LoadEdgeAttributesAction() {
            super("Edge Attributes...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(CytoscapeWindow.this.currentDirectory);
            jFileChooser.setDialogTitle("Load Edge Attributes");
            if (jFileChooser.showOpenDialog(CytoscapeWindow.this) == 0) {
                CytoscapeWindow.this.currentDirectory = jFileChooser.getCurrentDirectory();
                String[] stringArray = new String[]{jFileChooser.getSelectedFile().toString()};
                FileReadingAbstractions.readAttribs(CytoscapeWindow.this.bioDataServer, CytoscapeWindow.this.defaultSpecies, CytoscapeWindow.this.graph, null, CytoscapeWindow.this.edgeAttributes, null, stringArray, CytoscapeWindow.this.config.getCanonicalize());
                CytoscapeWindow.this.redrawGraph(false, true);
            }
        }
    }

    protected class LoadNodeAttributesAction
    extends AbstractAction {
        LoadNodeAttributesAction() {
            super("Node Attributes...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(CytoscapeWindow.this.currentDirectory);
            jFileChooser.setDialogTitle("Load Node Attributes");
            if (jFileChooser.showOpenDialog(CytoscapeWindow.this) == 0) {
                CytoscapeWindow.this.currentDirectory = jFileChooser.getCurrentDirectory();
                String[] stringArray = new String[]{jFileChooser.getSelectedFile().toString()};
                FileReadingAbstractions.readAttribs(CytoscapeWindow.this.bioDataServer, CytoscapeWindow.this.defaultSpecies, CytoscapeWindow.this.graph, CytoscapeWindow.this.nodeAttributes, null, stringArray, null, CytoscapeWindow.this.config.getCanonicalize());
                CytoscapeWindow.this.redrawGraph(false, true);
            }
        }
    }

    protected class LoadInteractionFileAction
    extends AbstractAction {
        LoadInteractionFileAction() {
            super("Interaction...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(CytoscapeWindow.this.currentDirectory);
            CyFileFilter cyFileFilter = new CyFileFilter();
            cyFileFilter.addExtension("sif");
            cyFileFilter.setDescription("Interaction files");
            jFileChooser.setFileFilter(cyFileFilter);
            jFileChooser.addChoosableFileFilter(cyFileFilter);
            if (jFileChooser.showOpenDialog(CytoscapeWindow.this) == 0) {
                CytoscapeWindow.this.currentDirectory = jFileChooser.getCurrentDirectory();
                String string = jFileChooser.getSelectedFile().toString();
                CytoscapeWindow.this.loadInteraction(string);
            }
        }
    }

    protected class LoadGMLFileAction
    extends AbstractAction {
        LoadGMLFileAction() {
            super("GML...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(CytoscapeWindow.this.currentDirectory);
            CyFileFilter cyFileFilter = new CyFileFilter();
            cyFileFilter.addExtension("gml");
            cyFileFilter.setDescription("GML files");
            jFileChooser.setFileFilter(cyFileFilter);
            jFileChooser.addChoosableFileFilter(cyFileFilter);
            if (jFileChooser.showOpenDialog(CytoscapeWindow.this) == 0) {
                String string;
                CytoscapeWindow.this.currentDirectory = jFileChooser.getCurrentDirectory();
                CytoscapeWindow.this.geometryFilename = string = jFileChooser.getSelectedFile().toString();
                boolean bl = CytoscapeWindow.this.loadGML(string);
                if (!bl) {
                    String string2 = System.getProperty("line.separator");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Could not read graph from file " + string + string2);
                    stringBuffer.append("This file may not be a valid GML file." + string2);
                    JOptionPane.showMessageDialog(CytoscapeWindow.this.mainFrame, stringBuffer.toString(), "Error loading graph", 0);
                }
            }
        }
    }

    protected class SaveAsGMLAction
    extends AbstractAction {
        SaveAsGMLAction() {
            super("As GML...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(CytoscapeWindow.this.currentDirectory);
            if (jFileChooser.showSaveDialog(CytoscapeWindow.this) == 0) {
                CytoscapeWindow.this.currentDirectory = jFileChooser.getCurrentDirectory();
                String string = jFileChooser.getSelectedFile().toString();
                if (!string.endsWith(".gml")) {
                    string = string + ".gml";
                }
                GraphProps graphProps = CytoscapeWindow.this.getProps();
                GMLWriter gMLWriter = new GMLWriter(graphProps);
                gMLWriter.write(string);
            }
        }
    }

    protected class SaveAsInteractionsAction
    extends AbstractAction {
        SaveAsInteractionsAction() {
            super("As Interactions...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(CytoscapeWindow.this.currentDirectory);
            if (jFileChooser.showSaveDialog(CytoscapeWindow.this) == 0) {
                String string = jFileChooser.getSelectedFile().toString();
                CytoscapeWindow.this.currentDirectory = jFileChooser.getCurrentDirectory();
                if (!string.endsWith(".sif")) {
                    string = string + ".sif";
                }
                SIFWriter sIFWriter = new SIFWriter(CytoscapeWindow.this.getProps());
                sIFWriter.write(string);
            }
        }
    }

    protected class CloseWindowAction
    extends AbstractAction {
        CloseWindowAction() {
            super("Close");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.close();
        }
    }

    protected class ExitAction
    extends AbstractAction {
        ExitAction() {
            super("Exit");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.saveCalculatorCatalog();
            CytoscapeWindow.this.parentApp.exit(0);
        }
    }

    protected class ShowConditionAction
    extends AbstractAction {
        String conditionName;

        ShowConditionAction(String string) {
            super(string);
            this.conditionName = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class SelectedSubGraphMaker {
        Graph2D parentGraph;
        Graph2D subGraph;
        GraphObjAttributes parentNodeAttributes;
        GraphObjAttributes parentEdgeAttributes;
        GraphObjAttributes newNodeAttributes;
        GraphObjAttributes newEdgeAttributes;
        HashMap parentNameMap = new HashMap();

        SelectedSubGraphMaker(Graph2D graph2D, GraphObjAttributes graphObjAttributes, GraphObjAttributes graphObjAttributes2) {
            Node[] nodeArray;
            Object object;
            this.parentGraph = graph2D;
            this.parentNodeAttributes = graphObjAttributes;
            this.parentEdgeAttributes = graphObjAttributes2;
            NodeCursor nodeCursor = graph2D.selectedNodes();
            nodeCursor.toFirst();
            while (nodeCursor.ok()) {
                object = this.parentNodeAttributes.getCanonicalName(nodeCursor.node());
                if (object != null && (nodeArray = (Node[])this.parentNodeAttributes.getValue("commonName", (String)object)) != null) {
                    this.parentNameMap.put(nodeArray, object);
                }
                nodeCursor.next();
            }
            object = graph2D.selectedEdges();
            nodeCursor.toFirst();
            this.subGraph = new Graph2D(graph2D, (YCursor)nodeCursor);
            nodeArray = this.subGraph.getNodeArray();
            CytoscapeWindow.this.logger.warning("nodes in new subgraph: " + nodeArray.length);
            this.newNodeAttributes = (GraphObjAttributes)this.parentNodeAttributes.clone();
            this.newNodeAttributes.clearNameMap();
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[i];
                String string = this.subGraph.getLabelText(node);
                String string2 = (String)this.parentNameMap.get(string);
                NodeRealizer nodeRealizer = this.subGraph.getRealizer(node);
                nodeRealizer.setLabelText(string2);
                this.newNodeAttributes.addNameMapping(string2, node);
            }
            this.newEdgeAttributes = (GraphObjAttributes)this.parentEdgeAttributes.clone();
        }

        Graph2D getSubGraph() {
            return this.subGraph;
        }

        GraphObjAttributes getNodeAttributes() {
            return this.newNodeAttributes;
        }

        GraphObjAttributes getEdgeAttributes() {
            return this.newEdgeAttributes;
        }
    }

    protected class CloneGraphInNewWindowAction
    extends AbstractAction {
        CloneGraphInNewWindowAction() {
            super("Whole graph");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.cloneGraphInNewWindow();
        }
    }

    protected class NewWindowSelectedNodesEdgesAction
    extends AbstractAction {
        NewWindowSelectedNodesEdgesAction() {
            super("Selected nodes, Selected edges");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.newWindowSelectedNodesEdges();
        }
    }

    protected class NewWindowSelectedNodesOnlyAction
    extends AbstractAction {
        NewWindowSelectedNodesOnlyAction() {
            super("Selected nodes, All edges");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.newWindowSelectedNodesOnly();
        }
    }

    protected class DisplayAttributesOfSelectedNodesAction
    extends AbstractAction {
        DisplayAttributesOfSelectedNodesAction() {
            super("Display attributes of selected nodes");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Graph2D graph2D = CytoscapeWindow.this.graphView.getGraph2D();
            NodeCursor nodeCursor = graph2D.selectedNodes();
            CytoscapeWindow.this.logger.info("debug, selected node count: " + nodeCursor.size());
            nodeCursor.toFirst();
            while (nodeCursor.ok()) {
                object = CytoscapeWindow.this.nodeAttributes.getCanonicalName(nodeCursor.node());
                CytoscapeWindow.this.logger.info((String)object + ": " + CytoscapeWindow.this.nodeAttributes.getAttributes((String)object));
                nodeCursor.next();
            }
            object = graph2D.selectedEdges();
            CytoscapeWindow.this.logger.info("debug, selected edge count: " + object.size());
            object.toFirst();
            while (object.ok()) {
                String string = CytoscapeWindow.this.edgeAttributes.getCanonicalName(object.edge());
                CytoscapeWindow.this.logger.info(string + ": " + CytoscapeWindow.this.edgeAttributes.getAttributes(string));
                object.next();
            }
        }
    }

    protected class SelectFirstNeighborsAction
    extends AbstractAction {
        SelectFirstNeighborsAction() {
            super("First neighbors of selected nodes");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Edge edge;
            EdgeCursor edgeCursor;
            Graph2D graph2D = CytoscapeWindow.this.graphView.getGraph2D();
            NodeCursor nodeCursor = graph2D.selectedNodes();
            Vector<Node> vector = new Vector<Node>();
            nodeCursor.toFirst();
            while (nodeCursor.ok()) {
                Node node = nodeCursor.node();
                edgeCursor = node.edges();
                edgeCursor.toFirst();
                while (edgeCursor.ok()) {
                    Node node2;
                    edge = edgeCursor.edge();
                    Node node3 = edge.source();
                    if (!vector.contains(node3)) {
                        vector.add(node3);
                    }
                    if (!vector.contains(node2 = edge.target())) {
                        vector.add(node2);
                    }
                    edgeCursor.next();
                }
                nodeCursor.next();
            }
            for (int i = 0; i < vector.size(); ++i) {
                edgeCursor = (Node)vector.elementAt(i);
                edge = CytoscapeWindow.this.graphView.getGraph2D().getRealizer((Node)edgeCursor);
                edge.setSelected(true);
            }
            CytoscapeWindow.this.redrawGraph(false, false);
        }
    }

    protected class EditModeAction
    extends AbstractAction {
        EditModeAction() {
            super("Edit Mode for Nodes and Edges");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.graphView.removeViewMode(CytoscapeWindow.this.currentGraphMode);
            CytoscapeWindow.this.currentGraphMode = CytoscapeWindow.this.editGraphMode;
            CytoscapeWindow.this.graphView.addViewMode(CytoscapeWindow.this.currentGraphMode);
            CytoscapeWindow.this.deleteSelectionMenuItem.setEnabled(true);
        }
    }

    protected class ReadOnlyModeAction
    extends AbstractAction {
        ReadOnlyModeAction() {
            super("Read only Mode");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.graphView.removeViewMode(CytoscapeWindow.this.currentGraphMode);
            CytoscapeWindow.this.currentGraphMode = CytoscapeWindow.this.readOnlyGraphMode;
            CytoscapeWindow.this.graphView.addViewMode(CytoscapeWindow.this.currentGraphMode);
            CytoscapeWindow.this.deleteSelectionMenuItem.setEnabled(false);
        }
    }

    protected class RedoAction
    extends AbstractAction {
        RedoAction() {
            super("Redo");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.undoManager.redo();
            CytoscapeWindow.this.updateUndoRedoMenuItemStatus();
            CytoscapeWindow.this.redrawGraph();
        }
    }

    protected class UndoAction
    extends AbstractAction {
        UndoAction() {
            super("Undo");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.undoManager.undo();
            CytoscapeWindow.this.updateUndoRedoMenuItemStatus();
            CytoscapeWindow.this.redrawGraph(false, true);
        }
    }

    protected class DeselectAllAction
    extends AbstractAction {
        DeselectAllAction() {
            super("Deselect All");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.deselectAllNodes();
        }
    }

    protected class SaveSelectedNodesAction
    extends AbstractAction {
        SaveSelectedNodesAction() {
            super("Selected Nodes");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(CytoscapeWindow.this.currentDirectory);
            if (jFileChooser.showSaveDialog(CytoscapeWindow.this) == 0) {
                String string = jFileChooser.getSelectedFile().toString();
                CytoscapeWindow.this.currentDirectory = jFileChooser.getCurrentDirectory();
                boolean bl = CytoscapeWindow.this.saveSelectedNodeNames(string);
                Object[] objectArray = new Object[]{"OK"};
                if (bl) {
                    JOptionPane.showOptionDialog(null, "Selected Nodes Saved.", "Selected Nodes Saved.", -1, -1, null, objectArray, objectArray[0]);
                }
            }
        }
    }

    protected class SaveVisibleNodesAction
    extends AbstractAction {
        SaveVisibleNodesAction() {
            super("Visible Nodes");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(CytoscapeWindow.this.currentDirectory);
            if (jFileChooser.showSaveDialog(CytoscapeWindow.this) == 0) {
                String string = jFileChooser.getSelectedFile().toString();
                CytoscapeWindow.this.currentDirectory = jFileChooser.getCurrentDirectory();
                boolean bl = CytoscapeWindow.this.saveVisibleNodeNames(string);
                Object[] objectArray = new Object[]{"OK"};
                if (bl) {
                    JOptionPane.showOptionDialog(null, "Visible Nodes Saved.", "Visible Nodes Saved.", -1, -1, null, objectArray, objectArray[0]);
                }
            }
        }
    }

    protected class ListFromFileSelectionAction
    extends AbstractAction {
        ListFromFileSelectionAction() {
            super("From File...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = !this.useSelectionFile();
        }

        private boolean useSelectionFile() {
            JFileChooser jFileChooser = new JFileChooser(CytoscapeWindow.this.currentDirectory);
            jFileChooser.setDialogTitle("Load Gene Selection File");
            switch (jFileChooser.showOpenDialog(null)) {
                case 0: {
                    File file = jFileChooser.getSelectedFile();
                    CytoscapeWindow.this.currentDirectory = jFileChooser.getCurrentDirectory();
                    try {
                        String string;
                        Node[] nodeArray;
                        StringTokenizer stringTokenizer;
                        String string2;
                        FileReader fileReader = new FileReader(file);
                        BufferedReader bufferedReader = new BufferedReader(fileReader);
                        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
                        while ((string2 = bufferedReader.readLine()) != null) {
                            stringTokenizer = new StringTokenizer(string2);
                            nodeArray = stringTokenizer.nextToken();
                            String string3 = nodeArray.trim();
                            if (string3.length() <= 0) continue;
                            string = CytoscapeWindow.this.findCanonicalName(string3);
                            hashtable.put(string, Boolean.TRUE);
                        }
                        fileReader.close();
                        stringTokenizer = CytoscapeWindow.this.graphView.getGraph2D();
                        nodeArray = CytoscapeWindow.this.graphView.getGraph2D().getNodeArray();
                        for (int i = 0; i < nodeArray.length; ++i) {
                            Boolean bl;
                            string = nodeArray[i];
                            String string4 = CytoscapeWindow.this.nodeAttributes.getCanonicalName(string);
                            if (string4 == null) {
                                string4 = CytoscapeWindow.this.graph.getLabelText((Node)string);
                            }
                            if ((bl = (Boolean)hashtable.get(string4)) == null) continue;
                            CytoscapeWindow.this.graphView.getGraph2D().getRealizer((Node)string).setSelected(true);
                        }
                        CytoscapeWindow.this.redrawGraph(false, false);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, exception.toString(), "Error Reading \"" + file.getName() + "\"", 0);
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
    }

    public class AlphabeticalSelectionAction
    extends AbstractAction {
        AlphabeticalSelectionAction() {
            super("By Name...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(CytoscapeWindow.this.mainFrame, (Object)"Select nodes whose name (or synonym) starts with");
            if (string != null && string.length() > 0) {
                CytoscapeWindow.this.selectNodesStartingWith(string.trim());
            }
        }
    }

    protected class ReduceEquivalentNodesAction
    extends AbstractAction {
        ReduceEquivalentNodesAction() {
            super("Reduce Equivalent Nodes");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new ReduceEquivalentNodes(CytoscapeWindow.this.nodeAttributes, CytoscapeWindow.this.edgeAttributes, CytoscapeWindow.this.graph);
            CytoscapeWindow.this.redrawGraph(false, true);
        }
    }

    protected class RotateSelectedNodesAction
    extends AbstractAction {
        RotateSelectedNodesAction() {
            super("Rotate Selected Nodes");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.undoManager.saveRealizerState();
            CytoscapeWindow.this.undoManager.pause();
            RotateSelectionDialog rotateSelectionDialog = new RotateSelectionDialog(CytoscapeWindow.this.mainFrame, CytoscapeWindow.this, CytoscapeWindow.this.graph);
            CytoscapeWindow.this.undoManager.resume();
        }
    }

    protected class AlignVerticalAction
    extends AbstractAction {
        AlignVerticalAction() {
            super("Vertical");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Node node;
            CytoscapeWindow.this.undoManager.saveRealizerState();
            CytoscapeWindow.this.undoManager.pause();
            double d = 0.0;
            int n = 0;
            NodeCursor nodeCursor = CytoscapeWindow.this.graph.nodes();
            while (nodeCursor.ok()) {
                node = nodeCursor.node();
                if (CytoscapeWindow.this.graph.isSelected(node)) {
                    d += CytoscapeWindow.this.graph.getX(node);
                    ++n;
                }
                nodeCursor.next();
            }
            d /= (double)n;
            nodeCursor = CytoscapeWindow.this.graph.nodes();
            while (nodeCursor.ok()) {
                node = nodeCursor.node();
                if (CytoscapeWindow.this.graph.isSelected(node)) {
                    CytoscapeWindow.this.graph.setLocation(node, d, CytoscapeWindow.this.graph.getY(node));
                }
                nodeCursor.next();
            }
            CytoscapeWindow.this.undoManager.resume();
            CytoscapeWindow.this.redrawGraph(false, false);
        }
    }

    protected class AlignHorizontalAction
    extends AbstractAction {
        AlignHorizontalAction() {
            super("Horizontal");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Node node;
            CytoscapeWindow.this.undoManager.saveRealizerState();
            CytoscapeWindow.this.undoManager.pause();
            double d = 0.0;
            int n = 0;
            NodeCursor nodeCursor = CytoscapeWindow.this.graph.nodes();
            while (nodeCursor.ok()) {
                node = nodeCursor.node();
                if (CytoscapeWindow.this.graph.isSelected(node)) {
                    d += CytoscapeWindow.this.graph.getY(node);
                    ++n;
                }
                nodeCursor.next();
            }
            d /= (double)n;
            nodeCursor = CytoscapeWindow.this.graph.nodes();
            while (nodeCursor.ok()) {
                node = nodeCursor.node();
                if (CytoscapeWindow.this.graph.isSelected(node)) {
                    CytoscapeWindow.this.graph.setLocation(node, CytoscapeWindow.this.graph.getX(node), d);
                }
                nodeCursor.next();
            }
            CytoscapeWindow.this.undoManager.resume();
            CytoscapeWindow.this.redrawGraph(false, false);
        }
    }

    protected class EmbeddedLayoutAction
    extends AbstractAction {
        EmbeddedLayoutAction() {
            super("Embedded");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.layouter = new EmbeddedLayouter();
        }
    }

    protected class RandomLayoutAction
    extends AbstractAction {
        RandomLayoutAction() {
            super("Random");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.layouter = new RandomLayouter();
        }
    }

    protected class OrganicLayoutAction
    extends AbstractAction {
        OrganicLayoutAction() {
            super("Organic");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OrganicLayouter organicLayouter = new OrganicLayouter();
            organicLayouter.setActivateDeterministicMode(true);
            organicLayouter.setPreferredEdgeLength(80);
            CytoscapeWindow.this.layouter = organicLayouter;
        }
    }

    protected class HierarchicalLayoutAction
    extends AbstractAction {
        HierarchicalLayoutDialog hDialog;

        HierarchicalLayoutAction() {
            super("Hierarchical");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.hDialog == null) {
                this.hDialog = new HierarchicalLayoutDialog(CytoscapeWindow.this.mainFrame);
            }
            this.hDialog.pack();
            this.hDialog.setLocationRelativeTo(CytoscapeWindow.this.mainFrame);
            this.hDialog.setVisible(true);
            CytoscapeWindow.this.layouter = this.hDialog.getLayouter();
            CytoscapeWindow.this.layouter = new HierarchicLayouter();
        }
    }

    protected class CircularLayoutAction
    extends AbstractAction {
        CircularLayoutAction() {
            super("Circular");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.layouter = new CircularLayouter();
        }
    }

    protected class LayoutSelectionAction
    extends AbstractAction {
        LayoutSelectionAction() {
            super("Layout current selection");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.undoManager.saveRealizerState();
            CytoscapeWindow.this.undoManager.pause();
            CytoscapeWindow.this.applyLayoutSelection();
            CytoscapeWindow.this.undoManager.resume();
            CytoscapeWindow.this.redrawGraph(false, false);
        }
    }

    protected class LayoutAction
    extends AbstractAction {
        LayoutAction() {
            super("Layout whole graph");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.undoManager.saveRealizerState();
            CytoscapeWindow.this.undoManager.pause();
            CytoscapeWindow.this.applyLayout(false);
            CytoscapeWindow.this.undoManager.resume();
            CytoscapeWindow.this.redrawGraph(false, false);
        }
    }

    protected class DeleteSelectedAction
    extends AbstractAction {
        DeleteSelectedAction() {
            super("Delete Selected Nodes and Edges");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Graph2D graph2D = CytoscapeWindow.this.graphView.getGraph2D();
            graph2D.firePreEvent();
            int n = 0;
            NodeCursor nodeCursor = graph2D.selectedNodes();
            while (nodeCursor.ok()) {
                Node node = nodeCursor.node();
                graph2D.removeNode(node);
                ++n;
                CytoscapeWindow.this.nodeAttributes.removeObjectMapping(node);
                nodeCursor.next();
            }
            EdgeCursor edgeCursor = graph2D.selectedEdges();
            while (edgeCursor.ok()) {
                Edge edge = edgeCursor.edge();
                graph2D.removeEdge(edge);
                edgeCursor.next();
                CytoscapeWindow.this.edgeAttributes.removeObjectMapping(edge);
            }
            graph2D.firePostEvent();
            CytoscapeWindow.this.redrawGraph(false, false);
        }
    }

    protected class InvertSelectedEdgesAction
    extends AbstractAction {
        InvertSelectedEdgesAction() {
            super("Invert selection");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Graph2D graph2D = CytoscapeWindow.this.graphView.getGraph2D();
            Edge[] edgeArray = CytoscapeWindow.this.graphView.getGraph2D().getEdgeArray();
            for (int i = 0; i < edgeArray.length; ++i) {
                EdgeRealizer edgeRealizer;
                edgeRealizer.setSelected(!(edgeRealizer = CytoscapeWindow.this.graphView.getGraph2D().getRealizer(edgeArray[i])).isSelected());
            }
            CytoscapeWindow.this.redrawGraph(false, false);
        }
    }

    protected class HideSelectedEdgesAction
    extends AbstractAction {
        HideSelectedEdgesAction() {
            super("Hide selection");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.hideSelectedEdges();
        }
    }

    protected class InvertSelectedNodesAction
    extends AbstractAction {
        InvertSelectedNodesAction() {
            super("Invert selection");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Graph2D graph2D = CytoscapeWindow.this.graphView.getGraph2D();
            Node[] nodeArray = CytoscapeWindow.this.graphView.getGraph2D().getNodeArray();
            for (int i = 0; i < nodeArray.length; ++i) {
                NodeRealizer nodeRealizer;
                nodeRealizer.setSelected(!(nodeRealizer = CytoscapeWindow.this.graphView.getGraph2D().getRealizer(nodeArray[i])).isSelected());
            }
            CytoscapeWindow.this.redrawGraph(false, false);
        }
    }

    protected class HideSelectedNodesAction
    extends AbstractAction {
        HideSelectedNodesAction() {
            super("Hide selection");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.hideSelectedNodes();
        }
    }

    protected class SetVisualPropertiesAction
    extends AbstractAction {
        SetVisualPropertiesAction() {
            super("Set Visual Properties");
        }

        SetVisualPropertiesAction(boolean bl) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CytoscapeWindow.this.vizMapUI.refreshUI();
            CytoscapeWindow.this.vizMapUI.getStyleSelector().show();
        }
    }

    class PrintAction
    extends AbstractAction {
        PageFormat pageFormat;
        OptionHandler printOptions;

        PrintAction() {
            super("Print...");
            this.printOptions = new OptionHandler("Print Options");
            this.printOptions.addInt("Poster Rows", 1);
            this.printOptions.addInt("Poster Columns", 1);
            this.printOptions.addBool("Add Poster Coords", false);
            Object[] objectArray = new String[]{"View", "Graph"};
            this.printOptions.addEnum("Clip Area", objectArray, 1);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Graph2DPrinter graph2DPrinter = new Graph2DPrinter(CytoscapeWindow.this.graphView);
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            if (this.pageFormat == null) {
                this.pageFormat = printerJob.defaultPage();
            }
            printerJob.setPrintable((Printable)graph2DPrinter, this.pageFormat);
            if (printerJob.printDialog()) {
                try {
                    CytoscapeWindow.this.setInteractivity(false);
                    printerJob.print();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            CytoscapeWindow.this.setInteractivity(true);
        }
    }
}

