/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.CytoscapeWindow;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextJarReader;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class CytoscapeConfig {
    protected String argSpecificationString = "n:j:g:b:i:he:vWs:l:p:xc;";
    protected String[] commandLineArguments;
    protected String[] argsCopy;
    protected boolean canonicalize = true;
    protected boolean helpRequested = false;
    protected boolean inputsError = false;
    protected boolean displayVersion = false;
    protected String geometryFilename = null;
    protected String bioDataDirectory = null;
    protected String expressionFilename = null;
    protected String projectFilename = null;
    protected String interactionsFilename = null;
    protected Vector nodeAttributeFilenames = new Vector();
    protected Vector edgeAttributeFilenames = new Vector();
    protected String defaultSpeciesName = null;
    protected String projectPropsFileName = null;
    protected String projectVizmapPropsFileName = null;
    protected File projectFileDirectoryAbsolute;
    protected boolean enableUndo = false;
    protected boolean copyExpToAttribs = true;
    protected String[] layoutStrategies = new String[]{"organic", "hierarchical", "embedded", "circular"};
    protected String defaultLayoutStrategy = this.layoutStrategies[0];
    protected StringBuffer errorMessages = new StringBuffer();
    protected Properties props;

    public CytoscapeConfig() {
        this(new String[0]);
    }

    public CytoscapeConfig(String[] stringArray) {
        this.commandLineArguments = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.commandLineArguments, 0, stringArray.length);
        this.argsCopy = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.argsCopy, 0, stringArray.length);
        this.parseArgs();
        this.readProjectFile();
        this.props = this.readProperties();
        this.getConfigurationsFromProperties();
    }

    public String[] getArgs() {
        String[] stringArray = new String[this.argsCopy.length];
        System.arraycopy(this.argsCopy, 0, stringArray, 0, this.argsCopy.length);
        return stringArray;
    }

    public String getGeometryFilename() {
        return this.geometryFilename;
    }

    public String getExpressionFilename() {
        return this.expressionFilename;
    }

    public String getProjectFilename() {
        return this.projectFilename;
    }

    public String getProjectVizmapPropsFileName() {
        return this.projectVizmapPropsFileName;
    }

    public String getBioDataDirectory() {
        return this.bioDataDirectory;
    }

    public String getInteractionsFilename() {
        return this.interactionsFilename;
    }

    public int getNumberOfNodeAttributeFiles() {
        return this.nodeAttributeFilenames.size();
    }

    public int getNumberOfEdgeAttributeFiles() {
        return this.edgeAttributeFilenames.size();
    }

    public String[] getNodeAttributeFilenames() {
        return this.nodeAttributeFilenames.toArray(new String[0]);
    }

    public String[] getEdgeAttributeFilenames() {
        return this.edgeAttributeFilenames.toArray(new String[0]);
    }

    public boolean getCanonicalize() {
        return this.canonicalize;
    }

    public void addNodeAttributeFilename(String string) {
        if (!this.nodeAttributeFilenames.contains(string)) {
            this.nodeAttributeFilenames.add(string);
        }
    }

    public void addEdgeAttributeFilename(String string) {
        if (!this.edgeAttributeFilenames.contains(string)) {
            this.edgeAttributeFilenames.add(string);
        }
    }

    public String[] getAllDataFileNames() {
        int n;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.getNodeAttributeFilenames();
        String[] stringArray2 = this.getEdgeAttributeFilenames();
        for (n = 0; n < stringArray.length; ++n) {
            vector.add(stringArray[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            vector.add(stringArray2[n]);
        }
        if (this.geometryFilename != null) {
            vector.add(this.geometryFilename);
        }
        if (this.interactionsFilename != null) {
            vector.add(this.interactionsFilename);
        }
        if (this.expressionFilename != null) {
            vector.add(this.expressionFilename);
        }
        return vector.toArray(new String[0]);
    }

    public String[] getAllDataFileExtensions() {
        String[] stringArray = this.getAllDataFileNames();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2 = stringArray[i];
            int n = string2.lastIndexOf(".");
            if (n <= 0 || vector.contains(string = string2.substring(n + 1))) continue;
            vector.add(string);
        }
        return vector.toArray(new String[0]);
    }

    public String getDefaultSpeciesName() {
        return this.defaultSpeciesName;
    }

    public String getDefaultLayoutStrategy() {
        return this.defaultLayoutStrategy;
    }

    public boolean helpRequested() {
        return this.helpRequested;
    }

    public boolean inputsError() {
        return this.inputsError;
    }

    public boolean displayVersion() {
        return this.displayVersion;
    }

    public boolean enableUndo() {
        return this.enableUndo;
    }

    public Properties getProperties() {
        return this.props;
    }

    public boolean getWhetherToCopyExpToAttribs() {
        return this.copyExpToAttribs;
    }

    protected Properties readProperties() {
        File file;
        File file2;
        Properties properties = null;
        Properties properties2 = null;
        Properties properties3 = null;
        Properties properties4 = null;
        String string = "cytoscape.props";
        File file3 = this.createFile(System.getProperty("CYTOSCAPE_HOME"), string);
        if (file3 != null) {
            properties = this.readOnePropertyFile(null, file3);
        }
        if ((file2 = this.createFile(System.getProperty("user.home"), string)) != null) {
            properties2 = this.readOnePropertyFile(properties, file2);
        }
        if ((file = this.createFile(System.getProperty("user.dir"), string)) != null) {
            properties3 = this.readOnePropertyFile(properties2, file);
        }
        CytoscapeWindow.debugLog.append("projectPropsFileName: " + this.projectPropsFileName);
        if (this.projectPropsFileName != null) {
            properties4 = this.readPropertyFileAsText(this.projectPropsFileName);
        }
        Properties properties5 = new Properties();
        if (properties != null) {
            properties5.putAll((Map<?, ?>)properties);
        }
        if (properties2 != null) {
            properties5.putAll((Map<?, ?>)properties2);
        }
        if (properties3 != null) {
            properties5.putAll((Map<?, ?>)properties3);
        }
        if (properties4 != null) {
            CytoscapeWindow.debugLog.append("--- about to add " + properties4.size() + " project Cyproperties");
            properties5.putAll((Map<?, ?>)properties4);
        }
        return properties5;
    }

    public Properties readPropertyFileAsText(String string) {
        Object object;
        Object object2;
        String string2 = "";
        CytoscapeWindow.debugLog.append("CC.readPropertyFileAsText, path: " + string + "\n");
        try {
            if (string.trim().startsWith("jar://")) {
                CytoscapeWindow.debugLog.append("CC.readPropertyFileAsText, starts with jar://\n");
                object2 = new TextJarReader(string);
                ((TextJarReader)object2).read();
                string2 = ((TextJarReader)object2).getText();
                CytoscapeWindow.debugLog.append("from jar, rawText:\n" + string2 + "\n");
            } else {
                CytoscapeWindow.debugLog.append("CC.readPropertyFileAsText, does not start with jar://\n");
                object2 = new File(this.absolutizeFilename(this.projectFileDirectoryAbsolute, string));
                object = new TextFileReader(((File)object2).getPath());
                ((TextFileReader)object).read();
                string2 = ((TextFileReader)object).getText();
                CytoscapeWindow.debugLog.append("from file, rawText:\n" + string2 + "\n");
            }
        }
        catch (Exception exception) {
            System.err.println("-- Exception while reading properties file " + string);
            System.err.println(exception.getMessage());
        }
        object2 = string2.getBytes();
        object = new ByteArrayInputStream((byte[])object2);
        Properties properties = new Properties();
        try {
            properties.load((InputStream)object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return properties;
    }

    private File createFile(String string, String string2) {
        File file;
        if (string != null && (file = new File(string, string2)).canRead()) {
            return file;
        }
        return null;
    }

    private Properties readOnePropertyFile(Properties properties, File file) {
        Properties properties2 = new Properties();
        if (properties != null) {
            properties2 = new Properties(properties);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties2.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties2;
    }

    protected void parseArgs() {
        int n;
        this.helpRequested = false;
        boolean bl = false;
        if (this.commandLineArguments == null || this.commandLineArguments.length == 0) {
            return;
        }
        LongOpt[] longOptArray = new LongOpt[]{};
        Getopt getopt = new Getopt("cytoscape", this.commandLineArguments, this.argSpecificationString, longOptArray);
        getopt.setOpterr(false);
        block16: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 110: {
                    this.nodeAttributeFilenames.add(getopt.getOptarg());
                    continue block16;
                }
                case 106: {
                    this.edgeAttributeFilenames.add(getopt.getOptarg());
                    continue block16;
                }
                case 103: {
                    this.geometryFilename = getopt.getOptarg();
                    continue block16;
                }
                case 98: {
                    this.bioDataDirectory = getopt.getOptarg();
                    continue block16;
                }
                case 105: {
                    this.interactionsFilename = getopt.getOptarg();
                    continue block16;
                }
                case 108: {
                    this.defaultLayoutStrategy = getopt.getOptarg();
                    continue block16;
                }
                case 101: {
                    this.expressionFilename = getopt.getOptarg();
                    continue block16;
                }
                case 104: {
                    this.helpRequested = true;
                    continue block16;
                }
                case 112: {
                    this.projectFilename = getopt.getOptarg();
                    continue block16;
                }
                case 115: {
                    this.defaultSpeciesName = getopt.getOptarg();
                    continue block16;
                }
                case 120: {
                    this.copyExpToAttribs = false;
                    continue block16;
                }
                case 118: {
                    this.displayVersion = true;
                    continue block16;
                }
                case 99: {
                    this.canonicalize = false;
                    continue block16;
                }
                case 63: {
                    int n2 = getopt.getOptopt();
                    if (n2 == 0) continue block16;
                    this.errorMessages.append("The option '" + (char)n2 + "' is not valid\n");
                    continue block16;
                }
            }
            this.errorMessages.append("unexpected argument: " + n + "\n");
            this.inputsError = true;
        }
        if (!this.inputsError) {
            this.inputsError = !this.legalArguments();
        }
    }

    protected void getConfigurationsFromProperties() {
        this.defaultLayoutStrategy = this.props.getProperty("defaultLayoutStrategy", this.defaultLayoutStrategy);
        String string = this.props.getProperty("enableUndo");
        if (string != null) {
            this.enableUndo = Boolean.valueOf(string);
        }
    }

    protected void readProjectFile() {
        int n;
        String[] stringArray;
        String string;
        String[] stringArray2;
        if (this.projectFilename == null) {
            return;
        }
        boolean bl = false;
        try {
            if (this.projectFilename.trim().startsWith("jar://")) {
                bl = true;
                stringArray2 = new TextJarReader(this.projectFilename);
                stringArray2.read();
                string = stringArray2.getText();
            } else {
                stringArray2 = new File(this.projectFilename.trim());
                stringArray = new TextFileReader(stringArray2.getPath());
                stringArray.read();
                string = stringArray.getText();
                this.projectFileDirectoryAbsolute = stringArray2.getAbsoluteFile().getParentFile();
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("cannot read project file: " + this.projectFilename);
        }
        stringArray2 = string.split("\n");
        stringArray = this.parseProjectFileText(stringArray2, "sif");
        String[] stringArray3 = this.parseProjectFileText(stringArray2, "gml");
        String[] stringArray4 = this.parseProjectFileText(stringArray2, "noa");
        String[] stringArray5 = this.parseProjectFileText(stringArray2, "eda");
        String[] stringArray6 = this.parseProjectFileText(stringArray2, "expr");
        String[] stringArray7 = this.parseProjectFileText(stringArray2, "dataServer");
        String[] stringArray8 = this.parseProjectFileText(stringArray2, "species");
        String[] stringArray9 = this.parseProjectFileText(stringArray2, "layout");
        String[] stringArray10 = this.parseProjectFileText(stringArray2, "props");
        String[] stringArray11 = this.parseProjectFileText(stringArray2, "vprops");
        String[] stringArray12 = this.parseProjectFileText(stringArray2, "canonicalizeNames");
        String[] stringArray13 = this.parseProjectFileText(stringArray2, "matrix");
        String[] stringArray14 = this.parseProjectFileText(stringArray2, "arg");
        if (stringArray.length >= 1) {
            this.interactionsFilename = bl ? stringArray[0] : this.absolutizeFilename(this.projectFileDirectoryAbsolute, stringArray[0]);
        }
        if (stringArray3.length >= 1) {
            this.geometryFilename = bl ? stringArray3[0] : this.absolutizeFilename(this.projectFileDirectoryAbsolute, stringArray3[0]);
        }
        if (stringArray6.length >= 1) {
            this.expressionFilename = bl ? stringArray6[0] : this.absolutizeFilename(this.projectFileDirectoryAbsolute, stringArray6[0]);
        }
        for (n = 0; n < stringArray4.length; ++n) {
            if (bl) {
                this.nodeAttributeFilenames.add(stringArray4[n]);
                continue;
            }
            this.nodeAttributeFilenames.add(this.absolutizeFilename(this.projectFileDirectoryAbsolute, stringArray4[n]));
        }
        for (n = 0; n < stringArray5.length; ++n) {
            if (bl) {
                this.edgeAttributeFilenames.add(stringArray5[n]);
                continue;
            }
            this.edgeAttributeFilenames.add(this.absolutizeFilename(this.projectFileDirectoryAbsolute, stringArray5[n]));
        }
        if (stringArray7.length >= 1) {
            String string2 = stringArray7[0];
            this.bioDataDirectory = !string2.startsWith("rmi://") && !string2.startsWith("jar://") && !string2.startsWith("http://") ? this.absolutizeFilename(this.projectFileDirectoryAbsolute, string2) : string2;
        }
        if (stringArray8.length > 0) {
            this.defaultSpeciesName = stringArray8[0];
        }
        if (stringArray9.length > 0) {
            this.defaultLayoutStrategy = stringArray9[0];
        }
        CytoscapeWindow.debugLog.append("config.readProjectFile, propsFile count: " + stringArray10.length + "\n");
        if (stringArray10.length >= 1) {
            this.projectPropsFileName = stringArray10[0];
            CytoscapeWindow.debugLog.append("config.readProjectFile, propsPropsFileName: " + this.projectPropsFileName + "\n");
        }
        CytoscapeWindow.debugLog.append("config.readProjectFile, vizmapPropsFile count: " + stringArray11.length + "\n");
        if (stringArray11.length >= 1) {
            this.projectVizmapPropsFileName = stringArray11[0];
            CytoscapeWindow.debugLog.append("config.readProjectFile, vizmapPropsFileName: " + this.projectVizmapPropsFileName + "\n");
        }
        if (stringArray12.length > 0) {
            String string3 = stringArray12[0];
            if (string3.equals("yes")) {
                this.canonicalize = true;
            } else if (string3.equals("no")) {
                this.canonicalize = false;
            }
        }
        if (stringArray14.length > 0) {
            int n2 = this.argsCopy.length;
            int n3 = stringArray14.length;
            int n4 = n2 + n3;
            String[] stringArray15 = new String[n2];
            System.arraycopy(this.argsCopy, 0, stringArray15, 0, n2);
            this.argsCopy = new String[n4];
            System.arraycopy(stringArray15, 0, this.argsCopy, 0, n2);
            System.arraycopy(stringArray14, 0, this.argsCopy, n2, n3);
        }
    }

    protected String absolutizeFilename(File file, String string) {
        if (string.trim().startsWith("/")) {
            return string;
        }
        return new File(file, string).getPath();
    }

    protected String[] parseProjectFileText(String[] stringArray, String string) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            if (!string2.startsWith(string)) continue;
            String string3 = string2.substring(string2.indexOf("=") + 1);
            vector.add(string3.trim());
        }
        return vector.toArray(new String[0]);
    }

    protected boolean legalArguments() {
        boolean bl = true;
        if (this.geometryFilename != null && this.interactionsFilename != null) {
            this.errorMessages.append(" -  geometry & interactions both specify a graph: use only one\n");
            bl = false;
        }
        boolean bl2 = true;
        for (int i = 0; i < this.layoutStrategies.length; ++i) {
            if (!this.defaultLayoutStrategy.equals(this.layoutStrategies[i])) continue;
            bl2 = false;
            break;
        }
        bl = bl && !bl2;
        return bl;
    }

    public String getErrorMessages() {
        return this.errorMessages.toString();
    }

    public void setGeometryFilename(String string) {
        this.geometryFilename = string;
    }

    public void setExpressionFilename(String string) {
        this.expressionFilename = string;
    }

    public void setProjectFilename(String string) {
        this.projectFilename = string;
    }

    public void setProjectVizmapPropsFileName(String string) {
        this.projectVizmapPropsFileName = string;
    }

    public void setBioDataDirectory(String string) {
        this.bioDataDirectory = string;
    }

    public void setInteractionsFilename(String string) {
        this.interactionsFilename = string;
    }

    public void setDefaultSpecies(String string) {
        this.defaultSpeciesName = string;
    }

    public void setDefaultLayoutStrategy(String string) {
        this.defaultLayoutStrategy = string;
    }

    public void setProperties(Properties properties) {
        this.props = properties;
    }

    public void setWhetherToCopyExpToAttribs(boolean bl) {
        this.copyExpToAttribs = bl;
    }

    public String getUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "cytoscape";
        stringBuffer.append("usage: ");
        stringBuffer.append(string);
        stringBuffer.append(" [optional arguments]");
        stringBuffer.append("\n\n");
        stringBuffer.append("\n      optional arguments\n");
        stringBuffer.append("      ------------------\n");
        stringBuffer.append(" -g  <geometry file name>          (xxxx.gml)\n");
        stringBuffer.append(" -b  <bioData directory>           (./biodata)\n");
        stringBuffer.append(" -i  <interactions filename>       (yyyy.intr)\n");
        stringBuffer.append(" -e  <expression filename>         (zzz.mrna)\n");
        stringBuffer.append(" -x  (causes Cytoscape not to copy expression to attribs)\n");
        stringBuffer.append(" -s  <default species name>        (\"Saccharomyces cerevisiae\")\n");
        stringBuffer.append(" -n  <nodeAttributes filename>     (zero or more)\n");
        stringBuffer.append(" -j  <edgeAttributes filename>     (zero or more)\n");
        stringBuffer.append(" -l  <layout strategy>             (organic|hierarchical|embedded|circular)\n");
        stringBuffer.append(" -c  (suppresses automatic canonicalization of node names in input graph files)\n");
        stringBuffer.append("\n");
        stringBuffer.append(" -h  (display usage)\n");
        stringBuffer.append(" -v  (display version)\n");
        return stringBuffer.toString();
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("---------- requested options:\n");
        stringBuffer.append("            geometry file: " + this.geometryFilename + "\n");
        stringBuffer.append("        interactions file: " + this.interactionsFilename + "\n");
        stringBuffer.append("          expression file: " + this.expressionFilename + "\n");
        stringBuffer.append("         bioDataDirectory: " + this.bioDataDirectory + "\n");
        stringBuffer.append("       defaultSpeciesName: " + this.defaultSpeciesName + "\n");
        stringBuffer.append("    defaultLayoutStrategy: " + this.defaultLayoutStrategy + "\n");
        for (n = 0; n < this.nodeAttributeFilenames.size(); ++n) {
            stringBuffer.append("        nodeAttributeFile: " + (String)this.nodeAttributeFilenames.get(n) + "\n");
        }
        for (n = 0; n < this.edgeAttributeFilenames.size(); ++n) {
            stringBuffer.append("        edgeAttributeFile: " + (String)this.edgeAttributeFilenames.get(n) + "\n");
        }
        return stringBuffer.toString();
    }
}

