/*
 * Decompiled with CFR 0.152.
 */
package com.bluemarsh.adt;

import java.util.Stack;

public class FibonacciHeap {
    protected Node min;
    protected int n;

    protected void cascadingCut(Node node) {
        Node node2 = node.parent;
        if (node2 != null) {
            if (!node.mark) {
                node.mark = true;
            } else {
                this.cut(node, node2);
                this.cascadingCut(node2);
            }
        }
    }

    public void clear() {
        this.min = null;
        this.n = 0;
    }

    protected void consolidate() {
        int n;
        int n2 = this.n + 1;
        Node[] nodeArray = new Node[n2];
        int n3 = 0;
        while (n3 < n2) {
            nodeArray[n3] = null;
            ++n3;
        }
        int n4 = 0;
        Node node = this.min;
        if (node != null) {
            ++n4;
            node = node.right;
            while (node != this.min) {
                ++n4;
                node = node.right;
            }
        }
        while (n4 > 0) {
            n = node.degree;
            Node node2 = node.right;
            while (nodeArray[n] != null) {
                Node node3 = nodeArray[n];
                if (node.key > node3.key) {
                    Node node4 = node3;
                    node3 = node;
                    node = node4;
                }
                this.link(node3, node);
                nodeArray[n] = null;
                ++n;
            }
            nodeArray[n] = node;
            node = node2;
            --n4;
        }
        this.min = null;
        n = 0;
        while (n < n2) {
            if (nodeArray[n] != null) {
                if (this.min != null) {
                    nodeArray[n].left.right = nodeArray[n].right;
                    nodeArray[n].right.left = nodeArray[n].left;
                    nodeArray[n].left = this.min;
                    nodeArray[n].right = this.min.right;
                    this.min.right = nodeArray[n];
                    nodeArray[n].right.left = nodeArray[n];
                    if (nodeArray[n].key < this.min.key) {
                        this.min = nodeArray[n];
                    }
                } else {
                    this.min = nodeArray[n];
                }
            }
            ++n;
        }
    }

    protected void cut(Node node, Node node2) {
        node.left.right = node.right;
        node.right.left = node.left;
        --node2.degree;
        if (node2.child == node) {
            node2.child = node.right;
        }
        if (node2.degree == 0) {
            node2.child = null;
        }
        node.left = this.min;
        node.right = this.min.right;
        this.min.right = node;
        node.right.left = node;
        node.parent = null;
        node.mark = false;
    }

    public void decreaseKey(Node node, double d) {
        if (d > node.key) {
            throw new IllegalArgumentException("decreaseKey() got larger key value");
        }
        node.key = d;
        Node node2 = node.parent;
        if (node2 != null && node.key < node2.key) {
            this.cut(node, node2);
            this.cascadingCut(node2);
        }
        if (node.key < this.min.key) {
            this.min = node;
        }
    }

    public void delete(Node node) {
        this.decreaseKey(node, Double.NEGATIVE_INFINITY);
        this.removeMin();
    }

    public boolean isEmpty() {
        return this.min == null;
    }

    public Node insert(Object object, double d) {
        Node node = new Node(object, d);
        if (this.min != null) {
            node.left = this.min;
            node.right = this.min.right;
            this.min.right = node;
            node.right.left = node;
            if (d < this.min.key) {
                this.min = node;
            }
        } else {
            this.min = node;
        }
        ++this.n;
        return node;
    }

    protected void link(Node node, Node node2) {
        node.left.right = node.right;
        node.right.left = node.left;
        node.parent = node2;
        if (node2.child == null) {
            node2.child = node;
            node.right = node;
            node.left = node;
        } else {
            node.left = node2.child;
            node.right = node2.child.right;
            node2.child.right = node;
            node.right.left = node;
        }
        ++node2.degree;
        node.mark = false;
    }

    public Node min() {
        return this.min;
    }

    public Object removeMin() {
        Node node = this.min;
        if (node != null) {
            int n = node.degree;
            Node node2 = node.child;
            while (n > 0) {
                Node node3 = node2.right;
                node2.left.right = node2.right;
                node2.right.left = node2.left;
                node2.left = this.min;
                node2.right = this.min.right;
                this.min.right = node2;
                node2.right.left = node2;
                node2.parent = null;
                node2 = node3;
                --n;
            }
            node.left.right = node.right;
            node.right.left = node.left;
            if (node == node.right) {
                this.min = null;
            } else {
                this.min = node.right;
                this.consolidate();
            }
            --this.n;
        }
        return node.data;
    }

    public int size() {
        return this.n;
    }

    public static FibonacciHeap union(FibonacciHeap fibonacciHeap, FibonacciHeap fibonacciHeap2) {
        FibonacciHeap fibonacciHeap3 = new FibonacciHeap();
        if (fibonacciHeap != null && fibonacciHeap2 != null) {
            fibonacciHeap3.min = fibonacciHeap.min;
            if (fibonacciHeap3.min != null) {
                if (fibonacciHeap2.min != null) {
                    fibonacciHeap3.min.right.left = fibonacciHeap2.min.left;
                    fibonacciHeap2.min.left.right = fibonacciHeap3.min.right;
                    fibonacciHeap3.min.right = fibonacciHeap2.min;
                    fibonacciHeap2.min.left = fibonacciHeap3.min;
                    if (fibonacciHeap2.min.key < fibonacciHeap.min.key) {
                        fibonacciHeap3.min = fibonacciHeap2.min;
                    }
                }
            } else {
                fibonacciHeap3.min = fibonacciHeap2.min;
            }
            fibonacciHeap3.n = fibonacciHeap.n + fibonacciHeap2.n;
        }
        return fibonacciHeap3;
    }

    public String toString() {
        if (this.min == null) {
            return "FibonacciHeap=[]";
        }
        Stack<Node> stack = new Stack<Node>();
        stack.push(this.min);
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("FibonacciHeap=[");
        while (!stack.empty()) {
            Node node = (Node)stack.pop();
            stringBuffer.append(node);
            stringBuffer.append(", ");
            if (node.child != null) {
                stack.push(node.child);
            }
            Node node2 = node;
            node = node.right;
            while (node != node2) {
                stringBuffer.append(node);
                stringBuffer.append(", ");
                if (node.child != null) {
                    stack.push(node.child);
                }
                node = node.right;
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static class Node {
        public Object data;
        public double key;
        public Node parent;
        public Node child;
        public Node right;
        public Node left;
        public int degree;
        public boolean mark;

        public Node(Object object, double d) {
            this.data = object;
            this.key = d;
            this.right = this;
            this.left = this;
        }

        public String toString() {
            return Double.toString(this.key);
        }
    }
}

