/*
 * Decompiled with CFR 0.152.
 */
package visad.data.units;

import visad.BaseUnit;
import visad.OffsetUnit;
import visad.SI;
import visad.ScaledUnit;
import visad.Unit;
import visad.UnitException;
import visad.data.units.UnitPrefix;
import visad.data.units.UnitTable;
import visad.data.units.UnitsDB;

public final class DefaultUnitsDB
extends UnitTable {
    private static DefaultUnitsDB b;
    public final UnitPrefix[] d = new UnitPrefix[]{new UnitPrefix("centi", 0.01), new UnitPrefix("femto", 1.0E-15), new UnitPrefix("hecto", 100.0), new UnitPrefix("micro", 1.0E-6), new UnitPrefix("milli", 0.001), new UnitPrefix("yocto", 1.0E-24), new UnitPrefix("yotta", 1.0E24), new UnitPrefix("zepto", 1.0E-21), new UnitPrefix("zetta", 1.0E21), new UnitPrefix("atto", 1.0E-18), new UnitPrefix("deca", 10.0), new UnitPrefix("deci", 0.1), new UnitPrefix("deka", 10.0), new UnitPrefix("giga", 1.0E9), new UnitPrefix("kilo", 1000.0), new UnitPrefix("mega", 1000000.0), new UnitPrefix("nano", 1.0E-9), new UnitPrefix("peta", 1.0E15), new UnitPrefix("pico", 1.0E-12), new UnitPrefix("tera", 1.0E12), new UnitPrefix("exa", 1.0E18)};
    public final UnitPrefix[] a = new UnitPrefix[]{new UnitPrefix("da", 10.0), new UnitPrefix("E", 1.0E18), new UnitPrefix("G", 1.0E9), new UnitPrefix("M", 1000000.0), new UnitPrefix("P", 1.0E15), new UnitPrefix("T", 1.0E12), new UnitPrefix("Y", 1.0E24), new UnitPrefix("Z", 1.0E21), new UnitPrefix("a", 1.0E-18), new UnitPrefix("c", 0.01), new UnitPrefix("d", 0.1), new UnitPrefix("f", 1.0E-15), new UnitPrefix("h", 100.0), new UnitPrefix("k", 1000.0), new UnitPrefix("m", 0.001), new UnitPrefix("n", 1.0E-9), new UnitPrefix("p", 1.0E-12), new UnitPrefix("u", 1.0E-6), new UnitPrefix("y", 1.0E-24), new UnitPrefix("z", 1.0E-21)};
    public static Class f;

    private DefaultUnitsDB() throws UnitException {
        super(677, 98);
        this.a(SI.a);
        this.a(SI.c);
        this.a(SI.f);
        this.a(SI.e);
        this.a(SI.d);
        this.a(SI.i);
        this.a(SI.h);
        this.a(SI.b);
        this.a(SI.g);
        this.b("%", new ScaledUnit(0.01));
        this.c("percent", "%");
        this.c("PI", new ScaledUnit(Math.PI));
        this.c("bakersdozen", new ScaledUnit(13.0));
        this.c("pair", new ScaledUnit(2.0));
        this.c("ten", new ScaledUnit(10.0));
        this.c("dozen", new ScaledUnit(12.0));
        this.c("score", new ScaledUnit(20.0));
        this.c("hundred", new ScaledUnit(100.0));
        this.c("thousand", new ScaledUnit(1000.0));
        this.c("million", new ScaledUnit(1000000.0));
        this.c("amp", "ampere");
        this.c("abampere", this.b("A").b(10.0));
        this.c("gilbert", this.b("A").b(0.7957747));
        this.c("statampere", this.b("A").b(3.33564E-10));
        this.c("biot", "abampere");
        this.c("candle", "candela");
        this.a("degree kelvin", "K");
        this.a("degrees kelvin", "K");
        this.b("degK", "K");
        this.a("degreeK", "K");
        this.a("degreesK", "K");
        this.a("deg K", "K");
        this.a("degree K", "K");
        this.a("degrees K", "K");
        this.b("Cel", new OffsetUnit(273.15, (BaseUnit)this.b("K")));
        this.c("celsius", "Cel");
        this.a("degree celsius", "Cel");
        this.a("degrees celsius", "Cel");
        this.c("centigrade", "Cel");
        this.a("degree centigrade", "Cel");
        this.a("degrees centigrade", "Cel");
        this.a("degC", "Cel");
        this.a("degreeC", "Cel");
        this.a("degreesC", "Cel");
        this.a("deg C", "Cel");
        this.a("degree C", "Cel");
        this.a("degrees C", "Cel");
        this.c("rankine", this.b("K").b(0.5555555555555556));
        this.a("degree rankine", "rankine");
        this.a("degrees rankine", "rankine");
        this.a("degR", "rankine");
        this.a("degreeR", "rankine");
        this.a("degreesR", "rankine");
        this.a("deg R", "rankine");
        this.a("degree R", "rankine");
        this.a("degrees R", "rankine");
        this.c("fahrenheit", this.b("Rankine").a(459.67));
        this.a("degree fahrenheit", "fahrenheit");
        this.a("degrees fahrenheit", "fahrenheit");
        this.a("degF", "fahrenheit");
        this.a("degreeF", "fahrenheit");
        this.a("degreesF", "fahrenheit");
        this.a("deg F", "fahrenheit");
        this.a("degree F", "fahrenheit");
        this.a("degrees F", "fahrenheit");
        this.c("assay ton", this.b("kg").b(0.02916667));
        this.c("avoirdupois ounce", this.b("kg").b(0.02834952));
        this.c("avoirdupois pound", this.b("kg").b(0.45359237));
        this.c("carat", this.b("kg").b(2.0E-4));
        this.b("gr", this.b("kg").b(6.479891E-5));
        this.b("g", this.b("kg").b(0.001));
        this.c("long hundredweight", this.b("kg").b(50.80235));
        this.b("tne", this.b("kg").b(1000.0));
        this.c("pennyweight", this.b("kg").b(0.001555174));
        this.c("short hundredweight", this.b("kg").b(45.35924));
        this.c("slug", this.b("kg").b(14.5939));
        this.c("troy ounce", this.b("kg").b(0.03110348));
        this.c("troy pound", this.b("kg").b(0.3732417));
        this.c("amu", this.b("kg").b(1.66054E-27));
        this.c("scruple", this.b("gr").b(20.0));
        this.c("apdram", this.b("gr").b(60.0));
        this.c("apounce", this.b("gr").b(480.0));
        this.c("appound", this.b("gr").b(5760.0));
        this.c("gram", "g");
        this.c("tonne", "tne");
        this.a("metric ton", "tne");
        this.c("apothecary ounce", "troy ounce");
        this.c("apothecary pound", "troy pound");
        this.c("pound", "avoirdupois pound");
        this.c("metricton", "tne");
        this.b("grain", "gr");
        this.c("atomicmassunit", "amu");
        this.c("atomic mass unit", "amu");
        this.b("t", "tne");
        this.b("lb", "avoirdupois pound");
        this.c("bag", this.b("pound").b(94.0));
        this.c("short ton", this.b("pound").b(2000.0));
        this.c("long ton", this.b("pound").b(2240.0));
        this.c("ton", "short ton");
        this.c("shortton", "short ton");
        this.c("longton", "long ton");
        this.c("angstrom", this.b("m").b(1.0E-10));
        this.c("au", this.b("m").b(1.495979E11));
        this.c("fermi", this.b("m").b(1.0E-15));
        this.c("light year", this.b("m").b(9.46073E15));
        this.c("micron", this.b("m").b(1.0E-6));
        this.c("mil", this.b("m").b(2.54E-5));
        this.c("nautical mile", this.b("m").b(1852.0));
        this.c("parsec", this.b("m").b(3.085678E16));
        this.c("printers point", this.b("m").b(3.514598E-4));
        this.c("metre", "m");
        this.a("prs", "parsec");
        this.a("US survey foot", this.b("m").b(0.3048006096012192));
        this.c("US survey yard", this.b("US survey foot").b(3.0));
        this.c("US survey mile", this.b("US survey foot").b(5280.0));
        this.c("rod", this.b("US survey foot").b(16.5));
        this.c("furlong", this.b("US survey foot").b(660.0));
        this.c("fathom", this.b("US survey foot").b(6.0));
        this.a("US survey feet", "US survey foot");
        this.c("US statute mile", "US survey mile");
        this.c("pole", "rod");
        this.a("perch", "rod");
        this.a("perches", "perch");
        this.a("international inch", this.b("m").b(0.0254));
        this.a("international foot", this.b("international inch").b(12.0));
        this.c("international yard", this.b("international foot").b(3.0));
        this.c("international mile", this.b("international foot").b(5280.0));
        this.a("international inches", "international inch");
        this.a("international feet", "international foot");
        this.a("inch", "international inch");
        this.a("foot", "international foot");
        this.c("yard", "international yard");
        this.c("mile", "international mile");
        this.a("inches", "inch");
        this.b("in", "inches");
        this.a("feet", "foot");
        this.b("ft", "feet");
        this.b("yd", "yard");
        this.b("mi", "mile");
        this.c("chain", this.b("m").b(20.11684));
        this.c("pica", this.b("printers point").b(12.0));
        this.c("printers pica", "pica");
        this.c("astronomicalunit", "au");
        this.b("astronomical unit", "au");
        this.a("asu", "au");
        this.c("nmile", "nautical mile");
        this.b("nmi", "nautical mile");
        this.c("big point", this.b("inch").b(0.013888888888888888));
        this.c("barleycorn", this.b("inch").b(0.3333333333333333));
        this.c("arpentlin", this.b("foot").b(191.835));
        this.c("year", this.b("s").b(3.15569259747E7));
        this.b("d", this.b("s").b(86400.0));
        this.b("h", this.b("s").b(3600.0));
        this.b("min", this.b("s").b(60.0));
        this.c("shake", this.b("s").b(1.0E-8));
        this.c("sidereal day", this.b("s").b(86164.09));
        this.c("sidereal hour", this.b("s").b(3590.17));
        this.c("sidereal minute", this.b("s").b(59.83617));
        this.c("sidereal second", this.b("s").b(0.9972696));
        this.c("sidereal year", this.b("s").b(3.155815E7));
        this.c("day", "d");
        this.c("hour", "h");
        this.c("minute", "min");
        this.c("sec", "s");
        this.c("lunar month", this.b("d").b(29.530589));
        this.c("common year", this.b("d").b(365.0));
        this.c("leap year", this.b("d").b(366.0));
        this.c("Julian year", this.b("d").b(365.25));
        this.c("Gregorian year", this.b("d").b(365.2425));
        this.c("tropical year", "year");
        this.c("sidereal month", this.b("d").b(27.321661));
        this.c("tropical month", this.b("d").b(27.321582));
        this.c("fortnight", this.b("d").b(14.0));
        this.c("week", this.b("d").b(7.0));
        this.c("jiffy", this.b("s").b(0.01));
        this.c("eon", this.b("y").b(1.0E9));
        this.c("month", this.b("y").b(0.08333333333333333));
        this.c("tropical year", "year");
        this.c("yr", "year");
        this.b("a", "year");
        this.a("ann", "year");
        this.c("hr", "h");
        this.c("circle", this.b("radian").b(Math.PI * 2));
        this.c("deg", this.b("radian").b(Math.PI / 180));
        this.c("'", this.b("deg").b(0.016666666666666666));
        this.c("\"", this.b("deg").b(2.777777777777778E-4));
        this.c("grade", this.b("deg").b(0.9));
        this.c("cycle", this.b("circle"));
        this.c("turn", "circle");
        this.c("revolution", "cycle");
        this.a("gon", "grade");
        this.c("angular degree", "deg");
        this.c("angular minute", "'");
        this.c("angular second", "\"");
        this.c("arcdeg", "deg");
        this.c("degree", "deg");
        this.c("arcminute", "'");
        this.a("mnt", "'");
        this.c("arcsecond", "\"");
        this.c("arcmin", "'");
        this.c("arcsec", "\"");
        this.a("degree true", this.b("deg"));
        this.a("degrees true", this.b("deg"));
        this.a("degrees north", this.b("deg"));
        this.a("degrees east", this.b("deg"));
        this.a("degrees south", this.b("degrees north").b(-1.0));
        this.a("degrees west", this.b("degrees east").b(-1.0));
        this.a("degree north", "degrees north");
        this.a("degreeN", "degrees north");
        this.a("degree N", "degrees north");
        this.a("degreesN", "degrees north");
        this.a("degrees N", "degrees north");
        this.a("degree east", "degrees east");
        this.a("degreeE", "degrees east");
        this.a("degree E", "degrees east");
        this.a("degreesE", "degrees east");
        this.a("degrees E", "degrees east");
        this.a("degree west", "degrees west");
        this.a("degreeW", "degrees west");
        this.a("degree W", "degrees west");
        this.a("degreesW", "degrees west");
        this.a("degrees W", "degrees west");
        this.a("degree true", "degrees true");
        this.a("degreeT", "degrees true");
        this.a("degree T", "degrees true");
        this.a("degreesT", "degrees true");
        this.a("degrees T", "degrees true");
        this.b("Hz", this.b("second").a(-1));
        this.b("N", this.b("kg").e(this.b("m").b(this.b("s").a(2))));
        this.b("C", this.b("A").e(this.b("s")));
        this.b("lm", this.b("cd").e(this.b("sr")));
        this.b("Bq", this.b("Hz"));
        this.a("standard free fall", this.b("m").b(this.b("s").a(2)).b(9.80665));
        this.b("Pa", this.b("N").b(this.b("m").a(2)));
        this.b("J", this.b("N").e(this.b("m")));
        this.b("lx", this.b("lm").b(this.b("m").a(2)));
        this.c("sphere", this.b("steradian").b(Math.PI * 4));
        this.b("W", this.b("J").b(this.b("s")));
        this.b("Gy", this.b("J").b(this.b("kg")));
        this.b("Sv", this.b("J").b(this.b("kg")));
        this.b("V", this.b("W").b(this.b("A")));
        this.b("F", this.b("C").b(this.b("V")));
        this.b("Ohm", this.b("V").b(this.b("A")));
        this.b("S", this.b("A").b(this.b("V")));
        this.b("Wb", this.b("V").e(this.b("s")));
        this.b("T", this.b("Wb").b(this.b("m").a(2)));
        this.b("H", this.b("Wb").b(this.b("A")));
        this.c("newton", "N");
        this.c("hertz", "Hz");
        this.c("watt", "W");
        this.a("force", "standard free fall");
        this.a("gravity", "standard free fall");
        this.a("free fall", "standard free fall");
        this.a("conventional mercury", this.b("gravity").e(this.b("kg").b(this.b("m").a(3))).b(13595.1));
        this.a("mercury 0C", this.b("gravity").e(this.b("kg").b(this.b("m").a(3))).b(13595.1));
        this.a("mercury 60F", this.b("gravity").e(this.b("kg").b(this.b("m").a(3))).b(13556.8));
        this.a("conventional water", this.b("gravity").e(this.b("kg").b(this.b("m").a(3))).b(1000.0));
        this.a("water 4C", this.b("gravity").e(this.b("kg").b(this.b("m").a(3))).b(999.972));
        this.a("water 60F", this.b("gravity").e(this.b("kg").b(this.b("m").a(3))).b(999.001));
        this.a("mercury 32F", "mercury 0C");
        this.a("water 39F", "water 4C");
        this.a("mercury", "conventional mercury");
        this.a("water", "conventional water");
        this.c("farad", "F");
        this.b("Hg", "mercury");
        this.a("H2O", "water");
        this.b("Gal", this.b("m").b(this.b("s").a(2)).b(0.01));
        this.a("gals", "Gal");
        this.c("are", this.b("m").a(2).b(100.0));
        this.c("barn", this.b("m").a(2).b(1.0E-28));
        this.c("circular mil", this.b("m").a(2).b(5.067075E-10));
        this.c("darcy", this.b("m").a(2).b(9.869233E-13));
        this.c("hectare", this.b("hectoare"));
        this.a("har", "hectare");
        this.c("acre", this.b("rod").a(2).b(160.0));
        this.c("abfarad", this.b("F").b(1.0E9));
        this.c("abhenry", this.b("H").b(1.0E-9));
        this.c("abmho", this.b("S").b(1.0E9));
        this.c("abohm", this.b("Ohm").b(1.0E-9));
        this.c("megohm", this.b("Ohm").b(1000000.0));
        this.c("kilohm", this.b("Ohm").b(1000.0));
        this.c("abvolt", this.b("V").b(1.0E-8));
        this.b("e", this.b("C").b(-17.39782267));
        this.c("chemical faraday", this.b("C").b(96495.7));
        this.c("physical faraday", this.b("C").b(96521.9));
        this.c("C12 faraday", this.b("C").b(96485.31));
        this.c("gamma", this.b("nT"));
        this.c("gauss", this.b("T").b(1.0E-4));
        this.c("maxwell", this.b("Wb").b(1.0E-8));
        this.b("Oe", this.b("A").b(this.b("m")).b(79.57747));
        this.c("statcoulomb", this.b("C").b(3.33564E-10));
        this.c("statfarad", this.b("F").b(1.11265E-12));
        this.c("stathenry", this.b("H").b(8.987554E11));
        this.c("statmho", this.b("S").b(1.11265E-12));
        this.c("statohm", this.b("Ohm").b(8.987554E11));
        this.c("statvolt", this.b("V").b(299.7925));
        this.c("unit pole", this.b("Wb").b(1.256637E-7));
        this.c("henry", "H");
        this.c("siemens", "S");
        this.c("ohm", "Ohm");
        this.c("tesla", "T");
        this.c("volt", "V");
        this.c("weber", "Wb");
        this.c("mho", "siemens");
        this.c("oersted", "Oe");
        this.c("faraday", "C12 faraday");
        this.c("coulomb", "C");
        this.b("eV", this.b("J").b(1.602177E-19));
        this.b("bev", this.b("eV").b(1.0E9));
        this.c("erg", this.b("J").b(1.0E-7));
        this.c("IT Btu", this.b("J").b(1055.05585262));
        this.c("EC therm", this.b("J").b(1.05506E8));
        this.c("thermochemical calorie", this.b("J").b(4.184));
        this.c("IT calorie", this.b("J").b(4.1868));
        this.a("ton TNT", this.b("J").b(4.184E9));
        this.c("US therm", this.b("J").b(1.054804E8));
        this.b("Wh", this.b("W").e(this.b("h")));
        this.c("joule", "J");
        this.c("therm", "US therm");
        this.c("watthour", "Wh");
        this.b("Btu", "IT Btu");
        this.c("calorie", "IT calorie");
        this.c("electronvolt", "eV");
        this.c("electron volt", "eV");
        this.b("thm", "therm");
        this.b("cal", "calorie");
        this.c("dyne", this.b("N").b(1.0E-5));
        this.c("pond", this.b("N").b(0.00980665));
        this.a("force kilogram", this.b("N").b(9.80665));
        this.a("force gram", this.b("N").b(0.00980665));
        this.a("force ounce", this.b("N").b(0.2780139));
        this.a("force pound", this.b("N").b(4.4482216152605));
        this.c("poundal", this.b("N").b(0.138255));
        this.c("force ton", this.b("force pound").b(2000.0));
        this.b("gf", "force gram");
        this.b("lbf", "force pound");
        this.a("ounce force", "force ounce");
        this.a("kilogram force", "force kilogram");
        this.a("pound force", "force pound");
        this.b("ozf", "force ounce");
        this.b("kgf", "force kilogram");
        this.a("ton force", "force ton");
        this.a("gram force", "force gram");
        this.c("kip", this.b("lbf").b(1000.0));
        this.c("clo", this.b("K").e(this.b("m").a(2).b(this.b("W"))).b(0.155));
        this.c("lumen", "lm");
        this.c("lux", "lx");
        this.c("footcandle", this.b("lux").b(0.1076391));
        this.c("footlambert", this.b("cd").b(this.b("m").a(2)).b(3.426259));
        this.c("lambert", this.b("cd").b(this.b("m").a(2)).b(3183.098861837907));
        this.c("stilb", this.b("cd").b(this.b("m").a(2)).b(10000.0));
        this.c("phot", this.b("lm").b(this.b("m").a(2)).b(10000.0));
        this.c("nit", this.b("cd").e(this.b("m").a(2)));
        this.c("langley", this.b("J").b(this.b("m").a(2)).b(41840.0));
        this.c("blondel", this.b("cd").b(this.b("m").a(2)).b(0.3183098861837907));
        this.c("apostilb", "blondel");
        this.b("nt", "nit");
        this.b("ph", "phot");
        this.b("sb", "stilb");
        this.c("denier", this.b("kg").b(this.b("m")).b(1.111111E-7));
        this.c("tex", this.b("kg").b(this.b("m")).b(1.0E-6));
        this.a("perm 0C", this.b("kg").b(this.b("Pa").e(this.b("s")).e(this.b("m").a(2))).b(5.72135E-11));
        this.a("perm 23C", this.b("kg").b(this.b("Pa").e(this.b("s")).e(this.b("m").a(2))).b(5.74525E-11));
        this.b("VA", this.b("V").e(this.b("A")));
        this.c("voltampere", "VA");
        this.c("boiler horsepower", this.b("W").b(9809.5));
        this.c("shaft horsepower", this.b("W").b(745.6999));
        this.c("metric horsepower", this.b("W").b(7.35499));
        this.c("electric horsepower", this.b("W").b(746.0));
        this.c("water horsepower", this.b("W").b(746.043));
        this.c("UK horsepower", this.b("W").b(745.7));
        this.c("refrigeration ton", this.b("Btu").b(this.b("h")).b(12000.0));
        this.c("horsepower", "shaft horsepower");
        this.c("ton of refrigeration", "refrigeration ton");
        this.b("hp", "horsepower");
        this.c("bar", this.b("Pa").b(100000.0));
        this.c("standard atmosphere", this.b("Pa").b(101325.0));
        this.c("technical atmosphere", this.b("kg").e(this.b("gravity").b(this.b("m").b(0.01).a(2))));
        this.a("inch H2O 39F", this.b("inch").e(this.b("water 39F")));
        this.a("inch H2O 60F", this.b("inch").e(this.b("water 60F")));
        this.a("inch Hg 32F", this.b("inch").e(this.b("mercury 32F")));
        this.a("inch Hg 60F", this.b("inch").e(this.b("mercury 60F")));
        this.a("mm Hg 0C", this.b("m").b(0.001).e(this.b("mercury 0C")));
        this.b("cmHg", this.b("m").b(0.01).e(this.b("Hg")));
        this.b("cmH2O", this.b("m").b(0.01).e(this.b("water")));
        this.a("inch Hg", this.b("inch").e(this.b("Hg")));
        this.a("torr", this.b("m").b(0.001).e(this.b("Hg")));
        this.a("foot H2O", this.b("foot").e(this.b("water")));
        this.b("psi", this.b("pound").e(this.b("gravity").b(this.b("inch").a(2))));
        this.b("ksi", this.b("kip").b(this.b("inch").a(2)));
        this.c("barie", this.b("N").b(this.b("m").a(2)).b(0.1));
        this.a("footH2O", "foot H2O");
        this.b("ftH2O", "foot H2O");
        this.c("millimeter Hg", "torr");
        this.a("mm Hg", "torr");
        this.a("mm Hg", "torr");
        this.c("pascal", "Pa");
        this.a("pal", "Pa");
        this.b("inHg", "inch Hg");
        this.a("in Hg", "inch Hg");
        this.b("at", "technical atmosphere");
        this.c("atmosphere", "standard atmosphere");
        this.b("atm", "standard atmosphere");
        this.c("barye", "barie");
        this.b("Ci", this.b("Bq").b(3.7E10));
        this.c("rem", this.b("Sv").b(0.01));
        this.b("rd", this.b("Gy").b(0.01));
        this.b("R", this.b("C").b(this.b("kg")).b(2.58E-4));
        this.b("gray", "Gy");
        this.a("sie", "Sv");
        this.c("becquerel", "Bq");
        this.a("rads", "rd");
        this.c("roentgen", "R");
        this.c("curie", "Ci");
        this.b("c", this.b("m").b(this.b("s")).b(2.997925E8));
        this.c("kt", this.b("nautical mile").b(this.b("h")));
        this.a("knot international", "kt");
        this.a("international knot", "kt");
        this.c("knot", "kt");
        this.b("P", this.b("Pa").e(this.b("s")).b(0.1));
        this.b("St", this.b("m").a(2).b(this.b("s")).b(1.0E-4));
        this.b("rhe", this.b("Pa").e(this.b("s")).a(-1).b(10.0));
        this.c("poise", "P");
        this.c("stokes", "St");
        this.a("acre feet", this.b("m").a(3).b(1233.489));
        this.a("board feet", this.b("m").a(3).b(0.002359737));
        this.c("bushel", this.b("m").a(3).b(0.03523907));
        this.c("UK liquid gallon", this.b("m").a(3).b(0.00454609));
        this.c("Canadian liquid gallon", this.b("m").a(3).b(0.00454609));
        this.c("US dry gallon", this.b("m").a(3).b(0.004404884));
        this.c("US liquid gallon", this.b("m").a(3).b(0.003785412));
        this.b("cc", this.b("m").b(0.01).a(3));
        this.c("liter", this.b("m").a(3).b(0.001));
        this.c("stere", this.b("m").a(3));
        this.c("register ton", this.b("m").a(3).b(2.831685));
        this.c("US dry quart", this.b("US dry gallon").b(0.25));
        this.c("US dry pint", this.b("US dry gallon").b(0.125));
        this.c("US liquid quart", this.b("US liquid gallon").b(0.25));
        this.c("US liquid pint", this.b("US liquid gallon").b(0.125));
        this.c("US liquid cup", this.b("US liquid gallon").b(0.0625));
        this.c("US liquid gill", this.b("US liquid gallon").b(0.03125));
        this.c("US liquid ounce", this.b("US liquid gallon").b(0.0078125));
        this.c("UK liquid quart", this.b("UK liquid gallon").b(0.25));
        this.c("UK liquid pint", this.b("UK liquid gallon").b(0.125));
        this.c("UK liquid cup", this.b("UK liquid gallon").b(0.0625));
        this.c("UK liquid gill", this.b("UK liquid gallon").b(0.03125));
        this.c("UK liquid ounce", this.b("UK liquid gallon").b(0.00625));
        this.c("US fluid ounce", "US liquid ounce");
        this.c("UK fluid ounce", "UK liquid ounce");
        this.c("liquid gallon", "US liquid gallon");
        this.c("fluid ounce", "US fluid ounce");
        this.c("dry quart", "US dry quart");
        this.c("dry pint", "US dry pint");
        this.c("liquid quart", this.b("liquid gallon").b(0.25));
        this.c("liquid pint", this.b("liquid gallon").b(0.125));
        this.b("bbl", this.b("US liquid gallon").b(42.0));
        this.b("pt", this.b("liquid pint"));
        this.c("gallon", "liquid gallon");
        this.c("quart", "liquid quart");
        this.c("cup", this.b("liquid gallon").b(0.0625));
        this.c("gill", this.b("liquid gallon").b(0.03125));
        this.c("tablespoon", this.b("US fluid ounce").b(0.5));
        this.c("teaspoon", this.b("tablespoon").b(0.3333333333333333));
        this.c("peck", this.b("bushel").b(0.25));
        this.a("acre foot", "acre feet");
        this.a("board foot", "board feet");
        this.c("barrel", "bbl");
        this.b("gal", this.b("gallon"));
        this.b("oz", "fluid ounce");
        this.a("floz", "fluid ounce");
        this.c("Tbl", "tablespoon");
        this.b("Tbsp", "tablespoon");
        this.b("tbsp", "tablespoon");
        this.b("Tblsp", "tablespoon");
        this.b("tblsp", "tablespoon");
        this.c("litre", "liter");
        this.b("L", "liter");
        this.b("l", "liter");
        this.a("tsp", "teaspoon");
        this.b("pk", "peck");
        this.b("bu", "bushel");
        this.b("fldr", this.b("floz").b(0.125));
        this.b("dr", this.b("floz").b(0.0625));
        this.c("firkin", this.b("bbl").b(0.25));
        this.c("pint", "pt");
        this.b("dram", "dr");
        this.c("sverdrup", this.b("m").a(3).b(1000000.0).b(this.b("s")));
        this.c("bit", new ScaledUnit(1.0));
        this.b("Bd", this.b("Hz"));
        this.b("bps", this.b("Hz"));
        this.b("cps", this.b("cycle").b(this.b("s")));
        this.b("b", "bit");
        this.c("baud", "Bd");
        this.c("kayser", this.b("m").a(-1).b(100.0));
        this.b("rps", this.b("revolution").b(this.b("s")));
        this.b("rpm", this.b("revolution").b(this.b("min")));
        this.a("geopotential", this.b("gravity"));
        this.c("work year", this.b("hours").b(2056.0));
        this.c("work month", this.b("work year").b(0.08333333333333333));
        this.c("count", "");
        this.b("gp", "geopotential");
        this.a("dynamic", "geopotential");
        this.b("gpm", this.b("geopotential").e(this.b("meter")));
    }

    public static UnitsDB a() throws UnitException {
        if (b == null) {
            Class clazz = f == null ? (f = DefaultUnitsDB.a("visad.data.units.DefaultUnitsDB")) : f;
            synchronized (clazz) {
                if (b == null) {
                    b = new DefaultUnitsDB();
                }
            }
        }
        return b;
    }

    public Unit b(String string) {
        Prefixer prefixer;
        Unit unit = super.b(string);
        if (unit == null && (prefixer = new Prefixer(this, string)).a(this.d, this.a) && (unit = this.b(prefixer.b())) != null) {
            try {
                unit = unit.b(prefixer.a());
            }
            catch (UnitException unitException) {
                unit = null;
            }
        }
        return unit;
    }

    public void b(String string, String string2) {
        this.d(string, super.b(string2));
    }

    public void b(String string, Unit unit) throws UnitException {
        this.d(string, unit.b(string));
    }

    public void c(String string, Unit unit) throws UnitException {
        unit = unit.b(string);
        this.e(string, unit);
        this.e(this.c(string), unit);
    }

    public void c(String string, String string2) {
        Unit unit = super.b(string2);
        this.e(string, unit);
        this.e(this.c(string), unit);
    }

    public void a(String string, Unit unit) throws UnitException {
        this.e(string, unit.b(string));
    }

    public void a(String string, String string2) {
        this.e(string, super.b(string2));
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class Prefixer {
        public final String b;
        public int c;
        public double a;
        private final DefaultUnitsDB d;

        public Prefixer(DefaultUnitsDB defaultUnitsDB, String string) {
            this.d = defaultUnitsDB;
            this.b = string;
            this.c = 0;
            this.a = 1.0;
        }

        public boolean a(UnitPrefix[] unitPrefixArray, UnitPrefix[] unitPrefixArray2) {
            int n2 = 0;
            while (n2 < unitPrefixArray.length) {
                UnitPrefix unitPrefix = unitPrefixArray[n2];
                if (this.b.regionMatches(true, this.c, unitPrefix.b, 0, unitPrefix.b.length())) {
                    this.a *= unitPrefix.a;
                    this.c += unitPrefix.b.length();
                    return true;
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < unitPrefixArray2.length) {
                UnitPrefix unitPrefix = unitPrefixArray2[n3];
                if (this.b.startsWith(unitPrefix.b, this.c)) {
                    this.a *= unitPrefix.a;
                    this.c += unitPrefix.b.length();
                    return true;
                }
                ++n3;
            }
            return false;
        }

        public String b() {
            return this.b.substring(this.c);
        }

        public double a() {
            return this.a;
        }
    }
}

