/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.DisplayException;
import visad.ErrorEstimate;
import visad.GriddedSet;
import visad.IrregularSet;
import visad.MathType;
import visad.ProductSet;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADIndexedTriangleStripArray;
import visad.VisADLineArray;
import visad.VisADLineStripArray;
import visad.VisADTriangleStripArray;

public class UnionSet
extends SampledSet {
    public SampledSet[] b;

    public UnionSet(MathType mathType, SampledSet[] sampledSetArray) throws VisADException {
        this(mathType, sampledSetArray, null, null, null, true);
    }

    private UnionSet(MathType mathType, SampledSet[] sampledSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, sampledSetArray, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public UnionSet(MathType mathType, SampledSet[] sampledSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2) throws VisADException {
        super(mathType, UnionSet.a(sampledSetArray), sampledSetArray[0].d(), sampledSetArray[0].h(), null);
        int n2;
        this.y = sampledSetArray[0].y;
        if (bl2) {
            this.b = new SampledSet[sampledSetArray.length];
            n2 = 0;
            while (n2 < sampledSetArray.length) {
                this.b[n2] = (SampledSet)sampledSetArray[n2].clone();
                ++n2;
            }
        } else {
            this.b = sampledSetArray;
        }
        this.B = 0;
        n2 = 0;
        while (n2 < sampledSetArray.length) {
            this.B += this.b[n2].B;
            ++n2;
        }
        this.j = new float[this.y];
        this.l = new float[this.y];
        int n3 = 0;
        while (n3 < this.y) {
            this.j[n3] = this.b[0].j[n3];
            this.l[n3] = this.b[0].l[n3];
            int n4 = 1;
            while (n4 < sampledSetArray.length) {
                if (sampledSetArray[n4].j[n3] < this.j[n3]) {
                    this.j[n3] = sampledSetArray[n4].j[n3];
                }
                if (sampledSetArray[n4].l[n3] > this.l[n3]) {
                    this.l[n3] = sampledSetArray[n4].l[n3];
                }
                ++n4;
            }
            ++n3;
        }
    }

    private static int a(SampledSet[] sampledSetArray) throws VisADException {
        if (sampledSetArray == null || sampledSetArray.length == 0 || sampledSetArray[0] == null) {
            throw new SetException("UnionSet: Sets cannot be missing");
        }
        if (sampledSetArray.length < 2) {
            return sampledSetArray[0].u;
        }
        int n2 = sampledSetArray[0].y;
        int n3 = sampledSetArray[0].u;
        CoordinateSystem coordinateSystem = sampledSetArray[0].d();
        Unit[] unitArray = sampledSetArray[0].h();
        int n4 = 1;
        while (n4 < sampledSetArray.length) {
            if (sampledSetArray[n4] == null) {
                throw new SetException("UnionSet: Sets cannot be missing");
            }
            if (sampledSetArray[n4].y != n2) {
                throw new SetException("UnionSet: set #" + n4 + " Domain dimension is " + sampledSetArray[n4].y + ", not " + n2);
            }
            if (sampledSetArray[n4].u != n3) {
                throw new SetException("UnionSet: set #" + n4 + " Manifold dimension is " + sampledSetArray[n4].u + ", not " + n3);
            }
            CoordinateSystem coordinateSystem2 = sampledSetArray[n4].d();
            if (!(coordinateSystem == null && coordinateSystem2 == null || coordinateSystem != null && coordinateSystem2 != null && coordinateSystem.equals(coordinateSystem2))) {
                throw new CoordinateSystemException("UnionSet: Coordinate system #" + n4 + " (" + (coordinateSystem2 == null ? null : coordinateSystem2.c()) + " must match #0 " + (coordinateSystem == null ? null : coordinateSystem.c()));
            }
            Unit[] unitArray2 = sampledSetArray[n4].h();
            if (unitArray != null || unitArray2 != null) {
                if (unitArray == null || unitArray2 == null || unitArray.length != unitArray2.length) {
                    throw new SetException("UnionSet: Expected " + (unitArray == null ? "null" : Integer.toString(unitArray.length)) + " units for set " + n4 + ", not " + (unitArray2 == null ? "null" : Integer.toString(unitArray2.length)));
                }
                int n5 = 0;
                while (n5 < unitArray.length) {
                    if (!(unitArray[n5] == null && unitArray2[n5] == null || unitArray[n5] != null && unitArray2[n5] != null && unitArray[n5].d(unitArray2[n5]))) {
                        throw new SetException("UnionSet: Expected set " + n4 + ", element " + n5 + " units to be " + unitArray[n5] + " not " + unitArray2[n5]);
                    }
                    ++n5;
                }
            }
            ++n4;
        }
        return n3;
    }

    public UnionSet(SampledSet[] sampledSetArray) throws VisADException {
        this(sampledSetArray[0].e(), sampledSetArray, null, null, null, true);
    }

    public SampledSet c() throws VisADException {
        int n2 = this.b.length;
        SampledSet[] sampledSetArray = new SampledSet[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (this.b[n4] instanceof GriddedSet || this.b[n4] instanceof IrregularSet) {
                sampledSetArray[n4] = this.b[n4];
            } else if (this.b[n4] instanceof ProductSet) {
                sampledSetArray[n4] = ((ProductSet)this.b[n4]).c();
            } else if (this.b[n4] instanceof UnionSet) {
                sampledSetArray[n4] = ((UnionSet)this.b[n4]).c();
            } else {
                throw new UnimplementedException("UnionSet.product: " + this.b[n4].getClass());
            }
            n3 = sampledSetArray[n4] instanceof UnionSet ? (n3 += ((UnionSet)sampledSetArray[n4]).b.length) : ++n3;
            ++n4;
        }
        SampledSet[] sampledSetArray2 = new SampledSet[n3];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            if (sampledSetArray[n6] instanceof UnionSet) {
                int n7 = 0;
                while (n7 < ((UnionSet)sampledSetArray[n6]).b.length) {
                    sampledSetArray2[n5++] = ((UnionSet)sampledSetArray[n6]).b[n7];
                    ++n7;
                }
            } else {
                sampledSetArray2[n5++] = sampledSetArray[n6];
            }
            ++n6;
        }
        return new UnionSet(this.e(), sampledSetArray2);
    }

    public SampledSet a(SampledSet sampledSet) throws VisADException {
        int n2 = this.b.length;
        SampledSet[] sampledSetArray = new SampledSet[n2];
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n2) {
            if (this.b[n3] instanceof ProductSet) {
                sampledSetArray[n3] = ((ProductSet)this.b[n3]).a(sampledSet);
            } else if (sampledSet instanceof ProductSet) {
                sampledSetArray[n3] = ((ProductSet)sampledSet).b(this.b[n3]);
            } else if (sampledSet instanceof UnionSet) {
                sampledSetArray[n3] = ((UnionSet)sampledSet).b(this.b[n3]);
                bl2 = true;
            } else {
                sampledSetArray[n3] = new ProductSet(new SampledSet[]{this.b[n3], sampledSet});
            }
            ++n3;
        }
        SampledSet sampledSet2 = new UnionSet(sampledSetArray);
        if (bl2) {
            sampledSet2 = sampledSet2.c();
        }
        return sampledSet2;
    }

    public SampledSet b(SampledSet sampledSet) throws VisADException {
        int n2 = this.b.length;
        SampledSet[] sampledSetArray = new SampledSet[n2];
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n2) {
            if (this.b[n3] instanceof ProductSet) {
                sampledSetArray[n3] = ((ProductSet)this.b[n3]).b(sampledSet);
            } else if (sampledSet instanceof ProductSet) {
                sampledSetArray[n3] = ((ProductSet)sampledSet).a(this.b[n3]);
            } else if (sampledSet instanceof UnionSet) {
                sampledSetArray[n3] = ((UnionSet)sampledSet).a(this.b[n3]);
                bl2 = true;
            } else {
                sampledSetArray[n3] = new ProductSet(new SampledSet[]{sampledSet, this.b[n3]});
            }
            ++n3;
        }
        SampledSet sampledSet2 = new UnionSet(sampledSetArray);
        if (bl2) {
            sampledSet2 = sampledSet2.c();
        }
        return sampledSet2;
    }

    public Set a(SetType setType, float[][] fArray) throws VisADException {
        int n2 = this.b.length;
        int n3 = fArray.length;
        SampledSet[] sampledSetArray = new SampledSet[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = this.b[n5].B;
            float[][] fArray2 = new float[n3][n6];
            int n7 = 0;
            while (n7 < n3) {
                int n8 = 0;
                while (n8 < n6) {
                    fArray2[n7][n8] = fArray[n7][n4 + n8];
                    ++n8;
                }
                ++n7;
            }
            sampledSetArray[n5] = (SampledSet)this.b[n5].a(setType, fArray2);
            n4 += n6;
            ++n5;
        }
        UnionSet unionSet = new UnionSet((SetType)sampledSetArray[0].e(), sampledSetArray);
        return unionSet;
    }

    public void a(boolean[] blArray) {
        int n2 = blArray.length;
        int n3 = this.b.length;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            try {
                n6 = this.b[n5].r();
            }
            catch (VisADException visADException) {
                return;
            }
            if (n4 + n6 > n2) {
                return;
            }
            boolean[] blArray2 = new boolean[n6];
            System.arraycopy(blArray, n4, blArray2, 0, n6);
            this.b[n5].a(blArray2);
            n4 += n6;
            ++n5;
        }
    }

    public VisADGeometryArray a(byte[][] byArray, boolean bl2) throws VisADException {
        if (this.y != 3) {
            throw new SetException("UnionSet.make2DGeometry: DomainDimension must be 3, not " + this.y);
        }
        if (this.u != 2) {
            throw new SetException("UnionSet.make2DGeometry: ManifoldDimension must be 2, not " + this.u);
        }
        int n2 = this.b.length;
        int n3 = this.y;
        if (byArray != null && n3 != byArray.length) {
            throw new SetException("UnionSet.make2DGeometry: color_values dimension should be " + n3 + ", not " + byArray.length);
        }
        if (bl2) {
            VisADIndexedTriangleStripArray[] visADIndexedTriangleStripArrayArray = new VisADIndexedTriangleStripArray[n2];
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                VisADGeometryArray visADGeometryArray;
                int n6 = this.b[n5].B;
                byte[][] byArray2 = null;
                if (byArray != null) {
                    byArray2 = new byte[n3][n6];
                    int n7 = 0;
                    while (n7 < n3) {
                        int n8 = 0;
                        while (n8 < n6) {
                            byArray2[n7][n8] = byArray[n7][n4 + n8];
                            ++n8;
                        }
                        ++n7;
                    }
                }
                visADIndexedTriangleStripArrayArray[n5] = (visADGeometryArray = this.b[n5].a(byArray2, bl2)) instanceof VisADIndexedTriangleStripArray ? (VisADIndexedTriangleStripArray)visADGeometryArray : null;
                n4 += n6;
                ++n5;
            }
            return VisADIndexedTriangleStripArray.a(visADIndexedTriangleStripArrayArray);
        }
        VisADTriangleStripArray[] visADTriangleStripArrayArray = new VisADTriangleStripArray[n2];
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            VisADGeometryArray visADGeometryArray;
            int n11 = this.b[n10].B;
            byte[][] byArray3 = null;
            if (byArray != null) {
                byArray3 = new byte[n3][n11];
                int n12 = 0;
                while (n12 < n3) {
                    int n13 = 0;
                    while (n13 < n11) {
                        byArray3[n12][n13] = byArray[n12][n9 + n13];
                        ++n13;
                    }
                    ++n12;
                }
            }
            visADTriangleStripArrayArray[n10] = (visADGeometryArray = this.b[n10].a(byArray3, bl2)) instanceof VisADTriangleStripArray ? (VisADTriangleStripArray)visADGeometryArray : null;
            n9 += n11;
            ++n10;
        }
        return VisADTriangleStripArray.a(visADTriangleStripArrayArray);
    }

    public VisADGeometryArray a(byte[][] byArray) throws VisADException {
        if (this.y != 3) {
            throw new SetException("UnionSet.make1DGeometry: DomainDimension must be 3, not " + this.y);
        }
        if (this.u != 1) {
            throw new SetException("UnionSet.make1DGeometry: ManifoldDimension must be 1, not " + this.u);
        }
        int n2 = this.b.length;
        int n3 = this.y;
        if (byArray != null && n3 != byArray.length) {
            throw new SetException("UnionSet.make1DGeometry: color_values dimension should be " + n3 + ", not " + byArray.length);
        }
        VisADLineStripArray[] visADLineStripArrayArray = new VisADLineStripArray[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            VisADGeometryArray visADGeometryArray;
            int n6 = this.b[n5].B;
            byte[][] byArray2 = null;
            if (byArray != null) {
                byArray2 = new byte[n3][n6];
                int n7 = 0;
                while (n7 < n3) {
                    int n8 = 0;
                    while (n8 < n6) {
                        byArray2[n7][n8] = byArray[n7][n4 + n8];
                        ++n8;
                    }
                    ++n7;
                }
            }
            visADLineStripArrayArray[n5] = (visADGeometryArray = this.b[n5].a(byArray2)) instanceof VisADLineStripArray ? (VisADLineStripArray)visADGeometryArray : null;
            n4 += n6;
            ++n5;
        }
        VisADLineStripArray visADLineStripArray = VisADLineStripArray.a(visADLineStripArrayArray);
        return visADLineStripArray;
    }

    public VisADGeometryArray[][] a(float[] fArray, float f2, float f3, float f4, float[] fArray2, byte[][] byArray, boolean[] blArray, boolean bl2, boolean bl3, ScalarMap[] scalarMapArray, double d2, double d3, float[][][] fArray3) throws VisADException {
        int n2;
        int n3;
        Object[] objectArray;
        if (this.y != 3) {
            throw new DisplayException("UnionSet.makeIsoLines: DomainDimension must be 3, not " + this.y);
        }
        if (this.u != 2) {
            throw new DisplayException("UnionSet.makeIsoLines: ManifoldDimension must be 2, not " + this.u);
        }
        int n4 = this.b.length;
        int n5 = byArray.length;
        if (n5 != this.y) {
            throw new SetException("UnionSet.makeIsoLines: color_values dimension should be " + this.y + ", not " + n5);
        }
        VisADLineArray[][][] visADLineArrayArrayArray = new VisADLineArray[n4][][];
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = this.b[n7].B;
            byte[][] byArray2 = new byte[n5][n8];
            objectArray = new float[n8];
            n3 = 0;
            while (n3 < n5) {
                n2 = 0;
                while (n2 < n8) {
                    byArray2[n3][n2] = byArray[n3][n6 + n2];
                    ++n2;
                }
                ++n3;
            }
            n2 = 0;
            while (n2 < n8) {
                objectArray[n2] = fArray2[n6 + n2];
                ++n2;
            }
            visADLineArrayArrayArray[n7] = (VisADLineArray[][])this.b[n7].a(fArray, f2, f3, f4, (float[])objectArray, byArray2, blArray, bl2, bl3, scalarMapArray, d2, d3, fArray3);
            n6 += n8;
            ++n7;
        }
        VisADGeometryArray[][] visADGeometryArrayArray = new VisADLineArray[4][];
        int n9 = 0;
        while (n9 < 2) {
            visADGeometryArrayArray[n9] = new VisADLineArray[1];
            objectArray = new VisADLineArray[n4];
            n3 = 0;
            while (n3 < n4) {
                objectArray[n3] = (float)visADLineArrayArrayArray[n3][n9][0];
                ++n3;
            }
            visADGeometryArrayArray[n9][0] = VisADLineArray.a((VisADLineArray[])objectArray);
            ++n9;
        }
        int n10 = 2;
        while (n10 < 4) {
            n3 = 0;
            n2 = 0;
            while (n2 < n4) {
                n3 += visADLineArrayArrayArray[n2][n10].length;
                ++n2;
            }
            visADGeometryArrayArray[n10] = new VisADLineArray[n3];
            n3 = 0;
            int n11 = 0;
            while (n11 < n4) {
                int n12 = 0;
                while (n12 < n4) {
                    visADGeometryArrayArray[n10][n3++] = visADLineArrayArrayArray[n11][n10][n12];
                    ++n12;
                }
                ++n11;
            }
            ++n10;
        }
        return visADGeometryArrayArray;
    }

    public VisADGeometryArray a(float f2, float[] fArray, byte[][] byArray, boolean bl2) throws VisADException {
        if (this.y != 3) {
            throw new DisplayException("UnionSet.makeIsoSurface: DomainDimension must be 3, not " + this.y);
        }
        if (this.u != 3) {
            throw new DisplayException("UnionSet.makeIsoSurface: ManifoldDimension must be 3, not " + this.u);
        }
        int n2 = this.b.length;
        int n3 = byArray.length;
        if (n3 != this.y) {
            throw new SetException("UnionSet.makeIsoSurface: color_values dimension should be " + this.y + ", not " + n3);
        }
        if (bl2) {
            VisADIndexedTriangleStripArray[] visADIndexedTriangleStripArrayArray = new VisADIndexedTriangleStripArray[n2];
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                int n6;
                int n7 = this.b[n5].B;
                byte[][] byArray2 = new byte[n3][n7];
                float[] fArray2 = new float[n7];
                int n8 = 0;
                while (n8 < n3) {
                    n6 = 0;
                    while (n6 < n7) {
                        byArray2[n8][n6] = byArray[n8][n4 + n6];
                        ++n6;
                    }
                    ++n8;
                }
                n6 = 0;
                while (n6 < n7) {
                    fArray2[n6] = fArray[n4 + n6];
                    ++n6;
                }
                visADIndexedTriangleStripArrayArray[n5] = (VisADIndexedTriangleStripArray)this.b[n5].a(f2, fArray2, byArray2, bl2);
                n4 += n7;
                ++n5;
            }
            return VisADIndexedTriangleStripArray.a(visADIndexedTriangleStripArrayArray);
        }
        VisADTriangleStripArray[] visADTriangleStripArrayArray = new VisADTriangleStripArray[n2];
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11;
            int n12 = this.b[n10].B;
            byte[][] byArray3 = new byte[n3][n12];
            float[] fArray3 = new float[n12];
            int n13 = 0;
            while (n13 < n3) {
                n11 = 0;
                while (n11 < n12) {
                    byArray3[n13][n11] = byArray[n13][n9 + n11];
                    ++n11;
                }
                ++n13;
            }
            n11 = 0;
            while (n11 < n12) {
                fArray3[n11] = fArray[n9 + n11];
                ++n11;
            }
            visADTriangleStripArrayArray[n10] = (VisADTriangleStripArray)this.b[n10].a(f2, fArray3, byArray3, bl2);
            n9 += n12;
            ++n10;
        }
        return VisADTriangleStripArray.a(visADTriangleStripArrayArray);
    }

    public float[][] a(boolean bl2) throws VisADException {
        int n2 = this.r();
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = n3;
            ++n3;
        }
        return this.b(nArray);
    }

    public float[][] b(int[] nArray) throws VisADException {
        int n2;
        int n3;
        int n4 = this.b.length;
        int n5 = nArray.length;
        float[][] fArray = new float[this.y][n5];
        if (n5 == this.r()) {
            boolean bl2 = true;
            int n6 = 0;
            while (n6 < n5) {
                if (nArray[n6] != n6) {
                    bl2 = false;
                    break;
                }
                ++n6;
            }
            if (bl2) {
                int n7 = 0;
                int n8 = 0;
                while (n8 < n4) {
                    int n9 = this.b[n8].r();
                    int[] nArray2 = new int[n9];
                    int n10 = 0;
                    while (n10 < n9) {
                        nArray2[n10] = n10;
                        ++n10;
                    }
                    float[][] fArray2 = this.b[n8].b(nArray2);
                    int n11 = 0;
                    while (n11 < this.y) {
                        System.arraycopy(fArray2[n11], 0, fArray[n11], n7, n9);
                        ++n11;
                    }
                    n7 += n9;
                    ++n8;
                }
                return fArray;
            }
        }
        int[][] nArrayArray = new int[n4][];
        int[] nArray3 = new int[n4];
        int[] nArray4 = new int[n5];
        int[] nArray5 = new int[n5];
        int n12 = 0;
        while (n12 < n5) {
            n3 = 0;
            n2 = nArray[n12];
            while (n3 < n4 && n2 >= this.b[n3].B) {
                n2 -= this.b[n3++].B;
            }
            if (n3 == n4) {
                n2 += this.b[--n3].B;
            }
            int n13 = n3;
            nArray3[n13] = nArray3[n13] + 1;
            nArray4[n12] = n3;
            nArray5[n12] = n2;
            ++n12;
        }
        n3 = 0;
        while (n3 < n4) {
            nArrayArray[n3] = nArray3[n3] > 0 ? new int[nArray3[n3]] : null;
            nArray3[n3] = 0;
            ++n3;
        }
        n2 = 0;
        while (n2 < n5) {
            int n14 = nArray4[n2];
            int n15 = nArray3[n14];
            nArray3[n14] = n15 + 1;
            nArrayArray[nArray4[n2]][n15] = nArray5[n2];
            ++n2;
        }
        float[][][] fArrayArray = new float[n4][][];
        int n16 = 0;
        while (n16 < n4) {
            if (nArrayArray[n16] != null) {
                fArrayArray[n16] = this.b[n16].b(nArrayArray[n16]);
            }
            ++n16;
        }
        int n17 = 0;
        while (n17 < n4) {
            nArray3[n17] = 0;
            ++n17;
        }
        int n18 = 0;
        while (n18 < n5) {
            int n19 = 0;
            while (n19 < this.y) {
                fArray[n19][n18] = fArrayArray[nArray4[n18]][n19][nArray3[nArray4[n18]]];
                ++n19;
            }
            int n20 = nArray4[n18];
            nArray3[n20] = nArray3[n20] + 1;
            ++n18;
        }
        return fArray;
    }

    public int[] b(float[][] fArray) throws VisADException {
        int n2 = this.b.length;
        int n3 = fArray[0].length;
        int[] nArray = new int[n3];
        int[][] nArrayArray = new int[n2][];
        int n4 = 0;
        while (n4 < n2) {
            nArrayArray[n4] = this.b[n4].b(fArray);
            ++n4;
        }
        float[][][] fArrayArray = new float[n2][][];
        int n5 = 0;
        while (n5 < n2) {
            fArrayArray[n5] = this.b[n5].b(nArrayArray[n5]);
            ++n5;
        }
        int n6 = 0;
        while (n6 < n3) {
            int n7;
            float[] fArray2 = new float[n2];
            int n8 = 0;
            int n9 = 0;
            while (n9 < n2) {
                fArray2[n9] = 0.0f;
                n7 = 0;
                while (n7 < this.y) {
                    if (nArrayArray[n9][n6] == -1) {
                        fArray2[n9] = Float.MAX_VALUE;
                        break;
                    }
                    float f2 = fArrayArray[n9][n7][n6] - fArray[n7][n6];
                    int n10 = n9;
                    fArray2[n10] = fArray2[n10] + f2 * f2;
                    ++n7;
                }
                if (fArray2[n8] > fArray2[n9]) {
                    n8 = n9;
                }
                ++n9;
            }
            n7 = nArrayArray[n8][n6];
            while (n8 > 0) {
                n7 += this.b[--n8].B;
            }
            nArray[n6] = n7;
            ++n6;
        }
        return nArray;
    }

    public void a(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        int n2 = this.b.length;
        int n3 = nArray.length;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            int[][] nArrayArray = new int[n3][];
            float[][] fArrayArray = new float[n3][];
            this.b[n5].a(fArray, nArrayArray, fArrayArray);
            int n6 = 0;
            while (n6 < n3) {
                if (nArray[n6] == null && nArrayArray[n6] != null) {
                    int n7 = nArrayArray[n6].length;
                    nArray[n6] = new int[n7];
                    fArray2[n6] = new float[n7];
                    int n8 = 0;
                    while (n8 < n7) {
                        nArray[n6][n8] = nArrayArray[n6][n8] + n4;
                        fArray2[n6][n8] = fArrayArray[n6][n8];
                        ++n8;
                    }
                }
                ++n6;
            }
            n4 += this.b[n5].r();
            ++n5;
        }
    }

    public Object clone() {
        UnionSet unionSet = (UnionSet)super.clone();
        if (this.b != null) {
            unionSet.b = new SampledSet[this.b.length];
            int n2 = 0;
            while (n2 < this.b.length) {
                unionSet.b[n2] = (SampledSet)this.b[n2].clone();
                ++n2;
            }
        }
        return unionSet;
    }

    public Object c(MathType mathType) throws VisADException {
        return new UnionSet(mathType, this.b, this.w, this.q, this.C);
    }

    public boolean equals(Object object) {
        if (!(object instanceof UnionSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        UnionSet unionSet = (UnionSet)object;
        if (unionSet.y != this.y || unionSet.u != this.u) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.b.length) {
            if (!this.b[n2].equals(unionSet.b[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        if (!this.t) {
            this.d = this.y ^ this.u;
            int n2 = 0;
            while (n2 < this.b.length) {
                this.d ^= this.b[n2].hashCode();
                ++n2;
            }
            this.t = true;
        }
        return this.d;
    }

    public boolean j() {
        int n2 = 0;
        while (n2 < this.b.length) {
            if (this.b[n2].j()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String a(String string) throws VisADException {
        String string2 = string + "UnionSet: Dimension = " + this.y + " Length = " + this.r() + "\n";
        int n2 = this.b.length;
        int n3 = 0;
        while (n3 < n2) {
            string2 = string2 + this.b[n3].toString();
            ++n3;
        }
        return string2;
    }
}

