/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.DataShadow;
import visad.ErrorEstimate;
import visad.MathType;
import visad.RealType;
import visad.SampledSetIface;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowSetType;
import visad.ShadowType;
import visad.SimpleSet;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineStripArray;
import visad.VisADPointArray;

public abstract class SampledSet
extends SimpleSet
implements SampledSetIface {
    public float[][] k;
    public float[] j;
    public float[] l;

    public SampledSet(MathType mathType, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        super(mathType, n2, coordinateSystem, unitArray, errorEstimateArray);
        this.j = new float[this.y];
        this.l = new float[this.y];
    }

    public SampledSet(MathType mathType) throws VisADException {
        this(mathType, null, null, null);
    }

    public SampledSet(MathType mathType, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        super(mathType, coordinateSystem, unitArray, errorEstimateArray);
        this.j = new float[this.y];
        this.l = new float[this.y];
    }

    public void e(float[][] fArray) throws VisADException {
        this.a(fArray, true);
    }

    public void a(float[][] fArray, boolean bl2) throws VisADException {
        if (fArray.length != this.y) {
            throw new SetException("SampledSet.init_samples: sample dimension " + fArray.length + " doesn't match expected length " + this.y);
        }
        if (this.B == 0) {
            this.B = fArray[0].length;
        } else if (this.B != fArray[0].length) {
            throw new SetException("SampledSet.init_samples: sample#0 length " + fArray[0].length + " doesn't match expected length " + this.B);
        }
        this.k = bl2 ? new float[this.y][this.B] : fArray;
        int n2 = 0;
        while (n2 < this.y) {
            if (fArray[n2].length != this.B) {
                throw new SetException("SampledSet.init_samples: sample#" + n2 + " length " + fArray[n2].length + " doesn't match expected length " + this.B);
            }
            float[] fArray2 = fArray[n2];
            float[] fArray3 = this.k[n2];
            if (bl2) {
                System.arraycopy(fArray2, 0, fArray3, 0, this.B);
            }
            this.j[n2] = Float.POSITIVE_INFINITY;
            this.l[n2] = Float.NEGATIVE_INFINITY;
            float f2 = 0.0f;
            int n3 = 0;
            while (n3 < this.B) {
                if (fArray3[n3] == fArray3[n3] && !Float.isInfinite(fArray3[n3])) {
                    if (fArray3[n3] < this.j[n2]) {
                        this.j[n2] = fArray3[n3];
                    }
                    if (fArray3[n3] > this.l[n2]) {
                        this.l[n2] = fArray3[n3];
                    }
                } else {
                    fArray3[n3] = Float.NaN;
                }
                f2 += fArray3[n3];
                ++n3;
            }
            if (this.C[n2] != null) {
                this.C[n2] = new ErrorEstimate(this.C[n2].a(), f2 / (float)this.B, this.B, this.C[n2].d());
            }
            ++n2;
        }
    }

    public void a(boolean[] blArray) {
        int n2 = Math.min(blArray.length, this.k[0].length);
        int n3 = 0;
        while (n3 < n2) {
            if (!blArray[n3]) {
                this.k[0][n3] = Float.NaN;
            }
            ++n3;
        }
    }

    public boolean j() {
        return this.k == null;
    }

    public float[][] a(boolean bl2) throws VisADException {
        return bl2 ? Set.a(this.k) : this.k;
    }

    public DataShadow a(ShadowType shadowType, DataShadow dataShadow) throws VisADException {
        int n2 = this.s();
        double[][] dArray = new double[2][n2];
        return this.a(shadowType, dataShadow, dArray, false);
    }

    public DataShadow a(ShadowType shadowType, DataShadow dataShadow, double[][] dArray, boolean bl2) throws VisADException {
        ShadowRealTupleType shadowRealTupleType;
        if (this.j()) {
            return dataShadow;
        }
        this.a(shadowType, dataShadow, bl2);
        int[] nArray = new int[this.y];
        int n2 = 0;
        while (n2 < this.y) {
            ShadowRealType shadowRealType = null;
            if (shadowType instanceof ShadowSetType) {
                shadowRealType = (ShadowRealType)((ShadowSetType)shadowType).h().e(n2);
            } else if (shadowType instanceof ShadowRealTupleType) {
                shadowRealType = (ShadowRealType)((ShadowRealTupleType)shadowType).e(n2);
            } else {
                throw new TypeException("SampledSet.computeRanges: bad ShadowType " + shadowType.getClass().getName());
            }
            nArray[n2] = shadowRealType.v();
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.y) {
            int n4 = nArray[n3];
            double d2 = this.j[n3];
            double d3 = this.l[n3];
            Unit unit = ((RealType)((SetType)this.a).b().b(n3)).e();
            if (unit != null && !unit.d(this.q[n3])) {
                d2 = unit.a(d2, this.q[n3]);
                d3 = unit.a(d3, this.q[n3]);
            }
            if (dArray != null) {
                dArray[0][n3] = d2;
                dArray[1][n3] = d3;
            }
            if (n4 >= 0 && n4 < dataShadow.b[0].length) {
                dataShadow.b[0][n4] = Math.min(dataShadow.b[0][n4], d2);
                dataShadow.b[1][n4] = Math.max(dataShadow.b[1][n4], d3);
            }
            ++n3;
        }
        ShadowRealTupleType shadowRealTupleType2 = null;
        if (shadowType instanceof ShadowRealTupleType) {
            shadowRealTupleType2 = (ShadowRealTupleType)shadowType;
        } else if (shadowType instanceof ShadowSetType) {
            shadowRealTupleType2 = ((ShadowSetType)shadowType).h();
        }
        if (shadowRealTupleType2 != null && dArray != null && (shadowRealTupleType = shadowRealTupleType2.F()) != null) {
            dataShadow = this.a(shadowRealTupleType2, this.w, ((SetType)this.a).b().g(), dataShadow, shadowRealTupleType, dArray);
        }
        return dataShadow;
    }

    public VisADGeometryArray a(byte[][] byArray) throws VisADException {
        if (this.y != 3) {
            throw new SetException("SampledSet.make1DGeometry: DomainDimension must be 3, not " + this.y);
        }
        if (this.u != 1) {
            throw new SetException("SampledSet.make1DGeometry: ManifoldDimension must be 1, not " + this.u);
        }
        VisADGeometryArray visADGeometryArray = null;
        if (this.B == 0) {
            return null;
        }
        if (this.B == 1) {
            visADGeometryArray = new VisADPointArray();
        } else {
            visADGeometryArray = new VisADLineStripArray();
            ((VisADLineStripArray)visADGeometryArray).k = new int[1];
            ((VisADLineStripArray)visADGeometryArray).k[0] = this.B;
        }
        this.a(visADGeometryArray, 3, byArray);
        return visADGeometryArray;
    }

    public void a(VisADGeometryArray visADGeometryArray, int n2, byte[][] byArray) throws VisADException {
        SampledSet.a(visADGeometryArray, this.a(false), n2, byArray);
    }

    public static void a(VisADGeometryArray visADGeometryArray, float[][] fArray, int n2, byte[][] byArray) throws VisADException {
        int n3;
        if (fArray == null) {
            throw new SetException("SampledSet.setGeometryArray: Null samples array");
        }
        if (fArray.length != 3) {
            throw new SetException("SampledSet.setGeometryArray: Expected 3 dimensions in samples array, not " + fArray.length);
        }
        visADGeometryArray.e = n3 = fArray[0].length;
        float[] fArray2 = new float[3 * n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            fArray2[n4++] = fArray[0][n5];
            fArray2[n4++] = fArray[1][n5];
            fArray2[n4++] = fArray[2][n5];
            ++n5;
        }
        visADGeometryArray.j = fArray2;
        if (byArray != null) {
            n2 = Math.min(n2, byArray.length);
            byte[] byArray2 = new byte[n2 * n3];
            n4 = 0;
            if (n2 == 4) {
                int n6 = 0;
                while (n6 < n3) {
                    byArray2[n4++] = byArray[0][n6];
                    byArray2[n4++] = byArray[1][n6];
                    byArray2[n4++] = byArray[2][n6];
                    byArray2[n4++] = byArray[3][n6];
                    ++n6;
                }
            } else if (n2 == 3) {
                int n7 = 0;
                while (n7 < n3) {
                    byArray2[n4++] = byArray[0][n7];
                    byArray2[n4++] = byArray[1][n7];
                    byArray2[n4++] = byArray[2][n7];
                    ++n7;
                }
            } else {
                throw new SetException("SampledSet.setGeometryArray: color_length must be 3 or 4, not " + n2);
            }
            visADGeometryArray.i = byArray2;
        }
    }

    public float[] a() {
        float[] fArray = new float[this.j.length];
        int n2 = 0;
        while (n2 < this.j.length) {
            fArray[n2] = this.j[n2];
            ++n2;
        }
        return fArray;
    }

    public float[] t() {
        float[] fArray = new float[this.l.length];
        int n2 = 0;
        while (n2 < this.l.length) {
            fArray[n2] = this.l[n2];
            ++n2;
        }
        return fArray;
    }

    public Object clone() {
        SampledSet sampledSet = (SampledSet)super.clone();
        if (sampledSet.k != null) {
            sampledSet.k = new float[this.k.length][];
            int n2 = 0;
            while (n2 < this.k.length) {
                sampledSet.k[n2] = (float[])this.k[n2].clone();
                ++n2;
            }
        }
        return sampledSet;
    }
}

