/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.CommonUnit;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.DateTime;
import visad.ErrorEstimate;
import visad.Field;
import visad.MathType;
import visad.RealIface;
import visad.RealType;
import visad.Scalar;
import visad.ShadowRealType;
import visad.ShadowType;
import visad.Text;
import visad.TupleIface;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public class Real
extends Scalar
implements RealIface {
    private final double d;
    private final Unit i;
    private final ErrorEstimate k;

    public Real(RealType realType, double d2, Unit unit, ErrorEstimate errorEstimate) throws VisADException {
        super(realType);
        if (!Unit.a(unit, realType.e())) {
            throw new UnitException("Real: Unit \"" + unit + "\" must be convertable" + " with Type default Unit \"" + realType.e() + "\"");
        }
        this.i = unit != null && realType.d() ? unit.b() : unit;
        this.d = d2;
        this.k = Double.isNaN(d2) ? null : errorEstimate;
    }

    public Real(RealType realType, double d2, Unit unit) throws VisADException {
        this(realType, d2, unit, null);
    }

    public Real(RealType realType, double d2) {
        this(realType, d2, realType.e(), null, true);
    }

    public Real(RealType realType) {
        this(realType, Double.NaN, realType.e(), null, true);
    }

    public Real(double d2) {
        this(RealType.u, d2, RealType.u.e(), new ErrorEstimate(d2, 0.0, RealType.u.e()), true);
    }

    private Real(RealType realType, double d2, Unit unit, ErrorEstimate errorEstimate, boolean bl2) {
        super(realType);
        this.i = unit != null && realType.d() ? unit.b() : unit;
        this.d = d2;
        this.k = Double.isNaN(d2) ? null : errorEstimate;
    }

    public final double a() {
        return this.d;
    }

    public final double a(Unit unit) throws VisADException {
        if (unit == null) {
            if (this.i != null) {
                throw new UnitException("Real.getValue: illegal Unit conversion");
            }
            return this.d;
        }
        if (this.i == null) {
            throw new UnitException("Real.getValue: illegal Unit conversion");
        }
        if (((RealType)this.e()).d()) {
            unit = unit.b();
        }
        return unit.a(this.d, this.i);
    }

    public boolean j() {
        return Double.isNaN(this.d);
    }

    public Data a(Data data, int n2, MathType mathType, int n3, int n4) throws VisADException, RemoteException {
        if (mathType == null) {
            throw new TypeException("binary: new_type may not be null");
        }
        if (data instanceof Real) {
            Real real = (Real)data;
            if (!(mathType instanceof RealType)) {
                throw new TypeException("binary: new_type doesn't match return type");
            }
            Unit unit = this.d();
            Unit unit2 = real.d();
            double d2 = this.a();
            double d3 = real.a();
            ErrorEstimate errorEstimate = this.c();
            ErrorEstimate errorEstimate2 = real.c();
            Unit unit3 = null;
            double d4 = Double.NaN;
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 9: 
                case 10: {
                    if (unit == null || unit2 == null) {
                        unit3 = null;
                    } else if (unit == CommonUnit.d) {
                        unit3 = unit2.b();
                    } else if (unit2 == CommonUnit.d) {
                        unit3 = unit.b();
                    } else {
                        try {
                            unit3 = unit.b();
                            d2 = unit3.a(d2, unit);
                            d3 = unit3.a(d3, unit2);
                            if (n4 != 202 && errorEstimate != null && errorEstimate2 != null) {
                                double d5;
                                Unit unit4;
                                if (!unit3.d(unit)) {
                                    unit4 = errorEstimate.d();
                                    if (unit4 == null) {
                                        unit4 = unit;
                                    }
                                    d5 = unit3.a(errorEstimate.a(), unit4);
                                    errorEstimate = new ErrorEstimate(d2, d5, unit3);
                                }
                                if (!unit3.d(unit2)) {
                                    unit4 = errorEstimate2.d();
                                    if (unit4 == null) {
                                        unit4 = unit2;
                                    }
                                    d5 = unit3.a(errorEstimate2.a(), unit4);
                                    errorEstimate2 = new ErrorEstimate(d3, d5, unit3);
                                }
                            }
                        }
                        catch (UnitException unitException) {
                            unit3 = null;
                        }
                    }
                    switch (n2) {
                        case 1: {
                            d4 = d2 + d3;
                            break;
                        }
                        case 2: {
                            d4 = d2 - d3;
                            break;
                        }
                        case 3: {
                            d4 = d3 - d2;
                            break;
                        }
                        case 9: {
                            d4 = Math.max(d2, d3);
                            break;
                        }
                        case 10: {
                            d4 = Math.min(d2, d3);
                        }
                    }
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    Unit unit5;
                    if (unit != null) {
                        unit5 = unit.b();
                        d2 = unit5.a(d2, unit);
                        unit = unit5;
                    }
                    if (unit2 != null) {
                        unit5 = unit2.b();
                        d3 = unit5.a(d3, unit2);
                        unit2 = unit5;
                    }
                    if (unit == null || unit2 == null) {
                        unit3 = null;
                    } else {
                        switch (n2) {
                            case 4: {
                                unit3 = unit.d(CommonUnit.d) ? unit2 : (unit2.d(CommonUnit.d) ? unit : unit.e(unit2));
                                break;
                            }
                            case 5: {
                                unit3 = unit2.d(CommonUnit.d) ? unit : unit.b(unit2);
                                break;
                            }
                            case 6: {
                                unit3 = unit.d(CommonUnit.d) ? unit2 : unit2.b(unit);
                            }
                        }
                    }
                    switch (n2) {
                        case 4: {
                            d4 = d2 * d3;
                            break;
                        }
                        case 5: {
                            d4 = d2 / d3;
                            break;
                        }
                        case 6: {
                            d4 = d3 / d2;
                        }
                    }
                    break;
                }
                case 7: {
                    Unit unit6;
                    if (unit != null) {
                        unit6 = unit.b();
                        d2 = unit6.a(d2, unit);
                        unit = unit6;
                    }
                    if (unit2 != null && !CommonUnit.d.d(this.i)) {
                        unit6 = unit2.b();
                        d3 = unit6.a(d3, unit2);
                        unit2 = unit6;
                    }
                    unit3 = unit != null && (unit.d(CommonUnit.d) || unit.d(CommonUnit.a)) ? unit : null;
                    d4 = Math.pow(d2, d3);
                    break;
                }
                case 8: {
                    Unit unit7;
                    if (unit2 != null) {
                        unit7 = unit2.b();
                        d3 = unit7.a(d3, unit2);
                        unit2 = unit7;
                    }
                    if (unit != null && !CommonUnit.d.d(this.i)) {
                        unit7 = unit.b();
                        d2 = unit7.a(d2, unit);
                        unit = unit7;
                    }
                    unit3 = unit2 != null && (unit2.d(CommonUnit.d) || unit2.d(CommonUnit.a)) ? unit2 : null;
                    d4 = Math.pow(d3, d2);
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    if (unit != null && unit2 != null) {
                        Unit unit8 = unit.b();
                        d2 = unit8.a(d2, unit);
                        d3 = unit8.a(d3, unit2);
                        unit = unit8;
                        unit2 = unit8;
                    }
                    switch (n2) {
                        case 11: {
                            d4 = Math.atan2(d2, d3);
                            unit3 = CommonUnit.c;
                            break;
                        }
                        case 12: {
                            d4 = 57.29577951308232 * Math.atan2(d2, d3);
                            unit3 = CommonUnit.g;
                            break;
                        }
                        case 13: {
                            d4 = Math.atan2(d3, d2);
                            unit3 = CommonUnit.c;
                            break;
                        }
                        case 14: {
                            d4 = 57.29577951308232 * Math.atan2(d3, d2);
                            unit3 = CommonUnit.g;
                            break;
                        }
                        case 15: {
                            d4 = d2 % d3;
                            unit3 = unit;
                            break;
                        }
                        case 16: {
                            d4 = d3 % d2;
                            unit3 = unit2;
                        }
                    }
                    break;
                }
                default: {
                    throw new ArithmeticException("Real.binary: illegal operation");
                }
            }
            if (n4 == 202 || errorEstimate == null || errorEstimate2 == null) {
                return new Real((RealType)mathType, d4, unit3, null);
            }
            return new Real((RealType)mathType, d4, unit3, new ErrorEstimate(d4, unit3, n2, errorEstimate, errorEstimate2, n4));
        }
        if (data instanceof Text) {
            throw new TypeException("Real.binary: types don't match");
        }
        if (data instanceof TupleIface) {
            if (!data.e().a(mathType)) {
                throw new TypeException();
            }
            return data.a(this, DataImpl.a(n2), mathType, n3, n4);
        }
        if (data instanceof Field) {
            if (!data.e().a(mathType)) {
                throw new TypeException();
            }
            return data.a(this, DataImpl.a(n2), mathType, n3, n4);
        }
        throw new TypeException("Real.binary");
    }

    public Data a(int n2, MathType mathType, int n3, int n4) throws VisADException {
        Unit unit;
        double d2;
        double d3;
        Unit unit2;
        if (this.i == null) {
            unit2 = null;
            d3 = this.d;
        } else {
            unit2 = Unit.a(CommonUnit.a, this.i) ? CommonUnit.a : this.i.b();
            d3 = unit2.a(this.d, this.i);
        }
        if (mathType == null) {
            throw new TypeException("unary: new_type may not be null");
        }
        switch (n2) {
            case 21: {
                d2 = Math.abs(d3);
                unit = unit2;
                break;
            }
            case 22: {
                d2 = Math.acos(d3);
                unit = CommonUnit.c;
                break;
            }
            case 23: {
                d2 = 57.29577951308232 * Math.acos(d3);
                unit = CommonUnit.g;
                break;
            }
            case 24: {
                d2 = Math.asin(d3);
                unit = CommonUnit.c;
                break;
            }
            case 25: {
                d2 = 57.29577951308232 * Math.asin(d3);
                unit = CommonUnit.g;
                break;
            }
            case 26: {
                d2 = Math.atan(d3);
                unit = CommonUnit.c;
                break;
            }
            case 27: {
                d2 = 57.29577951308232 * Math.atan(d3);
                unit = CommonUnit.g;
                break;
            }
            case 28: {
                d2 = Math.ceil(d3);
                unit = unit2;
                break;
            }
            case 29: {
                d2 = CommonUnit.g.d(unit2) ? Math.cos(Math.PI / 180 * d3) : Math.cos(d3);
                unit = CommonUnit.a.d(unit2) ? unit2 : null;
                break;
            }
            case 30: {
                d2 = CommonUnit.c.d(unit2) ? Math.cos(d3) : Math.cos(Math.PI / 180 * d3);
                unit = CommonUnit.a.d(unit2) ? unit2 : null;
                break;
            }
            case 31: {
                d2 = Math.exp(d3);
                unit = CommonUnit.a.d(unit2) ? unit2 : null;
                break;
            }
            case 32: {
                d2 = Math.floor(d3);
                unit = unit2;
                break;
            }
            case 33: {
                d2 = Math.log(d3);
                unit = CommonUnit.a.d(unit2) ? unit2 : null;
                break;
            }
            case 34: {
                d2 = Math.rint(d3);
                unit = unit2;
                break;
            }
            case 35: {
                d2 = Math.round(d3);
                unit = unit2;
                break;
            }
            case 36: {
                d2 = CommonUnit.g.d(unit2) ? Math.sin(Math.PI / 180 * d3) : Math.sin(d3);
                unit = CommonUnit.a.d(unit2) ? unit2 : null;
                break;
            }
            case 37: {
                d2 = CommonUnit.c.d(unit2) ? Math.sin(d3) : Math.sin(Math.PI / 180 * d3);
                unit = CommonUnit.a.d(unit2) ? unit2 : null;
                break;
            }
            case 38: {
                d2 = Math.sqrt(d3);
                if (unit2 == null) {
                    unit = null;
                    break;
                }
                try {
                    unit = unit2.d();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    unit = null;
                }
                catch (UnitException unitException) {
                    unit = null;
                }
                break;
            }
            case 39: {
                d2 = CommonUnit.g.d(unit2) ? Math.tan(Math.PI / 180 * d3) : Math.tan(d3);
                unit = CommonUnit.a.d(unit2) ? unit2 : null;
                break;
            }
            case 40: {
                d2 = CommonUnit.c.d(unit2) ? Math.tan(d3) : Math.tan(Math.PI / 180 * d3);
                unit = CommonUnit.a.d(unit2) ? unit2 : null;
                break;
            }
            case 41: {
                d2 = -d3;
                unit = unit2;
                break;
            }
            case 42: {
                d2 = d3;
                unit = unit2;
                break;
            }
            default: {
                throw new ArithmeticException("Real.unary: illegal operation");
            }
        }
        if (n4 == 202 || this.k == null) {
            return new Real((RealType)mathType, d2, unit, null);
        }
        return new Real((RealType)mathType, d2, unit, new ErrorEstimate(d2, unit, n2, this.k, n4));
    }

    public DataShadow a(ShadowType shadowType, DataShadow dataShadow) throws VisADException, RemoteException {
        Unit unit;
        double d2;
        if (Double.isNaN(this.d)) {
            return dataShadow;
        }
        int n2 = ((ShadowRealType)shadowType).v();
        if (n2 >= 0 && (d2 = (unit = ((RealType)this.a).e()) != null && !unit.d(this.i) ? unit.a(this.d, this.i) : this.d) == d2) {
            dataShadow.b[0][n2] = Math.min(dataShadow.b[0][n2], d2);
            dataShadow.b[1][n2] = Math.max(dataShadow.b[1][n2], d2);
        }
        return dataShadow;
    }

    public Unit d() {
        return this.i;
    }

    public ErrorEstimate c() {
        return this.k;
    }

    public Data a(Data data, int n2) throws VisADException, RemoteException {
        if (this.j() || this.k == null || data == null || data.j()) {
            return this;
        }
        double d2 = ((Real)data).a();
        double d3 = this.k.a();
        double d4 = n2 == 200 ? Math.sqrt(d2 * d2 + d3 * d3) : Math.abs(d2) + Math.abs(d3);
        return new Real((RealType)this.a, this.d, this.i, new ErrorEstimate(this.d, d4, this.i));
    }

    public String toString() {
        try {
            if (Double.isNaN(this.d)) {
                return "missing";
            }
            return Unit.a(this.d(), CommonUnit.b) && !this.d().b().d(this.d()) ? new DateTime(this).toString() : Double.toString(this.d);
        }
        catch (VisADException visADException) {
            return visADException.toString();
        }
    }

    public String h() {
        String string;
        try {
            if (Double.isNaN(this.d)) {
                string = "missing";
            } else if (Unit.a(this.d(), CommonUnit.b) && !this.d().b().d(this.d())) {
                string = new DateTime(this).h();
            } else {
                Unit unit = this.i != null ? this.i : ((RealType)this.e()).e();
                string = Float.toString((float)this.d) + (unit == null ? "" : " " + unit);
            }
        }
        catch (VisADException visADException) {
            string = visADException.toString();
        }
        return string;
    }

    public String a(String string) throws VisADException {
        if (Double.isNaN(this.d)) {
            return string + "missing\n";
        }
        if (Unit.a(this.d(), CommonUnit.b) && !this.d().b().d(this.d())) {
            return string + "Real.Time: Value = " + new DateTime(this).toString() + "\n";
        }
        return string + "Real: Value = " + this.d + "  (TypeName: " + ((RealType)this.a).h() + ")\n";
    }

    public int compareTo(Object object) {
        int n2;
        Real real = (Real)object;
        try {
            Unit unit = ((RealType)this.e()).e();
            n2 = new Double(this.a(unit)).compareTo(new Double(real.a(unit)));
            if (n2 == 0) {
                n2 = this.k == null ? (real.k == null ? 0 : -1) : (real.k == null ? 1 : this.k.compareTo(real.k));
            }
        }
        catch (VisADException visADException) {
            n2 = 1;
        }
        return n2;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Real && this.e().equals(((Real)object).e()) && this.compareTo(object) == 0;
    }

    public int hashCode() {
        RealType realType = (RealType)this.e();
        int n2 = realType.hashCode();
        try {
            n2 ^= new Double(this.a(realType.e())).hashCode();
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        if (this.k != null) {
            n2 ^= this.k.hashCode();
        }
        return n2;
    }
}

