/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.GriddedSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.UnimplementedException;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;

public class ProductSet
extends SampledSet {
    public SampledSet[] b;

    public ProductSet(SampledSet[] sampledSetArray) throws VisADException {
        this(ProductSet.a(sampledSetArray), sampledSetArray, null, null, null, true);
    }

    public ProductSet(MathType mathType, SampledSet[] sampledSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, sampledSetArray, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public ProductSet(MathType mathType, SampledSet[] sampledSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2) throws VisADException {
        super(mathType, ProductSet.a(sampledSetArray, unitArray), coordinateSystem, unitArray, errorEstimateArray);
        int n2;
        int n3 = 0;
        int n4 = 0;
        while (n4 < sampledSetArray.length) {
            n3 += sampledSetArray[n4].y;
            ++n4;
        }
        if (n3 != this.y) {
            throw new SetException("ProductSet: DomainDimension does not match");
        }
        if (bl2) {
            this.b = new SampledSet[sampledSetArray.length];
            n2 = 0;
            while (n2 < sampledSetArray.length) {
                this.b[n2] = (SampledSet)sampledSetArray[n2].clone();
                ++n2;
            }
        } else {
            this.b = sampledSetArray;
        }
        this.B = 1;
        n2 = 0;
        while (n2 < sampledSetArray.length) {
            this.B *= sampledSetArray[n2].B;
            ++n2;
        }
        this.j = new float[this.y];
        this.l = new float[this.y];
        int n5 = 0;
        int n6 = 0;
        while (n6 < sampledSetArray.length) {
            float[] fArray = sampledSetArray[n6].a();
            float[] fArray2 = sampledSetArray[n6].t();
            int n7 = sampledSetArray[n6].s();
            int n8 = 0;
            while (n8 < n7) {
                this.j[n5 + n8] = fArray[n8];
                this.l[n5 + n8] = fArray2[n8];
                ++n8;
            }
            n5 += n7;
            ++n6;
        }
    }

    private static int a(SampledSet[] sampledSetArray, Unit[] unitArray) throws VisADException {
        if (sampledSetArray == null || sampledSetArray[0] == null) {
            throw new SetException("ProductSet: Sets cannot be missing");
        }
        if (sampledSetArray.length < 2) {
            throw new SetException("ProductSet: must be at least 2 sets");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < sampledSetArray.length) {
            if (unitArray != null) {
                int n5 = sampledSetArray[n4].s();
                if (n3 + n5 > unitArray.length) {
                    throw new SetException("ProductSet: Sets exceed ManifoldDimension " + unitArray.length);
                }
                Unit[] unitArray2 = sampledSetArray[n4].h();
                if (unitArray2 == null) {
                    throw new SetException("ProductSet: Set#" + n4 + " is null");
                }
                int n6 = 0;
                while (n6 < n5) {
                    if (!(unitArray[n3 + n6] == null && unitArray2[n6] == null || unitArray[n3 + n6] != null && unitArray2[n6] != null && unitArray[n3 + n6].d(unitArray2[n6]))) {
                        throw new SetException("ProductSet: Expected set " + n4 + ", element " + n6 + " units to be " + unitArray[n3 + n6] + " not " + unitArray2[n6]);
                    }
                    ++n6;
                }
            }
            n3 += sampledSetArray[n4].s();
            n2 += sampledSetArray[n4].v();
            ++n4;
        }
        return n2;
    }

    public static MathType a(SampledSet[] sampledSetArray) throws VisADException {
        int n2 = sampledSetArray.length;
        RealTupleType[] realTupleTypeArray = new RealTupleType[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            realTupleTypeArray[n4] = ((SetType)sampledSetArray[n4].e()).b();
            n3 += realTupleTypeArray[n4].f();
            ++n4;
        }
        RealType[] realTypeArray = new RealType[n3];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = 0;
            while (n7 < realTupleTypeArray[n6].f()) {
                realTypeArray[n5++] = (RealType)realTupleTypeArray[n6].b(n7);
                ++n7;
            }
            ++n6;
        }
        return new SetType(new RealTupleType(realTypeArray));
    }

    public SampledSet c() throws VisADException {
        int n2 = this.b.length;
        SampledSet[] sampledSetArray = new SampledSet[n2];
        int n3 = 0;
        while (n3 < n2) {
            if (this.b[n3] instanceof GriddedSet || this.b[n3] instanceof IrregularSet) {
                sampledSetArray[n3] = this.b[n3];
            } else if (this.b[n3] instanceof ProductSet) {
                sampledSetArray[n3] = ((ProductSet)this.b[n3]).c();
            } else if (this.b[n3] instanceof UnionSet) {
                sampledSetArray[n3] = ((UnionSet)this.b[n3]).c();
            } else {
                throw new UnimplementedException("ProductSet.product: " + this.b[n3].getClass());
            }
            ++n3;
        }
        SampledSet sampledSet = sampledSetArray[0];
        int n4 = 1;
        while (n4 < n2) {
            sampledSet = sampledSet instanceof ProductSet ? ((ProductSet)sampledSet).a(sampledSetArray[n4]) : (sampledSet instanceof UnionSet ? ((UnionSet)sampledSet).a(sampledSetArray[n4]) : (sampledSetArray[n4] instanceof ProductSet ? ((ProductSet)sampledSetArray[n4]).b(sampledSet) : (sampledSetArray[n4] instanceof UnionSet ? ((UnionSet)sampledSetArray[n4]).b(sampledSet) : new ProductSet(new SampledSet[]{sampledSet, sampledSetArray[n4]}))));
            ++n4;
        }
        return sampledSet;
    }

    public SampledSet a(SampledSet sampledSet) throws VisADException {
        int n2 = this.b.length;
        if (sampledSet instanceof ProductSet) {
            int n3 = ((ProductSet)sampledSet).b.length;
            SampledSet[] sampledSetArray = new SampledSet[n2 + n3];
            int n4 = 0;
            while (n4 < n2) {
                sampledSetArray[n4] = this.b[n4];
                ++n4;
            }
            int n5 = 0;
            while (n5 < n3) {
                sampledSetArray[n2 + n5] = ((ProductSet)sampledSet).b[n5];
                ++n5;
            }
            return new ProductSet(sampledSetArray);
        }
        if (sampledSet instanceof UnionSet) {
            int n6 = ((UnionSet)sampledSet).b.length;
            SampledSet[] sampledSetArray = new SampledSet[n6];
            int n7 = 0;
            while (n7 < n6) {
                sampledSetArray[n7] = this.a(((UnionSet)sampledSet).b[n7]);
                ++n7;
            }
            return new UnionSet(sampledSetArray);
        }
        SampledSet[] sampledSetArray = new SampledSet[n2 + 1];
        int n8 = 0;
        while (n8 < n2) {
            sampledSetArray[n8] = this.b[n8];
            ++n8;
        }
        sampledSetArray[n2] = sampledSet;
        return new ProductSet(sampledSetArray);
    }

    public SampledSet b(SampledSet sampledSet) throws VisADException {
        int n2 = this.b.length;
        if (sampledSet instanceof ProductSet) {
            int n3 = ((ProductSet)sampledSet).b.length;
            SampledSet[] sampledSetArray = new SampledSet[n2 + n3];
            int n4 = 0;
            while (n4 < n3) {
                sampledSetArray[n4] = ((ProductSet)sampledSet).b[n4];
                ++n4;
            }
            int n5 = 0;
            while (n5 < n2) {
                sampledSetArray[n3 + n5] = this.b[n5];
                ++n5;
            }
            return new ProductSet(sampledSetArray);
        }
        if (sampledSet instanceof UnionSet) {
            int n6 = ((UnionSet)sampledSet).b.length;
            SampledSet[] sampledSetArray = new SampledSet[n6];
            int n7 = 0;
            while (n7 < n6) {
                sampledSetArray[n7] = this.b(((UnionSet)sampledSet).b[n7]);
                ++n7;
            }
            return new UnionSet(sampledSetArray);
        }
        SampledSet[] sampledSetArray = new SampledSet[n2 + 1];
        sampledSetArray[0] = sampledSet;
        int n8 = 0;
        while (n8 < n2) {
            sampledSetArray[n8 + 1] = this.b[n8];
            ++n8;
        }
        return new ProductSet(sampledSetArray);
    }

    public Set a(SetType setType, float[][] fArray) throws VisADException {
        int n2 = this.b.length;
        int n3 = fArray.length;
        if (n3 != this.y || n3 != 3) {
            throw new SetException("ProductSet.makeSpatial: samples bad dimension");
        }
        try {
            boolean bl2 = false;
            int n4 = 0;
            while (n4 < n2) {
                if (this.b[n4] instanceof ProductSet || this.b[n4] instanceof UnionSet) {
                    bl2 = true;
                }
                ++n4;
            }
            if (bl2) {
                return this.c().a(setType, fArray);
            }
            boolean bl3 = true;
            int[] nArray = new int[this.u];
            int n5 = 0;
            int n6 = 0;
            while (n6 < n2) {
                if (!(this.b[n6] instanceof GriddedSet)) {
                    bl3 = false;
                    break;
                }
                int[] nArray2 = ((GriddedSet)this.b[n6]).p();
                int n7 = 0;
                while (n7 < nArray2.length) {
                    nArray[n5++] = nArray2[n7];
                    ++n7;
                }
                ++n6;
            }
            if (bl3) {
                return GriddedSet.a(setType, fArray, nArray);
            }
            throw new UnimplementedException("ProductSet.makeSpatial");
        }
        catch (VisADException visADException) {
            return new Irregular3DSet((MathType)setType, fArray, null, null, null, null, false);
        }
    }

    public float[][] a(boolean bl2) throws VisADException {
        int n2 = this.r();
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = n3;
            ++n3;
        }
        return this.b(nArray);
    }

    public float[][] b(int[] nArray) throws VisADException {
        int n2;
        int n3;
        int n4 = this.b.length;
        int n5 = nArray.length;
        int[][] nArray2 = new int[n4][n5];
        float[][] fArrayArray = new float[this.y][];
        int n6 = 0;
        while (n6 < n5) {
            n3 = nArray[n6];
            n2 = 0;
            while (n2 < n4) {
                nArray2[n2][n6] = n3 % this.b[n2].B;
                n3 /= this.b[n2].B;
                ++n2;
            }
            ++n6;
        }
        n3 = 0;
        n2 = 0;
        while (n2 < n4) {
            float[][] fArray = this.b[n2].b(nArray2[n2]);
            int n7 = 0;
            while (n7 < fArray.length) {
                fArrayArray[n3++] = fArray[n7];
                ++n7;
            }
            ++n2;
        }
        return fArrayArray;
    }

    public int[] b(float[][] fArray) throws VisADException {
        int n2;
        int n3 = this.b.length;
        int n4 = fArray[0].length;
        int[] nArray = new int[n4];
        float[][][] fArrayArray = new float[n3][][];
        int n5 = 0;
        int[][] nArrayArray = new int[n3][];
        int n6 = 0;
        while (n6 < n3) {
            fArrayArray[n6] = new float[this.b[n6].y][];
            n2 = 0;
            while (n2 < this.b[n6].y) {
                fArrayArray[n6][n2] = fArray[n5++];
                ++n2;
            }
            nArrayArray[n6] = this.b[n6].b(fArrayArray[n6]);
            ++n6;
        }
        n2 = 0;
        while (n2 < n4) {
            int n7 = 0;
            int n8 = 1;
            int n9 = 0;
            while (n9 < n3) {
                n7 += nArrayArray[n9][n2] * n8;
                n8 *= this.b[n9].B;
                ++n9;
            }
            nArray[n2] = n7;
            ++n2;
        }
        return nArray;
    }

    public void a(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        int n2;
        int n3 = this.b.length;
        int n4 = fArray[0].length;
        float[][][] fArrayArray = new float[n3][][];
        int n5 = 0;
        int[][][] nArray2 = new int[n3][n4][];
        float[][][] fArray3 = new float[n3][n4][];
        int n6 = 0;
        while (n6 < n3) {
            fArrayArray[n6] = new float[this.b[n6].y][];
            n2 = 0;
            while (n2 < this.b[n6].y) {
                fArrayArray[n6][n2] = fArray[n5++];
                ++n2;
            }
            this.b[n6].a(fArrayArray[n6], nArray2[n6], fArray3[n6]);
            ++n6;
        }
        n2 = 0;
        while (n2 < n4) {
            int[] nArray3 = new int[n3];
            int n7 = 1;
            int n8 = 0;
            while (n8 < n3) {
                nArray3[n8] = 0;
                n7 *= nArray2[n8][n2].length;
                ++n8;
            }
            nArray[n2] = new int[n7];
            fArray2[n2] = new float[n7];
            int n9 = 0;
            while (nArray3[0] < nArray2[0][n2].length) {
                int n10 = 0;
                float f2 = 1.0f;
                int n11 = 1;
                int n12 = 0;
                while (n12 < n3) {
                    n10 += nArray2[n12][n2][nArray3[n12]] * n11;
                    f2 *= fArray3[n12][n2][nArray3[n12]];
                    n11 *= this.b[n12].B;
                    ++n12;
                }
                nArray[n2][n9] = n10;
                fArray2[n2][n9] = f2;
                ++n9;
                int n13 = n3 - 1;
                nArray3[n13] = nArray3[n13] + 1;
                int n14 = n3 - 2;
                while (n14 >= 0) {
                    if (nArray3[n14 + 1] >= nArray2[n14 + 1][n2].length) {
                        nArray3[n14 + 1] = 0;
                        int n15 = n14;
                        nArray3[n15] = nArray3[n15] + 1;
                    } else {
                        n14 = 0;
                    }
                    --n14;
                }
            }
            ++n2;
        }
    }

    public Object clone() {
        ProductSet productSet = (ProductSet)super.clone();
        if (this.b != null) {
            productSet.b = new SampledSet[this.b.length];
            int n2 = 0;
            while (n2 < this.b.length) {
                productSet.b[n2] = (SampledSet)this.b[n2].clone();
                ++n2;
            }
        }
        return productSet;
    }

    public Object c(MathType mathType) throws VisADException {
        return new ProductSet(mathType, this.b, this.w, this.q, this.C);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProductSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ProductSet productSet = (ProductSet)object;
        if (productSet.y != this.y || productSet.u != this.u) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.b.length) {
            if (!this.b[n2].equals(productSet.b[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        if (!this.t) {
            int n2 = 0;
            while (n2 < this.b.length) {
                this.d ^= this.b[n2].hashCode();
                ++n2;
            }
            this.t = true;
        }
        return this.d;
    }

    public boolean j() {
        int n2 = 0;
        while (n2 < this.b.length) {
            if (this.b[n2].j()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String a(String string) throws VisADException {
        return string + "ProductSet: Dimension = " + this.y + "\n";
    }
}

