/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.GriddedSet;
import visad.Linear1DSet;
import visad.LinearSet;
import visad.MathType;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADException;

public class LinearNDSet
extends GriddedSet
implements LinearSet {
    public Linear1DSet[] e;
    private boolean b = false;

    public LinearNDSet(MathType mathType, Linear1DSet[] linear1DSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2) throws VisADException {
        super(mathType, null, LinearNDSet.a(linear1DSetArray), coordinateSystem, unitArray, errorEstimateArray);
        if (this.y != this.u) {
            throw new SetException("LinearNDSet: DomainDimension != ManifoldDimension");
        }
        this.e = new Linear1DSet[this.y];
        int n2 = 0;
        while (n2 < this.y) {
            this.e[n2] = linear1DSetArray[n2];
            this.j[n2] = this.e[n2].w();
            this.l[n2] = this.e[n2].c();
            if (this.C[n2] != null) {
                this.C[n2] = new ErrorEstimate(this.C[n2].a(), (double)(this.j[n2] + this.l[n2]) / 2.0, this.B, this.C[n2].d());
            }
            ++n2;
        }
        this.b = bl2;
    }

    private static int[] a(Linear1DSet[] linear1DSetArray) throws VisADException {
        int[] nArray = new int[linear1DSetArray.length];
        int n2 = 0;
        while (n2 < linear1DSetArray.length) {
            nArray[n2] = linear1DSetArray[n2].r();
            ++n2;
        }
        return nArray;
    }

    public float[][] b(int[] nArray) throws VisADException {
        int n2;
        int n3 = this.s();
        int n4 = nArray.length;
        int[][] nArray2 = new int[n3][n4];
        float[][] fArrayArray = new float[n3][];
        int[] nArray3 = new int[n3];
        int n5 = 0;
        while (n5 < n3) {
            nArray3[n5] = this.e[n5].r();
            ++n5;
        }
        int n6 = 0;
        while (n6 < n4) {
            int n7;
            n2 = nArray[n6];
            if (0 <= n2 && n2 < this.B) {
                n7 = 0;
                while (n7 < n3 - 1) {
                    nArray2[n7][n6] = n2 % nArray3[n7];
                    n2 /= nArray3[n7];
                    ++n7;
                }
                nArray2[n3 - 1][n6] = n2;
            } else {
                n7 = 0;
                while (n7 < n3) {
                    nArray2[n7][n6] = -1;
                    ++n7;
                }
            }
            ++n6;
        }
        n2 = 0;
        while (n2 < n3) {
            float[][] fArray = this.e[n2].b(nArray2[n2]);
            fArrayArray[n2] = fArray[0];
            ++n2;
        }
        return fArrayArray;
    }

    public float[][] c(float[][] fArray) throws VisADException {
        if (fArray.length != this.y) {
            throw new SetException("LinearNDSet.gridToValue: grid dimension " + fArray.length + " not equal to Domain dimension " + this.y);
        }
        int n2 = 0;
        while (n2 < this.y) {
            if (this.i[n2] < 2) {
                throw new SetException("LinearNDSet.gridToValue: requires all grid dimensions to be > 1");
            }
            ++n2;
        }
        int n3 = fArray[0].length;
        float[][][] fArray2 = new float[this.y][1][];
        float[][][] fArrayArray = new float[this.y][][];
        n2 = 0;
        while (n2 < this.y) {
            fArray2[n2][0] = fArray[n2];
            fArrayArray[n2] = this.e[n2].c(fArray2[n2]);
            ++n2;
        }
        float[][] fArrayArray2 = new float[this.y][];
        n2 = 0;
        while (n2 < this.y) {
            fArrayArray2[n2] = fArrayArray[n2][0];
            ++n2;
        }
        return fArrayArray2;
    }

    public float[][] f(float[][] fArray) throws VisADException {
        if (fArray.length != this.y) {
            throw new SetException("LinearNDSet.valueToGrid: value dimension " + fArray.length + " not equal to Domain dimension " + this.y);
        }
        int n2 = 0;
        while (n2 < this.y) {
            if (this.i[n2] < 2) {
                throw new SetException("LinearNDSet.valueToGrid: requires all grid dimensions to be > 1");
            }
            ++n2;
        }
        int n3 = fArray[0].length;
        float[][][] fArray2 = new float[this.y][1][];
        float[][][] fArrayArray = new float[this.y][][];
        n2 = 0;
        while (n2 < this.y) {
            fArray2[n2][0] = fArray[n2];
            fArrayArray[n2] = this.e[n2].f(fArray2[n2]);
            ++n2;
        }
        float[][] fArrayArray2 = new float[this.y][];
        n2 = 0;
        while (n2 < this.y) {
            fArrayArray2[n2] = fArrayArray[n2][0];
            ++n2;
        }
        return fArrayArray2;
    }

    public boolean j() {
        return false;
    }

    public float[][] a(boolean bl2) throws VisADException {
        if (this.k != null) {
            return bl2 ? Set.a(this.k) : this.k;
        }
        float[][] fArray = this.c();
        if (this.b) {
            this.k = fArray;
            return bl2 ? Set.a(this.k) : this.k;
        }
        return fArray;
    }

    private float[][] c() throws VisADException {
        int n2 = this.r();
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = n3;
            ++n3;
        }
        return this.b(nArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LinearNDSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!this.e((Set)object)) {
            return false;
        }
        if (this.y != ((LinearNDSet)object).s()) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.y) {
            if (!this.e[n2].equals(((LinearNDSet)object).c(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        if (!this.t) {
            this.d = this.m();
            int n2 = 0;
            while (n2 < this.y) {
                this.d ^= this.e[n2].hashCode();
                ++n2;
            }
            this.t = true;
        }
        return this.d;
    }

    public Linear1DSet c(int n2) {
        return this.e[n2];
    }

    public Object c(MathType mathType) throws VisADException {
        Linear1DSet[] linear1DSetArray = new Linear1DSet[this.y];
        int n2 = 0;
        while (n2 < this.y) {
            linear1DSetArray[n2] = (Linear1DSet)this.e[n2].clone();
            ++n2;
        }
        return new LinearNDSet(mathType, linear1DSetArray, this.w, this.q, this.C, this.b);
    }

    public String a(String string) throws VisADException {
        String string2 = string + "LinearNDSet: Dimension = " + this.y + " Length = " + this.B + "\n";
        int n2 = 0;
        while (n2 < this.y) {
            string2 = string2 + string + "  Dimension " + n2 + ":" + " Length = " + this.e[n2].r() + " Range = " + this.e[n2].u() + " to " + this.e[n2].q() + "\n";
            ++n2;
        }
        return string2;
    }
}

