/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.DisplayException;
import visad.ErrorEstimate;
import visad.Gridded3DSet;
import visad.Linear1DSet;
import visad.LinearSet;
import visad.MathType;
import visad.RealTupleType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADIndexedTriangleStripArray;
import visad.VisADTriangleStripArray;

public class Linear3DSet
extends Gridded3DSet
implements LinearSet {
    public Linear1DSet D;
    public Linear1DSet N;
    public Linear1DSet F;
    private boolean e;

    public Linear3DSet(MathType mathType, Linear1DSet[] linear1DSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2) throws VisADException {
        super(mathType, (float[][])null, linear1DSetArray[0].r(), linear1DSetArray[1].r(), linear1DSetArray[2].r(), coordinateSystem, unitArray, errorEstimateArray);
        if (this.y != 3) {
            throw new SetException("Linear3DSet: DomainDimension must be 3, not " + this.y);
        }
        if (linear1DSetArray.length != 3) {
            throw new SetException("Linear3DSet: ManifoldDimension must be 3, not " + linear1DSetArray.length);
        }
        this.D = linear1DSetArray[0];
        this.N = linear1DSetArray[1];
        this.F = linear1DSetArray[2];
        this.O = this.D.r();
        this.r = this.N.r();
        this.I = this.F.r();
        this.B = this.O * this.r * this.I;
        this.j[0] = this.D.w();
        this.l[0] = this.D.c();
        this.j[1] = this.N.w();
        this.l[1] = this.N.c();
        this.j[2] = this.F.w();
        this.l[2] = this.F.c();
        if (this.C[0] != null) {
            this.C[0] = new ErrorEstimate(this.C[0].a(), (double)(this.j[0] + this.l[0]) / 2.0, this.B, this.C[0].d());
        }
        if (this.C[1] != null) {
            this.C[1] = new ErrorEstimate(this.C[1].a(), (double)(this.j[1] + this.l[1]) / 2.0, this.B, this.C[1].d());
        }
        if (this.C[2] != null) {
            this.C[2] = new ErrorEstimate(this.C[2].a(), (double)(this.j[2] + this.l[2]) / 2.0, this.B, this.C[2].d());
        }
        this.e = bl2;
    }

    public float[][] b(int[] nArray) throws VisADException {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        float[][] fArrayArray = new float[3][];
        int n3 = 0;
        while (n3 < n2) {
            if (0 <= nArray[n3] && nArray[n3] < this.B) {
                nArray2[n3] = nArray[n3] % this.O;
                int n4 = nArray[n3] / this.O;
                nArray3[n3] = n4 % this.r;
                nArray4[n3] = n4 / this.r;
            } else {
                nArray2[n3] = -1;
                nArray3[n3] = -1;
                nArray4[n3] = -1;
            }
            ++n3;
        }
        float[][] fArray = this.D.b(nArray2);
        float[][] fArray2 = this.N.b(nArray3);
        float[][] fArray3 = this.F.b(nArray4);
        fArrayArray[0] = fArray[0];
        fArrayArray[1] = fArray2[0];
        fArrayArray[2] = fArray3[0];
        return fArrayArray;
    }

    public float[][] c(float[][] fArray) throws VisADException {
        if (fArray.length != this.u) {
            throw new SetException("Linear3DSet.gridToValue: grid dimension " + fArray.length + " not equal to Manifold dimension " + this.u);
        }
        if (this.u != 3) {
            throw new SetException("Linear3DSet.gridToValue: ManifoldDimension must be 3, not " + this.u);
        }
        if (this.i[0] < 2 || this.i[1] < 2 || this.i[2] < 2) {
            throw new SetException("Linear3DSet.gridToValue: requires all grid dimensions to be > 1");
        }
        int n2 = fArray[0].length;
        float[][] fArrayArray = new float[][]{fArray[0]};
        float[][] fArrayArray2 = new float[][]{fArray[1]};
        float[][] fArrayArray3 = new float[][]{fArray[2]};
        float[][] fArray2 = this.D.c(fArrayArray);
        float[][] fArray3 = this.N.c(fArrayArray2);
        float[][] fArray4 = this.F.c(fArrayArray3);
        float[][] fArrayArray4 = new float[][]{fArray2[0], fArray3[0], fArray4[0]};
        return fArrayArray4;
    }

    public float[][] f(float[][] fArray) throws VisADException {
        if (fArray.length != 3) {
            throw new SetException("Linear3DSet.valueToGrid: value dimension must be 3, not " + fArray.length);
        }
        if (this.i[0] < 2 || this.i[1] < 2 || this.i[2] < 2) {
            throw new SetException("Linear3DSet.valueToGrid: requires all grid dimensions to be > 1");
        }
        int n2 = fArray[0].length;
        float[][] fArrayArray = new float[][]{fArray[0]};
        float[][] fArrayArray2 = new float[][]{fArray[1]};
        float[][] fArrayArray3 = new float[][]{fArray[2]};
        float[][] fArray2 = this.D.f(fArrayArray);
        float[][] fArray3 = this.N.f(fArrayArray2);
        float[][] fArray4 = this.F.f(fArrayArray3);
        float[][] fArrayArray4 = new float[][]{fArray2[0], fArray3[0], fArray4[0]};
        return fArrayArray4;
    }

    public Linear1DSet q() {
        return this.D;
    }

    public Linear1DSet c() {
        return this.N;
    }

    public Linear1DSet w() {
        return this.F;
    }

    public boolean j() {
        return false;
    }

    public float[][] a(boolean bl2) throws VisADException {
        if (this.k != null) {
            return bl2 ? Set.a(this.k) : this.k;
        }
        float[][] fArray = this.u();
        if (this.e) {
            this.k = fArray;
            return bl2 ? Set.a(this.k) : this.k;
        }
        return fArray;
    }

    private float[][] u() throws VisADException {
        float[][] fArray = this.D.a(false);
        float[][] fArray2 = this.N.a(false);
        float[][] fArray3 = this.F.a(false);
        float[][] fArray4 = new float[3][this.B];
        int n2 = 0;
        int n3 = 0;
        while (n3 < fArray3[0].length) {
            int n4 = 0;
            while (n4 < fArray2[0].length) {
                int n5 = 0;
                while (n5 < fArray[0].length) {
                    fArray4[0][n2] = fArray[0][n5];
                    fArray4[1][n2] = fArray2[0][n4];
                    fArray4[2][n2] = fArray3[0][n3];
                    ++n2;
                    ++n5;
                }
                ++n4;
            }
            ++n3;
        }
        return fArray4;
    }

    public VisADGeometryArray a(float f2, float[] fArray, byte[][] byArray, boolean bl2, ScalarMap[] scalarMapArray, int[] nArray) throws VisADException {
        boolean bl3 = false;
        if (this.u != 3) {
            throw new DisplayException("Linear3DSet.makeLinearIsoSurface: ManifoldDimension must be 3, not " + this.u);
        }
        int n2 = this.r;
        int n3 = this.O;
        int n4 = this.I;
        float[] fArray2 = fArray;
        int n5 = n2 * n3;
        int n6 = n5 * n4;
        int n7 = (n2 - 1) * (n3 - 1) * (n4 - 1);
        int[] nArray2 = new int[n7];
        int[] nArray3 = new int[n6];
        int[] nArray4 = new int[n7 + 1];
        int n8 = Gridded3DSet.a(f2, nArray2, nArray3, nArray4, fArray2, n2, n3, n4);
        if (bl3) {
            System.out.println("npolygons= " + n8);
        }
        if (n8 == 0) {
            return null;
        }
        nArray4 = null;
        int n9 = 4 * n8 + 100;
        int n10 = 9 * (n9 + 50);
        int n11 = 7 * n8;
        float[][] fArray3 = new float[1][n9];
        float[][] fArray4 = new float[1][n9];
        float[][] fArray5 = new float[1][n9];
        byte[][] byArrayArray = null;
        if (byArray != null) {
            byArrayArray = new byte[byArray.length][];
        }
        int[] nArray5 = new int[n10];
        int[] nArray6 = new int[n11];
        int[][] nArrayArray = new int[][]{nArray5};
        float[] fArray6 = new float[6];
        Unit[] unitArray = this.h();
        RealTupleType realTupleType = ((SetType)this.e()).b();
        Unit[] unitArray2 = realTupleType.g();
        Linear1DSet[] linear1DSetArray = new Linear1DSet[]{this.q(), this.c(), this.w()};
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        int n12 = 0;
        while (n12 < 3) {
            double d2 = linear1DSetArray[n12].u();
            double d3 = linear1DSetArray[n12].x();
            if (unitArray[n12] != null && !unitArray[n12].d(unitArray2[n12])) {
                double d4 = unitArray[n12].b(0.0, unitArray2[n12]);
                double d5 = unitArray[n12].b(1.0, unitArray2[n12]) - d4;
                d2 = d4 + d5 * d2;
                d3 = d5 * d3;
            }
            scalarMapArray[n12].a(dArray, dArray2, dArray3);
            fArray6[2 * n12 + 0] = (float)(dArray[1] + dArray[0] * d2);
            fArray6[2 * n12 + 1] = (float)(dArray[0] * d3);
            ++n12;
        }
        float f3 = fArray6[0];
        fArray6[0] = fArray6[2];
        fArray6[2] = f3;
        f3 = fArray6[1];
        fArray6[1] = fArray6[3];
        fArray6[3] = f3;
        int n13 = this.a(f2, nArray2, n9, n8, fArray2, n2, n3, n4, fArray4, fArray3, fArray5, byArray, byArrayArray, nArrayArray, nArray6, fArray6);
        nArray5 = nArrayArray[0];
        if (n13 == 0) {
            return null;
        }
        nArray2 = null;
        nArray3 = null;
        float[][] fArray7 = new float[3][n13];
        System.arraycopy(fArray3[0], 0, fArray7[nArray[0]], 0, n13);
        System.arraycopy(fArray4[0], 0, fArray7[nArray[1]], 0, n13);
        System.arraycopy(fArray5[0], 0, fArray7[nArray[2]], 0, n13);
        fArray3 = null;
        fArray4 = null;
        fArray5 = null;
        byte[][] byArray2 = null;
        if (byArray != null) {
            byArray2 = new byte[byArray.length][n13];
            System.arraycopy(byArrayArray[0], 0, byArray2[0], 0, n13);
            System.arraycopy(byArrayArray[1], 0, byArray2[1], 0, n13);
            System.arraycopy(byArrayArray[2], 0, byArray2[2], 0, n13);
            if (byArrayArray.length > 3) {
                System.arraycopy(byArrayArray[3], 0, byArray2[3], 0, n13);
            }
            byArrayArray = null;
        }
        if (bl3) {
            System.out.println("nvertex= " + n13);
        }
        float[] fArray8 = new float[n8];
        float[] fArray9 = new float[n8];
        float[] fArray10 = new float[n8];
        float[] fArray11 = new float[n8];
        float[] fArray12 = new float[n8];
        float[] fArray13 = new float[n8];
        float[] fArray14 = new float[n8];
        float[] fArray15 = new float[n8];
        float[] fArray16 = new float[n8];
        float[] fArray17 = new float[n13];
        float[] fArray18 = new float[n13];
        float[] fArray19 = new float[n13];
        Gridded3DSet.a(fArray7[0], fArray7[1], fArray7[2], fArray17, fArray18, fArray19, n13, n8, fArray14, fArray15, fArray16, fArray8, fArray9, fArray10, fArray11, fArray12, fArray13, nArray5, nArray6);
        fArray16 = null;
        fArray15 = null;
        fArray14 = null;
        fArray13 = null;
        fArray12 = null;
        fArray11 = null;
        fArray10 = null;
        fArray9 = null;
        fArray8 = null;
        float[] fArray20 = new float[3 * n13];
        int n14 = 0;
        n12 = 0;
        while (n12 < n13) {
            fArray20[n14++] = fArray17[n12];
            fArray20[n14++] = fArray18[n12];
            fArray20[n14++] = fArray19[n12];
            ++n12;
        }
        fArray19 = null;
        fArray18 = null;
        fArray17 = null;
        int[] nArray7 = new int[6 * n8];
        int[] nArray8 = new int[n8];
        int n15 = Gridded3DSet.a(nArray8, nArray7, n13, n8, nArray5, nArray6);
        nArray5 = null;
        nArray6 = null;
        if (bl2) {
            VisADIndexedTriangleStripArray visADIndexedTriangleStripArray = new VisADIndexedTriangleStripArray();
            visADIndexedTriangleStripArray.k = n15;
            visADIndexedTriangleStripArray.m = new int[n15];
            System.arraycopy(nArray7, 0, visADIndexedTriangleStripArray.m, 0, n15);
            visADIndexedTriangleStripArray.l = new int[1];
            visADIndexedTriangleStripArray.l[0] = n15;
            nArray7 = null;
            SampledSet.a(visADIndexedTriangleStripArray, fArray7, 4, byArray2);
            fArray7 = null;
            byArray2 = null;
            visADIndexedTriangleStripArray.d = fArray20;
            if (bl3) {
                System.out.println("size_stripe= " + n15);
                int n16 = 0;
                while (n16 < n15) {
                    System.out.println(visADIndexedTriangleStripArray.m[n16]);
                    ++n16;
                }
            }
            return visADIndexedTriangleStripArray;
        }
        VisADTriangleStripArray visADTriangleStripArray = new VisADTriangleStripArray();
        visADTriangleStripArray.k = new int[]{n15};
        visADTriangleStripArray.e = n15;
        visADTriangleStripArray.d = new float[3 * n15];
        int n17 = 0;
        n12 = 0;
        while (n12 < 3 * n15) {
            n14 = 3 * nArray7[n17];
            visADTriangleStripArray.d[n12] = fArray20[n14];
            visADTriangleStripArray.d[n12 + 1] = fArray20[n14 + 1];
            visADTriangleStripArray.d[n12 + 2] = fArray20[n14 + 2];
            ++n17;
            n12 += 3;
        }
        fArray20 = null;
        visADTriangleStripArray.j = new float[3 * n15];
        n17 = 0;
        n12 = 0;
        while (n12 < 3 * n15) {
            n14 = nArray7[n17];
            visADTriangleStripArray.j[n12] = fArray7[0][n14];
            visADTriangleStripArray.j[n12 + 1] = fArray7[1][n14];
            visADTriangleStripArray.j[n12 + 2] = fArray7[2][n14];
            ++n17;
            n12 += 3;
        }
        fArray7 = null;
        if (byArray2 != null) {
            int n18 = byArray2.length;
            visADTriangleStripArray.i = new byte[n18 * n15];
            n17 = 0;
            if (n18 == 4) {
                n12 = 0;
                while (n12 < n18 * n15) {
                    n14 = nArray7[n17];
                    visADTriangleStripArray.i[n12] = byArray2[0][n14];
                    visADTriangleStripArray.i[n12 + 1] = byArray2[1][n14];
                    visADTriangleStripArray.i[n12 + 2] = byArray2[2][n14];
                    visADTriangleStripArray.i[n12 + 3] = byArray2[3][n14];
                    ++n17;
                    n12 += n18;
                }
            } else {
                n12 = 0;
                while (n12 < n18 * n15) {
                    n14 = nArray7[n17];
                    visADTriangleStripArray.i[n12] = byArray2[0][n14];
                    visADTriangleStripArray.i[n12 + 1] = byArray2[1][n14];
                    visADTriangleStripArray.i[n12 + 2] = byArray2[2][n14];
                    ++n17;
                    n12 += n18;
                }
            }
        }
        byArray2 = null;
        nArray7 = null;
        return visADTriangleStripArray;
    }

    private int a(float f2, int[] nArray, int n2, int n3, float[] fArray, int n4, int n5, int n6, float[][] fArray2, float[][] fArray3, float[][] fArray4, byte[][] byArray, byte[][] byArray2, int[][] nArray2, int[] nArray3, float[] fArray5) throws VisADException {
        int n7;
        int[] nArray4 = new int[13];
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        int n8 = 0;
        int n9 = n4 * n5;
        float f11 = fArray5[0];
        float f12 = fArray5[1];
        float f13 = fArray5[2];
        float f14 = fArray5[3];
        float f15 = fArray5[4];
        float f16 = fArray5[5];
        int n10 = n7 = byArray != null ? byArray.length : 0;
        if (n7 > 0) {
            if (byArray2 == null || byArray2.length != n7) {
                throw new SetException("Linear3DSet.isosurf: auxLevels length " + byArray2.length + " doesn't match expected " + n7);
            }
            int n11 = 0;
            while (n11 < n7) {
                if (byArray[n11].length != this.B) {
                    throw new SetException("Linear3DSet.isosurf: expected auxValues  length#" + n11 + " to be " + this.B + ", not " + byArray[n11].length);
                }
                ++n11;
            }
        } else if (byArray2 != null) {
            throw new SetException("Linear3DSet.isosurf: auxValues null but auxLevels not null");
        }
        byte[][] byArray3 = n7 > 0 ? new byte[n7][n2] : null;
        int n12 = 0;
        int n13 = 0;
        int n14 = 1;
        int n15 = 1;
        int n16 = 0;
        while (n16 < nArray2[0].length) {
            nArray2[0][n16] = -2000000000;
            ++n16;
        }
        n16 = 8;
        while (n16 < nArray2[0].length) {
            nArray2[0][n16] = 0;
            n16 += 9;
        }
        n16 = 0;
        while (n16 < nArray3.length) {
            nArray3[n16] = -2000000000;
            ++n16;
        }
        n16 = 6;
        while (n16 < nArray3.length) {
            nArray3[n16] = 0;
            n16 += 7;
        }
        int n17 = n9 - n5;
        int n18 = n9 - n4;
        int n19 = n5;
        int n20 = 2 * (n17 + n18 + n19);
        int[] nArray5 = new int[n20];
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        int n25 = 0;
        while (n25 < n6 - 1) {
            int n26;
            int n27 = 0;
            while (n27 < n4 - 1) {
                int n28 = 0;
                while (n28 < n5 - 1) {
                    if (nArray[n23] != 0 & nArray[n23] != 255) {
                        int n29;
                        float f17;
                        if (n24 + 12 > n2) {
                            n2 = 2 * (n24 + 12);
                            if (n7 > 0) {
                                int n30 = 0;
                                while (n30 < n7) {
                                    byte[] byArray4 = byArray3[n30];
                                    byArray3[n30] = new byte[n2];
                                    System.arraycopy(byArray4, 0, byArray3[n30], 0, n24);
                                    ++n30;
                                }
                            }
                            float[] fArray6 = fArray2[0];
                            fArray2[0] = new float[n2];
                            System.arraycopy(fArray6, 0, fArray2[0], 0, fArray6.length);
                            fArray6 = fArray3[0];
                            fArray3[0] = new float[n2];
                            System.arraycopy(fArray6, 0, fArray3[0], 0, fArray6.length);
                            fArray6 = fArray4[0];
                            fArray4[0] = new float[n2];
                            System.arraycopy(fArray6, 0, fArray4[0], 0, fArray6.length);
                            int n31 = 9 * (n2 + 50);
                            int[] nArray6 = nArray2[0];
                            nArray2[0] = new int[n31];
                            n16 = 0;
                            while (n16 < nArray2[0].length) {
                                nArray2[0][n16] = -2000000000;
                                ++n16;
                            }
                            n16 = 8;
                            while (n16 < nArray2[0].length) {
                                nArray2[0][n16] = 0;
                                n16 += 9;
                            }
                            System.arraycopy(nArray6, 0, nArray2[0], 0, nArray6.length);
                        }
                        f3 = fArray[n8];
                        f4 = fArray[n8 + n5];
                        f5 = fArray[n8 + 1];
                        f6 = fArray[n8 + n5 + 1];
                        f7 = fArray[n8 + n9];
                        f8 = fArray[n8 + n5 + n9];
                        f9 = fArray[n8 + 1 + n9];
                        f10 = fArray[n8 + 1 + n5 + n9];
                        if (nArray[n23] < 317) {
                            int n32;
                            int n33 = Gridded3DSet.p[nArray[n23]][2];
                            int n34 = nArray[n23];
                            int n35 = 4;
                            int n36 = n21;
                            int n37 = Gridded3DSet.p[nArray[n23]][1];
                            n20 = 0;
                            while (n20 < n37) {
                                nArray3[n36 + 6] = n32 = n33 & 0xF;
                                n32 += n36;
                                n16 = n36;
                                while (n16 < n32 && n16 < n36 + 6) {
                                    nArray3[n16] = Gridded3DSet.p[n34][n35];
                                    if (++n35 >= 16) {
                                        ++n34;
                                        n35 -= 16;
                                    }
                                    ++n16;
                                }
                                n33 >>= 4;
                                n36 += 7;
                                ++n20;
                            }
                            if ((Gridded3DSet.p[nArray[n23]][3] & 2) != 0) {
                                if (n25 != 0 || n28 != 0) {
                                    nArray4[1] = nArray5[n13 * n17 + n27 * n5 + n28];
                                } else {
                                    f17 = (f2 - f3) / (f4 - f3);
                                    fArray2[0][n24] = f11 + f12 * (f17 + (float)n27);
                                    fArray3[0][n24] = f13 + f14 * (float)n28;
                                    fArray4[0][n24] = f15 + f16 * (float)n25;
                                    int n38 = 0;
                                    while (n38 < n7) {
                                        n29 = (int)(f17 * (byArray[n38][n8 + n5] < 0 ? (float)byArray[n38][n8 + n5] + 256.0f : (float)byArray[n38][n8 + n5]) + (1.0f - f17) * (byArray[n38][n8] < 0 ? (float)byArray[n38][n8] + 256.0f : (float)byArray[n38][n8]));
                                        byArray3[n38][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                        ++n38;
                                    }
                                    nArray4[1] = n24++;
                                }
                            }
                            if ((Gridded3DSet.p[nArray[n23]][3] & 4) != 0) {
                                if (n25 != 0 || n27 != 0) {
                                    nArray4[2] = nArray5[2 * n17 + n13 * n18 + n28 * n4 + n27];
                                } else {
                                    f17 = (f2 - f3) / (f5 - f3);
                                    fArray2[0][n24] = f11 + f12 * (float)n27;
                                    fArray3[0][n24] = f13 + f14 * (f17 + (float)n28);
                                    fArray4[0][n24] = f15 + f16 * (float)n25;
                                    int n39 = 0;
                                    while (n39 < n7) {
                                        n29 = (int)(f17 * (byArray[n39][n8 + 1] < 0 ? (float)byArray[n39][n8 + 1] + 256.0f : (float)byArray[n39][n8 + 1]) + (1.0f - f17) * (byArray[n39][n8] < 0 ? (float)byArray[n39][n8] + 256.0f : (float)byArray[n39][n8]));
                                        byArray3[n39][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                        ++n39;
                                    }
                                    nArray4[2] = n24++;
                                }
                            }
                            if ((Gridded3DSet.p[nArray[n23]][3] & 8) != 0) {
                                if (n27 != 0 || n28 != 0) {
                                    nArray4[3] = nArray5[2 * n17 + 2 * n18 + n12 * n19 + n28];
                                } else {
                                    f17 = (f2 - f3) / (f7 - f3);
                                    fArray2[0][n24] = f11 + f12 * (float)n27;
                                    fArray3[0][n24] = f13 + f14 * (float)n28;
                                    fArray4[0][n24] = f15 + f16 * (f17 + (float)n25);
                                    int n40 = 0;
                                    while (n40 < n7) {
                                        n29 = (int)(f17 * (byArray[n40][n8 + n9] < 0 ? (float)byArray[n40][n8 + n9] + 256.0f : (float)byArray[n40][n8 + n9]) + (1.0f - f17) * (byArray[n40][n8] < 0 ? (float)byArray[n40][n8] + 256.0f : (float)byArray[n40][n8]));
                                        byArray3[n40][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                        ++n40;
                                    }
                                    nArray4[3] = n24++;
                                }
                            }
                            if ((Gridded3DSet.p[nArray[n23]][3] & 0x10) != 0) {
                                if (n25 != 0) {
                                    nArray4[4] = nArray5[2 * n17 + n13 * n18 + n28 * n4 + (n27 + 1)];
                                } else {
                                    f17 = (f2 - f4) / (f6 - f4);
                                    fArray2[0][n24] = f11 + f12 * (float)(n27 + 1);
                                    fArray3[0][n24] = f13 + f14 * (f17 + (float)n28);
                                    fArray4[0][n24] = f15 + f16 * (float)n25;
                                    int n41 = 0;
                                    while (n41 < n7) {
                                        n29 = (int)(f17 * (byArray[n41][n8 + n5 + 1] < 0 ? (float)byArray[n41][n8 + n5 + 1] + 256.0f : (float)byArray[n41][n8 + n5 + 1]) + (1.0f - f17) * (byArray[n41][n8 + n5] < 0 ? (float)byArray[n41][n8 + n5] + 256.0f : (float)byArray[n41][n8 + n5]));
                                        byArray3[n41][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                        ++n41;
                                    }
                                    nArray4[4] = n24;
                                    nArray5[2 * n17 + n13 * n18 + n28 * n4 + (n27 + 1)] = n24++;
                                }
                            }
                            if ((Gridded3DSet.p[nArray[n23]][3] & 0x20) != 0) {
                                if (n28 != 0) {
                                    nArray4[5] = nArray5[2 * n17 + 2 * n18 + n14 * n19 + n28];
                                } else {
                                    f17 = (f2 - f4) / (f8 - f4);
                                    fArray2[0][n24] = f11 + f12 * (float)(n27 + 1);
                                    fArray3[0][n24] = f13 + f14 * (float)n28;
                                    fArray4[0][n24] = f15 + f16 * (f17 + (float)n25);
                                    int n42 = 0;
                                    while (n42 < n7) {
                                        n29 = (int)(f17 * (byArray[n42][n8 + n5 + n9] < 0 ? (float)byArray[n42][n8 + n5 + n9] + 256.0f : (float)byArray[n42][n8 + n5 + n9]) + (1.0f - f17) * (byArray[n42][n8 + n5] < 0 ? (float)byArray[n42][n8 + n5] + 256.0f : (float)byArray[n42][n8 + n5]));
                                        byArray3[n42][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                        ++n42;
                                    }
                                    nArray4[5] = n24;
                                    nArray5[2 * n17 + 2 * n18 + n14 * n19 + n28] = n24++;
                                }
                            }
                            if ((Gridded3DSet.p[nArray[n23]][3] & 0x40) != 0) {
                                if (n25 != 0) {
                                    nArray4[6] = nArray5[n13 * n17 + n27 * n5 + (n28 + 1)];
                                } else {
                                    f17 = (f2 - f5) / (f6 - f5);
                                    fArray2[0][n24] = f11 + f12 * (f17 + (float)n27);
                                    fArray3[0][n24] = f13 + f14 * (float)(n28 + 1);
                                    fArray4[0][n24] = f15 + f16 * (float)n25;
                                    int n43 = 0;
                                    while (n43 < n7) {
                                        n29 = (int)(f17 * (byArray[n43][n8 + n5 + 1] < 0 ? (float)byArray[n43][n8 + n5 + 1] + 256.0f : (float)byArray[n43][n8 + n5 + 1]) + (1.0f - f17) * (byArray[n43][n8 + 1] < 0 ? (float)byArray[n43][n8 + 1] + 256.0f : (float)byArray[n43][n8 + 1]));
                                        byArray3[n43][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                        ++n43;
                                    }
                                    nArray4[6] = n24;
                                    nArray5[n13 * n17 + n27 * n5 + (n28 + 1)] = n24++;
                                }
                            }
                            if ((Gridded3DSet.p[nArray[n23]][3] & 0x80) != 0) {
                                if (n27 != 0) {
                                    nArray4[7] = nArray5[2 * n17 + 2 * n18 + n12 * n19 + (n28 + 1)];
                                } else {
                                    f17 = (f2 - f5) / (f9 - f5);
                                    fArray2[0][n24] = f11 + f12 * (float)n27;
                                    fArray3[0][n24] = f13 + f14 * (float)(n28 + 1);
                                    fArray4[0][n24] = f15 + f16 * (f17 + (float)n25);
                                    int n44 = 0;
                                    while (n44 < n7) {
                                        n29 = (int)(f17 * (byArray[n44][n8 + 1 + n9] < 0 ? (float)byArray[n44][n8 + 1 + n9] + 256.0f : (float)byArray[n44][n8 + 1 + n9]) + (1.0f - f17) * (byArray[n44][n8 + 1] < 0 ? (float)byArray[n44][n8 + 1] + 256.0f : (float)byArray[n44][n8 + 1]));
                                        byArray3[n44][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                        ++n44;
                                    }
                                    nArray4[7] = n24;
                                    nArray5[2 * n17 + 2 * n18 + n12 * n19 + (n28 + 1)] = n24++;
                                }
                            }
                            if ((Gridded3DSet.p[nArray[n23]][3] & 0x100) != 0) {
                                f17 = (f2 - f6) / (f10 - f6);
                                fArray2[0][n24] = f11 + f12 * (float)(n27 + 1);
                                fArray3[0][n24] = f13 + f14 * (float)(n28 + 1);
                                fArray4[0][n24] = f15 + f16 * (f17 + (float)n25);
                                int n45 = 0;
                                while (n45 < n7) {
                                    n29 = (int)(f17 * (byArray[n45][n8 + 1 + n5 + n9] < 0 ? (float)byArray[n45][n8 + 1 + n5 + n9] + 256.0f : (float)byArray[n45][n8 + 1 + n5 + n9]) + (1.0f - f17) * (byArray[n45][n8 + n5 + 1] < 0 ? (float)byArray[n45][n8 + n5 + 1] + 256.0f : (float)byArray[n45][n8 + n5 + 1]));
                                    byArray3[n45][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                    ++n45;
                                }
                                nArray4[8] = n24;
                                nArray5[2 * n17 + 2 * n18 + n14 * n19 + (n28 + 1)] = n24++;
                            }
                            if ((Gridded3DSet.p[nArray[n23]][3] & 0x200) != 0) {
                                if (n28 != 0) {
                                    nArray4[9] = nArray5[n15 * n17 + n27 * n5 + n28];
                                } else {
                                    f17 = (f2 - f7) / (f8 - f7);
                                    fArray2[0][n24] = f11 + f12 * (f17 + (float)n27);
                                    fArray3[0][n24] = f13 + f14 * (float)n28;
                                    fArray4[0][n24] = f15 + f16 * (float)(n25 + 1);
                                    int n46 = 0;
                                    while (n46 < n7) {
                                        n29 = (int)(f17 * (byArray[n46][n8 + n5 + n9] < 0 ? (float)byArray[n46][n8 + n5 + n9] + 256.0f : (float)byArray[n46][n8 + n5 + n9]) + (1.0f - f17) * (byArray[n46][n8 + n9] < 0 ? (float)byArray[n46][n8 + n9] + 256.0f : (float)byArray[n46][n8 + n9]));
                                        byArray3[n46][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                        ++n46;
                                    }
                                    nArray4[9] = n24;
                                    nArray5[n15 * n17 + n27 * n5 + n28] = n24++;
                                }
                            }
                            if ((Gridded3DSet.p[nArray[n23]][3] & 0x400) != 0) {
                                if (n27 != 0) {
                                    nArray4[10] = nArray5[2 * n17 + n15 * n18 + n28 * n4 + n27];
                                } else {
                                    f17 = (f2 - f7) / (f9 - f7);
                                    fArray2[0][n24] = f11 + f12 * (float)n27;
                                    fArray3[0][n24] = f13 + f14 * (f17 + (float)n28);
                                    fArray4[0][n24] = f15 + f16 * (float)(n25 + 1);
                                    int n47 = 0;
                                    while (n47 < n7) {
                                        n29 = (int)(f17 * (byArray[n47][n8 + 1 + n9] < 0 ? (float)byArray[n47][n8 + 1 + n9] + 256.0f : (float)byArray[n47][n8 + 1 + n9]) + (1.0f - f17) * (byArray[n47][n8 + n9] < 0 ? (float)byArray[n47][n8 + n9] + 256.0f : (float)byArray[n47][n8 + n9]));
                                        byArray3[n47][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                        ++n47;
                                    }
                                    nArray4[10] = n24;
                                    nArray5[2 * n17 + n15 * n18 + n28 * n4 + n27] = n24++;
                                }
                            }
                            if ((Gridded3DSet.p[nArray[n23]][3] & 0x800) != 0) {
                                f17 = (f2 - f8) / (f10 - f8);
                                fArray2[0][n24] = f11 + f12 * (float)(n27 + 1);
                                fArray3[0][n24] = f13 + f14 * (f17 + (float)n28);
                                fArray4[0][n24] = f15 + f16 * (float)(n25 + 1);
                                int n48 = 0;
                                while (n48 < n7) {
                                    n29 = (int)(f17 * (byArray[n48][n8 + 1 + n5 + n9] < 0 ? (float)byArray[n48][n8 + 1 + n5 + n9] + 256.0f : (float)byArray[n48][n8 + 1 + n5 + n9]) + (1.0f - f17) * (byArray[n48][n8 + n5 + n9] < 0 ? (float)byArray[n48][n8 + n5 + n9] + 256.0f : (float)byArray[n48][n8 + n5 + n9]));
                                    byArray3[n48][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                    ++n48;
                                }
                                nArray4[11] = n24;
                                nArray5[2 * n17 + n15 * n18 + n28 * n4 + (n27 + 1)] = n24++;
                            }
                            if ((Gridded3DSet.p[nArray[n23]][3] & 0x1000) != 0) {
                                f17 = (f2 - f9) / (f10 - f9);
                                fArray2[0][n24] = f11 + f12 * (f17 + (float)n27);
                                fArray3[0][n24] = f13 + f14 * (float)(n28 + 1);
                                fArray4[0][n24] = f15 + f16 * (float)(n25 + 1);
                                int n49 = 0;
                                while (n49 < n7) {
                                    n29 = (int)(f17 * (byArray[n49][n8 + 1 + n5 + n9] < 0 ? (float)byArray[n49][n8 + 1 + n5 + n9] + 256.0f : (float)byArray[n49][n8 + 1 + n5 + n9]) + (1.0f - f17) * (byArray[n49][n8 + 1 + n9] < 0 ? (float)byArray[n49][n8 + 1 + n9] + 256.0f : (float)byArray[n49][n8 + 1 + n9]));
                                    byArray3[n49][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                    ++n49;
                                }
                                nArray4[12] = n24;
                                nArray5[n15 * n17 + n27 * n5 + (n28 + 1)] = n24++;
                            }
                            n33 = Gridded3DSet.p[nArray[n23]][2];
                            int n50 = Gridded3DSet.p[nArray[n23]][1];
                            n20 = 0;
                            while (n20 < n50) {
                                int n51 = n21 + (n33 & 0xF);
                                n16 = n21;
                                while (n16 < n51) {
                                    nArray3[n16] = n32 = nArray4[nArray3[n16]];
                                    int n52 = nArray2[0][n32 * 9 + 8];
                                    nArray2[0][n32 * 9 + n52] = n22;
                                    nArray2[0][n32 * 9 + 8] = n52 + 1;
                                    ++n16;
                                }
                                n33 >>= 4;
                                n21 += 7;
                                ++n22;
                                ++n20;
                            }
                        } else {
                            int n53 = n23;
                            nArray[n53] = nArray[n53] & 0x1FF;
                            if (nArray[n23] != 0 & nArray[n23] != 255) {
                                if ((Gridded3DSet.p[nArray[n23]][3] & 0x10) != 0 && n25 == 0 && f6 == f6 && f4 == f4) {
                                    f17 = (f2 - f4) / (f6 - f4);
                                    fArray2[0][n24] = f11 + f12 * (float)(n27 + 1);
                                    fArray3[0][n24] = f13 + f14 * (f17 + (float)n28);
                                    fArray4[0][n24] = f15 + f16 * (float)n25;
                                    int n54 = 0;
                                    while (n54 < n7) {
                                        n29 = (int)(f17 * (byArray[n54][n8 + n5 + 1] < 0 ? (float)byArray[n54][n8 + n5 + 1] + 256.0f : (float)byArray[n54][n8 + n5 + 1]) + (1.0f - f17) * (byArray[n54][n8 + n5] < 0 ? (float)byArray[n54][n8 + n5] + 256.0f : (float)byArray[n54][n8 + n5]));
                                        byArray3[n54][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                        ++n54;
                                    }
                                    nArray5[2 * n17 + n13 * n18 + n28 * n4 + (n27 + 1)] = n24++;
                                }
                                if ((Gridded3DSet.p[nArray[n23]][3] & 0x20) != 0 && n28 == 0 && f8 == f8 && f4 == f4) {
                                    f17 = (f2 - f4) / (f8 - f4);
                                    fArray2[0][n24] = f11 + f12 * (float)(n27 + 1);
                                    fArray3[0][n24] = f13 + f14 * (float)n28;
                                    fArray4[0][n24] = f15 + f16 * (f17 + (float)n25);
                                    int n55 = 0;
                                    while (n55 < n7) {
                                        n29 = (int)(f17 * (byArray[n55][n8 + n5 + n9] < 0 ? (float)byArray[n55][n8 + n5 + n9] + 256.0f : (float)byArray[n55][n8 + n5 + n9]) + (1.0f - f17) * (byArray[n55][n8 + n5] < 0 ? (float)byArray[n55][n8 + n5] + 256.0f : (float)byArray[n55][n8 + n5]));
                                        byArray3[n55][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                        ++n55;
                                    }
                                    nArray5[2 * n17 + 2 * n18 + n14 * n19 + n28] = n24++;
                                }
                                if ((Gridded3DSet.p[nArray[n23]][3] & 0x40) != 0 && n25 == 0 && f6 == f6 && f5 == f5) {
                                    f17 = (f2 - f5) / (f6 - f5);
                                    fArray2[0][n24] = f11 + f12 * (f17 + (float)n27);
                                    fArray3[0][n24] = f13 + f14 * (float)(n28 + 1);
                                    fArray4[0][n24] = f15 + f16 * (float)n25;
                                    int n56 = 0;
                                    while (n56 < n7) {
                                        n29 = (int)(f17 * (byArray[n56][n8 + n5 + 1] < 0 ? (float)byArray[n56][n8 + n5 + 1] + 256.0f : (float)byArray[n56][n8 + n5 + 1]) + (1.0f - f17) * (byArray[n56][n8 + 1] < 0 ? (float)byArray[n56][n8 + 1] + 256.0f : (float)byArray[n56][n8 + 1]));
                                        byArray3[n56][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                        ++n56;
                                    }
                                    nArray5[n13 * n17 + n27 * n5 + (n28 + 1)] = n24++;
                                }
                                if ((Gridded3DSet.p[nArray[n23]][3] & 0x80) != 0 && n27 == 0 && f9 == f9 && f5 == f5) {
                                    f17 = (f2 - f5) / (f9 - f5);
                                    fArray2[0][n24] = f11 + f12 * (float)n27;
                                    fArray3[0][n24] = f13 + f14 * (float)(n28 + 1);
                                    fArray4[0][n24] = f15 + f16 * (f17 + (float)n25);
                                    int n57 = 0;
                                    while (n57 < n7) {
                                        n29 = (int)(f17 * (byArray[n57][n8 + 1 + n9] < 0 ? (float)byArray[n57][n8 + 1 + n9] + 256.0f : (float)byArray[n57][n8 + 1 + n9]) + (1.0f - f17) * (byArray[n57][n8 + 1] < 0 ? (float)byArray[n57][n8 + 1] + 256.0f : (float)byArray[n57][n8 + 1]));
                                        byArray3[n57][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                        ++n57;
                                    }
                                    nArray5[2 * n17 + 2 * n18 + n12 * n19 + (n28 + 1)] = n24++;
                                }
                                if ((Gridded3DSet.p[nArray[n23]][3] & 0x100) != 0 && f10 == f10 && f6 == f6) {
                                    f17 = (f2 - f6) / (f10 - f6);
                                    fArray2[0][n24] = f11 + f12 * (float)(n27 + 1);
                                    fArray3[0][n24] = f13 + f14 * (float)(n28 + 1);
                                    fArray4[0][n24] = f15 + f16 * (f17 + (float)n25);
                                    int n58 = 0;
                                    while (n58 < n7) {
                                        n29 = (int)(f17 * (byArray[n58][n8 + 1 + n5 + n9] < 0 ? (float)byArray[n58][n8 + 1 + n5 + n9] + 256.0f : (float)byArray[n58][n8 + 1 + n5 + n9]) + (1.0f - f17) * (byArray[n58][n8 + n5 + 1] < 0 ? (float)byArray[n58][n8 + n5 + 1] + 256.0f : (float)byArray[n58][n8 + n5 + 1]));
                                        byArray3[n58][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                        ++n58;
                                    }
                                    nArray5[2 * n17 + 2 * n18 + n14 * n19 + (n28 + 1)] = n24++;
                                }
                                if ((Gridded3DSet.p[nArray[n23]][3] & 0x200) != 0 && n28 == 0 && f8 == f8 && f7 == f7) {
                                    f17 = (f2 - f7) / (f8 - f7);
                                    fArray2[0][n24] = f11 + f12 * (f17 + (float)n27);
                                    fArray3[0][n24] = f13 + f14 * (float)n28;
                                    fArray4[0][n24] = f15 + f16 * (float)(n25 + 1);
                                    int n59 = 0;
                                    while (n59 < n7) {
                                        n29 = (int)(f17 * (byArray[n59][n8 + n5 + n9] < 0 ? (float)byArray[n59][n8 + n5 + n9] + 256.0f : (float)byArray[n59][n8 + n5 + n9]) + (1.0f - f17) * (byArray[n59][n8 + n9] < 0 ? (float)byArray[n59][n8 + n9] + 256.0f : (float)byArray[n59][n8 + n9]));
                                        byArray3[n59][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                        ++n59;
                                    }
                                    nArray5[n15 * n17 + n27 * n5 + n28] = n24++;
                                }
                                if ((Gridded3DSet.p[nArray[n23]][3] & 0x400) != 0 && n27 == 0 && f9 == f9 && f7 == f7) {
                                    f17 = (f2 - f7) / (f9 - f7);
                                    fArray2[0][n24] = f11 + f12 * (float)n27;
                                    fArray3[0][n24] = f13 + f14 * (f17 + (float)n28);
                                    fArray4[0][n24] = f15 + f16 * (float)(n25 + 1);
                                    int n60 = 0;
                                    while (n60 < n7) {
                                        n29 = (int)(f17 * (byArray[n60][n8 + 1 + n9] < 0 ? (float)byArray[n60][n8 + 1 + n9] + 256.0f : (float)byArray[n60][n8 + 1 + n9]) + (1.0f - f17) * (byArray[n60][n8 + n9] < 0 ? (float)byArray[n60][n8 + n9] + 256.0f : (float)byArray[n60][n8 + n9]));
                                        byArray3[n60][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                        ++n60;
                                    }
                                    nArray5[2 * n17 + n15 * n18 + n28 * n4 + n27] = n24++;
                                }
                                if ((Gridded3DSet.p[nArray[n23]][3] & 0x800) != 0 && f10 == f10 && f8 == f8) {
                                    f17 = (f2 - f8) / (f10 - f8);
                                    fArray2[0][n24] = f11 + f12 * (float)(n27 + 1);
                                    fArray3[0][n24] = f13 + f14 * (f17 + (float)n28);
                                    fArray4[0][n24] = f15 + f16 * (float)(n25 + 1);
                                    int n61 = 0;
                                    while (n61 < n7) {
                                        n29 = (int)(f17 * (byArray[n61][n8 + 1 + n5 + n9] < 0 ? (float)byArray[n61][n8 + 1 + n5 + n9] + 256.0f : (float)byArray[n61][n8 + 1 + n5 + n9]) + (1.0f - f17) * (byArray[n61][n8 + n5 + n9] < 0 ? (float)byArray[n61][n8 + n5 + n9] + 256.0f : (float)byArray[n61][n8 + n5 + n9]));
                                        byArray3[n61][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                        ++n61;
                                    }
                                    nArray5[2 * n17 + n15 * n18 + n28 * n4 + (n27 + 1)] = n24++;
                                }
                                if ((Gridded3DSet.p[nArray[n23]][3] & 0x1000) != 0 && f10 == f10 && f9 == f9) {
                                    f17 = (f2 - f9) / (f10 - f9);
                                    fArray2[0][n24] = f11 + f12 * (f17 + (float)n27);
                                    fArray3[0][n24] = f13 + f14 * (float)(n28 + 1);
                                    fArray4[0][n24] = f15 + f16 * (float)(n25 + 1);
                                    int n62 = 0;
                                    while (n62 < n7) {
                                        n29 = (int)(f17 * (byArray[n62][n8 + 1 + n5 + n9] < 0 ? (float)byArray[n62][n8 + 1 + n5 + n9] + 256.0f : (float)byArray[n62][n8 + 1 + n5 + n9]) + (1.0f - f17) * (byArray[n62][n8 + 1 + n9] < 0 ? (float)byArray[n62][n8 + 1 + n9] + 256.0f : (float)byArray[n62][n8 + 1 + n9]));
                                        byArray3[n62][n24] = (byte)(n29 < 0 ? 0 : (byte)(n29 > 255 ? -1 : (n29 < 128 ? (byte)n29 : (byte)(n29 - 256))));
                                        ++n62;
                                    }
                                    nArray5[n15 * n17 + n27 * n5 + (n28 + 1)] = n24++;
                                }
                            }
                        }
                    }
                    ++n23;
                    ++n8;
                    ++n28;
                }
                n26 = n12;
                n12 = n14;
                n14 = n26;
                ++n8;
                ++n27;
            }
            n26 = n13;
            n13 = n15;
            n15 = n26;
            n8 += n5;
            ++n25;
        }
        int n63 = 0;
        while (n63 < n7) {
            byArray2[n63] = new byte[n24];
            System.arraycopy(byArray3[n63], 0, byArray2[n63], 0, n24);
            ++n63;
        }
        return n24;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Linear3DSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!this.e((Set)object)) {
            return false;
        }
        return this.D.equals(((Linear3DSet)object).q()) && this.N.equals(((Linear3DSet)object).c()) && this.F.equals(((Linear3DSet)object).w());
    }

    public int hashCode() {
        if (!this.t) {
            this.d = this.m() ^ this.D.hashCode() ^ this.N.hashCode() ^ this.F.hashCode();
            this.t = true;
        }
        return this.d;
    }

    public Object c(MathType mathType) throws VisADException {
        Linear1DSet[] linear1DSetArray = new Linear1DSet[]{(Linear1DSet)this.D.clone(), (Linear1DSet)this.N.clone(), (Linear1DSet)this.F.clone()};
        return new Linear3DSet(mathType, linear1DSetArray, this.w, this.q, this.C, this.e);
    }

    public String a(String string) throws VisADException {
        String string2 = string + "Linear3DSet: Length = " + this.B + "\n";
        string2 = string2 + string + "  Dimension 1: Length = " + this.D.r() + " Range = " + this.D.u() + " to " + this.D.q() + "\n";
        string2 = string2 + string + "  Dimension 2: Length = " + this.N.r() + " Range = " + this.N.u() + " to " + this.N.q() + "\n";
        string2 = string2 + string + "  Dimension 3: Length = " + this.F.r() + " Range = " + this.F.u() + " to " + this.F.q() + "\n";
        return string2;
    }
}

