/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded2DSet;
import visad.Linear1DSet;
import visad.LinearSet;
import visad.MathType;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADException;

public class Linear2DSet
extends Gridded2DSet
implements LinearSet {
    public Linear1DSet s;
    public Linear1DSet A;
    private boolean e;

    public Linear2DSet(MathType mathType, Linear1DSet[] linear1DSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, linear1DSetArray, coordinateSystem, unitArray, errorEstimateArray, false);
    }

    public Linear2DSet(MathType mathType, Linear1DSet[] linear1DSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2) throws VisADException {
        super(mathType, (float[][])null, linear1DSetArray[0].r(), linear1DSetArray[1].r(), coordinateSystem, unitArray, errorEstimateArray);
        if (this.y != 2) {
            throw new SetException("Linear2DSet: DomainDimension must be 2, not " + this.y);
        }
        if (linear1DSetArray.length != 2) {
            throw new SetException("Linear2DSet: ManifoldDimension must be 2, not " + linear1DSetArray.length);
        }
        this.s = linear1DSetArray[0];
        this.A = linear1DSetArray[1];
        this.D = this.s.r();
        this.p = this.A.r();
        this.B = this.D * this.p;
        this.j[0] = this.s.w();
        this.l[0] = this.s.c();
        this.j[1] = this.A.w();
        this.l[1] = this.A.c();
        if (this.C[0] != null) {
            this.C[0] = new ErrorEstimate(this.C[0].a(), (double)(this.j[0] + this.l[0]) / 2.0, this.B, this.C[0].d());
        }
        if (this.C[1] != null) {
            this.C[1] = new ErrorEstimate(this.C[1].a(), (double)(this.j[1] + this.l[1]) / 2.0, this.B, this.C[1].d());
        }
        this.e = bl2;
    }

    public float[][] b(int[] nArray) throws VisADException {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        float[][] fArrayArray = new float[2][];
        int n3 = 0;
        while (n3 < n2) {
            if (0 <= nArray[n3] && nArray[n3] < this.B) {
                nArray2[n3] = nArray[n3] % this.D;
                nArray3[n3] = nArray[n3] / this.D;
            } else {
                nArray2[n3] = -1;
                nArray3[n3] = -1;
            }
            ++n3;
        }
        float[][] fArray = this.s.b(nArray2);
        float[][] fArray2 = this.A.b(nArray3);
        fArrayArray[0] = fArray[0];
        fArrayArray[1] = fArray2[0];
        return fArrayArray;
    }

    public float[][] c(float[][] fArray) throws VisADException {
        if (fArray.length != this.u) {
            throw new SetException("Linear2DSet.gridToValue: grid dimension " + fArray.length + " not equal to Manifold dimension " + this.u);
        }
        if (this.u != 2) {
            throw new SetException("Linear2DSet.gridToValue: Manifold dimension must be 2, not " + this.u);
        }
        if (this.i[0] < 2 || this.i[1] < 2) {
            throw new SetException("Linear2DSet.gridToValue: requires all grid dimensions to be > 1");
        }
        int n2 = fArray[0].length;
        float[][] fArrayArray = new float[][]{fArray[0]};
        float[][] fArrayArray2 = new float[][]{fArray[1]};
        float[][] fArray2 = this.s.c(fArrayArray);
        float[][] fArray3 = this.A.c(fArrayArray2);
        float[][] fArrayArray3 = new float[][]{fArray2[0], fArray3[0]};
        return fArrayArray3;
    }

    public float[][] f(float[][] fArray) throws VisADException {
        if (fArray.length != 2) {
            throw new SetException("Linear2DSet.valueToGrid: value dimension must be 2, not " + fArray.length);
        }
        if (this.i[0] < 2 || this.i[1] < 2) {
            throw new SetException("Linear2DSet.valueToGrid: requires all grid dimensions to be > 1");
        }
        int n2 = fArray[0].length;
        float[][] fArrayArray = new float[][]{fArray[0]};
        float[][] fArrayArray2 = new float[][]{fArray[1]};
        float[][] fArray2 = this.s.f(fArrayArray);
        float[][] fArray3 = this.A.f(fArrayArray2);
        float[][] fArrayArray3 = new float[][]{fArray2[0], fArray3[0]};
        return fArrayArray3;
    }

    public Linear1DSet q() {
        return this.s;
    }

    public Linear1DSet c() {
        return this.A;
    }

    public boolean j() {
        return false;
    }

    public float[][] a(boolean bl2) throws VisADException {
        if (this.k != null) {
            return bl2 ? Set.a(this.k) : this.k;
        }
        float[][] fArray = this.u();
        if (this.e) {
            this.k = fArray;
            return bl2 ? Set.a(this.k) : this.k;
        }
        return fArray;
    }

    private float[][] u() throws VisADException {
        float[][] fArray = this.s.a(false);
        float[][] fArray2 = this.A.a(false);
        float[][] fArray3 = new float[2][this.r()];
        int n2 = 0;
        int n3 = 0;
        while (n3 < fArray2[0].length) {
            int n4 = 0;
            while (n4 < fArray[0].length) {
                fArray3[0][n2] = fArray[0][n4];
                fArray3[1][n2] = fArray2[0][n3];
                ++n2;
                ++n4;
            }
            ++n3;
        }
        return fArray3;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Linear2DSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!this.e((Set)object)) {
            return false;
        }
        return this.s.equals(((Linear2DSet)object).q()) && this.A.equals(((Linear2DSet)object).c());
    }

    public int hashCode() {
        if (!this.t) {
            this.d = this.m() ^ this.s.hashCode() ^ this.A.hashCode();
            this.t = true;
        }
        return this.d;
    }

    public Object c(MathType mathType) throws VisADException {
        Linear1DSet[] linear1DSetArray = new Linear1DSet[]{(Linear1DSet)this.s.clone(), (Linear1DSet)this.A.clone()};
        return new Linear2DSet(mathType, linear1DSetArray, this.w, this.q, this.C, this.e);
    }

    public String a(String string) throws VisADException {
        String string2 = string + "Linear2DSet: Length = " + this.B + "\n";
        string2 = string2 + string + "  Dimension 1: Length = " + this.s.r() + " Range = " + this.s.u() + " to " + this.s.q() + "\n";
        string2 = string2 + string + "  Dimension 2: Length = " + this.A.r() + " Range = " + this.A.u() + " to " + this.A.q() + "\n";
        return string2;
    }
}

