/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.LinearSet;
import visad.MathType;
import visad.RealType;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADException;

public class Linear1DSet
extends Gridded1DSet
implements LinearSet {
    private double e;
    private double x;
    private double z;
    private double A;
    private boolean n;

    public Linear1DSet(double d2, double d3, int n2) throws VisADException {
        this((MathType)RealType.u, d2, d3, n2, null, null, null);
    }

    public Linear1DSet(MathType mathType, double d2, double d3, int n2) throws VisADException {
        this(mathType, d2, d3, n2, null, null, null);
    }

    public Linear1DSet(MathType mathType, double d2, double d3, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, d2, d3, n2, coordinateSystem, unitArray, errorEstimateArray, false);
    }

    public Linear1DSet(MathType mathType, double d2, double d3, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2) throws VisADException {
        super(mathType, (float[][])null, n2, coordinateSystem, unitArray, errorEstimateArray);
        if (this.y != 1) {
            throw new SetException("Linear1DSet: DomainDimension must be 1, not " + this.y);
        }
        this.e = d2;
        this.x = d3;
        this.B = n2;
        if (this.B < 1) {
            throw new SetException("Linear1DSet: number of samples (" + this.B + " must be greater than 1");
        }
        this.z = this.B < 2 ? 1.0 : (this.x - this.e) / (double)(this.B - 1);
        this.A = 1.0 / this.z;
        this.r = (float)Math.min(this.e, this.e + this.z * (double)(this.B - 1));
        this.b = (float)Math.max(this.e, this.e + this.z * (double)(this.B - 1));
        this.j[0] = this.r;
        this.l[0] = this.b;
        if (this.C[0] != null) {
            this.C[0] = new ErrorEstimate(this.C[0].a(), (double)(this.j[0] + this.l[0]) / 2.0, this.B, this.C[0].d());
        }
        this.n = bl2;
    }

    public float[][] b(int[] nArray) throws VisADException {
        int n2 = nArray.length;
        float[][] fArray = new float[1][n2];
        int n3 = 0;
        while (n3 < n2) {
            fArray[0][n3] = 0 <= nArray[n3] && nArray[n3] < this.B ? (float)(this.e + (double)nArray[n3] * this.z) : Float.NaN;
            ++n3;
        }
        return fArray;
    }

    public double[][] a(int[] nArray) throws VisADException {
        int n2 = nArray.length;
        double[][] dArray = new double[1][n2];
        int n3 = 0;
        while (n3 < n2) {
            dArray[0][n3] = 0 <= nArray[n3] && nArray[n3] < this.B ? this.e + (double)nArray[n3] * this.z : Double.NaN;
            ++n3;
        }
        return dArray;
    }

    public int[] b(double[][] dArray) throws VisADException {
        if (dArray.length != this.y) {
            throw new SetException("Linear1DSet.doubleToIndex: value dimension " + dArray.length + " not equal to Domain dimension " + this.y);
        }
        int n2 = dArray[0].length;
        int[] nArray = new int[n2];
        double d2 = -0.5;
        double d3 = (double)this.B - 0.5;
        int n3 = 0;
        while (n3 < n2) {
            double d4 = 0.5 + (dArray[0][n3] - this.e) * this.A;
            nArray[n3] = 0.0 < d4 && d4 < (double)this.B ? (int)d4 : -1;
            ++n3;
        }
        return nArray;
    }

    public float[][] c(float[][] fArray) throws VisADException {
        if (fArray.length != 1) {
            throw new SetException("Linear1DSet.gridToValue: grid dimension should be 1, not " + fArray.length);
        }
        if (this.i[0] < 2) {
            throw new SetException("Linear1DSet.gridToValue: requires all grid dimensions to be > 1");
        }
        int n2 = fArray[0].length;
        float[][] fArray2 = new float[1][n2];
        float[] fArray3 = fArray2[0];
        float[] fArray4 = fArray[0];
        float f2 = -0.5f;
        float f3 = (float)this.B - 0.5f;
        int n3 = 0;
        while (n3 < n2) {
            float f4 = fArray4[n3];
            fArray3[n3] = f2 < f4 && f4 < f3 ? (float)(this.e + (double)f4 * this.z) : Float.NaN;
            ++n3;
        }
        return fArray2;
    }

    public float[][] f(float[][] fArray) throws VisADException {
        if (fArray.length != 1) {
            throw new SetException("Linear1DSet.valueToGrid: value dimension should be 1, not " + fArray.length);
        }
        if (this.i[0] < 2) {
            throw new SetException("Linear1DSet.valueToGrid: requires all grid dimensions to be > 1");
        }
        int n2 = fArray[0].length;
        float[][] fArray2 = new float[1][n2];
        float[] fArray3 = fArray2[0];
        float[] fArray4 = fArray[0];
        float f2 = (float)(this.e + ((double)this.B - 0.5) * this.z);
        float f3 = (float)(this.e - 0.5 * this.z);
        if (f2 < f3) {
            float f4 = f3;
            f3 = f2;
            f2 = f4;
        }
        int n3 = 0;
        while (n3 < n2) {
            float f5 = fArray4[n3];
            fArray3[n3] = f3 < f5 && f5 < f2 ? (float)(((double)f5 - this.e) * this.A) : Float.NaN;
            ++n3;
        }
        return fArray2;
    }

    public double u() {
        return this.e;
    }

    public double q() {
        return this.x;
    }

    public double x() {
        return this.z;
    }

    public boolean j() {
        return false;
    }

    public double[][] b(boolean bl2) throws VisADException {
        double[][] dArray = new double[1][this.B];
        int n2 = 0;
        while (n2 < this.B) {
            dArray[0][n2] = this.e + (double)n2 * this.z;
            ++n2;
        }
        return dArray;
    }

    public float[][] a(boolean bl2) throws VisADException {
        if (this.k != null) {
            return bl2 ? Set.a(this.k) : this.k;
        }
        float[][] fArray = this.y();
        if (this.n) {
            this.k = fArray;
            return bl2 ? Set.a(this.k) : this.k;
        }
        return fArray;
    }

    private float[][] y() throws VisADException {
        float[][] fArray = new float[1][this.B];
        int n2 = 0;
        while (n2 < this.B) {
            fArray[0][n2] = (float)(this.e + (double)n2 * this.z);
            ++n2;
        }
        return fArray;
    }

    public boolean equals(Object object) {
        boolean bl2;
        if (!(object instanceof Linear1DSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!this.e((Set)object)) {
            return false;
        }
        try {
            bl2 = this.e == ((Linear1DSet)object).u() && this.x == ((Linear1DSet)object).q() && this.B == ((Linear1DSet)object).r();
        }
        catch (VisADException visADException) {
            return false;
        }
        return bl2;
    }

    public int hashCode() {
        if (!this.t) {
            this.d = this.m() ^ new Double(this.e).hashCode() ^ new Double(this.x).hashCode() ^ this.B;
            this.t = true;
        }
        return this.d;
    }

    public Object c(MathType mathType) throws VisADException {
        return new Linear1DSet(mathType, this.e, this.x, this.B, this.w, this.q, this.C, this.n);
    }

    public String a(String string) throws VisADException {
        return string + "Linear1DSet: Length = " + this.B + " Range = " + this.e + " to " + this.x + "\n";
    }
}

