/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.Delaunay;
import visad.ErrorEstimate;
import visad.LinearSet;
import visad.MathType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;

public class IrregularSet
extends SampledSet {
    public Delaunay p = null;
    public int[] e;
    public int[] i;

    public IrregularSet(MathType mathType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Delaunay delaunay) throws VisADException {
        this(mathType, fArray, fArray.length, coordinateSystem, unitArray, errorEstimateArray, delaunay, true);
    }

    public IrregularSet(MathType mathType, float[][] fArray, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Delaunay delaunay, boolean bl2) throws VisADException {
        super(mathType, n2, coordinateSystem, unitArray, errorEstimateArray);
        if (fArray == null) {
            throw new SetException("IrregularSet: samples cannot be null");
        }
        this.a(fArray, bl2);
        if (this.u > 1) {
            this.p = delaunay != null ? (bl2 ? (Delaunay)delaunay.clone() : delaunay) : Delaunay.a(fArray, false);
        }
    }

    public float[][] b(int[] nArray) throws VisADException {
        float[][] fArray = new float[this.y][nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3;
            if (nArray[n2] >= 0 && nArray[n2] < this.B) {
                n3 = 0;
                while (n3 < this.y) {
                    fArray[n3][n2] = this.k[n3][nArray[n2]];
                    ++n3;
                }
            } else {
                n3 = 0;
                while (n3 < this.y) {
                    fArray[n3][n2] = Float.NaN;
                    ++n3;
                }
            }
            ++n2;
        }
        return fArray;
    }

    public int[] b(float[][] fArray) throws VisADException {
        throw new UnimplementedException("IrregularSet.valueToIndex");
    }

    public void a(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        throw new UnimplementedException("IrregularSet.valueToInterp");
    }

    public boolean equals(Object object) {
        if (!(object instanceof IrregularSet) || object == null || object instanceof LinearSet) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.f((Set)object)) {
            return false;
        }
        if (this.b((Set)object)) {
            return true;
        }
        if (!this.e((Set)object)) {
            return false;
        }
        try {
            if (this.y != ((IrregularSet)object).s() || this.u != ((IrregularSet)object).v() || this.B != ((IrregularSet)object).r()) {
                return false;
            }
            float[][] fArray = ((IrregularSet)object).a(false);
            int n2 = 0;
            while (n2 < this.y) {
                int n3 = 0;
                while (n3 < this.B) {
                    if (this.k[n2][n3] != fArray[n2][n3]) {
                        this.d((Set)object);
                        return false;
                    }
                    ++n3;
                }
                ++n2;
            }
            this.a((Set)object);
            return true;
        }
        catch (VisADException visADException) {
            return false;
        }
    }

    public Object clone() {
        IrregularSet irregularSet = (IrregularSet)super.clone();
        if (this.p != null) {
            irregularSet.p = (Delaunay)this.p.clone();
        }
        return irregularSet;
    }

    public Object c(MathType mathType) throws VisADException {
        return new IrregularSet(mathType, this.k, this.w, this.q, this.C, this.p);
    }

    public String a(String string) throws VisADException {
        String string2;
        if (this.y == this.u) {
            string2 = string + this.getClass().getName() + ": Dimension = " + this.y + " Length = " + this.B + "\n";
            int n2 = 0;
            while (n2 < this.y) {
                string2 = string2 + string + "  Dimension " + n2 + ":" + " Range = " + this.j[n2] + " to " + this.l[n2] + "\n";
                ++n2;
            }
        } else {
            string2 = string + this.getClass().getName() + ": DomainDimension = " + this.y + " ManifoldDimension = " + this.u + " Length = " + this.B + "\n";
            int n3 = 0;
            while (n3 < this.y) {
                string2 = string2 + string + "  DomainDimension " + n3 + ":" + " Range = " + this.j[n3] + " to " + this.l[n3] + "\n";
                ++n3;
            }
        }
        return string2;
    }
}

