/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.Delaunay;
import visad.DisplayException;
import visad.ErrorEstimate;
import visad.IrregularSet;
import visad.MathType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADIndexedTriangleStripArray;
import visad.VisADLineArray;
import visad.VisADTriangleStripArray;

public class Irregular3DSet
extends IrregularSet {
    private float n;
    private float b;
    private float x;
    private float z;
    private float o;
    private float r;
    public static final int[] m = new int[]{0, 1, 2, 1, 2, 0, 2, 0, 1, 0, 1, 3, 2, 1, 2, 0, 3, 2, 3, 1, 0, 3, 0, 2, 1, 0, 1, 4, 2, 3, 1, 2, 0, 3, 4, 2, 3, 1, 4, 0, 3, 4, 2, 0, 1, 4, 0, 3, 1, 2, 0, 1, 5, 2, 4, 3, 1, 2, 0, 3, 5, 4, 2, 3, 1, 4, 0, 5, 3, 4, 2, 5, 1, 0, 4, 5, 3, 0, 2, 1, 5, 0, 4, 1, 3, 2};
    public static final int[] s = new int[]{0, 2, 1, 1, 0, 2, 2, 1, 0, 0, 3, 1, 2, 1, 0, 2, 3, 2, 1, 3, 0, 3, 2, 0, 1, 0, 4, 1, 3, 2, 1, 0, 2, 4, 3, 2, 1, 3, 0, 4, 3, 2, 4, 1, 0, 4, 3, 0, 2, 1, 0, 5, 1, 4, 2, 3, 1, 0, 2, 5, 3, 4, 2, 1, 3, 0, 4, 5, 3, 2, 4, 1, 5, 0, 4, 3, 5, 2, 0, 1, 5, 4, 0, 3, 1, 2};
    public static final int[] v = new int[]{0, 9, 25, 50};

    public Irregular3DSet(MathType mathType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Delaunay delaunay) throws VisADException {
        this(mathType, fArray, coordinateSystem, unitArray, errorEstimateArray, delaunay, true);
    }

    public Irregular3DSet(MathType mathType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Delaunay delaunay, boolean bl2) throws VisADException {
        super(mathType, fArray, delaunay == null ? fArray.length : delaunay.c[0].length - 1, coordinateSystem, unitArray, errorEstimateArray, delaunay, bl2);
        this.n = this.j[0];
        this.b = this.l[0];
        this.x = this.j[1];
        this.z = this.l[1];
        this.o = this.j[2];
        this.r = this.l[2];
        this.e = null;
        this.i = null;
    }

    public Irregular3DSet(MathType mathType, float[][] fArray, int[] nArray, int[] nArray2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, fArray, nArray, nArray2, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Irregular3DSet(MathType mathType, float[][] fArray, int[] nArray, int[] nArray2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2) throws VisADException {
        super(mathType, fArray, 1, coordinateSystem, unitArray, errorEstimateArray, null, bl2);
        if (this.B != nArray.length || this.B != nArray2.length) {
            throw new SetException("Irregular3DSet: sort lengths do not match");
        }
        this.i = new int[this.B];
        this.e = new int[this.B];
        System.arraycopy(nArray, 0, this.i, 0, this.B);
        System.arraycopy(nArray2, 0, this.e, 0, this.B);
        this.n = this.j[0];
        this.b = this.l[0];
        this.x = this.j[1];
        this.z = this.l[1];
        this.o = this.j[2];
        this.r = this.l[2];
        this.p = null;
    }

    public Set a(SetType setType, float[][] fArray) throws VisADException {
        if (fArray.length == 3) {
            if (this.u == 1) {
                return new Irregular3DSet((MathType)setType, fArray, this.i, this.e, null, null, null, false);
            }
            if (this.p.c == null || this.p.c.length == 0) {
                return null;
            }
            return new Irregular3DSet((MathType)setType, fArray, null, null, null, this.p, false);
        }
        throw new SetException("Irregular3DSet.makeSpatial: bad samples length");
    }

    public float[][] b(int[] nArray) throws VisADException {
        float[][] fArray = new float[3][nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] >= 0 && nArray[n2] < this.B) {
                fArray[0][n2] = this.k[0][nArray[n2]];
                fArray[1][n2] = this.k[1][nArray[n2]];
                fArray[2][n2] = this.k[2][nArray[n2]];
            } else {
                fArray[2][n2] = Float.NaN;
                fArray[1][n2] = Float.NaN;
                fArray[0][n2] = Float.NaN;
            }
            ++n2;
        }
        return fArray;
    }

    public int[] c(float[][] fArray) throws VisADException {
        if (this.u != 3) {
            throw new SetException("Irregular3DSet.valueToTri: ManifoldDimension must be 3, not " + this.u);
        }
        int n2 = fArray[0].length;
        if (n2 != fArray[1].length || n2 != fArray[2].length) {
            throw new SetException("Irregular3DSet.valueToTri: lengths don't match");
        }
        boolean bl2 = this.p.a();
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        float[] fArray6 = new float[3];
        float[] fArray7 = new float[3];
        float[] fArray8 = new float[3];
        float[] fArray9 = new float[3];
        boolean[] blArray = new boolean[this.p.c.length];
        int n3 = 0;
        while (n3 < blArray.length) {
            blArray[n3] = false;
            ++n3;
        }
        int[] nArray = null;
        int n4 = 0;
        int[] nArray2 = new int[n2];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7;
            nArray2[n6] = -1;
            boolean bl3 = false;
            if (n5 < 0) {
                n5 = 0;
            }
            int n8 = 0;
            while (n8 < this.p.c.length && !bl3) {
                boolean bl4;
                boolean bl5;
                boolean bl6;
                boolean bl7;
                n7 = this.p.c[n5][0];
                int n9 = this.p.c[n5][1];
                int n10 = this.p.c[n5][2];
                int n11 = this.p.c[n5][3];
                float f2 = this.k[0][n7];
                float f3 = this.k[1][n7];
                float f4 = this.k[2][n7];
                float f5 = this.k[0][n9];
                float f6 = this.k[1][n9];
                float f7 = this.k[2][n9];
                float f8 = this.k[0][n10];
                float f9 = this.k[1][n10];
                float f10 = this.k[2][n10];
                float f11 = this.k[0][n11];
                float f12 = this.k[1][n11];
                float f13 = this.k[2][n11];
                float f14 = fArray[0][n6];
                float f15 = fArray[1][n6];
                float f16 = fArray[2][n6];
                fArray2[0] = f14 - f2;
                fArray2[1] = f15 - f3;
                fArray2[2] = f16 - f4;
                fArray3[0] = f14 - f5;
                fArray3[1] = f15 - f6;
                fArray3[2] = f16 - f7;
                fArray4[0] = f14 - f8;
                fArray4[1] = f15 - f9;
                fArray4[2] = f16 - f10;
                fArray5[0] = f14 - f11;
                fArray5[1] = f15 - f12;
                fArray5[2] = f16 - f13;
                fArray6[0] = (f6 - f3) * (f10 - f7) - (f7 - f4) * (f9 - f6);
                fArray6[1] = (f7 - f4) * (f8 - f5) - (f5 - f2) * (f10 - f7);
                fArray6[2] = (f5 - f2) * (f9 - f6) - (f6 - f3) * (f8 - f5);
                float f17 = fArray6[0] + fArray6[1] + fArray6[2];
                fArray7[0] = (f9 - f6) * (f13 - f10) - (f10 - f7) * (f12 - f9);
                fArray7[1] = (f10 - f7) * (f11 - f8) - (f8 - f5) * (f13 - f10);
                fArray7[2] = (f8 - f5) * (f12 - f9) - (f9 - f6) * (f11 - f8);
                float f18 = fArray7[0] + fArray7[1] + fArray7[2];
                fArray8[0] = (f12 - f9) * (f4 - f13) - (f13 - f10) * (f3 - f12);
                fArray8[1] = (f13 - f10) * (f2 - f11) - (f11 - f8) * (f4 - f13);
                fArray8[2] = (f11 - f8) * (f3 - f12) - (f12 - f9) * (f2 - f11);
                float f19 = fArray8[0] + fArray8[1] + fArray8[2];
                fArray9[0] = (f3 - f12) * (f7 - f4) - (f4 - f13) * (f6 - f3);
                fArray9[1] = (f4 - f13) * (f5 - f2) - (f2 - f11) * (f7 - f4);
                fArray9[2] = (f2 - f11) * (f6 - f3) - (f3 - f12) * (f5 - f2);
                float f20 = fArray9[0] + fArray9[1] + fArray9[2];
                float f21 = fArray6[0] * fArray2[0] + fArray6[1] * fArray2[1] + fArray6[2] * fArray2[2];
                float f22 = fArray7[0] * fArray3[0] + fArray7[1] * fArray3[1] + fArray7[2] * fArray3[2];
                float f23 = fArray8[0] * fArray4[0] + fArray8[1] * fArray4[1] + fArray8[2] * fArray4[2];
                float f24 = fArray9[0] * fArray5[0] + fArray9[1] * fArray5[1] + fArray9[2] * fArray5[2];
                boolean bl8 = (f21 == 0.0f || f21 > 0.0f == fArray6[0] * (f11 - f2) + fArray6[1] * (f12 - f3) + fArray6[2] * (f13 - f4) > 0.0f) && f17 != 0.0f ? true : (bl7 = false);
                boolean bl9 = (f22 == 0.0f || f22 > 0.0f == fArray7[0] * (f2 - f5) + fArray7[1] * (f3 - f6) + fArray7[2] * (f4 - f7) > 0.0f) && f18 != 0.0f ? true : (bl6 = false);
                boolean bl10 = (f23 == 0.0f || f23 > 0.0f == fArray8[0] * (f5 - f8) + fArray8[1] * (f6 - f9) + fArray8[2] * (f7 - f10) > 0.0f) && f19 != 0.0f ? true : (bl5 = false);
                boolean bl11 = (f24 == 0.0f || f24 > 0.0f == fArray9[0] * (f8 - f11) + fArray9[1] * (f9 - f12) + fArray9[2] * (f10 - f13) > 0.0f) && f20 != 0.0f ? true : (bl4 = false);
                if (!(bl7 && bl6 && bl5 && bl4)) {
                    blArray[n5] = true;
                    if (nArray == null) {
                        nArray = new int[4];
                        n4 = 0;
                    } else if (n4 >= nArray.length) {
                        int[] nArray3 = new int[2 * nArray.length];
                        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
                        nArray = nArray3;
                    }
                    nArray[n4] = n5;
                    ++n4;
                    int n12 = -1;
                    boolean bl12 = true;
                    if (!bl7 && bl12 && (n12 = this.p.b[n5][0]) != -1) {
                        bl12 = blArray[n12];
                    }
                    if (!bl6 && bl12 && (n12 = this.p.b[n5][1]) != -1) {
                        bl12 = blArray[n12];
                    }
                    if (!bl5 && bl12 && (n12 = this.p.b[n5][2]) != -1) {
                        bl12 = blArray[n12];
                    }
                    if (!bl4 && bl12 && (n12 = this.p.b[n5][3]) != -1) {
                        bl12 = blArray[n12];
                    }
                    if (!bl12 || n12 == -1) {
                        n5 = n12;
                    }
                    if (bl12) {
                        n5 = -1;
                    }
                    if (bl2 && n5 == -1) {
                        int n13 = 0;
                        while (n13 < blArray.length) {
                            if (!blArray[n13]) {
                                n5 = n13;
                                break;
                            }
                            ++n13;
                        }
                    }
                } else {
                    bl3 = true;
                }
                if (n5 < 0) {
                    bl3 = true;
                }
                if (bl3) {
                    nArray2[n6] = n5;
                }
                ++n8;
            }
            if (nArray != null) {
                n7 = 0;
                while (n7 < n4) {
                    blArray[nArray[n7]] = false;
                    ++n7;
                }
                nArray = null;
            }
            ++n6;
        }
        return nArray2;
    }

    public int[] b(float[][] fArray) throws VisADException {
        if (fArray.length < this.y) {
            throw new SetException("Irregular3DSet.valueToIndex: value dimension " + fArray.length + " not equal to Domain dimension " + this.y);
        }
        int[] nArray = this.c(fArray);
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] < 0) {
                nArray2[n2] = -1;
            } else {
                float f2 = fArray[0][n2];
                float f3 = fArray[1][n2];
                float f4 = fArray[2][n2];
                int n3 = nArray[n2];
                int n4 = this.p.c[n3][0];
                int n5 = this.p.c[n3][1];
                int n6 = this.p.c[n3][2];
                int n7 = this.p.c[n3][3];
                float f5 = this.k[0][n4] - f2;
                float f6 = this.k[1][n4] - f3;
                float f7 = this.k[2][n4] - f4;
                float f8 = this.k[0][n5] - f2;
                float f9 = this.k[1][n5] - f3;
                float f10 = this.k[2][n5] - f4;
                float f11 = this.k[0][n6] - f2;
                float f12 = this.k[1][n6] - f3;
                float f13 = this.k[2][n6] - f4;
                float f14 = this.k[0][n7] - f2;
                float f15 = this.k[1][n7] - f3;
                float f16 = this.k[2][n7] - f4;
                float f17 = f5 * f5 + f6 * f6 + f7 * f7;
                float f18 = f8 * f8 + f9 * f9 + f10 * f10;
                float f19 = f11 * f11 + f12 * f12 + f13 * f13;
                float f20 = f14 * f14 + f15 * f15 + f16 * f16;
                float f21 = Math.min(f17, f18);
                f21 = Math.min(f21, f19);
                nArray2[n2] = (f21 = Math.min(f21, f20)) == f17 ? n4 : (f21 == f18 ? n5 : (f21 == f19 ? n6 : n7));
            }
            ++n2;
        }
        return nArray2;
    }

    public void a(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        if (fArray.length < this.y) {
            throw new SetException("Irregular3DSet.valueToInterp: value dimension " + fArray.length + " not equal to Domain dimension " + this.y);
        }
        int n2 = fArray[0].length;
        if (nArray.length < n2 || fArray2.length < n2) {
            throw new SetException("Irregular3DSet.valueToInterp: lengths don't match");
        }
        int[] nArray2 = this.c(fArray);
        int n3 = 0;
        while (n3 < nArray2.length) {
            if (nArray2[n3] < 0) {
                nArray[n3] = null;
                fArray2[n3] = null;
            } else {
                int[] nArray3 = new int[4];
                float[] fArray3 = new float[4];
                float f2 = fArray[0][n3];
                float f3 = fArray[1][n3];
                float f4 = fArray[2][n3];
                int n4 = nArray2[n3];
                int n5 = this.p.c[n4][0];
                int n6 = this.p.c[n4][1];
                int n7 = this.p.c[n4][2];
                int n8 = this.p.c[n4][3];
                nArray3[0] = n5;
                nArray3[1] = n6;
                nArray3[2] = n7;
                nArray3[3] = n8;
                float f5 = this.k[0][n5];
                float f6 = this.k[1][n5];
                float f7 = this.k[2][n5];
                float f8 = this.k[0][n6];
                float f9 = this.k[1][n6];
                float f10 = this.k[2][n6];
                float f11 = this.k[0][n7];
                float f12 = this.k[1][n7];
                float f13 = this.k[2][n7];
                float f14 = this.k[0][n8];
                float f15 = this.k[1][n8];
                float f16 = this.k[2][n8];
                float f17 = (f15 - f9) * (f13 - f10) - (f16 - f10) * (f12 - f9);
                float f18 = (f16 - f10) * (f11 - f8) - (f14 - f8) * (f13 - f10);
                float f19 = (f14 - f8) * (f12 - f9) - (f15 - f9) * (f11 - f8);
                float f20 = (f15 - f6) * (f13 - f7) - (f16 - f7) * (f12 - f6);
                float f21 = (f16 - f7) * (f11 - f5) - (f14 - f5) * (f13 - f7);
                float f22 = (f14 - f5) * (f12 - f6) - (f15 - f6) * (f11 - f5);
                float f23 = (f15 - f6) * (f10 - f7) - (f16 - f7) * (f9 - f6);
                float f24 = (f16 - f7) * (f8 - f5) - (f14 - f5) * (f10 - f7);
                float f25 = (f14 - f5) * (f9 - f6) - (f15 - f6) * (f8 - f5);
                float f26 = (f12 - f6) * (f10 - f7) - (f13 - f7) * (f9 - f6);
                float f27 = (f13 - f7) * (f8 - f5) - (f11 - f5) * (f10 - f7);
                float f28 = (f11 - f5) * (f9 - f6) - (f12 - f6) * (f8 - f5);
                fArray3[0] = ((f2 - f8) * f17 + (f3 - f9) * f18 + (f4 - f10) * f19) / ((f5 - f8) * f17 + (f6 - f9) * f18 + (f7 - f10) * f19);
                fArray3[1] = ((f2 - f5) * f20 + (f3 - f6) * f21 + (f4 - f7) * f22) / ((f8 - f5) * f20 + (f9 - f6) * f21 + (f10 - f7) * f22);
                fArray3[2] = ((f2 - f5) * f23 + (f3 - f6) * f24 + (f4 - f7) * f25) / ((f11 - f5) * f23 + (f12 - f6) * f24 + (f13 - f7) * f25);
                fArray3[3] = ((f2 - f5) * f26 + (f3 - f6) * f27 + (f4 - f7) * f28) / ((f14 - f5) * f26 + (f15 - f6) * f27 + (f16 - f7) * f28);
                nArray[n3] = nArray3;
                fArray2[n3] = fArray3;
            }
            ++n3;
        }
    }

    public VisADGeometryArray[][] a(float[] fArray, float f2, float f3, float f4, float[] fArray2, byte[][] byArray, boolean[] blArray, boolean bl2, boolean bl3, ScalarMap[] scalarMapArray, double d2, double d3, float[][][] fArray3) throws VisADException {
        if (this.u != 2) {
            throw new DisplayException("Irregular3DSet.makeIsoLines: ManifoldDimension must be 2, not " + this.u);
        }
        if (fArray == null) {
            return null;
        }
        int[][] nArray = this.p.c;
        float[][] fArray4 = this.a(false);
        int n2 = nArray.length;
        int n3 = this.p.e.length;
        if (n2 < 1 || n3 < 3) {
            return null;
        }
        int n4 = 4 * this.B;
        int n5 = byArray != null ? byArray.length : 0;
        byte[][] byArray2 = null;
        if (n5 > 0) {
            if (n5 > 3) {
                n5 = 3;
            }
            byArray2 = new byte[n5][n4];
        }
        float[] fArray5 = new float[n4];
        float[] fArray6 = new float[n4];
        float[] fArray7 = new float[n4];
        int n6 = 0;
        int n7 = 0;
        while (n7 < n2) {
            float f5;
            float f6;
            int n8 = nArray[n7][0];
            int n9 = nArray[n7][1];
            int n10 = nArray[n7][2];
            float f7 = fArray2[n8];
            if (f7 == f7 && (f6 = fArray2[n9]) == f6 && (f5 = fArray2[n10]) == f5) {
                byte[] byArray3 = null;
                byte[] byArray4 = null;
                byte[] byArray5 = null;
                if (n5 > 0) {
                    byArray3 = new byte[n5];
                    byArray4 = new byte[n5];
                    byArray5 = new byte[n5];
                    int n11 = 0;
                    while (n11 < n5) {
                        byArray3[n11] = byArray[n11][n8];
                        byArray4[n11] = byArray[n11][n9];
                        byArray5[n11] = byArray[n11][n10];
                        ++n11;
                    }
                }
                float f8 = f7 < f6 ? f7 : f6;
                f8 = f5 < f8 ? f5 : f8;
                float f9 = f7 > f6 ? f7 : f6;
                f9 = f5 > f9 ? f5 : f9;
                int n12 = 0;
                while (n12 < fArray.length) {
                    float f10 = fArray[n12];
                    if (n6 + 8 >= n4) {
                        n4 = 2 * n4;
                        byte[][] byArray6 = byArray2;
                        byArray2 = new byte[n5][n4];
                        int n13 = 0;
                        while (n13 < n5) {
                            System.arraycopy(byArray6[n13], 0, byArray2[n13], 0, n6);
                            ++n13;
                        }
                        float[] fArray8 = fArray5;
                        float[] fArray9 = fArray6;
                        float[] fArray10 = fArray7;
                        fArray5 = new float[n4];
                        fArray6 = new float[n4];
                        fArray7 = new float[n4];
                        System.arraycopy(fArray8, 0, fArray5, 0, n6);
                        System.arraycopy(fArray9, 0, fArray6, 0, n6);
                        System.arraycopy(fArray10, 0, fArray7, 0, n6);
                    }
                    if (!(f10 < f8)) {
                        if (f10 > f9) break;
                        if (!(f10 < f2)) {
                            if (f10 > f3) break;
                            int n14 = 0;
                            if (f10 > f7) {
                                n14 = 1;
                            }
                            if (f10 > f6) {
                                n14 += 2;
                            }
                            if (f10 > f5) {
                                n14 += 4;
                            }
                            if (n14 > 3) {
                                n14 = 7 - n14;
                            }
                            if (n14 > 0) {
                                switch (n14) {
                                    case 1: {
                                        int n15;
                                        int n16;
                                        float f11 = f6 - f7;
                                        float f12 = f5 - f7;
                                        float f13 = (f10 - f7) / f11;
                                        float f14 = (f10 - f7) / f12;
                                        if (n5 > 0) {
                                            n16 = 0;
                                            while (n16 < n5) {
                                                n15 = (int)((1.0f - f13) * (byArray3[n16] < 0 ? (float)byArray3[n16] + 256.0f : (float)byArray3[n16]) + f13 * (byArray4[n16] < 0 ? (float)byArray4[n16] + 256.0f : (float)byArray4[n16]));
                                                byArray2[n16][n6] = (byte)(n15 < 0 ? 0 : (byte)(n15 > 255 ? -1 : (n15 < 128 ? (byte)n15 : (byte)(n15 - 256))));
                                                n15 = (int)((1.0f - f14) * (byArray3[n16] < 0 ? (float)byArray3[n16] + 256.0f : (float)byArray3[n16]) + f14 * (byArray5[n16] < 0 ? (float)byArray5[n16] + 256.0f : (float)byArray5[n16]));
                                                byArray2[n16][n6 + 1] = (byte)(n15 < 0 ? 0 : (byte)(n15 > 255 ? -1 : (n15 < 128 ? (byte)n15 : (byte)(n15 - 256))));
                                                ++n16;
                                            }
                                        }
                                        fArray5[n6] = fArray4[0][n8] + (fArray4[0][n9] - fArray4[0][n8]) * f13;
                                        fArray6[n6] = fArray4[1][n8] + (fArray4[1][n9] - fArray4[1][n8]) * f13;
                                        fArray7[n6] = fArray4[2][n8] + (fArray4[2][n9] - fArray4[2][n8]) * f13;
                                        fArray5[++n6] = fArray4[0][n8] + (fArray4[0][n10] - fArray4[0][n8]) * f14;
                                        fArray6[n6] = fArray4[1][n8] + (fArray4[1][n10] - fArray4[1][n8]) * f14;
                                        fArray7[n6] = fArray4[2][n8] + (fArray4[2][n10] - fArray4[2][n8]) * f14;
                                        ++n6;
                                        break;
                                    }
                                    case 2: {
                                        int n15;
                                        int n16;
                                        float f15 = f6 - f7;
                                        float f16 = f5 - f6;
                                        float f17 = (f10 - f7) / f15;
                                        float f18 = (f10 - f6) / f16;
                                        if (n5 > 0) {
                                            n16 = 0;
                                            while (n16 < n5) {
                                                n15 = (int)((1.0f - f17) * (byArray3[n16] < 0 ? (float)byArray3[n16] + 256.0f : (float)byArray3[n16]) + f17 * (byArray4[n16] < 0 ? (float)byArray4[n16] + 256.0f : (float)byArray4[n16]));
                                                byArray2[n16][n6] = (byte)(n15 < 0 ? 0 : (byte)(n15 > 255 ? -1 : (n15 < 128 ? (byte)n15 : (byte)(n15 - 256))));
                                                n15 = (int)((1.0f - f18) * (byArray4[n16] < 0 ? (float)byArray4[n16] + 256.0f : (float)byArray4[n16]) + f18 * (byArray5[n16] < 0 ? (float)byArray5[n16] + 256.0f : (float)byArray5[n16]));
                                                byArray2[n16][n6 + 1] = (byte)(n15 < 0 ? 0 : (byte)(n15 > 255 ? -1 : (n15 < 128 ? (byte)n15 : (byte)(n15 - 256))));
                                                ++n16;
                                            }
                                        }
                                        fArray5[n6] = fArray4[0][n8] + (fArray4[0][n9] - fArray4[0][n8]) * f17;
                                        fArray6[n6] = fArray4[1][n8] + (fArray4[1][n9] - fArray4[1][n8]) * f17;
                                        fArray7[n6] = fArray4[2][n8] + (fArray4[2][n9] - fArray4[2][n8]) * f17;
                                        fArray5[++n6] = fArray4[0][n9] + (fArray4[0][n10] - fArray4[0][n9]) * f18;
                                        fArray6[n6] = fArray4[1][n9] + (fArray4[1][n10] - fArray4[1][n9]) * f18;
                                        fArray7[n6] = fArray4[2][n9] + (fArray4[2][n10] - fArray4[2][n9]) * f18;
                                        ++n6;
                                        break;
                                    }
                                    case 3: {
                                        int n15;
                                        int n16;
                                        float f19 = f5 - f7;
                                        float f20 = f5 - f6;
                                        float f21 = (f10 - f7) / f19;
                                        float f18 = (f10 - f6) / f20;
                                        if (n5 > 0) {
                                            n16 = 0;
                                            while (n16 < n5) {
                                                n15 = (int)((1.0f - f21) * (byArray3[n16] < 0 ? (float)byArray3[n16] + 256.0f : (float)byArray3[n16]) + f21 * (byArray5[n16] < 0 ? (float)byArray5[n16] + 256.0f : (float)byArray5[n16]));
                                                byArray2[n16][n6] = (byte)(n15 < 0 ? 0 : (byte)(n15 > 255 ? -1 : (n15 < 128 ? (byte)n15 : (byte)(n15 - 256))));
                                                n15 = (int)((1.0f - f18) * (byArray4[n16] < 0 ? (float)byArray4[n16] + 256.0f : (float)byArray4[n16]) + f18 * (byArray5[n16] < 0 ? (float)byArray5[n16] + 256.0f : (float)byArray5[n16]));
                                                byArray2[n16][n6 + 1] = (byte)(n15 < 0 ? 0 : (byte)(n15 > 255 ? -1 : (n15 < 128 ? (byte)n15 : (byte)(n15 - 256))));
                                                ++n16;
                                            }
                                        }
                                        fArray5[n6] = fArray4[0][n8] + (fArray4[0][n10] - fArray4[0][n8]) * f21;
                                        fArray6[n6] = fArray4[1][n8] + (fArray4[1][n10] - fArray4[1][n8]) * f21;
                                        fArray7[n6] = fArray4[2][n8] + (fArray4[2][n10] - fArray4[2][n8]) * f21;
                                        fArray5[++n6] = fArray4[0][n9] + (fArray4[0][n10] - fArray4[0][n9]) * f18;
                                        fArray6[n6] = fArray4[1][n9] + (fArray4[1][n10] - fArray4[1][n9]) * f18;
                                        fArray7[n6] = fArray4[2][n9] + (fArray4[2][n10] - fArray4[2][n9]) * f18;
                                        ++n6;
                                    }
                                }
                            }
                        }
                    }
                    ++n12;
                }
            }
            ++n7;
        }
        VisADGeometryArray[][] visADGeometryArrayArray = new VisADLineArray[3][1];
        visADGeometryArrayArray[0][0] = new VisADLineArray();
        float[][] fArray11 = new float[3][n6];
        System.arraycopy(fArray5, 0, fArray11[0], 0, n6);
        System.arraycopy(fArray6, 0, fArray11[1], 0, n6);
        System.arraycopy(fArray7, 0, fArray11[2], 0, n6);
        fArray5 = null;
        fArray6 = null;
        fArray7 = null;
        byte[][] byArray7 = null;
        if (n5 > 0) {
            byArray7 = new byte[3][n6];
            System.arraycopy(byArray2[0], 0, byArray7[0], 0, n6);
            System.arraycopy(byArray2[1], 0, byArray7[1], 0, n6);
            System.arraycopy(byArray2[2], 0, byArray7[2], 0, n6);
            byArray2 = null;
        }
        SampledSet.a(visADGeometryArrayArray[0][0], fArray11, 3, byArray7);
        visADGeometryArrayArray[1][0] = null;
        visADGeometryArrayArray[2][0] = null;
        return visADGeometryArrayArray;
    }

    public VisADGeometryArray a(float f2, float[] fArray, byte[][] byArray, boolean bl2) throws VisADException {
        if (this.u != 3) {
            throw new DisplayException("Irregular3DSet.main_isosurf: ManifoldDimension must be 3, not " + this.u);
        }
        float[][] fArrayArray = new float[3][];
        byte[][] byArrayArray = null;
        if (byArray != null) {
            byArrayArray = new byte[byArray.length][];
        }
        int[][][] nArrayArray = new int[1][][];
        int[][][] nArrayArray2 = new int[1][][];
        this.a(f2, fArray, byArray, fArrayArray, byArrayArray, nArrayArray, nArrayArray2);
        int n2 = nArrayArray2[0].length;
        int n3 = nArrayArray[0].length;
        float[] fArray2 = new float[n2];
        float[] fArray3 = new float[n2];
        float[] fArray4 = new float[n2];
        if (n2 == 0 || n3 == 0) {
            return null;
        }
        float[] fArray5 = new float[n3];
        float[] fArray6 = new float[n3];
        float[] fArray7 = new float[n3];
        float[] fArray8 = new float[n3];
        float[] fArray9 = new float[n3];
        float[] fArray10 = new float[n3];
        float[] fArray11 = new float[n3];
        float[] fArray12 = new float[n3];
        float[] fArray13 = new float[n3];
        Irregular3DSet.a(fArrayArray[0], fArrayArray[1], fArrayArray[2], fArray2, fArray3, fArray4, n2, n3, fArray11, fArray12, fArray13, fArray5, fArray6, fArray7, fArray8, fArray9, fArray10, nArrayArray2[0], nArrayArray[0]);
        fArray13 = null;
        fArray12 = null;
        fArray11 = null;
        fArray10 = null;
        fArray9 = null;
        fArray8 = null;
        fArray7 = null;
        fArray6 = null;
        fArray5 = null;
        float[] fArray14 = new float[3 * n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            fArray14[n4++] = fArray2[n5];
            fArray14[n4++] = fArray3[n5];
            fArray14[n4++] = fArray4[n5];
            ++n5;
        }
        fArray4 = null;
        fArray3 = null;
        fArray2 = null;
        int[] nArray = new int[6 * n3];
        int n6 = Irregular3DSet.a(nArray, n2, n3, nArrayArray2[0], nArrayArray[0]);
        nArrayArray2 = null;
        nArrayArray = null;
        if (bl2) {
            VisADIndexedTriangleStripArray visADIndexedTriangleStripArray = new VisADIndexedTriangleStripArray();
            visADIndexedTriangleStripArray.k = n6;
            visADIndexedTriangleStripArray.m = new int[n6];
            System.arraycopy(nArray, 0, visADIndexedTriangleStripArray.m, 0, n6);
            visADIndexedTriangleStripArray.l = new int[1];
            visADIndexedTriangleStripArray.l[0] = n6;
            nArray = null;
            SampledSet.a(visADIndexedTriangleStripArray, fArrayArray, 4, byArrayArray);
            fArrayArray = null;
            byArrayArray = null;
            visADIndexedTriangleStripArray.d = fArray14;
            return visADIndexedTriangleStripArray;
        }
        VisADTriangleStripArray visADTriangleStripArray = new VisADTriangleStripArray();
        visADTriangleStripArray.k = new int[]{n6};
        visADTriangleStripArray.e = n6;
        visADTriangleStripArray.d = new float[3 * n6];
        int n7 = 0;
        int n8 = 0;
        while (n8 < 3 * n6) {
            n4 = 3 * nArray[n7];
            visADTriangleStripArray.d[n8] = fArray14[n4];
            visADTriangleStripArray.d[n8 + 1] = fArray14[n4 + 1];
            visADTriangleStripArray.d[n8 + 2] = fArray14[n4 + 2];
            ++n7;
            n8 += 3;
        }
        fArray14 = null;
        visADTriangleStripArray.j = new float[3 * n6];
        n7 = 0;
        int n9 = 0;
        while (n9 < 3 * n6) {
            n4 = nArray[n7];
            visADTriangleStripArray.j[n9] = fArrayArray[0][n4];
            visADTriangleStripArray.j[n9 + 1] = fArrayArray[1][n4];
            visADTriangleStripArray.j[n9 + 2] = fArrayArray[2][n4];
            ++n7;
            n9 += 3;
        }
        fArrayArray = null;
        if (byArrayArray != null) {
            int n10 = byArrayArray.length;
            visADTriangleStripArray.i = new byte[n10 * n6];
            n7 = 0;
            if (n10 == 4) {
                int n11 = 0;
                while (n11 < n10 * n6) {
                    n4 = nArray[n7];
                    visADTriangleStripArray.i[n11] = byArrayArray[0][n4];
                    visADTriangleStripArray.i[n11 + 1] = byArrayArray[1][n4];
                    visADTriangleStripArray.i[n11 + 2] = byArrayArray[2][n4];
                    visADTriangleStripArray.i[n11 + 3] = byArrayArray[3][n4];
                    ++n7;
                    n11 += n10;
                }
            } else {
                int n12 = 0;
                while (n12 < n10 * n6) {
                    n4 = nArray[n7];
                    visADTriangleStripArray.i[n12] = byArrayArray[0][n4];
                    visADTriangleStripArray.i[n12 + 1] = byArrayArray[1][n4];
                    visADTriangleStripArray.i[n12 + 2] = byArrayArray[2][n4];
                    ++n7;
                    n12 += n10;
                }
            }
        }
        byArrayArray = null;
        nArray = null;
        return visADTriangleStripArray;
    }

    private void a(float f2, float[] fArray, byte[][] byArray, float[][] fArray2, byte[][] byArray2, int[][][] nArray, int[][][] nArray2) throws VisADException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        boolean bl2 = false;
        if (this.u != 3) {
            throw new DisplayException("Irregular3DSet.makeIsosurface: ManifoldDimension must be 3, not " + this.u);
        }
        if (fArray.length != this.B) {
            throw new DisplayException("Irregular3DSet.makeIsosurface: fieldValues length does't match");
        }
        if (Double.isNaN(f2)) {
            throw new DisplayException("Irregular3DSet.makeIsosurface: isolevel cannot be missing");
        }
        if (fArray2.length != 3 || nArray.length != 1 || nArray2.length != 1) {
            throw new DisplayException("Irregular3DSet.makeIsosurface: return value arrays not correctly initialized " + fArray2.length + " " + nArray.length + " " + nArray2.length);
        }
        int n12 = n11 = byArray != null ? byArray.length : 0;
        if (n11 > 0) {
            if (byArray2 == null || byArray2.length != n11) {
                throw new DisplayException("Irregular3DSet.makeIsosurface: auxLevels length doesn't match");
            }
            n10 = 0;
            while (n10 < n11) {
                if (byArray[n10].length != this.B) {
                    throw new DisplayException("Irregular3DSet.makeIsosurface: auxValues lengths don't match");
                }
                ++n10;
            }
        } else if (byArray2 != null) {
            throw new DisplayException("Irregular3DSet.makeIsosurface: auxValues null but auxLevels not null");
        }
        if (bl2) {
            System.out.println("isolevel = " + f2 + "\n");
            System.out.println("fieldValues " + fArray.length);
            n10 = 0;
            while (n10 < fArray.length) {
                System.out.println("  " + n10 + " -> " + fArray[n10]);
                ++n10;
            }
            System.out.println(this.p.a(this.k));
        }
        n10 = this.p.c.length;
        int[][] nArray3 = new int[n10][4];
        int[] nArray4 = new int[this.p.d];
        int n13 = 0;
        while (n13 < this.p.d) {
            nArray4[n13] = -1;
            ++n13;
        }
        float[][] fArray3 = new float[this.y][this.p.d];
        int n14 = 0;
        while (n14 < this.p.d) {
            fArray3[0][n14] = Float.NaN;
            ++n14;
        }
        byte[][] byArray3 = n11 > 0 ? new byte[n11][this.p.d] : null;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        while (n17 < n10) {
            n9 = this.p.c[n17][0];
            n8 = this.p.c[n17][1];
            n7 = this.p.c[n17][2];
            n6 = this.p.c[n17][3];
            float f3 = fArray[n9];
            float f4 = fArray[n8];
            float f5 = fArray[n7];
            float f6 = fArray[n6];
            float f7 = this.k[0][n6] - this.k[0][n9];
            float f8 = this.k[1][n6] - this.k[1][n9];
            float f9 = this.k[2][n6] - this.k[2][n9];
            float f10 = this.k[0][n7] - this.k[0][n9];
            float f11 = this.k[1][n7] - this.k[1][n9];
            float f12 = this.k[2][n7] - this.k[2][n9];
            float f13 = this.k[0][n8] - this.k[0][n9];
            float f14 = this.k[1][n8] - this.k[1][n9];
            float f15 = this.k[2][n8] - this.k[2][n9];
            float f16 = f11 * f15 - f12 * f14;
            float f17 = f12 * f13 - f10 * f15;
            float f18 = f10 * f14 - f11 * f13;
            float f19 = f7 * f16 + f8 * f17 + f9 * f18;
            int n18 = (f3 > f2 ? 1 : 0) + (f4 > f2 ? 2 : 0) + (f5 > f2 ? 4 : 0) + (f6 > f2 ? 8 : 0);
            if (f19 < 0.0f) {
                n18 = 15 - n18;
            }
            switch (n18) {
                case 0: 
                case 15: {
                    break;
                }
                case 1: 
                case 14: {
                    int n19;
                    int n20;
                    float f20;
                    n5 = this.p.a[n17][0];
                    n4 = this.p.a[n17][1];
                    n3 = this.p.a[n17][2];
                    if (fArray3[0][n5] != fArray3[0][n5]) {
                        f20 = (f2 - f4) / (f3 - f4);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n5] = f20 * this.k[0][n9] + (1.0f - f20) * this.k[0][n8];
                        fArray3[1][n5] = f20 * this.k[1][n9] + (1.0f - f20) * this.k[1][n8];
                        fArray3[2][n5] = f20 * this.k[2][n9] + (1.0f - f20) * this.k[2][n8];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n9] < 0 ? (float)byArray[n20][n9] + 256.0f : (float)byArray[n20][n9]) + (1.0f - f20) * (byArray[n20][n8] < 0 ? (float)byArray[n20][n8] + 256.0f : (float)byArray[n20][n8]));
                            byArray3[n20][n5] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n5] = n15++;
                    }
                    if (fArray3[0][n4] != fArray3[0][n4]) {
                        f20 = (f2 - f5) / (f3 - f5);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n4] = f20 * this.k[0][n9] + (1.0f - f20) * this.k[0][n7];
                        fArray3[1][n4] = f20 * this.k[1][n9] + (1.0f - f20) * this.k[1][n7];
                        fArray3[2][n4] = f20 * this.k[2][n9] + (1.0f - f20) * this.k[2][n7];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n9] < 0 ? (float)byArray[n20][n9] + 256.0f : (float)byArray[n20][n9]) + (1.0f - f20) * (byArray[n20][n7] < 0 ? (float)byArray[n20][n7] + 256.0f : (float)byArray[n20][n7]));
                            byArray3[n20][n4] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n4] = n15++;
                    }
                    if (fArray3[0][n3] != fArray3[0][n3]) {
                        f20 = (f2 - f6) / (f3 - f6);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n3] = f20 * this.k[0][n9] + (1.0f - f20) * this.k[0][n6];
                        fArray3[1][n3] = f20 * this.k[1][n9] + (1.0f - f20) * this.k[1][n6];
                        fArray3[2][n3] = f20 * this.k[2][n9] + (1.0f - f20) * this.k[2][n6];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n9] < 0 ? (float)byArray[n20][n9] + 256.0f : (float)byArray[n20][n9]) + (1.0f - f20) * (byArray[n20][n6] < 0 ? (float)byArray[n20][n6] + 256.0f : (float)byArray[n20][n6]));
                            byArray3[n20][n3] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n3] = n15++;
                    }
                    nArray3[n16][0] = n5;
                    if (n18 == 1) {
                        nArray3[n16][1] = n4;
                        nArray3[n16][2] = n3;
                    } else {
                        nArray3[n16][1] = n3;
                        nArray3[n16][2] = n4;
                    }
                    nArray3[n16][3] = -1;
                    ++n16;
                    break;
                }
                case 2: 
                case 13: {
                    int n19;
                    int n20;
                    float f20;
                    n5 = this.p.a[n17][0];
                    n2 = this.p.a[n17][3];
                    int n21 = this.p.a[n17][4];
                    if (fArray3[0][n5] != fArray3[0][n5]) {
                        f20 = (f2 - f4) / (f3 - f4);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n5] = f20 * this.k[0][n9] + (1.0f - f20) * this.k[0][n8];
                        fArray3[1][n5] = f20 * this.k[1][n9] + (1.0f - f20) * this.k[1][n8];
                        fArray3[2][n5] = f20 * this.k[2][n9] + (1.0f - f20) * this.k[2][n8];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n9] < 0 ? (float)byArray[n20][n9] + 256.0f : (float)byArray[n20][n9]) + (1.0f - f20) * (byArray[n20][n8] < 0 ? (float)byArray[n20][n8] + 256.0f : (float)byArray[n20][n8]));
                            byArray3[n20][n5] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n5] = n15++;
                    }
                    if (fArray3[0][n2] != fArray3[0][n2]) {
                        f20 = (f2 - f5) / (f4 - f5);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n2] = f20 * this.k[0][n8] + (1.0f - f20) * this.k[0][n7];
                        fArray3[1][n2] = f20 * this.k[1][n8] + (1.0f - f20) * this.k[1][n7];
                        fArray3[2][n2] = f20 * this.k[2][n8] + (1.0f - f20) * this.k[2][n7];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n8] < 0 ? (float)byArray[n20][n8] + 256.0f : (float)byArray[n20][n8]) + (1.0f - f20) * (byArray[n20][n7] < 0 ? (float)byArray[n20][n7] + 256.0f : (float)byArray[n20][n7]));
                            byArray3[n20][n2] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n2] = n15++;
                    }
                    if (fArray3[0][n21] != fArray3[0][n21]) {
                        f20 = (f2 - f6) / (f4 - f6);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n21] = f20 * this.k[0][n8] + (1.0f - f20) * this.k[0][n6];
                        fArray3[1][n21] = f20 * this.k[1][n8] + (1.0f - f20) * this.k[1][n6];
                        fArray3[2][n21] = f20 * this.k[2][n8] + (1.0f - f20) * this.k[2][n6];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n8] < 0 ? (float)byArray[n20][n8] + 256.0f : (float)byArray[n20][n8]) + (1.0f - f20) * (byArray[n20][n6] < 0 ? (float)byArray[n20][n6] + 256.0f : (float)byArray[n20][n6]));
                            byArray3[n20][n21] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n21] = n15++;
                    }
                    nArray3[n16][0] = n5;
                    if (n18 == 2) {
                        nArray3[n16][1] = n21;
                        nArray3[n16][2] = n2;
                    } else {
                        nArray3[n16][1] = n2;
                        nArray3[n16][2] = n21;
                    }
                    nArray3[n16][3] = -1;
                    ++n16;
                    break;
                }
                case 3: 
                case 12: {
                    int n19;
                    int n20;
                    float f20;
                    n4 = this.p.a[n17][1];
                    n3 = this.p.a[n17][2];
                    n2 = this.p.a[n17][3];
                    int n21 = this.p.a[n17][4];
                    if (fArray3[0][n4] != fArray3[0][n4]) {
                        f20 = (f2 - f5) / (f3 - f5);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n4] = f20 * this.k[0][n9] + (1.0f - f20) * this.k[0][n7];
                        fArray3[1][n4] = f20 * this.k[1][n9] + (1.0f - f20) * this.k[1][n7];
                        fArray3[2][n4] = f20 * this.k[2][n9] + (1.0f - f20) * this.k[2][n7];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n9] < 0 ? (float)byArray[n20][n9] + 256.0f : (float)byArray[n20][n9]) + (1.0f - f20) * (byArray[n20][n7] < 0 ? (float)byArray[n20][n7] + 256.0f : (float)byArray[n20][n7]));
                            byArray3[n20][n4] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n4] = n15++;
                    }
                    if (fArray3[0][n3] != fArray3[0][n3]) {
                        f20 = (f2 - f6) / (f3 - f6);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n3] = f20 * this.k[0][n9] + (1.0f - f20) * this.k[0][n6];
                        fArray3[1][n3] = f20 * this.k[1][n9] + (1.0f - f20) * this.k[1][n6];
                        fArray3[2][n3] = f20 * this.k[2][n9] + (1.0f - f20) * this.k[2][n6];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n9] < 0 ? (float)byArray[n20][n9] + 256.0f : (float)byArray[n20][n9]) + (1.0f - f20) * (byArray[n20][n6] < 0 ? (float)byArray[n20][n6] + 256.0f : (float)byArray[n20][n6]));
                            byArray3[n20][n3] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n3] = n15++;
                    }
                    if (fArray3[0][n21] != fArray3[0][n21]) {
                        f20 = (f2 - f6) / (f4 - f6);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n21] = f20 * this.k[0][n8] + (1.0f - f20) * this.k[0][n6];
                        fArray3[1][n21] = f20 * this.k[1][n8] + (1.0f - f20) * this.k[1][n6];
                        fArray3[2][n21] = f20 * this.k[2][n8] + (1.0f - f20) * this.k[2][n6];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n8] < 0 ? (float)byArray[n20][n8] + 256.0f : (float)byArray[n20][n8]) + (1.0f - f20) * (byArray[n20][n6] < 0 ? (float)byArray[n20][n6] + 256.0f : (float)byArray[n20][n6]));
                            byArray3[n20][n21] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n21] = n15++;
                    }
                    if (fArray3[0][n2] != fArray3[0][n2]) {
                        f20 = (f2 - f5) / (f4 - f5);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n2] = f20 * this.k[0][n8] + (1.0f - f20) * this.k[0][n7];
                        fArray3[1][n2] = f20 * this.k[1][n8] + (1.0f - f20) * this.k[1][n7];
                        fArray3[2][n2] = f20 * this.k[2][n8] + (1.0f - f20) * this.k[2][n7];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n8] < 0 ? (float)byArray[n20][n8] + 256.0f : (float)byArray[n20][n8]) + (1.0f - f20) * (byArray[n20][n7] < 0 ? (float)byArray[n20][n7] + 256.0f : (float)byArray[n20][n7]));
                            byArray3[n20][n2] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n2] = n15++;
                    }
                    nArray3[n16][0] = n4;
                    if (n18 == 3) {
                        nArray3[n16][1] = n3;
                        nArray3[n16][2] = n21;
                        nArray3[n16][3] = n2;
                    } else {
                        nArray3[n16][1] = n2;
                        nArray3[n16][2] = n21;
                        nArray3[n16][3] = n3;
                    }
                    ++n16;
                    break;
                }
                case 4: 
                case 11: {
                    int n19;
                    int n20;
                    float f20;
                    n4 = this.p.a[n17][1];
                    n2 = this.p.a[n17][3];
                    int n22 = this.p.a[n17][5];
                    if (fArray3[0][n4] != fArray3[0][n4]) {
                        f20 = (f2 - f5) / (f3 - f5);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n4] = f20 * this.k[0][n9] + (1.0f - f20) * this.k[0][n7];
                        fArray3[1][n4] = f20 * this.k[1][n9] + (1.0f - f20) * this.k[1][n7];
                        fArray3[2][n4] = f20 * this.k[2][n9] + (1.0f - f20) * this.k[2][n7];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n9] < 0 ? (float)byArray[n20][n9] + 256.0f : (float)byArray[n20][n9]) + (1.0f - f20) * (byArray[n20][n7] < 0 ? (float)byArray[n20][n7] + 256.0f : (float)byArray[n20][n7]));
                            byArray3[n20][n4] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n4] = n15++;
                    }
                    if (fArray3[0][n2] != fArray3[0][n2]) {
                        f20 = (f2 - f5) / (f4 - f5);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n2] = f20 * this.k[0][n8] + (1.0f - f20) * this.k[0][n7];
                        fArray3[1][n2] = f20 * this.k[1][n8] + (1.0f - f20) * this.k[1][n7];
                        fArray3[2][n2] = f20 * this.k[2][n8] + (1.0f - f20) * this.k[2][n7];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n8] < 0 ? (float)byArray[n20][n8] + 256.0f : (float)byArray[n20][n8]) + (1.0f - f20) * (byArray[n20][n7] < 0 ? (float)byArray[n20][n7] + 256.0f : (float)byArray[n20][n7]));
                            byArray3[n20][n2] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n2] = n15++;
                    }
                    if (fArray3[0][n22] != fArray3[0][n22]) {
                        f20 = (f2 - f6) / (f5 - f6);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n22] = f20 * this.k[0][n7] + (1.0f - f20) * this.k[0][n6];
                        fArray3[1][n22] = f20 * this.k[1][n7] + (1.0f - f20) * this.k[1][n6];
                        fArray3[2][n22] = f20 * this.k[2][n7] + (1.0f - f20) * this.k[2][n6];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n7] < 0 ? (float)byArray[n20][n7] + 256.0f : (float)byArray[n20][n7]) + (1.0f - f20) * (byArray[n20][n6] < 0 ? (float)byArray[n20][n6] + 256.0f : (float)byArray[n20][n6]));
                            byArray3[n20][n22] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n22] = n15++;
                    }
                    nArray3[n16][0] = n4;
                    if (n18 == 4) {
                        nArray3[n16][1] = n2;
                        nArray3[n16][2] = n22;
                    } else {
                        nArray3[n16][1] = n22;
                        nArray3[n16][2] = n2;
                    }
                    nArray3[n16][3] = -1;
                    ++n16;
                    break;
                }
                case 5: 
                case 10: {
                    int n19;
                    int n20;
                    float f20;
                    n5 = this.p.a[n17][0];
                    n3 = this.p.a[n17][2];
                    n2 = this.p.a[n17][3];
                    int n22 = this.p.a[n17][5];
                    if (fArray3[0][n5] != fArray3[0][n5]) {
                        f20 = (f2 - f4) / (f3 - f4);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n5] = f20 * this.k[0][n9] + (1.0f - f20) * this.k[0][n8];
                        fArray3[1][n5] = f20 * this.k[1][n9] + (1.0f - f20) * this.k[1][n8];
                        fArray3[2][n5] = f20 * this.k[2][n9] + (1.0f - f20) * this.k[2][n8];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n9] < 0 ? (float)byArray[n20][n9] + 256.0f : (float)byArray[n20][n9]) + (1.0f - f20) * (byArray[n20][n8] < 0 ? (float)byArray[n20][n8] + 256.0f : (float)byArray[n20][n8]));
                            byArray3[n20][n5] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n5] = n15++;
                    }
                    if (fArray3[0][n3] != fArray3[0][n3]) {
                        f20 = (f2 - f6) / (f3 - f6);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n3] = f20 * this.k[0][n9] + (1.0f - f20) * this.k[0][n6];
                        fArray3[1][n3] = f20 * this.k[1][n9] + (1.0f - f20) * this.k[1][n6];
                        fArray3[2][n3] = f20 * this.k[2][n9] + (1.0f - f20) * this.k[2][n6];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n9] < 0 ? (float)byArray[n20][n9] + 256.0f : (float)byArray[n20][n9]) + (1.0f - f20) * (byArray[n20][n6] < 0 ? (float)byArray[n20][n6] + 256.0f : (float)byArray[n20][n6]));
                            byArray3[n20][n3] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n3] = n15++;
                    }
                    if (fArray3[0][n22] != fArray3[0][n22]) {
                        f20 = (f2 - f6) / (f5 - f6);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n22] = f20 * this.k[0][n7] + (1.0f - f20) * this.k[0][n6];
                        fArray3[1][n22] = f20 * this.k[1][n7] + (1.0f - f20) * this.k[1][n6];
                        fArray3[2][n22] = f20 * this.k[2][n7] + (1.0f - f20) * this.k[2][n6];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n7] < 0 ? (float)byArray[n20][n7] + 256.0f : (float)byArray[n20][n7]) + (1.0f - f20) * (byArray[n20][n6] < 0 ? (float)byArray[n20][n6] + 256.0f : (float)byArray[n20][n6]));
                            byArray3[n20][n22] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n22] = n15++;
                    }
                    if (fArray3[0][n2] != fArray3[0][n2]) {
                        f20 = (f2 - f5) / (f4 - f5);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n2] = f20 * this.k[0][n8] + (1.0f - f20) * this.k[0][n7];
                        fArray3[1][n2] = f20 * this.k[1][n8] + (1.0f - f20) * this.k[1][n7];
                        fArray3[2][n2] = f20 * this.k[2][n8] + (1.0f - f20) * this.k[2][n7];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n8] < 0 ? (float)byArray[n20][n8] + 256.0f : (float)byArray[n20][n8]) + (1.0f - f20) * (byArray[n20][n7] < 0 ? (float)byArray[n20][n7] + 256.0f : (float)byArray[n20][n7]));
                            byArray3[n20][n2] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n2] = n15++;
                    }
                    nArray3[n16][0] = n5;
                    if (n18 == 5) {
                        nArray3[n16][1] = n2;
                        nArray3[n16][2] = n22;
                        nArray3[n16][3] = n3;
                    } else {
                        nArray3[n16][1] = n3;
                        nArray3[n16][2] = n22;
                        nArray3[n16][3] = n2;
                    }
                    ++n16;
                    break;
                }
                case 6: 
                case 9: {
                    int n19;
                    int n20;
                    float f20;
                    n5 = this.p.a[n17][0];
                    n4 = this.p.a[n17][1];
                    int n21 = this.p.a[n17][4];
                    int n22 = this.p.a[n17][5];
                    if (fArray3[0][n5] != fArray3[0][n5]) {
                        f20 = (f2 - f4) / (f3 - f4);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n5] = f20 * this.k[0][n9] + (1.0f - f20) * this.k[0][n8];
                        fArray3[1][n5] = f20 * this.k[1][n9] + (1.0f - f20) * this.k[1][n8];
                        fArray3[2][n5] = f20 * this.k[2][n9] + (1.0f - f20) * this.k[2][n8];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n9] < 0 ? (float)byArray[n20][n9] + 256.0f : (float)byArray[n20][n9]) + (1.0f - f20) * (byArray[n20][n8] < 0 ? (float)byArray[n20][n8] + 256.0f : (float)byArray[n20][n8]));
                            byArray3[n20][n5] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n5] = n15++;
                    }
                    if (fArray3[0][n4] != fArray3[0][n4]) {
                        f20 = (f2 - f5) / (f3 - f5);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n4] = f20 * this.k[0][n9] + (1.0f - f20) * this.k[0][n7];
                        fArray3[1][n4] = f20 * this.k[1][n9] + (1.0f - f20) * this.k[1][n7];
                        fArray3[2][n4] = f20 * this.k[2][n9] + (1.0f - f20) * this.k[2][n7];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n9] < 0 ? (float)byArray[n20][n9] + 256.0f : (float)byArray[n20][n9]) + (1.0f - f20) * (byArray[n20][n7] < 0 ? (float)byArray[n20][n7] + 256.0f : (float)byArray[n20][n7]));
                            byArray3[n20][n4] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n4] = n15++;
                    }
                    if (fArray3[0][n22] != fArray3[0][n22]) {
                        f20 = (f2 - f6) / (f5 - f6);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n22] = f20 * this.k[0][n7] + (1.0f - f20) * this.k[0][n6];
                        fArray3[1][n22] = f20 * this.k[1][n7] + (1.0f - f20) * this.k[1][n6];
                        fArray3[2][n22] = f20 * this.k[2][n7] + (1.0f - f20) * this.k[2][n6];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n7] < 0 ? (float)byArray[n20][n7] + 256.0f : (float)byArray[n20][n7]) + (1.0f - f20) * (byArray[n20][n6] < 0 ? (float)byArray[n20][n6] + 256.0f : (float)byArray[n20][n6]));
                            byArray3[n20][n22] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n22] = n15++;
                    }
                    if (fArray3[0][n21] != fArray3[0][n21]) {
                        f20 = (f2 - f6) / (f4 - f6);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n21] = f20 * this.k[0][n8] + (1.0f - f20) * this.k[0][n6];
                        fArray3[1][n21] = f20 * this.k[1][n8] + (1.0f - f20) * this.k[1][n6];
                        fArray3[2][n21] = f20 * this.k[2][n8] + (1.0f - f20) * this.k[2][n6];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n8] < 0 ? (float)byArray[n20][n8] + 256.0f : (float)byArray[n20][n8]) + (1.0f - f20) * (byArray[n20][n6] < 0 ? (float)byArray[n20][n6] + 256.0f : (float)byArray[n20][n6]));
                            byArray3[n20][n21] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n21] = n15++;
                    }
                    nArray3[n16][0] = n5;
                    if (n18 == 6) {
                        nArray3[n16][1] = n21;
                        nArray3[n16][2] = n22;
                        nArray3[n16][3] = n4;
                    } else {
                        nArray3[n16][1] = n4;
                        nArray3[n16][2] = n22;
                        nArray3[n16][3] = n21;
                    }
                    ++n16;
                    break;
                }
                case 7: 
                case 8: {
                    int n19;
                    int n20;
                    float f20;
                    n3 = this.p.a[n17][2];
                    int n21 = this.p.a[n17][4];
                    int n22 = this.p.a[n17][5];
                    if (fArray3[0][n3] != fArray3[0][n3]) {
                        f20 = (f2 - f6) / (f3 - f6);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n3] = f20 * this.k[0][n9] + (1.0f - f20) * this.k[0][n6];
                        fArray3[1][n3] = f20 * this.k[1][n9] + (1.0f - f20) * this.k[1][n6];
                        fArray3[2][n3] = f20 * this.k[2][n9] + (1.0f - f20) * this.k[2][n6];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n9] < 0 ? (float)byArray[n20][n9] + 256.0f : (float)byArray[n20][n9]) + (1.0f - f20) * (byArray[n20][n6] < 0 ? (float)byArray[n20][n6] + 256.0f : (float)byArray[n20][n6]));
                            byArray3[n20][n3] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n3] = n15++;
                    }
                    if (fArray3[0][n21] != fArray3[0][n21]) {
                        f20 = (f2 - f6) / (f4 - f6);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n21] = f20 * this.k[0][n8] + (1.0f - f20) * this.k[0][n6];
                        fArray3[1][n21] = f20 * this.k[1][n8] + (1.0f - f20) * this.k[1][n6];
                        fArray3[2][n21] = f20 * this.k[2][n8] + (1.0f - f20) * this.k[2][n6];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n8] < 0 ? (float)byArray[n20][n8] + 256.0f : (float)byArray[n20][n8]) + (1.0f - f20) * (byArray[n20][n6] < 0 ? (float)byArray[n20][n6] + 256.0f : (float)byArray[n20][n6]));
                            byArray3[n20][n21] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n21] = n15++;
                    }
                    if (fArray3[0][n22] != fArray3[0][n22]) {
                        f20 = (f2 - f6) / (f5 - f6);
                        if (f20 < 0.0f) {
                            f20 = -f20;
                        }
                        fArray3[0][n22] = f20 * this.k[0][n7] + (1.0f - f20) * this.k[0][n6];
                        fArray3[1][n22] = f20 * this.k[1][n7] + (1.0f - f20) * this.k[1][n6];
                        fArray3[2][n22] = f20 * this.k[2][n7] + (1.0f - f20) * this.k[2][n6];
                        n20 = 0;
                        while (n20 < n11) {
                            n19 = (int)(f20 * (byArray[n20][n7] < 0 ? (float)byArray[n20][n7] + 256.0f : (float)byArray[n20][n7]) + (1.0f - f20) * (byArray[n20][n6] < 0 ? (float)byArray[n20][n6] + 256.0f : (float)byArray[n20][n6]));
                            byArray3[n20][n22] = (byte)(n19 < 0 ? 0 : (byte)(n19 > 255 ? -1 : (n19 < 128 ? (byte)n19 : (byte)(n19 - 256))));
                            ++n20;
                        }
                        nArray4[n22] = n15++;
                    }
                    nArray3[n16][0] = n3;
                    if (n18 == 7) {
                        nArray3[n16][1] = n21;
                        nArray3[n16][2] = n22;
                    } else {
                        nArray3[n16][1] = n22;
                        nArray3[n16][2] = n21;
                    }
                    nArray3[n16][3] = -1;
                    ++n16;
                }
            }
            ++n17;
        }
        if (bl2) {
            System.out.println("\npolys (polys -> global edges) " + n16 + "\n");
            n9 = 0;
            while (n9 < n16) {
                String string = "  " + n9 + " -> ";
                n7 = 0;
                while (n7 < 4) {
                    string = string + " " + nArray3[n9][n7];
                    ++n7;
                }
                System.out.println(string + "\n");
                ++n9;
            }
        }
        nArray[0] = new int[n16][];
        n9 = 0;
        while (n9 < n16) {
            n8 = nArray3[n9][3] < 0 ? 3 : 4;
            nArray[0][n9] = new int[n8];
            n7 = 0;
            while (n7 < n8) {
                nArray[0][n9][n7] = nArray4[nArray3[n9][n7]];
                ++n7;
            }
            ++n9;
        }
        if (bl2) {
            System.out.println("\npolyToVert (polys -> vertices) " + n16 + "\n");
            n8 = 0;
            while (n8 < n16) {
                String string = "  " + n8 + " -> ";
                n6 = 0;
                while (n6 < nArray[0][n8].length) {
                    string = string + " " + nArray[0][n8][n6];
                    ++n6;
                }
                System.out.println(string + "\n");
                ++n8;
            }
        }
        int[] nArray5 = new int[n15];
        int n23 = 0;
        while (n23 < n15) {
            nArray5[n23] = 0;
            ++n23;
        }
        n6 = 0;
        while (n6 < n16) {
            int n24 = nArray[0][n6][0];
            nArray5[n24] = nArray5[n24] + 1;
            int n25 = nArray[0][n6][1];
            nArray5[n25] = nArray5[n25] + 1;
            int n26 = nArray[0][n6][2];
            nArray5[n26] = nArray5[n26] + 1;
            if (nArray[0][n6].length > 3) {
                int n27 = nArray[0][n6][3];
                nArray5[n27] = nArray5[n27] + 1;
            }
            ++n6;
        }
        nArray2[0] = new int[n15][];
        int n28 = 0;
        while (n28 < n15) {
            nArray2[0][n28] = new int[nArray5[n28]];
            ++n28;
        }
        int n29 = 0;
        while (n29 < n15) {
            nArray5[n29] = 0;
            ++n29;
        }
        int n30 = 0;
        while (n30 < n16) {
            int n31 = nArray[0][n30][0];
            n5 = nArray[0][n30][1];
            n4 = nArray[0][n30][2];
            int n32 = n31;
            int n33 = nArray5[n32];
            nArray5[n32] = n33 + 1;
            nArray2[0][n31][n33] = n30;
            int n34 = n5;
            int n35 = nArray5[n34];
            nArray5[n34] = n35 + 1;
            nArray2[0][n5][n35] = n30;
            int n36 = n4;
            int n37 = nArray5[n36];
            nArray5[n36] = n37 + 1;
            nArray2[0][n4][n37] = n30;
            if (nArray[0][n30].length > 3 && (n3 = nArray[0][n30][3]) != -1) {
                int n38 = n3;
                int n39 = nArray5[n38];
                nArray5[n38] = n39 + 1;
                nArray2[0][n3][n39] = n30;
            }
            ++n30;
        }
        if (bl2) {
            System.out.println("\nvertToPoly (vertices -> polys) " + n15 + "\n");
            int n40 = 0;
            while (n40 < n15) {
                String string = "  " + n40 + " -> ";
                n4 = 0;
                while (n4 < nArray2[0][n40].length) {
                    string = string + " " + nArray2[0][n40][n4];
                    ++n4;
                }
                System.out.println(string + "\n");
                ++n40;
            }
        }
        fArray2[0] = new float[n15];
        fArray2[1] = new float[n15];
        fArray2[2] = new float[n15];
        int n41 = 0;
        while (n41 < n11) {
            byArray2[n41] = new byte[n15];
            ++n41;
        }
        int n42 = 0;
        while (n42 < this.p.d) {
            n4 = nArray4[n42];
            if (n4 >= 0) {
                fArray2[0][n4] = fArray3[0][n42];
                fArray2[1][n4] = fArray3[1][n42];
                fArray2[2][n4] = fArray3[2][n42];
                n3 = 0;
                while (n3 < n11) {
                    byArray2[n3][n4] = byArray3[n3][n42];
                    ++n3;
                }
            }
            ++n42;
        }
        if (bl2) {
            System.out.println("\nfieldVertices " + n15 + "\n");
            n4 = 0;
            while (n4 < n15) {
                String string = "  " + n4 + " -> ";
                n2 = 0;
                while (n2 < 3) {
                    string = string + " " + fArray2[n2][n4];
                    ++n2;
                }
                System.out.println(string + "\n");
                ++n4;
            }
        }
    }

    private static void a(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6, int n2, int n3, float[] fArray7, float[] fArray8, float[] fArray9, float[] fArray10, float[] fArray11, float[] fArray12, float[] fArray13, float[] fArray14, float[] fArray15, int[][] nArray, int[][] nArray2) throws VisADException {
        int n4;
        int n5;
        int[] nArray3 = new int[3];
        if (n2 <= 0) {
            return;
        }
        int n6 = 0;
        while (n6 < n2) {
            fArray4[n6] = 0.0f;
            fArray5[n6] = 0.0f;
            fArray6[n6] = 0.0f;
            ++n6;
        }
        float f2 = Float.MIN_VALUE;
        int n7 = 0;
        while (true) {
            n6 = n7 + 1;
            while (n6 < n3) {
                if (nArray2[n6].length > nArray2[n7].length) break;
                ++n6;
            }
            if (n6 >= n3) break;
            n7 = n6;
        }
        int n8 = nArray2[n7].length;
        n6 = 0;
        while (n6 < n3) {
            if (nArray2[n6].length > 0) {
                n5 = nArray2[n6][1];
                n4 = nArray2[n6][0];
                fArray10[n6] = fArray[n5] - fArray[n4];
                fArray12[n6] = fArray2[n5] - fArray2[n4];
                fArray14[n6] = fArray3[n5] - fArray3[n4];
            }
            ++n6;
        }
        boolean bl2 = false;
        n7 = 2;
        while (n7 < n8) {
            if (!bl2) {
                n6 = 0;
                while (n6 < n3) {
                    if (n7 < nArray2[n6].length) {
                        n5 = nArray2[n6][n7];
                        n4 = nArray2[n6][0];
                        fArray11[n6] = fArray[n5] - fArray[n4];
                        fArray13[n6] = fArray2[n5] - fArray2[n4];
                        fArray15[n6] = fArray3[n5] - fArray3[n4];
                        fArray7[n6] = fArray12[n6] * fArray15[n6] - fArray14[n6] * fArray13[n6];
                        fArray8[n6] = fArray14[n6] * fArray11[n6] - fArray10[n6] * fArray15[n6];
                        fArray9[n6] = fArray10[n6] * fArray13[n6] - fArray12[n6] * fArray11[n6];
                        fArray10[n6] = fArray7[n6] * fArray7[n6] + fArray8[n6] * fArray8[n6] + fArray9[n6] * fArray9[n6];
                        if (fArray10[n6] > f2) {
                            int n9 = n6;
                            fArray7[n9] = fArray7[n9] / fArray10[n6];
                            int n10 = n6;
                            fArray8[n10] = fArray8[n10] / fArray10[n6];
                            int n11 = n6;
                            fArray9[n11] = fArray9[n11] / fArray10[n6];
                        }
                    }
                    ++n6;
                }
            } else {
                n6 = 0;
                while (n6 < n3) {
                    if (n7 < nArray2[n6].length) {
                        n5 = nArray2[n6][n7];
                        n4 = nArray2[n6][0];
                        fArray10[n6] = fArray[n5] - fArray[n4];
                        fArray12[n6] = fArray2[n5] - fArray2[n4];
                        fArray14[n6] = fArray3[n5] - fArray3[n4];
                        fArray7[n6] = fArray13[n6] * fArray14[n6] - fArray15[n6] * fArray12[n6];
                        fArray8[n6] = fArray15[n6] * fArray10[n6] - fArray11[n6] * fArray14[n6];
                        fArray9[n6] = fArray11[n6] * fArray12[n6] - fArray13[n6] * fArray10[n6];
                        fArray11[n6] = fArray7[n6] * fArray7[n6] + fArray8[n6] * fArray8[n6] + fArray9[n6] * fArray9[n6];
                        if (fArray11[n6] > f2) {
                            int n12 = n6;
                            fArray7[n12] = fArray7[n12] / fArray11[n6];
                            int n13 = n6;
                            fArray8[n13] = fArray8[n13] / fArray11[n6];
                            int n14 = n6;
                            fArray9[n14] = fArray9[n14] / fArray11[n6];
                        }
                    }
                    ++n6;
                }
            }
            n6 = 0;
            while (n6 < n3) {
                if (n7 < nArray2[n6].length) {
                    nArray3[0] = nArray2[n6][0];
                    nArray3[1] = nArray2[n6][n7 - 1];
                    nArray3[2] = nArray2[n6][n7];
                    float f3 = fArray7[n6];
                    float f4 = fArray8[n6];
                    float f5 = fArray9[n6];
                    int n15 = nArray3[0];
                    fArray4[n15] = fArray4[n15] + f3;
                    int n16 = nArray3[0];
                    fArray5[n16] = fArray5[n16] + f4;
                    int n17 = nArray3[0];
                    fArray6[n17] = fArray6[n17] + f5;
                    int n18 = nArray3[1];
                    fArray4[n18] = fArray4[n18] + f3;
                    int n19 = nArray3[1];
                    fArray5[n19] = fArray5[n19] + f4;
                    int n20 = nArray3[1];
                    fArray6[n20] = fArray6[n20] + f5;
                    int n21 = nArray3[2];
                    fArray4[n21] = fArray4[n21] + f3;
                    int n22 = nArray3[2];
                    fArray5[n22] = fArray5[n22] + f4;
                    int n23 = nArray3[2];
                    fArray6[n23] = fArray6[n23] + f5;
                }
                ++n6;
            }
            bl2 = !bl2;
            ++n7;
        }
        n6 = 0;
        while (n6 < n2) {
            float f6 = (float)Math.sqrt(fArray4[n6] * fArray4[n6] + fArray5[n6] * fArray5[n6] + fArray6[n6] * fArray6[n6]);
            if (f6 > 1.0E-5f) {
                int n24 = n6;
                fArray4[n24] = fArray4[n24] / f6;
                int n25 = n6;
                fArray5[n25] = fArray5[n25] / f6;
                int n26 = n6;
                fArray6[n26] = fArray6[n26] / f6;
            }
            ++n6;
        }
    }

    public static int a(int[] nArray, int n2, int n3, int[][] nArray2, int[][] nArray3) throws VisADException {
        boolean bl2 = false;
        boolean[] blArray = new boolean[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n3) {
            blArray[n8] = true;
            ++n8;
        }
        block1: while (true) {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15 = n4;
            while (n15 < n3) {
                if (blArray[n15]) break;
                ++n15;
            }
            if (n15 == n3) {
                n15 = -1;
            } else {
                n4 = n15;
            }
            if (n15 < 0) break;
            blArray[n15] = false;
            int n16 = nArray3[n15].length;
            int n17 = 0;
            while (n17 < n16) {
                n7 = n17 + 1 == n16 ? 0 : n17 + 1;
                n5 = -1;
                if (n17 < nArray3[n15].length && n7 < nArray3[n15].length) {
                    n8 = nArray3[n15][n17];
                    n14 = nArray2[n8].length;
                    n13 = 0;
                    int n18 = nArray3[n15][n7];
                    n12 = nArray2[n18].length;
                    n11 = 0;
                    while (0 < n8 && n13 < n14 && 0 < n18 && n11 < n12) {
                        if (nArray2[n8][n13] == nArray2[n18][n11] && blArray[nArray2[n8][n13]]) {
                            n5 = nArray2[n8][n13];
                            break;
                        }
                        if (nArray2[n8][n13] < nArray2[n18][n11]) {
                            ++n13;
                            continue;
                        }
                        ++n11;
                    }
                }
                if (n5 >= 0) break;
                ++n17;
            }
            if (n5 < 0) {
                n10 = v[n16 - 3];
                if (n6 > 0) {
                    nArray[n6] = nArray[n6 - 1];
                    int n19 = ++n6;
                    ++n6;
                    nArray[n19] = nArray3[n15][m[n10]];
                } else {
                    bl2 = true;
                }
                n9 = 0;
                while (true) {
                    if (n9 >= (n16 < 6 ? n16 : 6)) continue block1;
                    nArray[n6++] = nArray3[n15][m[n10++]];
                    ++n9;
                }
            }
            if (n7 != 0 && n17 == n7 - 1 || n7 == 0 && n17 == n16 - 1) {
                n10 = v[n16 - 3] + (n7 + 1) * n16;
                if (bl2) {
                    nArray[n6] = nArray[n6 - 1];
                    int n20 = ++n6;
                    ++n6;
                    nArray[n20] = nArray3[n15][s[n10 - 1]];
                    bl2 = false;
                }
                n9 = 0;
                while (n9 < (n16 < 6 ? n16 : 6)) {
                    nArray[n6++] = nArray3[n15][s[--n10]];
                    ++n9;
                }
            } else {
                n10 = v[n16 - 3] + (n7 + 1) * n16;
                if (bl2) {
                    nArray[n6] = nArray[n6 - 1];
                    int n21 = ++n6;
                    ++n6;
                    nArray[n21] = nArray3[n15][m[n10 - 1]];
                    bl2 = false;
                }
                n9 = 0;
                while (n9 < (n16 < 6 ? n16 : 6)) {
                    nArray[n6++] = nArray3[n15][m[--n10]];
                    ++n9;
                }
            }
            int n22 = nArray[n6 - 1];
            int n23 = nArray[n6 - 2];
            n15 = n5;
            while (true) {
                n16 = nArray3[n15].length;
                blArray[n15] = false;
                n17 = 0;
                while (n17 < n16 && nArray3[n15][n17] != n23) {
                    ++n17;
                }
                n7 = 0;
                while (n7 < n16 && nArray3[n15][n7] != n22) {
                    ++n7;
                }
                if (n7 != 0 && n17 == n7 - 1 || n7 == 0 && n17 == n16 - 1) {
                    n10 = v[n16 - 3] + n17 * n16 + 2;
                    n9 = 2;
                    while (n9 < (n16 < 6 ? n16 : 6)) {
                        nArray[n6++] = nArray3[n15][m[n10++]];
                        ++n9;
                    }
                } else {
                    n10 = v[n16 - 3] + n17 * n16 + 2;
                    n9 = 2;
                    while (n9 < (n16 < 6 ? n16 : 6)) {
                        nArray[n6++] = nArray3[n15][s[n10++]];
                        ++n9;
                    }
                }
                n22 = nArray[n6 - 1];
                n23 = nArray[n6 - 2];
                n15 = -1;
                if (n23 >= 0 && n22 >= 0) {
                    n14 = nArray2[n23].length;
                    n13 = 0;
                    n12 = nArray2[n22].length;
                    n11 = 0;
                    while (0 < n23 && n13 < n14 && 0 < n22 && n11 < n12) {
                        if (nArray2[n23][n13] == nArray2[n22][n11] && blArray[nArray2[n23][n13]]) {
                            n15 = nArray2[n23][n13];
                            break;
                        }
                        if (nArray2[n23][n13] < nArray2[n22][n11]) {
                            ++n13;
                            continue;
                        }
                        ++n11;
                    }
                }
                if (n15 >= 0) continue;
                n23 = nArray[n6 - 3];
                n15 = -1;
                if (n23 >= 0 && n22 >= 0) {
                    n14 = nArray2[n23].length;
                    n13 = 0;
                    n12 = nArray2[n22].length;
                    n11 = 0;
                    while (0 < n23 && n13 < n14 && 0 < n22 && n11 < n12) {
                        if (nArray2[n23][n13] == nArray2[n22][n11] && blArray[nArray2[n23][n13]]) {
                            n15 = nArray2[n23][n13];
                            break;
                        }
                        if (nArray2[n23][n13] < nArray2[n22][n11]) {
                            ++n13;
                            continue;
                        }
                        ++n11;
                    }
                }
                if (n15 < 0) {
                    bl2 = true;
                    continue block1;
                }
                nArray[n6++] = n23;
                n8 = n23;
                n23 = n22;
                n22 = n8;
            }
            break;
        }
        return n6;
    }

    public VisADGeometryArray a(byte[][] byArray, boolean bl2) throws VisADException {
        if (this.y != 3) {
            throw new SetException("Irregular3DSet.make2DGeometry: DomainDimension must be 3, not " + this.y);
        }
        if (this.u != 2) {
            throw new SetException("Irregular3DSet.make2DGeometry: ManifoldDimension must be 2, not " + this.u);
        }
        int n2 = this.p.c.length;
        int n3 = this.p.e.length;
        if (n2 < 1 || n3 < 3) {
            return null;
        }
        int[][] nArray = this.p.c;
        int[][] nArray2 = this.p.b;
        int n4 = nArray[0].length - 1;
        int[][] nArrayArray = new int[n2][];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        int n5 = 0;
        while (n5 < n2) {
            if (nArrayArray[n5] == null) {
                nArrayArray[n5] = new int[3];
                nArrayArray[n5][0] = nArray[n5][0];
                nArrayArray[n5][1] = nArray[n5][1];
                nArrayArray[n5][2] = nArray[n5][2];
                int n6 = 0;
                nArray4[n6] = 0;
                nArray3[n6] = n5;
                do {
                    int n7;
                    int n8;
                    int n9;
                    if ((n9 = nArray2[n8 = nArray3[n6]][n7 = nArray4[n6]]) >= 0 && nArrayArray[n9] == null) {
                        int n10 = nArray[n8][n7];
                        int n11 = nArray[n8][(n7 + 1) % 3];
                        int n12 = -1;
                        int n13 = -1;
                        int n14 = -1;
                        int n15 = -1;
                        int n16 = 0;
                        while (n16 < 3) {
                            if (nArrayArray[n8][n16] == n10) {
                                n12 = n16;
                            }
                            if (nArrayArray[n8][n16] == n11) {
                                n13 = n16;
                            }
                            if (nArray[n9][n16] == n10) {
                                n14 = n16;
                            }
                            if (nArray[n9][n16] == n11) {
                                n15 = n16;
                            }
                            ++n16;
                        }
                        nArrayArray[n9] = new int[3];
                        nArrayArray[n9][0] = nArray[n9][0];
                        if ((n12 + 1) % 3 == n13 && (n14 + 1) % 3 == n15 || (n13 + 1) % 3 == n12 && (n15 + 1) % 3 == n14) {
                            nArrayArray[n9][1] = nArray[n9][2];
                            nArrayArray[n9][2] = nArray[n9][1];
                        } else {
                            nArrayArray[n9][1] = nArray[n9][1];
                            nArrayArray[n9][2] = nArray[n9][2];
                        }
                        nArray4[++n6] = 0;
                        nArray3[n6] = n9;
                        continue;
                    }
                    do {
                        int n17 = n6;
                        nArray4[n17] = nArray4[n17] + 1;
                    } while (nArray4[n6] >= 3 && --n6 >= 0);
                } while (n6 >= 0);
            }
            ++n5;
        }
        float[][] fArray = this.a(false);
        float[] fArray2 = new float[n2];
        float[] fArray3 = new float[n2];
        float[] fArray4 = new float[n2];
        float[] fArray5 = new float[n2];
        float[] fArray6 = new float[n2];
        float[] fArray7 = new float[n2];
        float[] fArray8 = new float[n2];
        float[] fArray9 = new float[n2];
        float[] fArray10 = new float[n2];
        float[] fArray11 = new float[n3];
        float[] fArray12 = new float[n3];
        float[] fArray13 = new float[n3];
        Irregular3DSet.a(fArray[0], fArray[1], fArray[2], fArray11, fArray12, fArray13, n3, n2, fArray8, fArray9, fArray10, fArray2, fArray3, fArray4, fArray5, fArray6, fArray7, this.p.e, nArrayArray);
        fArray10 = null;
        fArray9 = null;
        fArray8 = null;
        fArray7 = null;
        fArray6 = null;
        fArray5 = null;
        fArray4 = null;
        fArray3 = null;
        fArray2 = null;
        float[] fArray14 = new float[3 * n3];
        int n18 = 0;
        int n19 = 0;
        while (n19 < n3) {
            fArray14[n18++] = fArray11[n19];
            fArray14[n18++] = fArray12[n19];
            fArray14[n18++] = fArray13[n19];
            ++n19;
        }
        fArray13 = null;
        fArray12 = null;
        fArray11 = null;
        int[] nArray5 = new int[6 * n2];
        int n20 = Irregular3DSet.a(nArray5, n3, n2, this.p.e, this.p.c);
        if (bl2) {
            VisADIndexedTriangleStripArray visADIndexedTriangleStripArray = new VisADIndexedTriangleStripArray();
            visADIndexedTriangleStripArray.d = fArray14;
            fArray14 = null;
            visADIndexedTriangleStripArray.k = n20;
            visADIndexedTriangleStripArray.m = new int[n20];
            System.arraycopy(nArray5, 0, visADIndexedTriangleStripArray.m, 0, n20);
            visADIndexedTriangleStripArray.l = new int[1];
            visADIndexedTriangleStripArray.l[0] = n20;
            nArray5 = null;
            SampledSet.a(visADIndexedTriangleStripArray, fArray, 4, byArray);
            fArray = null;
            return visADIndexedTriangleStripArray;
        }
        VisADTriangleStripArray visADTriangleStripArray = new VisADTriangleStripArray();
        visADTriangleStripArray.k = new int[]{n20};
        visADTriangleStripArray.e = n20;
        visADTriangleStripArray.d = new float[3 * n20];
        int n21 = 0;
        int n22 = 0;
        while (n22 < 3 * n20) {
            n18 = 3 * nArray5[n21];
            visADTriangleStripArray.d[n22] = fArray14[n18];
            visADTriangleStripArray.d[n22 + 1] = fArray14[n18 + 1];
            visADTriangleStripArray.d[n22 + 2] = fArray14[n18 + 2];
            ++n21;
            n22 += 3;
        }
        fArray14 = null;
        visADTriangleStripArray.j = new float[3 * n20];
        n21 = 0;
        int n23 = 0;
        while (n23 < 3 * n20) {
            n18 = nArray5[n21];
            visADTriangleStripArray.j[n23] = fArray[0][n18];
            visADTriangleStripArray.j[n23 + 1] = fArray[1][n18];
            visADTriangleStripArray.j[n23 + 2] = fArray[2][n18];
            ++n21;
            n23 += 3;
        }
        fArray = null;
        if (byArray != null) {
            int n24 = byArray.length;
            visADTriangleStripArray.i = new byte[n24 * n20];
            n21 = 0;
            if (n24 == 4) {
                int n25 = 0;
                while (n25 < n24 * n20) {
                    n18 = nArray5[n21];
                    visADTriangleStripArray.i[n25] = byArray[0][n18];
                    visADTriangleStripArray.i[n25 + 1] = byArray[1][n18];
                    visADTriangleStripArray.i[n25 + 2] = byArray[2][n18];
                    visADTriangleStripArray.i[n25 + 3] = byArray[3][n18];
                    ++n21;
                    n25 += n24;
                }
            } else {
                int n26 = 0;
                while (n26 < n24 * n20) {
                    n18 = nArray5[n21];
                    visADTriangleStripArray.i[n26] = byArray[0][n18];
                    visADTriangleStripArray.i[n26 + 1] = byArray[1][n18];
                    visADTriangleStripArray.i[n26 + 2] = byArray[2][n18];
                    ++n21;
                    n26 += n24;
                }
            }
        }
        byArray = null;
        nArray5 = null;
        return visADTriangleStripArray;
    }

    public Object c(MathType mathType) throws VisADException {
        if (this.u == 1) {
            return new Irregular3DSet(mathType, this.k, this.i, this.e, this.w, this.q, this.C);
        }
        return new Irregular3DSet(mathType, this.k, this.w, this.q, this.C, this.p);
    }
}

