/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.Delaunay;
import visad.ErrorEstimate;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.MathType;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.VisADException;

public class Irregular2DSet
extends IrregularSet {
    private float m;
    private float b;
    private float n;
    private float o;

    public Irregular2DSet(MathType mathType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Delaunay delaunay) throws VisADException {
        this(mathType, fArray, coordinateSystem, unitArray, errorEstimateArray, delaunay, true);
    }

    public Irregular2DSet(MathType mathType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Delaunay delaunay, boolean bl2) throws VisADException {
        super(mathType, fArray, fArray.length, coordinateSystem, unitArray, errorEstimateArray, delaunay, bl2);
        if (fArray.length != 2) {
            throw new SetException("Irregular2DSet: ManifoldDimension must be 2 for this constructor");
        }
        this.m = this.j[0];
        this.b = this.l[0];
        this.n = this.j[1];
        this.o = this.l[1];
        this.e = null;
        this.i = null;
    }

    public Irregular2DSet(MathType mathType, float[][] fArray, int[] nArray, int[] nArray2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, fArray, nArray, nArray2, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Irregular2DSet(MathType mathType, float[][] fArray, int[] nArray, int[] nArray2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2) throws VisADException {
        super(mathType, fArray, 1, coordinateSystem, unitArray, errorEstimateArray, null, bl2);
        if (this.B != nArray.length || this.B != nArray2.length) {
            throw new SetException("Irregular2DSet: sort lengths do not match");
        }
        this.i = new int[this.B];
        this.e = new int[this.B];
        System.arraycopy(nArray, 0, this.i, 0, this.B);
        System.arraycopy(nArray2, 0, this.e, 0, this.B);
        this.m = this.j[0];
        this.b = this.l[0];
        this.n = this.j[1];
        this.o = this.l[1];
        this.p = null;
    }

    public Set a(SetType setType, float[][] fArray) throws VisADException {
        if (fArray.length == 3) {
            if (this.u == 1) {
                return new Irregular3DSet((MathType)setType, fArray, this.i, this.e, null, null, null, false);
            }
            if (this.p == null || this.p.c == null || this.p.c.length == 0) {
                return null;
            }
            return new Irregular3DSet((MathType)setType, fArray, null, null, null, this.p, false);
        }
        if (fArray.length == 2) {
            if (this.u == 1) {
                return new Irregular2DSet((MathType)setType, fArray, this.i, this.e, null, null, null, false);
            }
            if (this.p == null || this.p.c == null || this.p.c.length == 0) {
                return null;
            }
            return new Irregular2DSet((MathType)setType, fArray, null, null, null, this.p, false);
        }
        throw new SetException("Irregular2DSet.makeSpatial: bad samples length");
    }

    public float[][] b(int[] nArray) throws VisADException {
        float[][] fArray = new float[2][nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] >= 0 && nArray[n2] < this.B) {
                fArray[0][n2] = this.k[0][nArray[n2]];
                fArray[1][n2] = this.k[1][nArray[n2]];
            } else {
                fArray[1][n2] = Float.NaN;
                fArray[0][n2] = Float.NaN;
            }
            ++n2;
        }
        return fArray;
    }

    public int[] c(float[][] fArray) throws VisADException {
        if (this.u != 2) {
            throw new SetException("Irregular2DSet.valueToTri: ManifoldDimension must be 2, not " + this.u);
        }
        int n2 = fArray[0].length;
        if (n2 != fArray[1].length) {
            throw new SetException("Irregular2DSet.valueToTri: lengths don't match");
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            nArray[n4] = -1;
            boolean bl2 = false;
            if (n3 < 0) {
                n3 = 0;
            }
            int n5 = 0;
            while (n5 < this.p.c.length && !bl2) {
                int n6;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                int n7 = this.p.c[n3][0];
                int n8 = this.p.c[n3][1];
                int n9 = this.p.c[n3][2];
                float f2 = this.k[0][n7];
                float f3 = this.k[1][n7];
                float f4 = this.k[0][n8];
                float f5 = this.k[1][n8];
                float f6 = this.k[0][n9];
                float f7 = this.k[1][n9];
                float f8 = fArray[0][n4];
                float f9 = fArray[1][n4];
                float f10 = (f4 - f2) * (f9 - f3) - (f5 - f3) * (f8 - f2);
                float f11 = (f6 - f4) * (f9 - f5) - (f7 - f5) * (f8 - f4);
                float f12 = (f2 - f6) * (f9 - f7) - (f3 - f7) * (f8 - f6);
                boolean bl6 = f10 == 0.0f || f10 > 0.0f == (f4 - f2) * (f7 - f3) - (f5 - f3) * (f6 - f2) > 0.0f ? true : (bl5 = false);
                boolean bl7 = f11 == 0.0f || f11 > 0.0f == (f6 - f4) * (f3 - f5) - (f7 - f5) * (f2 - f4) > 0.0f ? true : (bl4 = false);
                boolean bl8 = f12 == 0.0f || f12 > 0.0f == (f2 - f6) * (f5 - f7) - (f3 - f7) * (f4 - f6) > 0.0f ? true : (bl3 = false);
                if (!(bl5 || bl4 || bl3)) {
                    n3 = -1;
                } else if (!bl5 && !bl4) {
                    n6 = this.p.b[n3][0];
                    n3 = n6 >= 0 ? n6 : this.p.b[n3][1];
                } else if (!bl4 && !bl3) {
                    n6 = this.p.b[n3][1];
                    n3 = n6 >= 0 ? n6 : this.p.b[n3][2];
                } else if (!bl3 && !bl5) {
                    n6 = this.p.b[n3][2];
                    n3 = n6 >= 0 ? n6 : this.p.b[n3][0];
                } else if (!bl5) {
                    n3 = this.p.b[n3][0];
                } else if (!bl4) {
                    n3 = this.p.b[n3][1];
                } else if (!bl3) {
                    n3 = this.p.b[n3][2];
                } else {
                    bl2 = true;
                }
                if (n3 < 0) {
                    bl2 = true;
                }
                if (bl2) {
                    nArray[n4] = n3;
                }
                ++n5;
            }
            ++n4;
        }
        return nArray;
    }

    public int[] b(float[][] fArray) throws VisADException {
        if (fArray.length < this.y) {
            throw new SetException("Irregular2DDSet.valueToIndex: value dimension " + fArray.length + " not equal to Domain dimension " + this.y);
        }
        int[] nArray = this.c(fArray);
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] < 0) {
                nArray2[n2] = -1;
            } else {
                float f2 = fArray[0][n2];
                float f3 = fArray[1][n2];
                int n3 = nArray[n2];
                int n4 = this.p.c[n3][0];
                int n5 = this.p.c[n3][1];
                int n6 = this.p.c[n3][2];
                float f4 = this.k[0][n4] - f2;
                float f5 = this.k[1][n4] - f3;
                float f6 = this.k[0][n5] - f2;
                float f7 = this.k[1][n5] - f3;
                float f8 = this.k[0][n6] - f2;
                float f9 = this.k[1][n6] - f3;
                float f10 = f4 * f4 + f5 * f5;
                float f11 = f6 * f6 + f7 * f7;
                float f12 = f8 * f8 + f9 * f9;
                float f13 = Math.min(f10, f11);
                nArray2[n2] = (f13 = Math.min(f13, f12)) == f10 ? n4 : (f13 == f11 ? n5 : n6);
            }
            ++n2;
        }
        return nArray2;
    }

    public void a(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        if (fArray.length < this.y) {
            throw new SetException("Irregular2DDSet.valueToInterp: value dimension " + fArray.length + " not equal to Domain dimension " + this.y);
        }
        int n2 = fArray[0].length;
        if (nArray.length < n2 || fArray2.length < n2) {
            throw new SetException("Irregular2DSet.valueToInterp: lengths don't match");
        }
        int[] nArray2 = this.c(fArray);
        int n3 = 0;
        while (n3 < nArray2.length) {
            if (nArray2[n3] < 0) {
                nArray[n3] = null;
                fArray2[n3] = null;
            } else {
                int[] nArray3 = new int[3];
                float[] fArray3 = new float[3];
                float f2 = fArray[0][n3];
                float f3 = fArray[1][n3];
                int n4 = nArray2[n3];
                int n5 = this.p.c[n4][0];
                int n6 = this.p.c[n4][1];
                int n7 = this.p.c[n4][2];
                nArray3[0] = n5;
                nArray3[1] = n6;
                nArray3[2] = n7;
                float f4 = this.k[0][n5];
                float f5 = this.k[1][n5];
                float f6 = this.k[0][n6];
                float f7 = this.k[1][n6];
                float f8 = this.k[0][n7];
                float f9 = this.k[1][n7];
                float f10 = f9 - f7;
                float f11 = f6 - f8;
                float f12 = f9 - f5;
                float f13 = f4 - f8;
                float f14 = f7 - f5;
                float f15 = f4 - f6;
                fArray3[0] = ((f2 - f6) * f10 + (f3 - f7) * f11) / ((f4 - f6) * f10 + (f5 - f7) * f11);
                fArray3[1] = ((f2 - f4) * f12 + (f3 - f5) * f13) / ((f6 - f4) * f12 + (f7 - f5) * f13);
                fArray3[2] = ((f2 - f4) * f14 + (f3 - f5) * f15) / ((f8 - f4) * f14 + (f9 - f5) * f15);
                nArray[n3] = nArray3;
                fArray2[n3] = fArray3;
            }
            ++n3;
        }
    }

    public Object c(MathType mathType) throws VisADException {
        if (this.u == 1) {
            return new Irregular2DSet(mathType, this.k, this.i, this.e, this.w, this.q, this.C);
        }
        return new Irregular2DSet(mathType, this.k, this.w, this.q, this.C, this.p);
    }
}

