/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;

public class HSVCoordinateSystem
extends CoordinateSystem {
    private static Unit[] b = new Unit[]{CommonUnit.g, null, null};

    public HSVCoordinateSystem(RealTupleType realTupleType, boolean bl2) {
        super(realTupleType, b, bl2);
    }

    public double[][] a(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 3) {
            throw new CoordinateSystemException("HSVCoordinateSystem.toReference: tuples wrong dimension");
        }
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[3][n2];
        int n3 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n4 = 0;
        while (n4 < n2) {
            double d6 = dArray[0][n4] % 360.0;
            if (d6 < 0.0) {
                d6 += 360.0;
            }
            double d7 = Math.max(0.0, Math.min(1.0, dArray[1][n4]));
            double d8 = Math.max(0.0, Math.min(1.0, dArray[2][n4]));
            if (d7 == 0.0) {
                dArray2[0][n4] = d8;
                dArray2[1][n4] = d8;
                dArray2[2][n4] = d8;
            } else {
                n3 = (int)Math.floor(d6 /= 60.0);
                d2 = d6 - (double)n3;
                d3 = d8 * (1.0 - d7);
                d4 = d8 * (1.0 - d7 * d2);
                d5 = d8 * (1.0 - d7 * (1.0 - d2));
                switch (n3) {
                    case 0: {
                        dArray2[0][n4] = d8;
                        dArray2[1][n4] = d5;
                        dArray2[2][n4] = d3;
                        break;
                    }
                    case 1: {
                        dArray2[0][n4] = d4;
                        dArray2[1][n4] = d8;
                        dArray2[2][n4] = d3;
                        break;
                    }
                    case 2: {
                        dArray2[0][n4] = d3;
                        dArray2[1][n4] = d8;
                        dArray2[2][n4] = d5;
                        break;
                    }
                    case 3: {
                        dArray2[0][n4] = d3;
                        dArray2[1][n4] = d4;
                        dArray2[2][n4] = d8;
                        break;
                    }
                    case 4: {
                        dArray2[0][n4] = d5;
                        dArray2[1][n4] = d3;
                        dArray2[2][n4] = d8;
                        break;
                    }
                    default: {
                        dArray2[0][n4] = d8;
                        dArray2[1][n4] = d3;
                        dArray2[2][n4] = d4;
                    }
                }
            }
            ++n4;
        }
        return dArray2;
    }

    public double[][] b(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 3) {
            throw new CoordinateSystemException("HSVCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[3][n2];
        int n3 = 0;
        while (n3 < n2) {
            double d2 = Math.max(0.0, Math.min(1.0, dArray[0][n3]));
            double d3 = Math.max(0.0, Math.min(1.0, dArray[1][n3]));
            double d4 = Math.max(0.0, Math.min(1.0, dArray[2][n3]));
            double d5 = Math.max(d2, Math.max(d3, d4));
            double d6 = Math.min(d2, Math.min(d3, d4));
            dArray2[2][n3] = d5;
            double d7 = dArray2[1][n3] = d5 != 0.0 ? (d5 - d6) / d5 : 0.0;
            if (dArray2[1][n3] == 0.0) {
                dArray2[2][n3] = 0.0;
            } else {
                double d8;
                double d9 = (d5 - d2) / (d5 - d6);
                double d10 = (d5 - d3) / (d5 - d6);
                double d11 = (d5 - d4) / (d5 - d6);
                if (d2 == d5) {
                    d8 = d11 - d10;
                } else if (d3 == d5) {
                    d8 = 2.0 + d9 - d11;
                } else if (d4 == d5) {
                    d8 = 4.0 + d10 - d9;
                } else {
                    throw new CoordinateSystemException("HSVCoordinateSystem: bad h");
                }
                d8 = 60.0 * d8;
                if (d8 < 0.0) {
                    d8 += 360.0;
                }
                dArray2[2][n3] = d8;
            }
            ++n3;
        }
        return dArray2;
    }

    public float[][] a(float[][] fArray) throws VisADException {
        if (fArray == null || fArray.length != 3) {
            throw new CoordinateSystemException("HSVCoordinateSystem.toReference: tuples wrong dimension");
        }
        int n2 = fArray[0].length;
        float[][] fArray2 = new float[3][n2];
        int n3 = 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n4 = 0;
        while (n4 < n2) {
            float f6 = fArray[0][n4] % 360.0f;
            if (f6 < 0.0f) {
                f6 += 360.0f;
            }
            float f7 = Math.max(0.0f, Math.min(1.0f, fArray[1][n4]));
            float f8 = Math.max(0.0f, Math.min(1.0f, fArray[2][n4]));
            if (f7 == 0.0f) {
                fArray2[0][n4] = f8;
                fArray2[1][n4] = f8;
                fArray2[2][n4] = f8;
            } else {
                n3 = (int)Math.floor(f6 /= 60.0f);
                f2 = f6 - (float)n3;
                f3 = f8 * (1.0f - f7);
                f4 = f8 * (1.0f - f7 * f2);
                f5 = f8 * (1.0f - f7 * (1.0f - f2));
                switch (n3) {
                    case 0: {
                        fArray2[0][n4] = f8;
                        fArray2[1][n4] = f5;
                        fArray2[2][n4] = f3;
                        break;
                    }
                    case 1: {
                        fArray2[0][n4] = f4;
                        fArray2[1][n4] = f8;
                        fArray2[2][n4] = f3;
                        break;
                    }
                    case 2: {
                        fArray2[0][n4] = f3;
                        fArray2[1][n4] = f8;
                        fArray2[2][n4] = f5;
                        break;
                    }
                    case 3: {
                        fArray2[0][n4] = f3;
                        fArray2[1][n4] = f4;
                        fArray2[2][n4] = f8;
                        break;
                    }
                    case 4: {
                        fArray2[0][n4] = f5;
                        fArray2[1][n4] = f3;
                        fArray2[2][n4] = f8;
                        break;
                    }
                    default: {
                        fArray2[0][n4] = f8;
                        fArray2[1][n4] = f3;
                        fArray2[2][n4] = f4;
                    }
                }
            }
            ++n4;
        }
        return fArray2;
    }

    public float[][] b(float[][] fArray) throws VisADException {
        if (fArray == null || fArray.length != 3) {
            throw new CoordinateSystemException("HSVCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int n2 = fArray[0].length;
        float[][] fArray2 = new float[3][n2];
        int n3 = 0;
        while (n3 < n2) {
            float f2 = Math.max(0.0f, Math.min(1.0f, fArray[0][n3]));
            float f3 = Math.max(0.0f, Math.min(1.0f, fArray[1][n3]));
            float f4 = Math.max(0.0f, Math.min(1.0f, fArray[2][n3]));
            float f5 = Math.max(f2, Math.max(f3, f4));
            float f6 = Math.min(f2, Math.min(f3, f4));
            fArray2[2][n3] = f5;
            float f7 = fArray2[1][n3] = f5 != 0.0f ? (f5 - f6) / f5 : 0.0f;
            if (fArray2[1][n3] == 0.0f) {
                fArray2[2][n3] = 0.0f;
            } else {
                float f8;
                float f9 = (f5 - f2) / (f5 - f6);
                float f10 = (f5 - f3) / (f5 - f6);
                float f11 = (f5 - f4) / (f5 - f6);
                if (f2 == f5) {
                    f8 = f11 - f10;
                } else if (f3 == f5) {
                    f8 = 2.0f + f9 - f11;
                } else if (f4 == f5) {
                    f8 = 4.0f + f10 - f9;
                } else {
                    throw new CoordinateSystemException("HSVCoordinateSystem: bad h");
                }
                f8 = 60.0f * f8;
                if (f8 < 0.0f) {
                    f8 += 360.0f;
                }
                fArray2[2][n3] = f8;
            }
            ++n3;
        }
        return fArray2;
    }

    public boolean equals(Object object) {
        return object instanceof HSVCoordinateSystem;
    }
}

