/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSetIface;
import visad.LinearSet;
import visad.MathType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;

public class GriddedSet
extends SampledSet
implements GriddedSetIface {
    public int[] i;
    public float m = 1.0E-15f;
    public boolean v;

    public GriddedSet(MathType mathType, float[][] fArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, fArray, nArray, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public GriddedSet(MathType mathType, float[][] fArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2) throws VisADException {
        super(mathType, nArray.length, coordinateSystem, unitArray, errorEstimateArray);
        this.c(nArray);
        if (fArray == null) {
            this.k = null;
        } else {
            this.a(fArray, bl2);
        }
    }

    private void c(int[] nArray) throws VisADException {
        this.i = new int[this.u];
        this.B = 1;
        int n2 = 0;
        while (n2 < this.u) {
            if (nArray[n2] < 1) {
                throw new SetException("GriddedSet: each grid length must be at least 1 (length#" + n2 + " is " + nArray[n2]);
            }
            this.i[n2] = nArray[n2];
            this.B *= nArray[n2];
            ++n2;
        }
    }

    public static GriddedSet a(MathType mathType, float[][] fArray, int[] nArray) throws VisADException {
        return GriddedSet.a(mathType, fArray, nArray, null, null, null);
    }

    public static GriddedSet a(MathType mathType, float[][] fArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        return GriddedSet.a(mathType, fArray, nArray, coordinateSystem, unitArray, errorEstimateArray, true, true);
    }

    private static GriddedSet a(MathType mathType, float[][] fArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2, boolean bl3) throws VisADException {
        int n2 = nArray.length;
        int n3 = fArray.length;
        if (n2 > n3) {
            throw new SetException("GriddedSet.create: manifold_dimension " + n2 + " is greater than" + " domain_dimension " + n3);
        }
        switch (n3) {
            case 1: {
                return new Gridded1DSet(mathType, fArray, nArray[0], coordinateSystem, unitArray, errorEstimateArray, bl2);
            }
            case 2: {
                if (n2 == 1) {
                    return new Gridded2DSet(mathType, fArray, nArray[0], coordinateSystem, unitArray, errorEstimateArray, bl2);
                }
                return new Gridded2DSet(mathType, fArray, nArray[0], nArray[1], coordinateSystem, unitArray, errorEstimateArray, bl2, bl3);
            }
            case 3: {
                if (n2 == 1) {
                    return new Gridded3DSet(mathType, fArray, nArray[0], coordinateSystem, unitArray, errorEstimateArray, bl2);
                }
                if (n2 == 2) {
                    return new Gridded3DSet(mathType, fArray, nArray[0], nArray[1], coordinateSystem, unitArray, errorEstimateArray, bl2);
                }
                return new Gridded3DSet(mathType, fArray, nArray[0], nArray[1], nArray[2], coordinateSystem, unitArray, errorEstimateArray, bl2, bl3);
            }
        }
        return new GriddedSet(mathType, fArray, nArray, coordinateSystem, unitArray, errorEstimateArray, bl2);
    }

    public Set a(SetType setType, float[][] fArray) throws VisADException {
        return GriddedSet.a(setType, fArray, this.i, null, null, null, false, false);
    }

    public int b(int n2) {
        return this.i[n2];
    }

    public int[] p() {
        int[] nArray = new int[this.i.length];
        int n2 = 0;
        while (n2 < this.i.length) {
            nArray[n2] = this.i[n2];
            ++n2;
        }
        return nArray;
    }

    public int[] n() {
        int[] nArray = new int[this.B];
        int n2 = this.i[0];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = n3;
            ++n3;
        }
        int n4 = 1;
        while (n4 < this.u) {
            boolean bl2 = true;
            int n5 = n2;
            int n6 = n2;
            int n7 = 1;
            while (n7 < this.i[n4]) {
                if (bl2) {
                    n3 = n2 - 1;
                    while (n3 >= 0) {
                        nArray[n6] = nArray[n3] + n5;
                        ++n6;
                        --n3;
                    }
                } else {
                    n3 = 0;
                    while (n3 < n2) {
                        nArray[n6] = nArray[n3] + n5;
                        ++n6;
                        ++n3;
                    }
                }
                n5 += n2;
                bl2 = !bl2;
                ++n7;
            }
            n2 *= this.i[n4];
            ++n4;
        }
        return nArray;
    }

    public float[][] b(int[] nArray) throws VisADException {
        int[] nArray2 = new int[this.u];
        int n2 = nArray.length;
        float[][] fArray = new float[this.u][n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            if (0 <= nArray[n3] && nArray[n3] < this.B) {
                int n5 = nArray[n3];
                n4 = 0;
                while (n4 < this.u - 1) {
                    nArray2[n4] = n5 % this.i[n4];
                    n5 /= this.i[n4];
                    ++n4;
                }
                nArray2[this.u - 1] = n5;
            } else {
                n4 = 0;
                while (n4 < this.u) {
                    nArray2[n4] = -1;
                    ++n4;
                }
            }
            n4 = 0;
            while (n4 < this.u) {
                fArray[n4][n3] = nArray2[n4];
                ++n4;
            }
            ++n3;
        }
        return this.c(fArray);
    }

    public int[] b(float[][] fArray) throws VisADException {
        if (fArray.length != this.y) {
            throw new SetException("GriddedSet.valueToIndex: value dimension " + fArray.length + " not equal to Domain dimension " + this.y);
        }
        int n2 = fArray[0].length;
        int[] nArray = new int[n2];
        float[][] fArray2 = this.f(fArray);
        int n3 = 0;
        while (n3 < n2) {
            if (Double.isNaN(fArray2[this.u - 1][n3])) {
                nArray[n3] = -1;
            } else {
                int n4 = (int)((double)fArray2[this.u - 1][n3] + 0.5);
                int n5 = this.u - 2;
                while (n5 >= 0) {
                    if (Double.isNaN(fArray2[n5][n3])) {
                        n4 = -1;
                        break;
                    }
                    n4 = (int)((double)fArray2[n5][n3] + 0.5) + this.i[n5] * n4;
                    --n5;
                }
                nArray[n3] = n4;
            }
            ++n3;
        }
        return nArray;
    }

    public float[][] c(float[][] fArray) throws VisADException {
        int n2 = 0;
        while (n2 < this.y) {
            if (this.i[n2] < 2) {
                throw new SetException("GriddedSet.gridToValue: requires all grid dimensions to be > 1");
            }
            ++n2;
        }
        throw new UnimplementedException("GriddedSet.gridToValue");
    }

    public float[][] f(float[][] fArray) throws VisADException {
        int n2 = 0;
        while (n2 < this.y) {
            if (this.i[n2] < 2) {
                throw new SetException("GriddedSet.valueToGrid: requires all grid dimensions to be > 1");
            }
            ++n2;
        }
        throw new UnimplementedException("GriddedSet.valueToGrid");
    }

    public void a(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        if (fArray.length != this.y) {
            throw new SetException("GriddedSet.valueToInterp: value dimension " + fArray.length + " not equal to Domain dimension " + this.y);
        }
        int n2 = fArray[0].length;
        if (nArray.length != n2) {
            throw new SetException("GriddedSet.valueToInterp: indices length " + nArray.length + " doesn't match value[0] length " + fArray[0].length);
        }
        if (fArray2.length != n2) {
            throw new SetException("GriddedSet.valueToInterp: weights length " + fArray2.length + " doesn't match value[0] length " + fArray[0].length);
        }
        float[][] fArray3 = this.f(fArray);
        int[] nArray2 = new int[this.u];
        float[] fArray4 = new float[this.u];
        int[] nArray3 = new int[this.u];
        nArray3[0] = 1;
        int n3 = 1;
        while (n3 < this.u) {
            nArray3[n3] = nArray3[n3 - 1] * this.i[n3 - 1];
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            float[] fArray5;
            int[] nArray4;
            int n5;
            int n6 = 1;
            if (Double.isNaN(fArray3[this.u - 1][n4])) {
                n5 = -1;
            } else {
                nArray2[this.u - 1] = (int)((double)fArray3[this.u - 1][n4] + 0.5);
                if (nArray2[this.u - 1] == this.i[this.u - 1]) {
                    int n7 = this.u - 1;
                    nArray2[n7] = nArray2[n7] - 1;
                }
                fArray4[this.u - 1] = fArray3[this.u - 1][n4] - (float)nArray2[this.u - 1];
                if (!(nArray2[this.u - 1] == 0 && (double)fArray4[this.u - 1] <= 0.0 || nArray2[this.u - 1] == this.i[this.u - 1] - 1 && (double)fArray4[this.u - 1] >= 0.0)) {
                    n6 *= 2;
                }
                if ((n5 = nArray2[this.u - 1]) >= this.i[this.u - 1]) {
                    n5 = -1;
                }
            }
            n3 = this.u - 2;
            while (n3 >= 0 && n5 >= 0) {
                if (Double.isNaN(fArray3[n3][n4])) {
                    n5 = -1;
                } else {
                    nArray2[n3] = (int)((double)fArray3[n3][n4] + 0.5);
                    if (nArray2[n3] == this.i[n3]) {
                        int n8 = n3;
                        nArray2[n8] = nArray2[n8] - 1;
                    }
                    fArray4[n3] = fArray3[n3][n4] - (float)nArray2[n3];
                    if (!(nArray2[n3] == 0 && (double)fArray4[n3] <= 0.0 || nArray2[n3] == this.i[n3] - 1 && (double)fArray4[n3] >= 0.0)) {
                        n6 *= 2;
                    }
                    n5 = nArray2[n3] + this.i[n3] * n5;
                    if (nArray2[n3] < 0 || nArray2[n3] >= this.i[n3]) {
                        n5 = -1;
                    }
                }
                --n3;
            }
            if (n5 < 0) {
                nArray4 = null;
                fArray5 = null;
            } else {
                nArray4 = new int[n6];
                fArray5 = new float[n6];
                nArray4[0] = n5;
                fArray5[0] = 1.0f;
                int n9 = 1;
                n3 = 0;
                while (n3 < this.u) {
                    if (!(nArray2[n3] == 0 && (double)fArray4[n3] <= 0.0 || nArray2[n3] == this.i[n3] - 1 && (double)fArray4[n3] >= 0.0)) {
                        float f2;
                        float f3;
                        int n10;
                        if ((double)fArray4[n3] >= 0.0) {
                            n10 = nArray3[n3];
                            f3 = 1.0f - fArray4[n3];
                            f2 = fArray4[n3];
                        } else {
                            n10 = -nArray3[n3];
                            f3 = 1.0f + fArray4[n3];
                            f2 = -fArray4[n3];
                        }
                        int n11 = 0;
                        while (n11 < n9) {
                            nArray4[n11 + n9] = nArray4[n11] + n10;
                            fArray5[n11 + n9] = fArray5[n11] * f2;
                            int n12 = n11++;
                            fArray5[n12] = fArray5[n12] * f3;
                        }
                        n9 *= 2;
                    }
                    ++n3;
                }
            }
            nArray[n4] = nArray4;
            fArray2[n4] = fArray5;
            ++n4;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof GriddedSet) || object == null || object instanceof LinearSet || object instanceof Gridded1DDoubleSet) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.f((Set)object)) {
            return false;
        }
        if (this.b((Set)object)) {
            return true;
        }
        if (!this.e((Set)object)) {
            return false;
        }
        try {
            if (this.y != ((GriddedSet)object).s() || this.u != ((GriddedSet)object).v() || this.B != ((GriddedSet)object).r()) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.u) {
                if (this.i[n2] != ((GriddedSet)object).b(n2)) {
                    return false;
                }
                ++n2;
            }
            float[][] fArray = ((GriddedSet)object).a(false);
            if (this.k != null) {
                n2 = 0;
                while (n2 < this.y) {
                    int n3 = 0;
                    while (n3 < this.B) {
                        boolean bl2 = this.k[n2][n3] == this.k[n2][n3] ? this.k[n2][n3] != fArray[n2][n3] : fArray[n2][n3] == fArray[n2][n3];
                        if (bl2) {
                            this.d((Set)object);
                            return false;
                        }
                        ++n3;
                    }
                    ++n2;
                }
            } else {
                float[][] fArray2 = this.a(false);
                n2 = 0;
                while (n2 < this.y) {
                    int n4 = 0;
                    while (n4 < this.B) {
                        boolean bl3 = fArray2[n2][n4] == fArray2[n2][n4] ? fArray2[n2][n4] != fArray[n2][n4] : fArray[n2][n4] == fArray[n2][n4];
                        if (bl3) {
                            this.d((Set)object);
                            return false;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            this.a((Set)object);
            return true;
        }
        catch (VisADException visADException) {
            return false;
        }
    }

    public int hashCode() {
        if (!this.t) {
            this.d = this.m();
            this.d ^= this.y ^ this.u ^ this.B;
            int n2 = 0;
            while (n2 < this.u) {
                this.d ^= this.i[n2];
                ++n2;
            }
            if (this.k != null) {
                int n3 = 0;
                while (n3 < this.y) {
                    int n4 = 0;
                    while (n4 < this.B) {
                        this.d ^= Float.floatToIntBits(this.k[n3][n4]);
                        ++n4;
                    }
                    ++n3;
                }
            }
            this.t = true;
        }
        return this.d;
    }

    public Object c(MathType mathType) throws VisADException {
        return new GriddedSet(mathType, this.k, this.i, this.w, this.q, this.C);
    }

    public String a(String string) throws VisADException {
        String string2;
        if (this.y == this.u) {
            string2 = string + this.getClass().getName() + ": Dimension = " + this.y + " Length = " + this.B + "\n";
            int n2 = 0;
            while (n2 < this.y) {
                string2 = string2 + string + "  Dimension " + n2 + ":" + " Length = " + this.i[n2] + " Range = " + this.j[n2] + " to " + this.l[n2] + "\n";
                ++n2;
            }
        } else {
            string2 = string + this.getClass().getName() + ": DomainDimension = " + this.y + " ManifoldDimension = " + this.u + " Length = " + this.B + "\n";
            int n3 = 0;
            while (n3 < this.u) {
                string2 = string2 + string + "  ManifoldDimension " + n3 + ":" + " Length = " + this.i[n3] + "\n";
                ++n3;
            }
            n3 = 0;
            while (n3 < this.y) {
                string2 = string2 + string + "  DomainDimension " + n3 + ":" + " Range = " + this.j[n3] + " to " + this.l[n3] + "\n";
                ++n3;
            }
        }
        return string2;
    }
}

